/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.chat.web;

import com.jeecg.chat.entity.ChatMessageHistory;
import com.jeecg.chat.service.ChatMessageHistoryService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.page.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/chat/chatMessageHistory"})
public class ChatMessageHistoryController
extends BaseController {
    @Autowired
    private ChatMessageHistoryService chatMessageHistoryService;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public void index(String id, String type, String from, HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) {
        try {
            int index = from.indexOf("?");
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("from", (Object)from.substring(0, index));
            velocityContext.put("to", (Object)from.substring(index + 4));
            velocityContext.put("type", (Object)type);
            String viewName = "chat/history.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
    }

    @RequestMapping(params={"getHistoryMessage"})
    @ResponseBody
    public AjaxJson getHistoryMessage(String from, String to, String type, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="1000") int pageSize) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ChatMessageHistory query = new ChatMessageHistory();
            query.setFrom(from);
            query.setTo(to);
            query.setType(type);
            MiniDaoPage<ChatMessageHistory> list = this.chatMessageHistoryService.getAll(query, pageNo, pageSize);
            ajaxJson.setObj((Object)SystemTools.convertPaginatedList(list));
            ajaxJson.setMsg("success");
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
        return ajaxJson;
    }
}

