/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.chat.service.impl;

import com.jeecg.chat.entity.SocketUser;
import com.jeecg.chat.service.IUserManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserManager
implements IUserManager {
    Log log = LogFactory.getLog(this.getClass());
    private static Map<String, SocketUser> socketUserMap;
    private static UserManager manager;

    static {
        manager = new UserManager();
    }

    private UserManager() {
        socketUserMap = new ConcurrentHashMap<String, SocketUser>();
    }

    public static IUserManager getInstance() {
        return manager;
    }

    @Override
    public boolean addUser(SocketUser user) {
        this.removeUser(user.getUserId());
        socketUserMap.put(user.getUserId(), user);
        return true;
    }

    @Override
    public boolean removeUser(SocketUser user) {
        if (user != null) {
            return this.removeUser(user.getUserId());
        }
        return false;
    }

    @Override
    public int getOnlineCount() {
        return socketUserMap.size();
    }

    @Override
    public SocketUser getUser(String userId) {
        if (socketUserMap.containsKey(userId)) {
            return socketUserMap.get(userId);
        }
        return new SocketUser();
    }

    private boolean removeUser(String sessionUserId) {
        try {
            socketUserMap.remove(sessionUserId);
        }
        catch (Exception e) {
            this.log.info((Object)("id\u4e3a" + sessionUserId + "\u7528\u6237\u5df2\u7ecf\u88ab\u79fb\u9664\u4e86"));
        }
        return true;
    }
}

