/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.chat.service.impl;

import com.jeecg.chat.dao.ImDao;
import com.jeecg.chat.entity.P3ImTSBaseUser;
import com.jeecg.chat.entity.P3ImTSDepart;
import com.jeecg.chat.service.ImService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Service;

@Service(value="imService")
public class ImServiceImpl
implements ImService {
    @Resource
    private ImDao imDao;

    @Override
    public List<P3ImTSBaseUser> getUsers() {
        List<Object> imTSUsers = new ArrayList();
        try {
            imTSUsers = this.getUsersOrcl();
        }
        catch (UncategorizedSQLException e) {
            imTSUsers = this.getUsersSqlServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imTSUsers;
    }

    @Override
    public List<P3ImTSDepart> getDeparts() {
        return this.imDao.getDeparts();
    }

    @Override
    public boolean isInThisOrg(String deptid, String oid) {
        String orgcode = this.imDao.getDepart(deptid).getOrgCode();
        boolean reslut = orgcode.substring(0, 3).equals(oid);
        return reslut;
    }

    @Override
    public int updateSign(String sign, String uid) {
        return this.imDao.update(sign, uid);
    }

    @Override
    public List<P3ImTSBaseUser> getUsersSqlServer() {
        return this.imDao.getUsersSqlServer();
    }

    @Override
    public List<P3ImTSBaseUser> getUsersOrcl() throws UncategorizedSQLException {
        return this.imDao.getUsers();
    }
}

