/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.chat.service.impl;

import com.alibaba.fastjson.JSON;
import com.jeecg.chat.dao.ChatMessageHistoryDao;
import com.jeecg.chat.entity.ChatMessage;
import com.jeecg.chat.entity.ChatMessageHistory;
import com.jeecg.chat.service.ChatMessageHistoryService;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="chatMessageHistoryService")
public class ChatMessageHistoryServiceImpl
implements ChatMessageHistoryService {
    @Autowired
    private ChatMessageHistoryDao messageHistoryDao;

    @Override
    public ChatMessageHistory get(String id, String type) {
        return this.messageHistoryDao.get(id, type);
    }

    @Override
    public int update(ChatMessageHistory chatMessageHis) {
        return this.messageHistoryDao.update(chatMessageHis);
    }

    @Override
    public void insert(ChatMessageHistory chatMessageHis) {
        this.messageHistoryDao.insert(chatMessageHis);
    }

    @Override
    public void insert(ChatMessage chatMessage) {
        ChatMessageHistory chatMessageHistory = new ChatMessageHistory();
        chatMessageHistory.setFrom(chatMessage.getMine().getId());
        chatMessageHistory.setTo(chatMessage.getTo().getId());
        chatMessageHistory.setData(JSON.toJSONString((Object)chatMessage));
        chatMessageHistory.setType(chatMessage.getTo().getType());
        this.messageHistoryDao.insert(chatMessageHistory);
    }

    @Override
    public MiniDaoPage<ChatMessageHistory> getAll(ChatMessageHistory chatMessageHis, int page, int rows) {
        if (chatMessageHis.getType().equals("group")) {
            return this.messageHistoryDao.getAllToGroup(chatMessageHis, page, rows);
        }
        return this.messageHistoryDao.getAll(chatMessageHis, page, rows);
    }

    @Override
    public void delete(ChatMessageHistory chatMessageHis) {
        this.messageHistoryDao.delete(chatMessageHis);
    }
}

