/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.codegenerate.generate.onetomany;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.codegenerate.generate.BaseCodeFactory;
import org.jeecgframework.codegenerate.generate.ICallBack;
import org.jeecgframework.codegenerate.util.CodeResourceUtil;
import org.jeecgframework.codegenerate.util.CodeStringUtils;

public class CodeFactoryOneToMany
extends BaseCodeFactory {
    private ICallBack callBack;

    public void generateFile(String templateFileName, String type, Map data) {
        try {
            String entityPackage = data.get("entityPackage").toString();
            String entityName = data.get("entityName").toString();
            String fileNamePath = this.getCodePath(type, entityPackage, entityName);
            String fileDir = StringUtils.substringBeforeLast((String)fileNamePath, (String)"/");
            Template template = this.getConfiguration().getTemplate(templateFileName);
            FileUtils.forceMkdir((File)new File(String.valueOf(fileDir) + "/"));
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileNamePath), CodeResourceUtil.SYSTEM_ENCODING);
            template.process((Object)data, (Writer)out);
            ((Writer)out).close();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getProjectPath() {
        String path = String.valueOf(System.getProperty("user.dir").replace("\\", "/")) + "/";
        return path;
    }

    public String getClassPath() {
        String path = Thread.currentThread().getContextClassLoader().getResource("./").getPath();
        return path;
    }

    public static void main(String[] args) {
        System.out.println(Thread.currentThread().getContextClassLoader().getResource("./").getPath());
    }

    public String getTemplatePath() {
        String path = String.valueOf(this.getClassPath()) + CodeResourceUtil.TEMPLATEPATH;
        return path;
    }

    public String getCodePath(String type, String entityPackage, String entityName) {
        String path = this.getProjectPath();
        StringBuilder str = new StringBuilder();
        if (StringUtils.isNotBlank((String)type)) {
            String codeType = Enum.valueOf(CodeType.class, type).getValue();
            str.append(path);
            if ("jsp".equals(type) || "jspList".equals(type)) {
                str.append(CodeResourceUtil.JSPPATH);
            } else {
                str.append(CodeResourceUtil.CODEPATH);
            }
            if ("Action".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"action"));
            } else if ("ServiceImpl".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"service/impl"));
            } else if ("ServiceI".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"service"));
            } else if (!"List".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)codeType));
            }
            str.append("/");
            str.append(StringUtils.lowerCase((String)entityPackage));
            str.append("/");
            if ("jsp".equals(type) || "jspList".equals(type)) {
                String jspName = StringUtils.capitalize((String)entityName);
                str.append(CodeStringUtils.getInitialSmall(jspName));
                str.append(codeType);
                str.append(".jsp");
            } else {
                str.append(StringUtils.capitalize((String)entityName));
                str.append(codeType);
                str.append(".java");
            }
        } else {
            throw new IllegalArgumentException("type is null");
        }
        return str.toString();
    }

    public void invoke(String templateFileName, String type) {
        Map<Object, Object> data = new HashMap();
        data = this.callBack.execute();
        this.generateFile(templateFileName, type, data);
    }

    public ICallBack getCallBack() {
        return this.callBack;
    }

    public void setCallBack(ICallBack callBack) {
        this.callBack = callBack;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CodeType {
        serviceImpl("ServiceImpl"),
        dao("Dao"),
        service("ServiceI"),
        controller("Controller"),
        page("Page"),
        entity("Entity"),
        jsp(""),
        jspList("List"),
        jspSubList("SubList");

        private String type;

        private CodeType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.type;
        }
    }
}

