/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.codegenerate.generate;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.codegenerate.database.JeecgReadTable;
import org.jeecgframework.codegenerate.generate.CgformCodeFactory;
import org.jeecgframework.codegenerate.generate.ICallBack;
import org.jeecgframework.codegenerate.pojo.CreateFileProperty;
import org.jeecgframework.codegenerate.pojo.onetomany.SubTableEntity;
import org.jeecgframework.codegenerate.util.CodeDateUtils;
import org.jeecgframework.codegenerate.util.CodeResourceUtil;
import org.jeecgframework.codegenerate.util.NonceUtils;
import org.jeecgframework.codegenerate.util.def.FtlDef;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.generate.GenerateEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CgformCodeGenerate
implements ICallBack {
    private static final Log log = LogFactory.getLog(CgformCodeGenerate.class);
    private String entityPackage = "test";
    private String entityName = "Person";
    private String tableName = "person";
    private String ftlDescription = "\u516c\u544a";
    private String primaryKeyPolicy = "uuid";
    private String sequenceCode = "";
    private String[] foreignKeys;
    public static int FIELD_ROW_NUM = 1;
    private SubTableEntity sub;
    private GenerateEntity subG;
    private CreateFileProperty subFileProperty;
    private String policy;
    private String[] array;
    private GenerateEntity cgformConfig;
    private static CreateFileProperty createFileProperty = new CreateFileProperty();

    static {
        createFileProperty.setActionFlag(true);
        createFileProperty.setServiceIFlag(true);
        createFileProperty.setJspFlag(true);
        createFileProperty.setServiceImplFlag(true);
        createFileProperty.setJspMode("01");
        createFileProperty.setPageFlag(true);
        createFileProperty.setEntityFlag(true);
    }

    public CgformCodeGenerate() {
    }

    public CgformCodeGenerate(CreateFileProperty createFileProperty2, GenerateEntity generateEntity) {
        this.entityName = generateEntity.getEntityName();
        this.entityPackage = generateEntity.getEntityPackage();
        this.tableName = generateEntity.getTableName();
        this.ftlDescription = generateEntity.getFtlDescription();
        FIELD_ROW_NUM = 1;
        createFileProperty = createFileProperty2;
        this.primaryKeyPolicy = generateEntity.getPrimaryKeyPolicy();
        this.sequenceCode = "";
        this.cgformConfig = generateEntity;
    }

    public CgformCodeGenerate(SubTableEntity sub, GenerateEntity subG, CreateFileProperty subFileProperty, String policy, String[] array) {
        this.entityName = subG.getEntityName();
        this.entityPackage = subG.getEntityPackage();
        this.tableName = subG.getTableName();
        this.ftlDescription = subG.getFtlDescription();
        createFileProperty = subFileProperty;
        FIELD_ROW_NUM = 1;
        this.primaryKeyPolicy = policy;
        this.sequenceCode = "";
        this.cgformConfig = subG;
        this.foreignKeys = array;
        this.sub = sub;
        this.subG = subG;
        this.subFileProperty = subFileProperty;
        this.policy = policy;
    }

    @Override
    public Map<String, Object> execute() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, String> fieldMeta = new HashMap<String, String>();
        data.put("bussiPackage", CodeResourceUtil.bussiPackage);
        data.put("entityPackage", this.entityPackage);
        data.put("entityName", this.entityName);
        data.put("tableName", this.tableName);
        data.put("ftl_description", this.ftlDescription);
        data.put(FtlDef.JEECG_TABLE_ID, CodeResourceUtil.JEECG_GENERATE_TABLE_ID);
        data.put(FtlDef.JEECG_PRIMARY_KEY_POLICY, this.primaryKeyPolicy);
        data.put(FtlDef.JEECG_SEQUENCE_CODE, this.sequenceCode);
        data.put("ftl_create_time", CodeDateUtils.dateToString(new Date()));
        data.put("foreignKeys", this.foreignKeys);
        data.put(FtlDef.FIELD_REQUIRED_NAME, StringUtils.isNotEmpty((String)CodeResourceUtil.JEECG_UI_FIELD_REQUIRED_NUM) ? Integer.parseInt(CodeResourceUtil.JEECG_UI_FIELD_REQUIRED_NUM) : -1);
        data.put(FtlDef.SEARCH_FIELD_NUM, StringUtils.isNotEmpty((String)CodeResourceUtil.JEECG_UI_FIELD_SEARCH_NUM) ? Integer.parseInt(CodeResourceUtil.JEECG_UI_FIELD_SEARCH_NUM) : -1);
        data.put(FtlDef.FIELD_ROW_NAME, FIELD_ROW_NUM);
        try {
            List columns = this.cgformConfig.deepCopy().getCgFormHead().getColumns();
            for (CgFormFieldEntity cf : columns) {
                String type = cf.getType();
                if ("string".equalsIgnoreCase(type)) {
                    cf.setType("java.lang.String");
                } else if ("Date".equalsIgnoreCase(type)) {
                    cf.setType("java.util.Date");
                } else if ("double".equalsIgnoreCase(type)) {
                    cf.setType("java.lang.Double");
                } else if ("int".equalsIgnoreCase(type)) {
                    cf.setType("java.lang.Integer");
                } else if ("BigDecimal".equalsIgnoreCase(type)) {
                    cf.setType("java.math.BigDecimal");
                } else if ("Text".equalsIgnoreCase(type)) {
                    cf.setType("java.lang.String");
                } else if ("Blob".equalsIgnoreCase(type)) {
                    cf.setType("java.sql.Blob");
                }
                String fieldName = cf.getFieldName();
                String fieldNameV = JeecgReadTable.formatField(fieldName);
                cf.setFieldName(fieldNameV);
                fieldMeta.put(fieldNameV, fieldName.toUpperCase());
            }
            ArrayList<CgFormFieldEntity> pageColumns = new ArrayList<CgFormFieldEntity>();
            for (CgFormFieldEntity cf : columns) {
                if (!StringUtils.isNotEmpty((String)cf.getIsShow()) || !"Y".equalsIgnoreCase(cf.getIsShow())) continue;
                pageColumns.add(cf);
            }
            data.put("cgformConfig", this.cgformConfig);
            data.put("fieldMeta", fieldMeta);
            data.put("columns", columns);
            data.put("pageColumns", pageColumns);
            data.put("buttons", this.cgformConfig.getButtons() == null ? new ArrayList(0) : this.cgformConfig.getButtons());
            data.put("buttonSqlMap", this.cgformConfig.getButtonSqlMap() == null ? new HashMap(0) : this.cgformConfig.getButtonSqlMap());
            data.put("packageStyle", this.cgformConfig.getPackageStyle());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long serialVersionUID = NonceUtils.randomLong() + NonceUtils.currentMills();
        data.put("serialVersionUID", String.valueOf(serialVersionUID));
        return data;
    }

    public void generateToFile() throws TemplateException, IOException {
        log.info((Object)("----jeecg---Code----Generation----[\u5355\u8868\u6a21\u578b:" + this.tableName + "]------- \u751f\u6210\u4e2d\u3002\u3002\u3002"));
        CgformCodeFactory codeFactory = new CgformCodeFactory();
        codeFactory.setProjectPath(this.cgformConfig.getProjectPath());
        codeFactory.setPackageStyle(this.cgformConfig.getPackageStyle());
        if (this.cgformConfig.getCgFormHead().getJformType() == 1) {
            codeFactory.setCallBack(new CgformCodeGenerate(createFileProperty, this.cgformConfig));
        } else {
            codeFactory.setCallBack(new CgformCodeGenerate(this.sub, this.subG, this.subFileProperty, "uuid", this.foreignKeys));
        }
        if (createFileProperty.isJspFlag()) {
            if ("03".equals(createFileProperty.getJspMode())) {
                codeFactory.invoke("onetomany/cgform_jspSubTemplate.ftl", "jspList");
            } else {
                if ("01".equals(createFileProperty.getJspMode())) {
                    codeFactory.invoke("cgform_jspTableTemplate_add.ftl", "jsp_add");
                    codeFactory.invoke("cgform_jspTableTemplate_update.ftl", "jsp_update");
                }
                if ("02".equals(createFileProperty.getJspMode())) {
                    codeFactory.invoke("cgform_jspDivTemplate_add.ftl", "jsp_add");
                    codeFactory.invoke("cgform_jspDivTemplate_update.ftl", "jsp_update");
                }
                codeFactory.invoke("cgform_jspListTemplate.ftl", "jspList");
                codeFactory.invoke("cgform_jsListEnhanceTemplate.ftl", "jsList");
                codeFactory.invoke("cgform_jsEnhanceTemplate.ftl", "js");
            }
        }
        if (createFileProperty.isServiceImplFlag()) {
            codeFactory.invoke("cgform_serviceImplTemplate.ftl", "serviceImpl");
        }
        if (createFileProperty.isServiceIFlag()) {
            codeFactory.invoke("cgform_serviceITemplate.ftl", "service");
        }
        if (createFileProperty.isActionFlag()) {
            codeFactory.invoke("cgform_controllerTemplate.ftl", "controller");
        }
        if (createFileProperty.isEntityFlag()) {
            codeFactory.invoke("cgform_entityTemplate.ftl", "entity");
        }
        log.info((Object)("----jeecg----Code----Generation-----[\u5355\u8868\u6a21\u578b\uff1a" + this.tableName + "]------ \u751f\u6210\u5b8c\u6210\u3002\u3002\u3002"));
    }

    public GenerateEntity getCgformConfig() {
        return this.cgformConfig;
    }

    public void setCgformConfig(GenerateEntity cgformConfig) {
        this.cgformConfig = cgformConfig;
    }
}

