/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web;

import com.jeecg.p3.system.entity.JwSystemUser;
import com.jeecg.p3.system.entity.JwWebJwid;
import com.jeecg.p3.system.entity.Menu;
import com.jeecg.p3.system.service.JwSystemAuthService;
import com.jeecg.p3.system.service.JwSystemUserService;
import com.jeecg.p3.system.service.JwWebJwidService;
import com.jeecg.p3.system.vo.LoginUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.util.MD5Util;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.StringUtils;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/system"})
public class loginController
extends BaseController {
    public static final Logger LOG = LoggerFactory.getLogger(loginController.class);
    @Autowired
    private JwWebJwidService jwidService;
    @Autowired
    private JwSystemAuthService jwSystemAuthService;
    @Autowired
    private JwSystemUserService jwSystemUserService;

    @RequestMapping(value={"/noAuth"}, method={RequestMethod.GET, RequestMethod.POST})
    public void noAuth(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewName = "base/back/common/error.vm";
        VelocityContext velocityContext = new VelocityContext();
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toLogin"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        LoginUser user = (LoginUser)request.getSession().getAttribute("OPERATE_WEB_LOGIN_USER");
        if (user != null) {
            velocityContext.put("jwidname", (Object)((String)request.getSession().getAttribute("jwidname")));
            try {
                LinkedHashMap<Menu, ArrayList<Menu>> menuTree = this.jwSystemAuthService.getSubMenuTree(user.getUserId(), null);
                velocityContext.put("OPERATE_WEB_MENU_TREE", menuTree);
                String viewName = "base/back/main/index.vm";
                ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        String viewName = "base/back/common/login.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/preLogin"}, method={RequestMethod.GET, RequestMethod.POST})
    public void preLogin(String username, String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "base/back/common/prelogin.vm";
        try {
            LoginUser user = this.jwSystemUserService.queryUserByUserId(username);
            boolean isAuth = false;
            String passwordEncode = MD5Util.MD5Encode((String)password, (String)"utf-8");
            if (user != null) {
                if (passwordEncode != null && passwordEncode.equals(user.getPassword()) && "NORMAL".equals(user.getUserStat())) {
                    isAuth = true;
                } else {
                    LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u767b\u5f55\u4fe1\u606f\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
                }
            } else {
                user = this.jwSSO(username, password);
                if (user != null) {
                    JwSystemUser jwSystemUser = new JwSystemUser();
                    jwSystemUser.setUserId(username);
                    jwSystemUser.setUserName(user.getUserName());
                    jwSystemUser.setPassword(passwordEncode);
                    jwSystemUser.setCreateDt(new Date());
                    jwSystemUser.setUserStat("NORMAL");
                    ArrayList<String> roleIds = new ArrayList<String>();
                    roleIds.add("01");
                    this.jwSystemUserService.doAdd(jwSystemUser, roleIds);
                    isAuth = true;
                } else {
                    LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u6377\u5fae\u5e73\u53f0\u6743\u9650\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
                }
            }
            List<Object> jwids = new ArrayList();
            if (isAuth) {
                jwids = this.jwidService.queryJwWebJwidByUserId(username);
                if (jwids != null && jwids.size() <= 0) {
                    // empty if block
                }
            } else {
                LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u6743\u9650\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
            }
            velocityContext.put("jwids", jwids);
        }
        catch (Exception e) {
            LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011" + e.getMessage());
        }
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    private LoginUser jwSSO(String username, String password) {
        LoginUser user = null;
        user = new LoginUser();
        user.setUserId(username);
        user.setUserName(username);
        return user;
    }

    private void syncUserJwid(String username) {
        List<JwWebJwid> jwidList = this.jwidService.queryJwWebJwidByUserId("admin");
        this.jwidService.syncJwid(username, jwidList);
    }

    @RequestMapping(value={"/syncJwid"}, method={RequestMethod.GET, RequestMethod.POST})
    public void syncJwid(String username, String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "base/back/common/prelogin.vm";
        try {
            this.syncUserJwid(username);
            List<JwWebJwid> jwids = this.jwidService.queryJwWebJwidByUserId(username);
            velocityContext.put("jwids", jwids);
        }
        catch (Exception e) {
            LOG.info("\u540c\u6b65\u5fae\u4fe1\u516c\u4f17\u53f7\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011" + e.getMessage());
        }
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET, RequestMethod.POST})
    public void login(String jwid, String username, String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext;
        String viewName;
        block9: {
            viewName = "base/back/common/login.vm";
            velocityContext = new VelocityContext();
            try {
                LoginUser user = (LoginUser)request.getSession().getAttribute("OPERATE_WEB_LOGIN_USER");
                if (user != null) {
                    viewName = "base/back/main/index.vm";
                    velocityContext.put("jwidname", (Object)((String)request.getSession().getAttribute("jwidname")));
                    try {
                        LinkedHashMap<Menu, ArrayList<Menu>> menuTree = this.jwSystemAuthService.getSubMenuTree(user.getUserId(), null);
                        velocityContext.put("OPERATE_WEB_MENU_TREE", menuTree);
                        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                this.validateLoginParam(jwid, username, password);
                user = this.jwSystemUserService.queryUserByUserId(username);
                if (user != null) {
                    String passwordEncode = MD5Util.MD5Encode((String)password, (String)"utf-8");
                    if (passwordEncode == null || !passwordEncode.equals(user.getPassword()) || !"NORMAL".equals(user.getUserStat())) break block9;
                    JwWebJwid jw = this.jwidService.queryJwidByJwidAndUserId(jwid, username);
                    if (jw != null) {
                        request.getSession().setAttribute("jwid", (Object)jwid);
                        request.getSession().setAttribute("jwidname", (Object)jw.getName());
                        request.getSession().setAttribute("OPERATE_WEB_LOGIN_USER", (Object)user);
                        velocityContext.put("jwidname", (Object)jw.getName());
                        try {
                            LinkedHashMap<Menu, ArrayList<Menu>> menuTree = this.jwSystemAuthService.getSubMenuTree(user.getUserId(), null);
                            velocityContext.put("OPERATE_WEB_MENU_TREE", menuTree);
                            viewName = "base/back/main/index.vm";
                            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    LOG.info("\u767b\u5f55\u5931\u8d25\uff1ajwid\u3010" + jwid + "\u3011\u4e0d\u5c5e\u4e8e\u7528\u6237\u3010" + username + "\u3011");
                    break block9;
                }
                LOG.info("\u767b\u5f55\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u4e0d\u5b58\u5728");
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.info("\u767b\u5f55\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011" + e.getMessage());
            }
        }
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    private void validateLoginParam(String jwid, String username, String password) {
        if (StringUtils.isEmpty((String)username)) {
            throw new RuntimeException("\u767b\u5f55\u7528\u6237\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)password)) {
            throw new RuntimeException("\u7528\u6237\u5bc6\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)jwid)) {
            throw new RuntimeException("\u5fae\u4fe1\u516c\u4f17\u53f7\u4e3a\u7a7a");
        }
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET, RequestMethod.POST})
    public void logout(String jwid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewName = "base/back/common/login.vm";
        VelocityContext velocityContext = new VelocityContext();
        request.getSession().removeAttribute("jwid");
        request.getSession().removeAttribute("jwidname");
        request.getSession().removeAttribute("OPERATE_WEB_LOGIN_USER");
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }
}

