/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.service.impl;

import com.jeecg.p3.system.dao.JwSystemUserDao;
import com.jeecg.p3.system.entity.JwSystemUser;
import com.jeecg.p3.system.entity.Menu;
import com.jeecg.p3.system.service.JwSystemUserService;
import com.jeecg.p3.system.vo.LoginUser;
import java.util.List;
import javax.annotation.Resource;
import org.jeecgframework.p3.core.utils.common.PageList;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.utils.common.Pagenation;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="jwSystemUserService")
public class JwSystemUserServiceImpl
implements JwSystemUserService {
    @Resource
    private JwSystemUserDao jwSystemUserDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doAdd(JwSystemUser jwSystemUser, List<String> roleIds) {
        this.jwSystemUserDao.add(jwSystemUser);
        if (roleIds != null && roleIds.size() > 0) {
            for (String roleId : roleIds) {
                this.jwSystemUserDao.insertUserRoleRel(jwSystemUser.getUserId(), roleId);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doEdit(JwSystemUser jwSystemUser, List<String> roleIds) {
        this.jwSystemUserDao.update(jwSystemUser);
        this.jwSystemUserDao.deleteRolesByUserId(jwSystemUser.getUserId());
        if (roleIds != null && roleIds.size() > 0) {
            for (String roleId : roleIds) {
                this.jwSystemUserDao.insertUserRoleRel(jwSystemUser.getUserId(), roleId);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doDelete(Long id) {
        JwSystemUser jwSystemUser = (JwSystemUser)this.jwSystemUserDao.get(id);
        if ("admin".equals(jwSystemUser.getUserId())) {
            throw new RuntimeException("admin\u7528\u6237\u4e0d\u80fd\u5220\u9664");
        }
        this.jwSystemUserDao.deleteRolesByUserId(jwSystemUser.getUserId());
        this.jwSystemUserDao.delete(id);
    }

    @Override
    public JwSystemUser queryById(Long id) {
        JwSystemUser jwSystemUser = (JwSystemUser)this.jwSystemUserDao.get(id);
        return jwSystemUser;
    }

    @Override
    public PageList<JwSystemUser> queryPageList(PageQuery<JwSystemUser> pageQuery) {
        PageList result = new PageList();
        Integer itemCount = this.jwSystemUserDao.count(pageQuery);
        List<JwSystemUser> list = this.jwSystemUserDao.queryPageList(pageQuery, itemCount);
        Pagenation pagenation = new Pagenation(pageQuery.getPageNo(), itemCount.intValue(), pageQuery.getPageSize());
        result.setPagenation(pagenation);
        result.setValues(list);
        return result;
    }

    @Override
    public List<String> queryUserRoles(String userId) {
        return this.jwSystemUserDao.queryUserRoles(userId);
    }

    @Override
    public List<Menu> queryUserMenuAuth(List<String> roleIds) {
        return this.jwSystemUserDao.queryUserMenuAuth(roleIds);
    }

    @Override
    public LoginUser queryUserByUserId(String userId) {
        return this.jwSystemUserDao.queryUserByUserId(userId);
    }
}

