/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.service.impl;

import com.jeecg.p3.system.dao.JwSystemAuthDao;
import com.jeecg.p3.system.entity.Auth;
import com.jeecg.p3.system.entity.JwSystemAuth;
import com.jeecg.p3.system.entity.Menu;
import com.jeecg.p3.system.entity.MenuFunction;
import com.jeecg.p3.system.service.JwSystemAuthService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.jeecgframework.p3.core.utils.common.PageList;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.utils.common.Pagenation;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="jwSystemAuthService")
public class JwSystemAuthServiceImpl
implements JwSystemAuthService {
    @Resource
    private JwSystemAuthDao jwSystemAuthDao;

    @Override
    public void doAdd(JwSystemAuth jwSystemAuth) {
        jwSystemAuth.setDelStat("0");
        this.jwSystemAuthDao.add(jwSystemAuth);
    }

    @Override
    public void doEdit(JwSystemAuth jwSystemAuth) {
        this.jwSystemAuthDao.update(jwSystemAuth);
    }

    @Override
    public void doDelete(Long id) {
        this.jwSystemAuthDao.delete(id);
    }

    @Override
    public JwSystemAuth queryById(Long id) {
        JwSystemAuth jwSystemAuth = (JwSystemAuth)this.jwSystemAuthDao.get(id);
        return jwSystemAuth;
    }

    @Override
    public PageList<JwSystemAuth> queryPageList(PageQuery<JwSystemAuth> pageQuery) {
        PageList result = new PageList();
        Integer itemCount = this.jwSystemAuthDao.count(pageQuery);
        List<JwSystemAuth> list = this.jwSystemAuthDao.queryPageList(pageQuery, itemCount);
        Pagenation pagenation = new Pagenation(pageQuery.getPageNo(), itemCount.intValue(), pageQuery.getPageSize());
        result.setPagenation(pagenation);
        result.setValues(list);
        return result;
    }

    @Override
    public List<MenuFunction> queryMenuAndFuncAuth() {
        return this.jwSystemAuthDao.queryMenuAndFuncAuth();
    }

    @Override
    public List<MenuFunction> queryMenuAndFuncAuthByRoleId(String roleId) {
        return this.jwSystemAuthDao.queryMenuAndFuncAuthByRoleId(roleId);
    }

    @Override
    public Menu queryMenuByAuthId(String authId) {
        return this.jwSystemAuthDao.queryMenuByAuthId(authId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOperateRoleAuthRel(String roleId, List<String> authIds) {
        this.jwSystemAuthDao.deleteRoleAuthRels(roleId);
        if (authIds != null && authIds.size() > 0) {
            for (String authId : authIds) {
                this.jwSystemAuthDao.insertRoleAuthRels(roleId, authId);
            }
        }
    }

    @Override
    public LinkedHashMap<Menu, ArrayList<Menu>> getSubMenuTree(String userId, String parentAuthId) {
        List<Menu> allSubMenuList = this.getAllSubMenuList(userId, parentAuthId, new ArrayList<Menu>());
        LinkedHashMap<Menu, ArrayList<Menu>> result = new LinkedHashMap<Menu, ArrayList<Menu>>();
        for (Menu menu : allSubMenuList) {
            if (this.isParentMenu(menu, allSubMenuList).booleanValue()) {
                ArrayList<Menu> subMenuList = this.getSubMenuList(allSubMenuList, menu.getAuthId());
                result.put(menu, subMenuList);
                continue;
            }
            if (this.isSonMenu(menu, allSubMenuList).booleanValue()) continue;
            result.put(menu, null);
        }
        return result;
    }

    private List<Menu> getAllSubMenuList(String userId, String parentAuthId, List<Menu> allSubMenu) {
        List<Menu> curSubMenu = this.jwSystemAuthDao.queryMenuByUserIdAndParentAuthId(userId, parentAuthId);
        if (curSubMenu.size() == 0) {
            return allSubMenu;
        }
        for (Menu menu : curSubMenu) {
            allSubMenu.add(menu);
            int allNum = allSubMenu.size();
            allSubMenu = this.getAllSubMenuList(userId, menu.getAuthId(), allSubMenu);
            int tmpNum = allSubMenu.size();
            if (allNum != tmpNum) continue;
        }
        return allSubMenu;
    }

    private Boolean isParentMenu(Menu curMenu, List<Menu> subMenuList) {
        for (Menu menu : subMenuList) {
            if (!curMenu.getAuthId().equals(menu.getParentAuthId())) continue;
            return true;
        }
        return false;
    }

    private Boolean isSonMenu(Menu curMenu, List<Menu> subMenuList) {
        for (Menu menu : subMenuList) {
            if (!menu.getAuthId().equals(curMenu.getParentAuthId())) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Menu> getSubMenuList(List<Menu> subMenuList, String parentId) {
        ArrayList<Menu> result = new ArrayList<Menu>();
        for (Menu menu : subMenuList) {
            if (!parentId.equals(menu.getParentAuthId())) continue;
            result.add(menu);
        }
        return result;
    }

    @Override
    public List<Auth> queryAuthByUserId(String userId) {
        return this.jwSystemAuthDao.queryAuthByUserId(userId);
    }

    @Override
    public List<Auth> queryAuthByAuthContr(String authContr) {
        return this.jwSystemAuthDao.queryAuthByAuthContr(authContr);
    }

    @Override
    public List<Auth> queryAuthByUserIdAndAuthContr(String userId, String authContr) {
        return this.jwSystemAuthDao.queryAuthByUserIdAndAuthContr(userId, authContr);
    }
}

