/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web.back;

import com.jeecg.p3.system.entity.JwSystemProject;
import com.jeecg.p3.system.service.JwSystemProjectService;
import com.jeecg.p3.system.util.ContextHolderUtils;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.util.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/system/back/jwSystemProject"})
public class JwSystemProjectController
extends BaseController {
    @Autowired
    private JwSystemProjectService jwSystemProjectService;

    @RequestMapping(value={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute JwSystemProject query, HttpServletResponse response, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        PageQuery pageQuery = new PageQuery();
        pageQuery.setPageNo(pageNo);
        pageQuery.setPageSize(pageSize);
        VelocityContext velocityContext = new VelocityContext();
        pageQuery.setQuery((Object)query);
        velocityContext.put("query", (Object)query);
        velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.jwSystemProjectService.queryPageList((PageQuery<JwSystemProject>)pageQuery)));
        String viewName = "system/back/jwSystemProject-list.vm";
        ViewVelocity.view((HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"toDetail"}, method={RequestMethod.GET})
    public void jwSystemProjectDetail(@RequestParam(required=true, value="id") String id, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemProject-detail.vm";
        JwSystemProject jwSystemProject = this.jwSystemProjectService.queryById(id);
        velocityContext.put("jwSystemProject", (Object)jwSystemProject);
        ViewVelocity.view((HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemProject-add.vm";
        ViewVelocity.view((HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JwSystemProject jwSystemProject) {
        AjaxJson j = new AjaxJson();
        try {
            Boolean repeat = this.jwSystemProjectService.validReat(jwSystemProject.getCode(), jwSystemProject.getId());
            if (repeat.booleanValue()) {
                j.setSuccess(false);
                j.setMsg("\u9879\u76ee\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
            } else {
                this.jwSystemProjectService.doAdd(jwSystemProject);
                j.setMsg("\u4fdd\u5b58\u6210\u529f");
            }
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") String id, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemProject jwSystemProject = this.jwSystemProjectService.queryById(id);
        velocityContext.put("jwSystemProject", (Object)jwSystemProject);
        String viewName = "system/back/jwSystemProject-edit.vm";
        ViewVelocity.view((HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JwSystemProject jwSystemProject) {
        AjaxJson j = new AjaxJson();
        try {
            Boolean repeat = this.jwSystemProjectService.validReat(jwSystemProject.getCode(), jwSystemProject.getId());
            if (repeat.booleanValue()) {
                j.setSuccess(false);
                j.setMsg("\u9879\u76ee\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
            } else {
                this.jwSystemProjectService.doEdit(jwSystemProject);
                j.setMsg("\u7f16\u8f91\u6210\u529f");
            }
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemProjectService.doDelete(id);
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"/doUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson doUpload(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            MultipartFile uploadify = request.getFile("file");
            byte[] bytes = uploadify.getBytes();
            System.out.println(uploadify.getOriginalFilename());
            String uploadDir = ContextHolderUtils.getRequest().getSession().getServletContext().getRealPath("upload/img/system");
            File dirPath = new File(uploadDir);
            if (!dirPath.exists()) {
                dirPath.mkdirs();
            }
            String sep = System.getProperty("file.separator");
            File uploadedFile = new File(uploadDir + sep + uploadify.getOriginalFilename());
            FileCopyUtils.copy((byte[])bytes, (File)uploadedFile);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }
}

