/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web.back;

import com.jeecg.p3.system.entity.JwSystemAuth;
import com.jeecg.p3.system.entity.JwSystemAuthMutex;
import com.jeecg.p3.system.entity.Menu;
import com.jeecg.p3.system.entity.MenuFunction;
import com.jeecg.p3.system.entity.MenuMutex;
import com.jeecg.p3.system.service.JwSystemAuthMutexService;
import com.jeecg.p3.system.service.JwSystemAuthService;
import com.jeecg.p3.system.util.SystemUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.util.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.utils.common.StringUtils;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/back/jwSystemAuth"})
public class JwSystemAuthController
extends BaseController {
    @Autowired
    private JwSystemAuthService jwSystemAuthService;
    @Autowired
    private JwSystemAuthMutexService jwSystemAuthMutexService;

    @RequestMapping(value={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute JwSystemAuth query, HttpServletResponse response, HttpServletRequest request, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        PageQuery pageQuery = new PageQuery();
        pageQuery.setPageNo(pageNo);
        pageQuery.setPageSize(pageSize);
        VelocityContext velocityContext = new VelocityContext();
        pageQuery.setQuery((Object)query);
        velocityContext.put("jwSystemAuth", (Object)query);
        velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.jwSystemAuthService.queryPageList((PageQuery<JwSystemAuth>)pageQuery)));
        String viewName = "system/back/jwSystemAuth-list.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"toDetail"}, method={RequestMethod.GET})
    public void jwSystemAuthDetail(@RequestParam(required=true, value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemAuth-detail.vm";
        JwSystemAuth jwSystemAuth = this.jwSystemAuthService.queryById(id);
        velocityContext.put("jwSystemAuth", (Object)jwSystemAuth);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemAuth-add.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JwSystemAuth jwSystemAuth) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemAuthService.doAdd(jwSystemAuth);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemAuth jwSystemAuth = this.jwSystemAuthService.queryById(id);
        velocityContext.put("jwSystemAuth", (Object)jwSystemAuth);
        String viewName = "system/back/jwSystemAuth-edit.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JwSystemAuth jwSystemAuth) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemAuthService.doEdit(jwSystemAuth);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") Long id) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemAuthService.doDelete(id);
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"/initAuth"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String initAuth(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="roleId", required=true) String roleId) {
        log.info("\u521d\u59cb\u5316\u6743\u9650");
        String tree = "";
        try {
            List<MenuFunction> allAuthList = this.jwSystemAuthService.queryMenuAndFuncAuth();
            List<MenuFunction> roleAuthList = this.jwSystemAuthService.queryMenuAndFuncAuthByRoleId(roleId);
            tree = SystemUtil.list2TreeWithCheck(allAuthList, roleAuthList);
            log.info("\u521d\u59cb\u5316\u6743\u9650: " + tree);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return tree;
    }

    @RequestMapping(value={"/editRoleAuth"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson editRoleAuth(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="checkedNodes", required=true) String checkedNodes, @RequestParam(value="roleId", required=true) String roleId) {
        AjaxJson j = new AjaxJson();
        log.info("\u7f16\u8f91\u89d2\u8272\u6743\u9650");
        try {
            MenuMutex menuMutex;
            ArrayList<String> authIds = new ArrayList<String>();
            if (StringUtils.isNotEmpty((String)checkedNodes)) {
                for (String auth : checkedNodes.split(",")) {
                    authIds.add(auth);
                }
            }
            if ((menuMutex = this.checkAuthMutex(authIds)) != null) {
                j.setSuccess(false);
                j.setMsg("\u89d2\u8272\u6388\u6743\u5931\u8d25\uff1a\u3010" + menuMutex.getMenu().getAuthName() + "\u3011\u4e0e\u3010" + menuMutex.getMutexMenu().getAuthName() + "\u3011\u6743\u9650\u51b2\u7a81\uff01");
                j.setObj((Object)menuMutex);
                return j;
            }
            this.jwSystemAuthService.modifyOperateRoleAuthRel(roleId, authIds);
            j.setSuccess(true);
            j.setMsg("\u89d2\u8272\u6388\u6743\u6210\u529f");
            log.info("\u7f16\u8f91\u89d2\u8272\u6743\u9650\u5b8c\u6210 ");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u89d2\u8272\u6388\u6743\u5931\u8d25");
        }
        return j;
    }

    private MenuMutex checkAuthMutex(List<String> authIds) {
        if (authIds == null || authIds.size() <= 0) {
            return null;
        }
        List<JwSystemAuthMutex> authMutexList = this.jwSystemAuthMutexService.queryAllAuthMutex();
        MenuMutex result = new MenuMutex();
        for (JwSystemAuthMutex authMutex : authMutexList) {
            if (!authIds.contains(authMutex.getAuthId()) || !authIds.contains(authMutex.getMutexAuthId())) continue;
            Menu menu = this.jwSystemAuthService.queryMenuByAuthId(authMutex.getAuthId());
            Menu menuMutex = this.jwSystemAuthService.queryMenuByAuthId(authMutex.getMutexAuthId());
            result.setMenu(menu);
            result.setMutexMenu(menuMutex);
            return result;
        }
        return null;
    }
}

