/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.service.impl;

import com.jeecg.p3.system.dao.JwSystemAuthDao;
import com.jeecg.p3.system.dao.JwSystemRoleDao;
import com.jeecg.p3.system.entity.JwSystemRole;
import com.jeecg.p3.system.service.JwSystemRoleService;
import java.util.List;
import javax.annotation.Resource;
import org.jeecgframework.p3.core.utils.common.PageList;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.utils.common.Pagenation;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="jwSystemRoleService")
public class JwSystemRoleServiceImpl
implements JwSystemRoleService {
    @Resource
    private JwSystemRoleDao jwSystemRoleDao;
    @Resource
    private JwSystemAuthDao jwSystemAuthDao;

    @Override
    public void doAdd(JwSystemRole jwSystemRole) {
        this.jwSystemRoleDao.add(jwSystemRole);
    }

    @Override
    public void doEdit(JwSystemRole jwSystemRole) {
        this.jwSystemRoleDao.update(jwSystemRole);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doDelete(Long id, String roleId) {
        this.jwSystemAuthDao.deleteRoleAuthRels(roleId);
        this.jwSystemRoleDao.delete(id);
    }

    @Override
    public JwSystemRole queryById(Long id) {
        JwSystemRole jwSystemRole = (JwSystemRole)this.jwSystemRoleDao.get(id);
        return jwSystemRole;
    }

    @Override
    public PageList<JwSystemRole> queryPageList(PageQuery<JwSystemRole> pageQuery) {
        PageList result = new PageList();
        Integer itemCount = this.jwSystemRoleDao.count(pageQuery);
        List<JwSystemRole> list = this.jwSystemRoleDao.queryPageList(pageQuery, itemCount);
        Pagenation pagenation = new Pagenation(pageQuery.getPageNo(), itemCount.intValue(), pageQuery.getPageSize());
        result.setPagenation(pagenation);
        result.setValues(list);
        return result;
    }

    @Override
    public List<JwSystemRole> queryAllRoleList() {
        return this.jwSystemRoleDao.queryAllRoleList();
    }
}

