/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.domo.order.web;

import com.jeecg.domo.order.entity.JpDemoOrderCustomEntity;
import com.jeecg.domo.order.entity.JpDemoOrderMainEntity;
import com.jeecg.domo.order.entity.JpDemoOrderProductEntity;
import com.jeecg.domo.order.page.JpDemoOrderMainPage;
import com.jeecg.domo.order.service.JpDemoOrderCustomService;
import com.jeecg.domo.order.service.JpDemoOrderMainService;
import com.jeecg.domo.order.service.JpDemoOrderProductService;
import com.jeecg.domo.order.util.QueryRuleSqlUtil;
import com.jeecg.domo.vo.QueryRuleVo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.page.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/demo/jpDemoOrderMain"})
public class JpDemoOrderMainController
extends BaseController {
    @Autowired
    private JpDemoOrderMainService jpDemoOrderMainService;
    @Autowired
    private JpDemoOrderProductService jpDemoOrderProductService;
    @Autowired
    private JpDemoOrderCustomService jpDemoOrderCustomService;

    @RequestMapping(params={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute QueryRuleVo queryRule, @ModelAttribute JpDemoOrderMainEntity query, HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        try {
            String sql = QueryRuleSqlUtil.queryRuleSql(queryRule);
            MiniDaoPage<JpDemoOrderMainEntity> list = this.jpDemoOrderMainService.getAll(query, sql, pageNo, pageSize);
            VelocityContext velocityContext = new VelocityContext();
            query.setDelflag(0);
            velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(list));
            velocityContext.put("queryRule", (Object)queryRule);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("GO_ORDER_CODE", "\u8ba2\u5355\u53f7");
            map.put("GO_CONTACT_NAME", "\u8054\u7cfb\u4eba");
            map.put("USERTYPE", "\u987e\u5ba2\u7c7b\u578b");
            map.put("GO_TELPHONE", "\u624b\u673a");
            map.put("GO_ORDER_COUNT", "\u8ba2\u5355\u4eba\u6570");
            map.put("GODER_TYPE", "\u8ba2\u5355\u7c7b\u578b");
            map.put("GO_RETURN_PRICE", "\u8fd4\u6b3e");
            map.put("GO_ALL_PRICE", "\u603b\u4ef7");
            map.put("CREATE_DT", "\u521b\u5efa\u65f6\u95f4");
            map.put("GO_CONTENT", "\u5907\u6ce8");
            velocityContext.put("allColumn", map);
            String viewName = "demo/order/jpDemoOrderMain-list.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"toDetail"}, method={RequestMethod.GET})
    public void jpDemoOrderMainDetail(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "demo/order/jpDemoOrderMain-detail.vm";
        JpDemoOrderMainEntity jpDemoOrderMain = this.jpDemoOrderMainService.get(id);
        List<JpDemoOrderCustomEntity> jpDemoOrderCustomEntities = this.jpDemoOrderCustomService.getByOrderCode(jpDemoOrderMain.getGoOrderCode());
        List<JpDemoOrderProductEntity> jpDemoOrderProductEntities = this.jpDemoOrderProductService.getByOrderCode(jpDemoOrderMain.getGoOrderCode());
        velocityContext.put("jpDemoOrderMain", (Object)jpDemoOrderMain);
        velocityContext.put("jpDemoOrderCustomEntities", jpDemoOrderCustomEntities);
        velocityContext.put("jpDemoOrderProductEntities", jpDemoOrderProductEntities);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(params={"toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "demo/order/jpDemoOrderMain-add.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(params={"doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JpDemoOrderMainEntity jpDemoOrderMain, @ModelAttribute JpDemoOrderMainPage jpDemoOrderMainPage) {
        AjaxJson j = new AjaxJson();
        try {
            List<JpDemoOrderCustomEntity> jpDemoOrderCustomEntities = jpDemoOrderMainPage.getJpDemoOrderCustomEntities();
            if (jpDemoOrderCustomEntities.size() <= 0) {
                j.setMsg("\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u5ba2\u6237\u8be6\u60c5");
                j.setSuccess(false);
                return j;
            }
            List<JpDemoOrderProductEntity> jpDemoOrderProductEntities = jpDemoOrderMainPage.getJpDemoOrderProductEntities();
            if (jpDemoOrderProductEntities.size() <= 0) {
                j.setMsg("\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u4ea7\u54c1\u8be6\u60c5");
                j.setSuccess(false);
                return j;
            }
            String randomSeed = UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
            jpDemoOrderMain.setId(randomSeed);
            jpDemoOrderMain.setDelflag(0);
            jpDemoOrderMain.setCreateDt(new Date());
            this.jpDemoOrderMainService.insert(jpDemoOrderMain);
            for (JpDemoOrderProductEntity entity : jpDemoOrderProductEntities) {
                randomSeed = UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
                entity.setId(randomSeed);
                if (StringUtils.isEmpty((String)jpDemoOrderMain.getGoOrderCode())) {
                    j.setMsg("\u5173\u8054\u5916\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                    j.setSuccess(false);
                    return j;
                }
                entity.setGoOrderCode(jpDemoOrderMain.getGoOrderCode());
                entity.setCreateDt(new Date());
                entity.setDelflag(0);
                this.jpDemoOrderProductService.insert(entity);
            }
            for (JpDemoOrderCustomEntity jpDemoOrderCustomEntity : jpDemoOrderCustomEntities) {
                randomSeed = UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
                jpDemoOrderCustomEntity.setId(randomSeed);
                if (StringUtils.isEmpty((String)jpDemoOrderMain.getGoOrderCode())) {
                    j.setMsg("\u5173\u8054\u5916\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                    j.setSuccess(false);
                    return j;
                }
                jpDemoOrderCustomEntity.setGoOrderCode(jpDemoOrderMain.getGoOrderCode());
                jpDemoOrderCustomEntity.setCreateDt(new Date());
                jpDemoOrderCustomEntity.setDelflag(0);
                this.jpDemoOrderCustomService.insert(jpDemoOrderCustomEntity);
            }
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        try {
            VelocityContext velocityContext = new VelocityContext();
            JpDemoOrderMainEntity jpDemoOrderMain = this.jpDemoOrderMainService.get(id);
            List<JpDemoOrderCustomEntity> jpDemoOrderCustomEntities = this.jpDemoOrderCustomService.getByOrderCode(jpDemoOrderMain.getGoOrderCode());
            List<JpDemoOrderProductEntity> jpDemoOrderProductEntities = this.jpDemoOrderProductService.getByOrderCode(jpDemoOrderMain.getGoOrderCode());
            velocityContext.put("jpDemoOrderMain", (Object)jpDemoOrderMain);
            velocityContext.put("jpDemoOrderCustomEntities", jpDemoOrderCustomEntities);
            velocityContext.put("jpDemoOrderProductEntities", jpDemoOrderProductEntities);
            String viewName = "demo/order/jpDemoOrderMain-edit.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JpDemoOrderMainEntity jpDemoOrderMain, @ModelAttribute JpDemoOrderMainPage jpDemoOrderMainPage) {
        AjaxJson j = new AjaxJson();
        try {
            String randomSeed;
            List<JpDemoOrderCustomEntity> jpDemoOrderCustomEntities = jpDemoOrderMainPage.getJpDemoOrderCustomEntities();
            if (jpDemoOrderCustomEntities.size() <= 0) {
                j.setMsg("\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u5ba2\u6237\u8be6\u60c5");
                j.setSuccess(false);
                return j;
            }
            List<JpDemoOrderProductEntity> jpDemoOrderProductEntities = jpDemoOrderMainPage.getJpDemoOrderProductEntities();
            if (jpDemoOrderProductEntities.size() <= 0) {
                j.setMsg("\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u4ea7\u54c1\u8be6\u60c5");
                j.setSuccess(false);
                return j;
            }
            this.jpDemoOrderMainService.update(jpDemoOrderMain);
            JpDemoOrderMainEntity tempJpDemoOrderMainEntity = this.jpDemoOrderMainService.get(jpDemoOrderMain.getId());
            boolean jpDemoOrderCustomIsChange = false;
            boolean jpDemoOrderProductIsChange = false;
            if (!tempJpDemoOrderMainEntity.getGoOrderCode().equals(jpDemoOrderMain.getGoOrderCode())) {
                this.jpDemoOrderCustomService.deleteByOrderCode(tempJpDemoOrderMainEntity.getGoOrderCode());
                jpDemoOrderCustomIsChange = true;
                this.jpDemoOrderProductService.deleteByOrderCode(tempJpDemoOrderMainEntity.getGoOrderCode());
                jpDemoOrderProductIsChange = true;
            } else {
                Integer jpDemoOrderProductCount;
                Integer n = this.jpDemoOrderCustomService.getCountByOrderCode(jpDemoOrderMain.getGoOrderCode());
                if (n.intValue() != jpDemoOrderCustomEntities.size()) {
                    this.jpDemoOrderCustomService.deleteByOrderCode(jpDemoOrderMain.getGoOrderCode());
                    jpDemoOrderCustomIsChange = true;
                }
                if ((jpDemoOrderProductCount = Integer.valueOf(this.jpDemoOrderProductService.getCountByOrderCode(jpDemoOrderMain.getGoOrderCode()))).intValue() != jpDemoOrderProductEntities.size()) {
                    this.jpDemoOrderProductService.deleteByOrderCode(jpDemoOrderMain.getGoOrderCode());
                    jpDemoOrderProductIsChange = true;
                }
            }
            for (JpDemoOrderCustomEntity jpDemoOrderCustomEntity : jpDemoOrderCustomEntities) {
                if (StringUtils.isEmpty((String)jpDemoOrderCustomEntity.getId()) || jpDemoOrderCustomIsChange) {
                    randomSeed = UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
                    jpDemoOrderCustomEntity.setId(randomSeed);
                    jpDemoOrderCustomEntity.setCreateDt(new Date());
                    jpDemoOrderCustomEntity.setDelflag(0);
                    jpDemoOrderCustomEntity.setGoOrderCode(jpDemoOrderMain.getGoOrderCode());
                    this.jpDemoOrderCustomService.insert(jpDemoOrderCustomEntity);
                    continue;
                }
                this.jpDemoOrderCustomService.update(jpDemoOrderCustomEntity);
            }
            for (JpDemoOrderProductEntity jpDemoOrderProductEntity : jpDemoOrderProductEntities) {
                if (StringUtils.isEmpty((String)jpDemoOrderProductEntity.getId()) || jpDemoOrderProductIsChange) {
                    randomSeed = UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
                    jpDemoOrderProductEntity.setId(randomSeed);
                    jpDemoOrderProductEntity.setCreateDt(new Date());
                    jpDemoOrderProductEntity.setDelflag(0);
                    jpDemoOrderProductEntity.setGoOrderCode(jpDemoOrderMain.getGoOrderCode());
                    this.jpDemoOrderProductService.insert(jpDemoOrderProductEntity);
                    continue;
                }
                this.jpDemoOrderProductService.update(jpDemoOrderProductEntity);
            }
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            JpDemoOrderMainEntity jpDemoOrderMain = new JpDemoOrderMainEntity();
            jpDemoOrderMain.setId(id);
            this.jpDemoOrderMainService.delete(jpDemoOrderMain);
            this.jpDemoOrderCustomService.delByOrderCode(jpDemoOrderMain.getGoOrderCode());
            this.jpDemoOrderProductService.delbyOrderCode(jpDemoOrderMain.getGoOrderCode());
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"checkOrderCode"})
    @ResponseBody
    public Map<String, String> checkOrderCode(String orderCode, String id, HttpServletRequest request) {
        orderCode = request.getParameter("param");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            if (orderCode != null && !orderCode.trim().equals("")) {
                JpDemoOrderMainEntity jpDemoOrderMainEntity = this.jpDemoOrderMainService.getByOrderCode(orderCode);
                this.LOG.debug("jpDemoOrderMainEntity == null" + (jpDemoOrderMainEntity == null));
                if (jpDemoOrderMainEntity != null && !jpDemoOrderMainEntity.getId().equals(id)) {
                    resultMap.put("info", "\u8be5\u7f16\u7801\u4e0d\u53ef\u7528");
                    resultMap.put("status", "n");
                } else {
                    resultMap.put("info", "\u8be5\u7f16\u7801\u53ef\u7528");
                    resultMap.put("status", "y");
                }
            } else {
                resultMap.put("info", "\u8be5\u7f16\u7801\u53ef\u7528");
                resultMap.put("status", "y");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap.put("info", "\u670d\u52a1\u7aef\u5f02\u5e38\uff1a" + e.getMessage());
            resultMap.put("status", "n");
        }
        this.LOG.debug(((Object)resultMap).toString());
        return resultMap;
    }
}

