/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.auth.web;

import com.jeecg.auth.dao.JwSystemAuthDao;
import com.jeecg.auth.entity.JwSystemAuth;
import com.jeecg.auth.util.SystemUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.page.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/p3/auth"})
public class JwSystemAuthController
extends BaseController {
    @Autowired
    private JwSystemAuthDao jwSystemAuthDao;

    @RequestMapping(params={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute JwSystemAuth query, HttpServletResponse response, HttpServletRequest request, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="100") int pageSize) throws Exception {
        MiniDaoPage<JwSystemAuth> list = this.jwSystemAuthDao.getAll(query, pageNo, pageSize);
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("jwSystemAuth", (Object)query);
        velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(list));
        String viewName = "auth/jwSystemAuth-list.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(params={"toDetail"}, method={RequestMethod.GET})
    public void jwSystemAuthDetail(@RequestParam(required=true, value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "auth/jwSystemAuth-detail.vm";
        JwSystemAuth jwSystemAuth = this.jwSystemAuthDao.get(id);
        velocityContext.put("jwSystemAuth", (Object)jwSystemAuth);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(params={"toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "auth/jwSystemAuth-add.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(params={"doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JwSystemAuth jwSystemAuth) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemAuthDao.insert(jwSystemAuth);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemAuth jwSystemAuth = this.jwSystemAuthDao.get(id);
        velocityContext.put("jwSystemAuth", (Object)jwSystemAuth);
        String viewName = "auth/jwSystemAuth-edit.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(params={"doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JwSystemAuth jwSystemAuth) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemAuthDao.update(jwSystemAuth);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") Long id) {
        AjaxJson j = new AjaxJson();
        try {
            JwSystemAuth jwSystemAuth = new JwSystemAuth();
            jwSystemAuth.setId(id);
            this.jwSystemAuthDao.delete(jwSystemAuth);
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"getAuthTree"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getAuthTree(HttpServletRequest request, HttpServletResponse response) {
        String tree = "";
        try {
            List<JwSystemAuth> allAuthList = this.jwSystemAuthDao.queryMenuAndFuncAuth();
            tree = SystemUtil.listTreeToAuth(allAuthList);
            log.info("\u6743\u9650\u6811: " + tree);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return tree;
    }
}

