/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.task;

import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.task.engine.NacosDelayTaskExecuteEngine;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.index.ClientServiceIndexesManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NamingExecuteTaskDispatcher;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.push.v2.executor.PushExecutor;
import com.alibaba.nacos.naming.push.v2.task.PushDelayTask;
import com.alibaba.nacos.naming.push.v2.task.PushExecuteTask;

public class PushDelayTaskExecuteEngine
extends NacosDelayTaskExecuteEngine {
    private final ClientManager clientManager;
    private final ClientServiceIndexesManager indexesManager;
    private final ServiceStorage serviceStorage;
    private final NamingMetadataManager metadataManager;
    private final PushExecutor pushExecutor;
    private final SwitchDomain switchDomain;

    public PushDelayTaskExecuteEngine(ClientManager clientManager, ClientServiceIndexesManager indexesManager, ServiceStorage serviceStorage, NamingMetadataManager metadataManager, PushExecutor pushExecutor, SwitchDomain switchDomain) {
        super(PushDelayTaskExecuteEngine.class.getSimpleName(), Loggers.PUSH);
        this.clientManager = clientManager;
        this.indexesManager = indexesManager;
        this.serviceStorage = serviceStorage;
        this.metadataManager = metadataManager;
        this.pushExecutor = pushExecutor;
        this.switchDomain = switchDomain;
        this.setDefaultTaskProcessor(new PushDelayTaskProcessor(this));
    }

    public ClientManager getClientManager() {
        return this.clientManager;
    }

    public ClientServiceIndexesManager getIndexesManager() {
        return this.indexesManager;
    }

    public ServiceStorage getServiceStorage() {
        return this.serviceStorage;
    }

    public NamingMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public PushExecutor getPushExecutor() {
        return this.pushExecutor;
    }

    protected void processTasks() {
        if (!this.switchDomain.isPushEnabled()) {
            return;
        }
        super.processTasks();
    }

    private static class PushDelayTaskProcessor
    implements NacosTaskProcessor {
        private final PushDelayTaskExecuteEngine executeEngine;

        public PushDelayTaskProcessor(PushDelayTaskExecuteEngine executeEngine) {
            this.executeEngine = executeEngine;
        }

        public boolean process(NacosTask task) {
            PushDelayTask pushDelayTask = (PushDelayTask)task;
            Service service = pushDelayTask.getService();
            NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(service, new PushExecuteTask(service, this.executeEngine, pushDelayTask));
            return true;
        }
    }
}

