/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute;

import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.InstanceUpgradeHelper;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class DefaultInstanceUpgradeHelper
implements InstanceUpgradeHelper {
    private static final String IGNORE_PROPERTIES = "metadata";

    @Override
    public Instance toV1(com.alibaba.nacos.api.naming.pojo.Instance v2) {
        Instance v1 = new Instance(v2.getIp(), v2.getPort(), v2.getClusterName());
        BeanUtils.copyProperties((Object)v2, (Object)v1);
        v1.setIp(v2.getIp());
        v1.setPort(v2.getPort());
        v1.setClusterName(v2.getClusterName());
        v1.setHealthy(v2.isHealthy());
        v1.setEphemeral(v2.isEphemeral());
        v1.setWeight(v2.getWeight());
        v1.setMetadata(v2.getMetadata());
        v1.setEnabled(v2.isEnabled());
        v1.setServiceName(v2.getServiceName());
        return v1;
    }

    @Override
    public com.alibaba.nacos.api.naming.pojo.Instance toV2(Instance v1) {
        com.alibaba.nacos.api.naming.pojo.Instance v2 = new com.alibaba.nacos.api.naming.pojo.Instance();
        BeanUtils.copyProperties((Object)v1, (Object)v2, (String[])new String[]{IGNORE_PROPERTIES});
        v2.getMetadata().putAll(v1.getMetadata());
        return v2;
    }

    @Configuration
    public static class Config {
        @Bean
        @ConditionalOnMissingBean(value={InstanceUpgradeHelper.class})
        public InstanceUpgradeHelper defaultInstanceUpgradeHelper() {
            return new DefaultInstanceUpgradeHelper();
        }
    }
}

