/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.client.manager.impl;

import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientAttributes;
import com.alibaba.nacos.naming.core.v2.client.factory.ClientFactory;
import com.alibaba.nacos.naming.core.v2.client.factory.ClientFactoryHolder;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.event.client.ClientEvent;
import com.alibaba.nacos.naming.healthcheck.heartbeat.ClientBeatUpdateTask;
import com.alibaba.nacos.naming.misc.ClientConfig;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NamingExecuteTaskDispatcher;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component(value="ephemeralIpPortClientManager")
public class EphemeralIpPortClientManager
implements ClientManager {
    private final ConcurrentMap<String, IpPortBasedClient> clients = new ConcurrentHashMap<String, IpPortBasedClient>();
    private final DistroMapper distroMapper;
    private final ClientFactory<IpPortBasedClient> clientFactory;

    public EphemeralIpPortClientManager(DistroMapper distroMapper, SwitchDomain switchDomain) {
        this.distroMapper = distroMapper;
        GlobalExecutor.scheduleExpiredClientCleaner(new ExpiredClientCleaner(this, switchDomain), 0L, Constants.DEFAULT_HEART_BEAT_INTERVAL, TimeUnit.MILLISECONDS);
        this.clientFactory = ClientFactoryHolder.getInstance().findClientFactory("ephemeralIpPort");
    }

    @Override
    public boolean clientConnected(String clientId, ClientAttributes attributes) {
        return this.clientConnected(this.clientFactory.newClient(clientId, attributes));
    }

    @Override
    public boolean clientConnected(Client client) {
        this.clients.computeIfAbsent(client.getClientId(), s -> {
            Loggers.SRV_LOG.info("Client connection {} connect", (Object)client.getClientId());
            IpPortBasedClient ipPortBasedClient = (IpPortBasedClient)client;
            ipPortBasedClient.init();
            return ipPortBasedClient;
        });
        return true;
    }

    @Override
    public boolean syncClientConnected(String clientId, ClientAttributes attributes) {
        return this.clientConnected(this.clientFactory.newSyncedClient(clientId, attributes));
    }

    @Override
    public boolean clientDisconnected(String clientId) {
        Loggers.SRV_LOG.info("Client connection {} disconnect, remove instances and subscribers", (Object)clientId);
        IpPortBasedClient client = (IpPortBasedClient)this.clients.remove(clientId);
        if (null == client) {
            return true;
        }
        NotifyCenter.publishEvent((Event)new ClientEvent.ClientDisconnectEvent(client));
        client.release();
        return true;
    }

    @Override
    public Client getClient(String clientId) {
        return (Client)this.clients.get(clientId);
    }

    @Override
    public boolean contains(String clientId) {
        return this.clients.containsKey(clientId);
    }

    @Override
    public Collection<String> allClientId() {
        return this.clients.keySet();
    }

    @Override
    public boolean isResponsibleClient(Client client) {
        if (client instanceof IpPortBasedClient) {
            return this.distroMapper.responsible(((IpPortBasedClient)client).getResponsibleId());
        }
        return false;
    }

    @Override
    public boolean verifyClient(String clientId) {
        IpPortBasedClient client = (IpPortBasedClient)this.clients.get(clientId);
        if (null != client) {
            NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(clientId, new ClientBeatUpdateTask(client));
            return true;
        }
        return false;
    }

    private static class ExpiredClientCleaner
    implements Runnable {
        private final EphemeralIpPortClientManager clientManager;
        private final SwitchDomain switchDomain;

        public ExpiredClientCleaner(EphemeralIpPortClientManager clientManager, SwitchDomain switchDomain) {
            this.clientManager = clientManager;
            this.switchDomain = switchDomain;
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            for (String each : this.clientManager.allClientId()) {
                IpPortBasedClient client = (IpPortBasedClient)this.clientManager.getClient(each);
                if (null == client || !this.isExpireClient(currentTime, client)) continue;
                this.clientManager.clientDisconnected(each);
            }
        }

        private boolean isExpireClient(long currentTime, IpPortBasedClient client) {
            long noUpdatedTime = currentTime - client.getLastUpdatedTime();
            return client.isEphemeral() && (this.isExpirePublishedClient(noUpdatedTime, client) && this.isExpireSubscriberClient(noUpdatedTime, client) || noUpdatedTime > ClientConfig.getInstance().getClientExpiredTime());
        }

        private boolean isExpirePublishedClient(long noUpdatedTime, IpPortBasedClient client) {
            return client.getAllPublishedService().isEmpty() && noUpdatedTime > Constants.DEFAULT_IP_DELETE_TIMEOUT;
        }

        private boolean isExpireSubscriberClient(long noUpdatedTime, IpPortBasedClient client) {
            return client.getAllSubscribeService().isEmpty() || noUpdatedTime > this.switchDomain.getDefaultPushCacheMillis();
        }
    }
}

