/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.builder.InstanceBuilder;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.InstanceOperatorClientImpl;
import com.alibaba.nacos.naming.core.InstancePatchObject;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.pojo.InstanceOperationInfo;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.pojo.instance.BeatInfoInstanceBuilder;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.naming.web.NamingResourceParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/ns/instance"})
public class InstanceControllerV2 {
    @Autowired
    private SwitchDomain switchDomain;
    @Autowired
    private InstanceOperatorClientImpl instanceServiceV2;

    @CanDistro
    @PostMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String register(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam String ip, @RequestParam(defaultValue="DEFAULT") String cluster, @RequestParam Integer port, @RequestParam(defaultValue="true") Boolean healthy, @RequestParam(defaultValue="1") Double weight, @RequestParam(defaultValue="true") Boolean enabled, @RequestParam String metadata, @RequestParam Boolean ephemeral) throws Exception {
        NamingUtils.checkServiceNameFormat((String)serviceName);
        this.checkWeight(weight);
        Instance instance = InstanceBuilder.newBuilder().setServiceName(serviceName).setIp(ip).setClusterName(cluster).setPort(port).setHealthy(healthy).setWeight(weight).setEnabled(enabled).setMetadata(UtilsAndCommons.parseMetadata(metadata)).setEphemeral(ephemeral).build();
        if (ephemeral == null) {
            instance.setEphemeral(this.switchDomain.isDefaultInstanceEphemeral());
        }
        this.instanceServiceV2.registerInstance(namespaceId, serviceName, instance);
        return "ok";
    }

    @CanDistro
    @DeleteMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String deregister(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam String ip, @RequestParam(defaultValue="DEFAULT") String cluster, @RequestParam Integer port, @RequestParam(defaultValue="true") Boolean healthy, @RequestParam(defaultValue="1") Double weight, @RequestParam(defaultValue="true") Boolean enabled, @RequestParam String metadata, @RequestParam Boolean ephemeral) throws Exception {
        NamingUtils.checkServiceNameFormat((String)serviceName);
        this.checkWeight(weight);
        Instance instance = InstanceBuilder.newBuilder().setServiceName(serviceName).setIp(ip).setClusterName(cluster).setPort(port).setHealthy(healthy).setWeight(weight).setEnabled(enabled).setMetadata(UtilsAndCommons.parseMetadata(metadata)).setEphemeral(ephemeral).build();
        if (ephemeral == null) {
            instance.setEphemeral(this.switchDomain.isDefaultInstanceEphemeral());
        }
        this.instanceServiceV2.removeInstance(namespaceId, serviceName, instance);
        return "ok";
    }

    @CanDistro
    @PutMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String update(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam String ip, @RequestParam(defaultValue="DEFAULT") String cluster, @RequestParam Integer port, @RequestParam(defaultValue="true") Boolean healthy, @RequestParam(defaultValue="1") Double weight, @RequestParam(defaultValue="true") Boolean enabled, @RequestParam String metadata, @RequestParam Boolean ephemeral) throws Exception {
        NamingUtils.checkServiceNameFormat((String)serviceName);
        this.checkWeight(weight);
        Instance instance = InstanceBuilder.newBuilder().setServiceName(serviceName).setIp(ip).setClusterName(cluster).setPort(port).setHealthy(healthy).setWeight(weight).setEnabled(enabled).setMetadata(UtilsAndCommons.parseMetadata(metadata)).setEphemeral(ephemeral).build();
        if (ephemeral == null) {
            instance.setEphemeral(this.switchDomain.isDefaultInstanceEphemeral());
        }
        this.instanceServiceV2.updateInstance(namespaceId, serviceName, instance);
        return "ok";
    }

    @CanDistro
    @PutMapping(value={"/metadata/batch"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public ObjectNode batchUpdateInstanceMetadata(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam(defaultValue="") String consistencyType, @RequestParam(defaultValue="") String instances, @RequestParam String metadata) throws Exception {
        List<Instance> targetInstances = this.parseBatchInstances(instances);
        Map<String, String> targetMetadata = UtilsAndCommons.parseMetadata(metadata);
        InstanceOperationInfo instanceOperationInfo = this.buildOperationInfo(serviceName, consistencyType, targetInstances);
        List<String> operatedInstances = this.instanceServiceV2.batchUpdateMetadata(namespaceId, instanceOperationInfo, targetMetadata);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode ipArray = JacksonUtils.createEmptyArrayNode();
        for (String ip : operatedInstances) {
            ipArray.add(ip);
        }
        result.replace("updated", (JsonNode)ipArray);
        return result;
    }

    @CanDistro
    @DeleteMapping(value={"/metadata/batch"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public ObjectNode batchDeleteInstanceMetadata(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam(defaultValue="") String consistencyType, @RequestParam(defaultValue="") String instances, @RequestParam String metadata) throws Exception {
        List<Instance> targetInstances = this.parseBatchInstances(instances);
        Map<String, String> targetMetadata = UtilsAndCommons.parseMetadata(metadata);
        InstanceOperationInfo instanceOperationInfo = this.buildOperationInfo(serviceName, consistencyType, targetInstances);
        List<String> operatedInstances = this.instanceServiceV2.batchDeleteMetadata(namespaceId, instanceOperationInfo, targetMetadata);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode ipArray = JacksonUtils.createEmptyArrayNode();
        for (String ip : operatedInstances) {
            ipArray.add(ip);
        }
        result.replace("updated", (JsonNode)ipArray);
        return result;
    }

    private InstanceOperationInfo buildOperationInfo(String serviceName, String consistencyType, List<Instance> instances) {
        if (!CollectionUtils.isEmpty(instances)) {
            for (Instance instance : instances) {
                if (!StringUtils.isBlank((CharSequence)instance.getClusterName())) continue;
                instance.setClusterName("DEFAULT");
            }
        }
        return new InstanceOperationInfo(serviceName, consistencyType, instances);
    }

    private List<Instance> parseBatchInstances(String instances) {
        try {
            return (List)JacksonUtils.toObj((String)instances, (TypeReference)new TypeReference<List<Instance>>(){});
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("UPDATE-METADATA: Param 'instances' is illegal, ignore this operation", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @CanDistro
    @PatchMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String patch(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam String ip, @RequestParam(defaultValue="DEFAULT") String cluster, @RequestParam Integer port, @RequestParam Double weight, @RequestParam Boolean enabled, @RequestParam String metadata) throws Exception {
        NamingUtils.checkServiceNameFormat((String)serviceName);
        InstancePatchObject patchObject = new InstancePatchObject(cluster, ip, port);
        if (StringUtils.isNotBlank((String)metadata)) {
            patchObject.setMetadata(UtilsAndCommons.parseMetadata(metadata));
        }
        if (weight != null) {
            this.checkWeight(weight);
            patchObject.setWeight(weight);
        }
        if (enabled != null) {
            patchObject.setEnabled(enabled);
        }
        this.instanceServiceV2.patchInstance(namespaceId, serviceName, patchObject);
        return "ok";
    }

    @GetMapping(value={"/list"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public Object list(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam(defaultValue="") String clusters, @RequestParam(defaultValue="") String clientIP, @RequestParam(defaultValue="0") Integer udpPort, @RequestParam(defaultValue="false") Boolean healthyOnly, @RequestParam(defaultValue="") String app, HttpServletRequest request) throws Exception {
        NamingUtils.checkServiceNameFormat((String)serviceName);
        String agent = WebUtils.getUserAgent((HttpServletRequest)request);
        Subscriber subscriber = new Subscriber(clientIP + ":" + udpPort, agent, app, clientIP, namespaceId, serviceName, udpPort, clusters);
        return this.instanceServiceV2.listInstance(namespaceId, serviceName, subscriber, clusters, healthyOnly);
    }

    @GetMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode detail(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam String ip, @RequestParam(defaultValue="DEFAULT") String clusterName, @RequestParam Integer port) throws Exception {
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Instance instance = this.instanceServiceV2.getInstance(namespaceId, serviceName, clusterName, ip, port);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("service", serviceName);
        result.put("ip", ip);
        result.put("port", port);
        result.put("clusterName", clusterName);
        result.put("weight", instance.getWeight());
        result.put("healthy", instance.isHealthy());
        result.put("instanceId", instance.getInstanceId());
        result.set("metadata", JacksonUtils.transferToJsonNode((Object)instance.getMetadata()));
        return result;
    }

    @CanDistro
    @PutMapping(value={"/beat"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public ObjectNode beat(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam(defaultValue="") String ip, @RequestParam(defaultValue="DEFAULT") String clusterName, @RequestParam(defaultValue="0") Integer port, @RequestParam(defaultValue="") String beat) throws Exception {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("clientBeatInterval", this.switchDomain.getClientBeatInterval());
        RsInfo clientBeat = null;
        if (StringUtils.isNotBlank((String)beat)) {
            clientBeat = (RsInfo)JacksonUtils.toObj((String)beat, RsInfo.class);
        }
        if (clientBeat != null) {
            if (StringUtils.isNotBlank((String)clientBeat.getCluster())) {
                clusterName = clientBeat.getCluster();
            } else {
                clientBeat.setCluster(clusterName);
            }
            ip = clientBeat.getIp();
            port = clientBeat.getPort();
        }
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Loggers.SRV_LOG.debug("[CLIENT-BEAT] full arguments: beat: {}, serviceName: {}, namespaceId: {}", new Object[]{clientBeat, serviceName, namespaceId});
        BeatInfoInstanceBuilder builder = BeatInfoInstanceBuilder.newBuilder();
        int resultCode = this.instanceServiceV2.handleBeat(namespaceId, serviceName, ip, port, clusterName, clientBeat, builder);
        result.put("code", resultCode);
        result.put("clientBeatInterval", this.instanceServiceV2.getHeartBeatInterval(namespaceId, serviceName, ip, port, clusterName));
        result.put("lightBeatEnabled", this.switchDomain.isLightBeatEnabled());
        return result;
    }

    @RequestMapping(value={"/statuses/{key}"})
    public ObjectNode listWithHealthStatus(@PathVariable String key) throws NacosException {
        String serviceName;
        String namespaceId;
        if (key.contains("##")) {
            namespaceId = key.split("##")[0];
            serviceName = key.split("##")[1];
        } else {
            namespaceId = "public";
            serviceName = key;
        }
        NamingUtils.checkServiceNameFormat((String)serviceName);
        List<? extends Instance> ips = this.instanceServiceV2.listAllInstances(namespaceId, serviceName);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode ipArray = JacksonUtils.createEmptyArrayNode();
        for (Instance instance : ips) {
            ipArray.add(instance.toInetAddr() + "_" + instance.isHealthy());
        }
        result.replace("ips", (JsonNode)ipArray);
        return result;
    }

    private void checkWeight(Double weight) throws NacosException {
        if (weight > 10000.0 || weight < 0.0) {
            throw new NacosException(400, "instance format invalid: The weights range from 0.0 to 10000.0");
        }
    }
}

