/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.ByteUtils;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.core.exception.ErrorCode;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.consistency.persistent.ClusterVersionJudgement;
import com.alibaba.nacos.naming.consistency.persistent.impl.BasePersistentServiceProcessor;
import com.alibaba.nacos.naming.consistency.persistent.impl.BatchReadResponse;
import com.alibaba.nacos.naming.consistency.persistent.impl.BatchWriteRequest;
import com.alibaba.nacos.naming.pojo.Record;
import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class StandalonePersistentServiceProcessor
extends BasePersistentServiceProcessor {
    public StandalonePersistentServiceProcessor(ClusterVersionJudgement judgement) throws Exception {
        super(judgement);
    }

    @Override
    public void put(String key, Record value) throws NacosException {
        BatchWriteRequest req = new BatchWriteRequest();
        Datum datum = Datum.createDatum(key, value);
        req.append(ByteUtils.toBytes((String)key), this.serializer.serialize((Object)datum));
        WriteRequest request = WriteRequest.newBuilder().setData(ByteString.copyFrom((byte[])this.serializer.serialize((Object)req))).setGroup("naming_persistent_service").setOperation(BasePersistentServiceProcessor.Op.Write.desc).build();
        try {
            this.onApply(request);
        }
        catch (Exception e) {
            throw new NacosException(ErrorCode.ProtoSubmitError.getCode(), e.getMessage());
        }
    }

    @Override
    public void remove(String key) throws NacosException {
        BatchWriteRequest req = new BatchWriteRequest();
        req.append(ByteUtils.toBytes((String)key), ByteUtils.EMPTY);
        WriteRequest request = WriteRequest.newBuilder().setData(ByteString.copyFrom((byte[])this.serializer.serialize((Object)req))).setGroup("naming_persistent_service").setOperation(BasePersistentServiceProcessor.Op.Delete.desc).build();
        try {
            this.onApply(request);
        }
        catch (Exception e) {
            throw new NacosException(ErrorCode.ProtoSubmitError.getCode(), e.getMessage());
        }
    }

    @Override
    public Datum get(String key) throws NacosException {
        List<byte[]> keys = Collections.singletonList(ByteUtils.toBytes((String)key));
        ReadRequest req = ReadRequest.newBuilder().setGroup("naming_persistent_service").setData(ByteString.copyFrom((byte[])this.serializer.serialize(keys))).build();
        try {
            Response resp = this.onRequest(req);
            if (resp.getSuccess()) {
                BatchReadResponse response = (BatchReadResponse)this.serializer.deserialize(resp.getData().toByteArray(), BatchReadResponse.class);
                List<byte[]> rValues = response.getValues();
                return rValues.isEmpty() ? null : (Datum)this.serializer.deserialize(rValues.get(0), this.getDatumTypeFromKey(key));
            }
            throw new NacosException(ErrorCode.ProtoReadError.getCode(), resp.getErrMsg());
        }
        catch (Throwable e) {
            throw new NacosException(ErrorCode.ProtoReadError.getCode(), e.getMessage());
        }
    }

    @Override
    public void listen(String key, RecordListener listener) throws NacosException {
        this.notifier.registerListener(key, listener);
        if (this.startNotify) {
            this.notifierDatumIfAbsent(key, listener);
        }
    }

    @Override
    public void unListen(String key, RecordListener listener) throws NacosException {
        this.notifier.deregisterListener(key, listener);
    }

    @Override
    public boolean isAvailable() {
        return !this.hasError;
    }

    @Override
    public Optional<String> getErrorMsg() {
        String errorMsg = this.hasError ? "The raft peer is in error: " + this.jRaftErrorMsg : null;
        return Optional.ofNullable(errorMsg);
    }
}

