/*
 *  Copyright 1999-2021 Alibaba Group Holding Ltd.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package com.alibaba.nacos.naming.selector.context;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.selector.context.SelectorContextBuilder;

import java.util.List;

/**
 * The {@link NoneSelectorContextBuilder} will return the provider as context for the {@link com.alibaba.nacos.api.selector.Selector}
 * which doesn't need any other resource.
 *
 * @author chenglu
 * @date 2021-08-04 13:31
 */
public class NoneSelectorContextBuilder<T extends Instance>  implements SelectorContextBuilder<List<T>, String, List<T>> {
    
    private static final String CONTEXT_TYPE = "NONE";
    
    @Override
    public List<T> build(String consumer, List<T> provider) {
        return provider;
    }
    
    @Override
    public String getContextType() {
        return CONTEXT_TYPE;
    }
}
