/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.example;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.AbstractEventListener;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NamingExample {
    public static void main(String[] args) throws NacosException, InterruptedException {
        Properties properties = new Properties();
        properties.setProperty("serverAddr", System.getProperty("serverAddr"));
        properties.setProperty("namespace", System.getProperty("namespace"));
        NamingService naming = NamingFactory.createNamingService((Properties)properties);
        naming.registerInstance("nacos.test.3", "11.11.11.11", 8888, "TEST1");
        System.out.println("instances after register: " + naming.getAllInstances("nacos.test.3"));
        final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("test-thread");
                return thread;
            }
        });
        naming.subscribe("nacos.test.3", (EventListener)new AbstractEventListener(){

            public Executor getExecutor() {
                return executor;
            }

            public void onEvent(Event event) {
                System.out.println("serviceName: " + ((NamingEvent)event).getServiceName());
                System.out.println("instances from event: " + ((NamingEvent)event).getInstances());
            }
        });
        naming.deregisterInstance("nacos.test.3", "11.11.11.11", 8888, "TEST1");
        Thread.sleep(1000L);
        System.out.println("instances after deregister: " + naming.getAllInstances("nacos.test.3"));
        Thread.sleep(1000L);
    }
}

