/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.capacity;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.model.capacity.Capacity;
import com.alibaba.nacos.config.server.model.capacity.GroupCapacity;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.mapper.GroupCapacityMapper;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;

@Service
public class GroupCapacityPersistService {
    static final String CLUSTER = "";
    private static final GroupCapacityRowMapper GROUP_CAPACITY_ROW_MAPPER = new GroupCapacityRowMapper();
    private JdbcTemplate jdbcTemplate;
    private DataSourceService dataSourceService;
    private MapperManager mapperManager;

    @PostConstruct
    public void init() {
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        this.jdbcTemplate = this.dataSourceService.getJdbcTemplate();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    public GroupCapacity getGroupCapacity(String groupId) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        String sql = groupCapacityMapper.select(Arrays.asList("id", "quota", "`usage`", "`max_size`", "max_aggr_count", "max_aggr_size", "group_id"), Arrays.asList("group_id"));
        List list = this.jdbcTemplate.query(sql, new Object[]{groupId}, (RowMapper)GROUP_CAPACITY_ROW_MAPPER);
        if (list.isEmpty()) {
            return null;
        }
        return (GroupCapacity)list.get(0);
    }

    public Capacity getClusterCapacity() {
        return this.getGroupCapacity(CLUSTER);
    }

    public boolean insertGroupCapacity(GroupCapacity capacity) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        String sql = CLUSTER.equals(capacity.getGroup()) ? groupCapacityMapper.insertIntoSelect() : groupCapacityMapper.insertIntoSelectByWhere();
        String[] primaryKeyGeneratedKeys = groupCapacityMapper.getPrimaryKeyGeneratedKeys();
        return this.insertGroupCapacity(sql, capacity, primaryKeyGeneratedKeys);
    }

    private boolean insertGroupCapacity(String sql, GroupCapacity capacity, String[] primaryKeyGeneratedKeys) {
        try {
            GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
            PreparedStatementCreator preparedStatementCreator = connection -> {
                PreparedStatement ps = connection.prepareStatement(sql, primaryKeyGeneratedKeys);
                String group = capacity.getGroup();
                ps.setString(1, group);
                ps.setInt(2, capacity.getQuota());
                ps.setInt(3, capacity.getMaxSize());
                ps.setInt(4, capacity.getMaxAggrCount());
                ps.setInt(5, capacity.getMaxAggrSize());
                ps.setTimestamp(6, capacity.getGmtCreate());
                ps.setTimestamp(7, capacity.getGmtModified());
                if (!CLUSTER.equals(group)) {
                    ps.setString(8, group);
                }
                return ps;
            };
            this.jdbcTemplate.update(preparedStatementCreator, (KeyHolder)generatedKeyHolder);
            return generatedKeyHolder.getKey() != null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public int getClusterUsage() {
        Capacity clusterCapacity = this.getClusterCapacity();
        if (clusterCapacity != null) {
            return clusterCapacity.getUsage();
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.count(null);
        Integer result = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    public boolean incrementUsageWithDefaultQuotaLimit(GroupCapacity groupCapacity) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        String sql = groupCapacityMapper.incrementUsageByWhereQuotaEqualZero();
        try {
            int affectRow = this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup(), groupCapacity.getQuota()});
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsageWithQuotaLimit(GroupCapacity groupCapacity) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        String sql = groupCapacityMapper.incrementUsageByWhereQuotaNotEqualZero();
        try {
            return this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup()}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsage(GroupCapacity groupCapacity) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        String sql = groupCapacityMapper.incrementUsageByWhere();
        try {
            int affectRow = this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup()});
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean decrementUsage(GroupCapacity groupCapacity) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        String sql = groupCapacityMapper.decrementUsageByWhere();
        try {
            return this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup()}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateGroupCapacity(String group, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        List argList = CollectionUtils.list((Object[])new Object[0]);
        List columnList = CollectionUtils.list((Object[])new String[0]);
        if (quota != null) {
            columnList.add("quota");
            argList.add(quota);
        }
        if (maxSize != null) {
            columnList.add("max_size");
            argList.add(maxSize);
        }
        if (maxAggrCount != null) {
            columnList.add("max_aggr_count");
            argList.add(maxAggrCount);
        }
        if (maxAggrSize != null) {
            columnList.add("max_aggr_size");
            argList.add(maxAggrSize);
        }
        columnList.add("gmt_modified");
        argList.add(TimeUtils.getCurrentTime());
        List whereList = CollectionUtils.list((Object[])new String[0]);
        whereList.add("group_id");
        argList.add(group);
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        String sql = groupCapacityMapper.update(columnList, whereList);
        try {
            return this.jdbcTemplate.update(sql, argList.toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateQuota(String group, Integer quota) {
        return this.updateGroupCapacity(group, quota, null, null, null);
    }

    public boolean updateMaxSize(String group, Integer maxSize) {
        return this.updateGroupCapacity(group, null, maxSize, null, null);
    }

    public boolean correctUsage(String group, Timestamp gmtModified) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        if (CLUSTER.equals(group)) {
            String sql = groupCapacityMapper.updateUsage();
            try {
                return this.jdbcTemplate.update(sql, new Object[]{gmtModified, group}) == 1;
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
                throw e;
            }
        }
        String sql = groupCapacityMapper.updateUsageByWhere();
        try {
            return this.jdbcTemplate.update(sql, new Object[]{group, gmtModified, group}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public List<GroupCapacity> getCapacityList4CorrectUsage(long lastId, int pageSize) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        String sql = groupCapacityMapper.selectGroupInfoBySize();
        try {
            return this.jdbcTemplate.query(sql, new Object[]{lastId, pageSize}, (RowMapper)new RowMapper<GroupCapacity>(){

                public GroupCapacity mapRow(ResultSet rs, int rowNum) throws SQLException {
                    GroupCapacity groupCapacity = new GroupCapacity();
                    groupCapacity.setId(rs.getLong("id"));
                    groupCapacity.setGroup(rs.getString("group_id"));
                    return groupCapacity;
                }
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean deleteGroupCapacity(String group) {
        try {
            GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
            PreparedStatementCreator preparedStatementCreator = connection -> {
                PreparedStatement ps = connection.prepareStatement(groupCapacityMapper.delete(Arrays.asList("group_id")));
                ps.setString(1, group);
                return ps;
            };
            return this.jdbcTemplate.update(preparedStatementCreator) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    private static final class GroupCapacityRowMapper
    implements RowMapper<GroupCapacity> {
        private GroupCapacityRowMapper() {
        }

        public GroupCapacity mapRow(ResultSet rs, int rowNum) throws SQLException {
            GroupCapacity groupCapacity = new GroupCapacity();
            groupCapacity.setId(rs.getLong("id"));
            groupCapacity.setQuota(rs.getInt("quota"));
            groupCapacity.setUsage(rs.getInt("usage"));
            groupCapacity.setMaxSize(rs.getInt("max_size"));
            groupCapacity.setMaxAggrCount(rs.getInt("max_aggr_count"));
            groupCapacity.setMaxAggrSize(rs.getInt("max_aggr_size"));
            groupCapacity.setGroup(rs.getString("group_id"));
            return groupCapacity;
        }
    }
}

