/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.lock.aspect;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.boot.starter.lock.annotation.JLock;
import org.jeecg.boot.starter.lock.aspect.BaseAspect;
import org.jeecg.boot.starter.lock.enums.LockModel;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonRedLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DistributedLockHandler
extends BaseAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistributedLockHandler.class);
    @Autowired(required=false)
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(jLock)")
    public Object around(ProceedingJoinPoint joinPoint, JLock jLock) {
        Object obj = null;
        log.info("\u8fdb\u5165RedisLock\u73af\u7ed5\u901a\u77e5...");
        RLock rLock = this.getLock(joinPoint, jLock);
        boolean res = false;
        long expireSeconds = jLock.expireSeconds();
        long waitTime = jLock.waitTime();
        if (rLock != null) {
            try {
                if (waitTime == -1L) {
                    res = true;
                    rLock.lock(expireSeconds, TimeUnit.MILLISECONDS);
                } else {
                    res = rLock.tryLock(waitTime, expireSeconds, TimeUnit.MILLISECONDS);
                }
                if (res) {
                    obj = joinPoint.proceed();
                } else {
                    log.error("\u83b7\u53d6\u9501\u5f02\u5e38");
                }
            }
            finally {
                if (res) {
                    rLock.unlock();
                }
            }
        }
        log.info("\u7ed3\u675fRedisLock\u73af\u7ed5\u901a\u77e5...");
        return obj;
    }

    private RLock getLock(ProceedingJoinPoint joinPoint, JLock jLock) {
        String[] keys = jLock.lockKey();
        if (keys.length == 0) {
            throw new RuntimeException("keys\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] parameterNames = new DefaultParameterNameDiscoverer().getParameterNames(((MethodSignature)joinPoint.getSignature()).getMethod());
        Object[] args = joinPoint.getArgs();
        LockModel lockModel = jLock.lockModel();
        RLock rLock = null;
        String keyConstant = jLock.keyConstant();
        if (lockModel.equals((Object)LockModel.AUTO)) {
            lockModel = keys.length > 1 ? LockModel.REDLOCK : LockModel.REENTRANT;
        }
        if (!lockModel.equals((Object)LockModel.MULTIPLE) && !lockModel.equals((Object)LockModel.REDLOCK) && keys.length > 1) {
            throw new RuntimeException("\u53c2\u6570\u6709\u591a\u4e2a,\u9501\u6a21\u5f0f\u4e3a->" + lockModel.name() + ".\u65e0\u6cd5\u9501\u5b9a");
        }
        switch (lockModel) {
            case FAIR: {
                rLock = this.redissonClient.getFairLock(this.getValueBySpEL(keys[0], parameterNames, args, keyConstant).get(0));
                break;
            }
            case REDLOCK: {
                ArrayList<RLock> rLocks = new ArrayList<RLock>();
                for (String key : keys) {
                    List<String> valueBySpEL = this.getValueBySpEL(key, parameterNames, args, keyConstant);
                    for (String s : valueBySpEL) {
                        rLocks.add(this.redissonClient.getLock(s));
                    }
                }
                RLock[] locks = new RLock[rLocks.size()];
                int index = 0;
                for (RLock r : rLocks) {
                    locks[index++] = r;
                }
                rLock = new RedissonRedLock(locks);
                break;
            }
            case MULTIPLE: {
                ArrayList<RLock> rLocks = new ArrayList<RLock>();
                for (String key : keys) {
                    List<String> valueBySpEL = this.getValueBySpEL(key, parameterNames, args, keyConstant);
                    for (String s : valueBySpEL) {
                        rLocks.add(this.redissonClient.getLock(s));
                    }
                }
                RLock[] locks = new RLock[rLocks.size()];
                int index = 0;
                for (RLock r : rLocks) {
                    locks[index++] = r;
                }
                rLock = new RedissonMultiLock(locks);
                break;
            }
            case REENTRANT: {
                List<String> valueBySpEL = this.getValueBySpEL(keys[0], parameterNames, args, keyConstant);
                if (valueBySpEL.size() == 1) {
                    rLock = this.redissonClient.getLock(valueBySpEL.get(0));
                    break;
                }
                RLock[] locks = new RLock[valueBySpEL.size()];
                int index = 0;
                for (String s : valueBySpEL) {
                    locks[index++] = this.redissonClient.getLock(s);
                }
                rLock = new RedissonRedLock(locks);
                break;
            }
            case READ: {
                rLock = this.redissonClient.getReadWriteLock(this.getValueBySpEL(keys[0], parameterNames, args, keyConstant).get(0)).readLock();
                break;
            }
            case WRITE: {
                rLock = this.redissonClient.getReadWriteLock(this.getValueBySpEL(keys[0], parameterNames, args, keyConstant).get(0)).writeLock();
            }
        }
        return rLock;
    }
}

