/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.airag.flow.service.a;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.LiteflowResponse;
import com.yomahub.liteflow.process.holder.SpringNodeIdHolder;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.AiragFlowDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.AssertUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.airag.common.utils.AiragLocalCache;
import org.jeecg.modules.airag.flow.component.code.CodeNode;
import org.jeecg.modules.airag.flow.context.JeecgFlowContext;
import org.jeecg.modules.airag.flow.entity.AiragFlow;
import org.jeecg.modules.airag.flow.mapper.AiragFlowMapper;
import org.jeecg.modules.airag.flow.service.IAiragFlowService;
import org.jeecg.modules.airag.flow.vo.api.FlowDebugParams;
import org.jeecg.modules.airag.flow.vo.api.FlowDesignParams;
import org.jeecg.modules.airag.flow.vo.api.FlowRunInnerParams;
import org.jeecg.modules.airag.flow.vo.api.FlowRunParams;
import org.jeecg.modules.airag.flow.vo.api.SubFlowResult;
import org.jeecg.modules.airag.flow.vo.flow.config.FlowNode;
import org.jeecg.modules.airag.flow.vo.flow.config.FlowNodeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service(value="airagFlowService")
public class c
extends ServiceImpl<AiragFlowMapper, AiragFlow>
implements IAiragFlowService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    FlowExecutor flowExecutor;
    @Autowired
    AiragFlowMapper airagFlowMapper;
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    @Override
    public Result<String> saveDesign(FlowDesignParams flowDesignParams) {
        AiragFlow existsFlow = (AiragFlow)this.getById((Serializable)((Object)flowDesignParams.getId()));
        AssertUtils.assertNotEmpty((String)"\u6d41\u7a0b\u4e0d\u5b58\u5728", (Object)existsFlow);
        AssertUtils.assertNotEmpty((String)"\u6d41\u7a0b\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (Object)flowDesignParams.getChain());
        AssertUtils.assertNotEmpty((String)"\u8bbe\u8ba1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object)flowDesignParams.getDesign());
        String design = existsFlow.getDesign();
        String metadataStr = existsFlow.getMetadata();
        JSONObject metadata = new JSONObject();
        if (oConvertUtils.isNotEmpty((Object)metadataStr)) {
            metadata = JSONObject.parseObject((String)metadataStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)design)) {
            JSONObject designJson = JSONObject.parseObject((String)design);
            JSONArray nodes = designJson.getJSONArray("nodes");
            c.a(nodes);
            c.a(nodes, metadata);
        } else {
            metadata.put("inputs", null);
            metadata.put("outputs", null);
        }
        if (FlowBus.containChain((String)existsFlow.getId())) {
            FlowBus.removeChain((String)existsFlow.getId());
        }
        existsFlow.setName(flowDesignParams.getName());
        existsFlow.setChain(flowDesignParams.getChain());
        existsFlow.setDesign(flowDesignParams.getDesign());
        existsFlow.setMetadata(metadata.toJSONString());
        this.updateById(existsFlow);
        return Result.OK((String)"\u4fdd\u5b58\u6210\u529f");
    }

    private static void a(JSONArray nodes, JSONObject metadata) {
        HashMap<String, FlowNodeConfig.NodeParam> outputParamMap = new HashMap<String, FlowNodeConfig.NodeParam>();
        for (Object node : nodes) {
            FlowNode flowNodeObj = (FlowNode)((JSONObject)node).toJavaObject(FlowNode.class);
            FlowNodeConfig properties = flowNodeObj.getProperties();
            if ("start".equals(flowNodeObj.getType())) {
                List<FlowNodeConfig.NodeParam> inputParams = properties.getInputParams();
                metadata.put("inputs", inputParams);
                continue;
            }
            if (!"end".equals(flowNodeObj.getType())) continue;
            boolean outputText = false;
            if (oConvertUtils.isObjectNotEmpty(properties.getOptions())) {
                outputText = (Boolean)properties.getOptions().get("outputText");
            }
            if (outputText) {
                FlowNodeConfig.NodeParam nodeParam2 = new FlowNodeConfig.NodeParam();
                nodeParam2.setField("outputText");
                nodeParam2.setType("string");
                outputParamMap.put(nodeParam2.getField(), nodeParam2);
                continue;
            }
            properties.getOutputParams().forEach(nodeParam -> outputParamMap.put(nodeParam.getField(), (FlowNodeConfig.NodeParam)nodeParam));
        }
        metadata.put("outputs", outputParamMap.values());
    }

    @Override
    public Object runFlow(FlowRunParams flowRunParams) {
        AiragFlow flow = this.airagFlowMapper.getFlowByIdIgnoreTenant(flowRunParams.getFlowId());
        JeecgFlowContext context = this.a(flow, flowRunParams);
        return this.a(flowRunParams, context);
    }

    @Override
    public Object runFlow(AiragFlowDTO airagFlowDTO) {
        FlowRunParams flowRunParams = new FlowRunParams();
        flowRunParams.setFlowId(airagFlowDTO.getFlowId());
        flowRunParams.setInputParams(airagFlowDTO.getInputParams());
        flowRunParams.setResponseMode("blocking");
        return this.runFlow(flowRunParams);
    }

    @Override
    public Object debugFlow(FlowDebugParams flowDebugParams) {
        AiragFlow flow = flowDebugParams.getFlow();
        String tempFLowId = UUIDGenerator.generate();
        flow.setId(tempFLowId);
        String appName = "jeecg";
        flow.setApplicationName(appName);
        flow.setStatus("enable");
        flowDebugParams.setFlowId(tempFLowId);
        flowDebugParams.setEventCallback(eventData -> {
            String eventFlowId = eventData.getFlowId();
            if (FlowBus.containChain((String)eventFlowId)) {
                FlowBus.removeChain((String)eventFlowId);
            }
            if (oConvertUtils.isNotEmpty((Object)flow.getDesign())) {
                JSONObject designJson = JSONObject.parseObject((String)flow.getDesign());
                JSONArray nodes = designJson.getJSONArray("nodes");
                c.a(nodes);
            }
        });
        JeecgFlowContext context = this.a(flow, flowDebugParams);
        return this.a(flowDebugParams, context);
    }

    private JeecgFlowContext a(AiragFlow flow, FlowRunParams flowRunParams) {
        HashMap<String, FlowNode> flowNode;
        AssertUtils.assertNotEmpty((String)"\u6d41\u7a0b\u4e0d\u5b58\u5728", (Object)flow);
        AssertUtils.assertNotEmpty((String)"\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b", (Object)flow.getChain());
        String design = flow.getDesign();
        if (StringUtils.isNotEmpty((CharSequence)design)) {
            JSONObject designJson = JSONObject.parseObject((String)design);
            JSONArray nodes = designJson.getJSONArray("nodes");
            flowNode = new HashMap<String, FlowNode>();
            nodes.forEach(node -> {
                FlowNode flowNodeObj = (FlowNode)((JSONObject)node).toJavaObject(FlowNode.class);
                if (oConvertUtils.isEmpty((Object)flowNodeObj)) {
                    return;
                }
                CodeNode.a(flowNodeObj);
                flowNode.put(flowNodeObj.getId(), flowNodeObj);
            });
        } else {
            flowNode = null;
        }
        if (oConvertUtils.isObjectNotEmpty(flowNode)) {
            flowNode.forEach((nodeId, flowNodeObj) -> {
                Map<String, Object> options;
                FlowNodeConfig flowNodeConfig = flowNodeObj.getProperties();
                if ("reply".equals(flowNodeObj.getType()) && (options = flowNodeConfig.getOptions()).containsKey("stream") && options.get("stream") instanceof Boolean && ((Boolean)options.get("stream")).booleanValue()) {
                    List<FlowNodeConfig.NodeParam> inputParams = flowNodeConfig.getInputParams();
                    List<String> publishNodeIds = inputParams.stream().map(FlowNodeConfig.NodeParam::getNodeId).collect(Collectors.toList());
                    publishNodeIds.forEach(publishNodeId -> ((FlowNode)flowNode.get(publishNodeId)).getProperties().setSteam(true));
                }
            });
        }
        JeecgFlowContext context = new JeecgFlowContext();
        context.setFlowNodes(flowNode);
        context.setRequestDatas(flowRunParams.getInputParams());
        if (oConvertUtils.isNotEmpty((Object)flowRunParams.getRequestId())) {
            context.setRequestId(flowRunParams.getRequestId());
        } else {
            context.setRequestId(UUIDGenerator.generate());
        }
        if (oConvertUtils.isNotEmpty((Object)flowRunParams.getConversationId())) {
            context.setConversationId(flowRunParams.getConversationId());
        }
        if (oConvertUtils.isNotEmpty((Object)flowRunParams.getTopicId())) {
            context.setTopicId(flowRunParams.getTopicId());
        }
        if (oConvertUtils.isObjectNotEmpty(flowRunParams.getEventCallback())) {
            context.setEventCallback(flowRunParams.getEventCallback());
        }
        if (oConvertUtils.isObjectNotEmpty((Object)flowRunParams.getHttpRequest())) {
            context.setHttpRequest(flowRunParams.getHttpRequest());
        } else {
            try {
                HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
                context.setHttpRequest(request);
            }
            catch (Exception request) {
                // empty catch block
            }
        }
        SysUserCacheInfo cacheUserInfo = null;
        if (flowRunParams instanceof FlowRunInnerParams) {
            cacheUserInfo = ((FlowRunInnerParams)flowRunParams).getCacheUser();
        }
        if (oConvertUtils.isObjectNotEmpty(cacheUserInfo)) {
            context.setCacheUser(cacheUserInfo);
        } else {
            try {
                LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                if (null != sysUser) {
                    context.setCacheUser(this.sysBaseAPI.getCacheUser(sysUser.getUsername()));
                }
            }
            catch (Exception e2) {
                a.warn("SecurityUtils.getSubject() \u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a" + e2.getMessage());
            }
        }
        String tenantId = TenantContext.getTenant();
        if (oConvertUtils.isNotEmpty((Object)tenantId)) {
            context.setTenantId(tenantId);
        }
        a.info("\u6d41\u7a0b\u7f16\u6392\u89c4\u5219:{}", (Object)flow.getChain());
        if (!FlowBus.containChain((String)flow.getId())) {
            FlowBus.reloadChain((String)flow.getId(), (String)flow.getChain());
        }
        return context;
    }

    private static void a(JSONArray nodes) {
        nodes.forEach(node -> {
            FlowNode flowNodeObj = (FlowNode)((JSONObject)node).toJavaObject(FlowNode.class);
            if (oConvertUtils.isEmpty((Object)flowNodeObj) || !"code".equals(flowNodeObj.getType())) {
                return;
            }
            if (FlowBus.containNode((String)flowNodeObj.getId())) {
                FlowBus.removeNode((String)flowNodeObj.getId());
            }
        });
    }

    private Object a(FlowRunParams flowRunParams, JeecgFlowContext context) {
        SseEmitter emitter;
        c.a();
        if ("blocking".equalsIgnoreCase(flowRunParams.getResponseMode())) {
            LiteflowResponse flowResponse = this.flowExecutor.execute2Resp(flowRunParams.getFlowId(), null, new Object[]{context});
            if (flowResponse.isSuccess()) {
                JeecgFlowContext resultContext = (JeecgFlowContext)flowResponse.getContextBean(JeecgFlowContext.class);
                return Result.OK((Object)resultContext.getResult());
            }
            if (null != flowResponse.getCause()) {
                a.error(flowResponse.getCause().getMessage(), (Throwable)flowResponse.getCause());
            }
            return Result.error((String)flowResponse.getMessage());
        }
        if (oConvertUtils.isNotEmpty((Object)flowRunParams.getRequestId())) {
            emitter = (SseEmitter)AiragLocalCache.get("CHAT:TYPE:SSE", flowRunParams.getRequestId());
        } else {
            emitter = new SseEmitter(Long.valueOf(0L));
            emitter.onError(throwable -> {
                a.warn("SEE\u5411\u5ba2\u6237\u7aef\u53d1\u9001\u6d88\u606f\u5931\u8d25: {}", (Object)throwable.getMessage());
                try {
                    emitter.complete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        context.setEmitter(emitter);
        this.flowExecutor.execute2Future(flowRunParams.getFlowId(), null, new Object[]{context});
        return emitter;
    }

    private static void a() {
        if (FlowBus.getNodeMap().isEmpty()) {
            SpringContextUtils.getBean((String)"start");
            SpringContextUtils.getBean((String)"llm");
            SpringContextUtils.getBean((String)"end");
            SpringContextUtils.getBean((String)"classifier");
            SpringContextUtils.getBean((String)"switch");
            SpringContextUtils.getBean((String)"subflow");
            SpringContextUtils.getBean((String)"knowledge");
            SpringContextUtils.getBean((String)"reply");
            SpringContextUtils.getBean((String)"enhanceJava");
            SpringContextUtils.getBean((String)"tools");
            SpringContextUtils.getBean((String)"nodeProcessAspect");
            SpringContextUtils.getBean((String)"flowExecuteAspect");
            SpringNodeIdHolder.getNodeIdSet().forEach(FlowBus::addManagedNode);
        }
    }

    @Override
    public IPage<SubFlowResult> subflowPage(IPage<AiragFlow> page, String id, String keywords) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(AiragFlow::getCreateTime);
        queryWrapper.select(Arrays.asList(AiragFlow::getId, AiragFlow::getName, AiragFlow::getDescr, AiragFlow::getStatus, AiragFlow::getDesign));
        if (oConvertUtils.isNotEmpty((Object)id)) {
            queryWrapper.ne(AiragFlow::getId, (Object)id);
        }
        if (oConvertUtils.isNotEmpty((Object)keywords)) {
            queryWrapper.like(AiragFlow::getName, (Object)("%" + keywords + "%"));
        }
        IPage pageList = ((AiragFlowMapper)this.baseMapper).selectPage(page, (Wrapper)queryWrapper);
        List flowList = pageList.getRecords();
        Page results = new Page();
        results.setPages(pageList.getPages());
        results.setTotal(pageList.getTotal());
        results.setCurrent(page.getCurrent());
        results.setSize(page.getSize());
        results.setRecords(new ArrayList());
        if (CollectionUtils.isEmpty((Collection)flowList)) {
            return results;
        }
        for (AiragFlow flow : flowList) {
            SubFlowResult result = new SubFlowResult(flow);
            if (result.getInputParams() == null) continue;
            results.getRecords().add(result);
        }
        return results;
    }

    @Override
    public SubFlowResult querySubflowById(String subflowId) {
        if (oConvertUtils.isEmpty((Object)subflowId)) {
            throw new JeecgBootBizTipException("subflowId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        AiragFlow flow = (AiragFlow)this.getById((Serializable)((Object)subflowId));
        if (flow == null) {
            throw new JeecgBootBizTipException("\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        SubFlowResult result = new SubFlowResult(flow);
        if (result.getInputParams() == null) {
            throw new JeecgBootBizTipException("\u6d41\u7a0b\u914d\u7f6e\u5f02\u5e38");
        }
        return result;
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "getCreateTime": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/airag/flow/entity/AiragFlow") || !lambda.getImplMethodSignature().equals("()Ljava/util/Date;")) break;
                return AiragFlow::getCreateTime;
            }
            case "getName": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/airag/flow/entity/AiragFlow") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return AiragFlow::getName;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/airag/flow/entity/AiragFlow") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return AiragFlow::getName;
            }
            case "getDesign": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/airag/flow/entity/AiragFlow") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return AiragFlow::getDesign;
            }
            case "getDescr": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/airag/flow/entity/AiragFlow") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return AiragFlow::getDescr;
            }
            case "getId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/airag/flow/entity/AiragFlow") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return AiragFlow::getId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/airag/flow/entity/AiragFlow") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return AiragFlow::getId;
            }
            case "getStatus": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/airag/flow/entity/AiragFlow") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return AiragFlow::getStatus;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

