/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.airag.flow.service.a;

import cn.hutool.core.codec.Base64Decoder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.airag.flow.entity.AiragFlow;
import org.jeecg.modules.airag.flow.mapper.AiragFlowMapper;
import org.jeecg.modules.airag.flow.service.IAiragFlowExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="airagFlowExportServiceImpl")
public class b
implements IAiragFlowExportService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    AiragFlowMapper airagFlowMapper;

    @Override
    public String exportFlow(String flowId, Integer izExportAppKey) {
        JSONObject flowObject;
        AiragFlow airagFlow = (AiragFlow)this.airagFlowMapper.selectById((Serializable)((Object)flowId));
        if (null == airagFlow) {
            throw new JeecgBootBizTipException("AI\u6d41\u7a0b\u5b9e\u4f8b\u672a\u627e\u5230\uff01");
        }
        String design = airagFlow.getDesign();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (oConvertUtils.isNotEmpty((Object)design) && (flowObject = JSONObject.parseObject((String)design)).containsKey((Object)"nodes")) {
            JSONArray nodeArray = flowObject.getJSONArray("nodes");
            Map<String, Object> map = this.a(nodeArray, izExportAppKey);
            resultMap.put("flowCorrelation", map);
        }
        resultMap.put("flowConfig", airagFlow);
        String jsonString = JSON.toJSONString(resultMap);
        byte[] arr = null;
        try {
            arr = jsonString.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new JeecgBootBizTipException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e2.getMessage());
        }
        return Base64.encodeBase64String((byte[])arr);
    }

    private Map<String, Object> a(JSONArray nodeArray, Integer izExportAppKey) {
        ArrayList<String> modeIdList = new ArrayList<String>();
        ArrayList<String> pluginIdList = new ArrayList<String>();
        for (int i2 = 0; i2 < nodeArray.size(); ++i2) {
            JSONObject jsonObject = nodeArray.getJSONObject(i2);
            if (null == jsonObject || !jsonObject.containsKey((Object)"properties")) continue;
            String type = jsonObject.getString("type");
            JSONObject propertiesObject = jsonObject.getJSONObject("properties");
            if (!propertiesObject.containsKey((Object)"options")) continue;
            JSONObject optionsObject = propertiesObject.getJSONObject("options");
            if ("llm".equals(type) || "knowledge".equals(type)) {
                this.a(optionsObject, modeIdList, pluginIdList);
            }
            if (!"classifier".equals(type)) continue;
            this.a(optionsObject, modeIdList, pluginIdList);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(modeIdList)) {
            List<Map<String, Object>> modeData = this.airagFlowMapper.selectModelByIds(modeIdList);
            if (!CollectionUtils.isEmpty(modeData) && CommonConstant.STATUS_0_INT.equals(izExportAppKey)) {
                modeData.forEach(item -> item.put("credential", ""));
            }
            resultMap.put("modeIdList", modeIdList);
            resultMap.put("modeData", modeData);
        }
        if (!CollectionUtils.isEmpty(pluginIdList)) {
            List<Map<String, Object>> mcpData = this.airagFlowMapper.selectMcpByIds(pluginIdList);
            resultMap.put("mcpData", mcpData);
            resultMap.put("pluginIdList", pluginIdList);
        }
        return resultMap;
    }

    private void a(JSONObject optionsObject, List<String> modeIdList, List<String> pluginIdList) {
        String modeId;
        if (optionsObject.containsKey((Object)"model") && oConvertUtils.isNotEmpty((Object)(modeId = optionsObject.getJSONObject("model").getString("modeId")))) {
            modeIdList.add(modeId);
        }
        if (optionsObject.containsKey((Object)"plugins")) {
            JSONArray pluginsArray = optionsObject.getJSONArray("plugins");
            for (int i2 = 0; i2 < pluginsArray.size(); ++i2) {
                JSONObject pluginObject = pluginsArray.getJSONObject(i2);
                String pluginId = pluginObject.getString("pluginId");
                if (!oConvertUtils.isNotEmpty((Object)pluginId)) continue;
                pluginIdList.add(pluginId);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importFlow(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        String suffix = FilenameUtils.getExtension((String)originalFilename);
        if (null != originalFilename) {
            if (!"jaif".equals(suffix)) {
                throw new JeecgBootBizTipException("\u8bf7\u4e0a\u4f20jaif\u6587\u4ef6");
            }
        } else {
            throw new JeecgBootBizTipException("\u8bf7\u4e0a\u4f20jaif\u6587\u4ef6");
        }
        try {
            InputStream inputStream = file.getInputStream();
            String content = this.a(inputStream);
            if (oConvertUtils.isNotEmpty((Object)content)) {
                String flow = Base64Decoder.decodeStr((CharSequence)content, (Charset)Charset.forName("utf-8"));
                this.a(flow);
            }
        }
        catch (IOException e2) {
            a.error(e2.getMessage(), (Throwable)e2);
            throw new JeecgBootBizTipException("\u5bfc\u5165\u5931\u8d25:" + e2.getMessage());
        }
    }

    private void a(String flow) {
        if (oConvertUtils.isNotEmpty((Object)flow)) {
            JSONObject flowObject = JSONObject.parseObject((String)flow);
            if (flowObject.containsKey((Object)"flowConfig")) {
                JSONObject flowConfigObject = flowObject.getJSONObject("flowConfig");
                String flowId = flowConfigObject.getString("id");
                AiragFlow airagFlow = (AiragFlow)this.airagFlowMapper.selectById((Serializable)((Object)flowId));
                if (null != airagFlow) {
                    throw new JeecgBootBizTipException("\u63d2\u5165\u5931\u8d25\uff0c\u8be5\u6d41\u7a0b\u5df2\u5b58\u5728\uff01");
                }
                AiragFlow aiFlow = (AiragFlow)JSONObject.parseObject((String)flowConfigObject.toJSONString(), AiragFlow.class);
                aiFlow.setCreateTime(new Date());
                aiFlow.setUpdateTime(null);
                aiFlow.setUpdateBy("");
                this.airagFlowMapper.insert(aiFlow);
            }
            if (flowObject.containsKey((Object)"flowCorrelation")) {
                JSONObject flowCorrelationObject = flowObject.getJSONObject("flowCorrelation");
                if (flowCorrelationObject.containsKey((Object)"modeData")) {
                    this.b(flowCorrelationObject);
                }
                if (flowCorrelationObject.containsKey((Object)"mcpData")) {
                    this.a(flowCorrelationObject);
                }
            }
        }
    }

    private void a(JSONObject jsonObject) {
        if (!jsonObject.containsKey((Object)"pluginIdList") || !jsonObject.containsKey((Object)"mcpData")) {
            return;
        }
        JSONArray mcpData = jsonObject.getJSONArray("mcpData");
        if (oConvertUtils.isEmpty((Object)mcpData)) {
            return;
        }
        List pluginIds = (List)jsonObject.getObject("pluginIdList", List.class);
        List<String> pluginIdList = this.airagFlowMapper.getMcpIdsByIds(pluginIds);
        List pluginDataList = this.a(pluginIdList, mcpData);
        if (!CollectionUtils.isEmpty((Collection)pluginDataList)) {
            try {
                this.airagFlowMapper.insertBatchMcp(pluginDataList);
            }
            catch (Exception e2) {
                a.error("ai\u6a21\u578b\u914d\u7f6e\u6279\u91cf\u63d2\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e2.getMessage(), (Throwable)e2);
            }
        }
    }

    private void b(JSONObject jsonObject) {
        if (!jsonObject.containsKey((Object)"modeIdList") || !jsonObject.containsKey((Object)"modeData")) {
            return;
        }
        JSONArray modeData = jsonObject.getJSONArray("modeData");
        if (CollectionUtils.isEmpty((Collection)modeData)) {
            return;
        }
        List modeList = (List)jsonObject.getObject("modeIdList", List.class);
        if (CollectionUtils.isEmpty((Collection)modeList)) {
            return;
        }
        List<String> modeIdList = this.airagFlowMapper.getModelIdsByIds(modeList);
        List modelDataList = this.a(modeIdList, modeData);
        if (!CollectionUtils.isEmpty((Collection)modelDataList)) {
            try {
                this.airagFlowMapper.insertBatchModel(modelDataList);
            }
            catch (Exception e2) {
                a.error("ai\u6a21\u578b\u914d\u7f6e\u6279\u91cf\u63d2\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e2.getMessage(), (Throwable)e2);
            }
        }
    }

    private List a(List<String> idList, JSONArray importData) {
        ArrayList<JSONObject> modelDataList = new ArrayList<JSONObject>();
        for (int i2 = 0; i2 < importData.size(); ++i2) {
            JSONObject obj;
            String id;
            Object item = importData.get(i2);
            if (item == null || idList.contains(id = (obj = item instanceof JSONObject ? (JSONObject)item : JSONObject.parseObject((String)JSONObject.toJSONString((Object)item))).getString("id"))) continue;
            obj.put("create_time", (Object)new Date());
            modelDataList.add(obj);
        }
        return modelDataList;
    }

    public String a(InputStream stream) {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        String line = "";
        StringBuilder responseStrBuilder = new StringBuilder();
        try {
            while ((line = br.readLine()) != null) {
                responseStrBuilder.append(line);
            }
            stream.close();
        }
        catch (IOException e2) {
            a.error(e2.getMessage(), (Throwable)e2);
            return "";
        }
        return responseStrBuilder.toString();
    }
}

