<#assign CACHE_VERSION = "v=1.0.3">
<#assign base = springMacroRequestContext.getContextUrl("")>
<#assign config_id = "${id!''}">
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width">
    <title>积木报表设计器</title>

    <link rel="stylesheet" type="text/css" href="${base}/jmreport/desreport_/cdn/iview/iview.css">
    <link rel="stylesheet" href="${base}/jmreport/desreport_/corelib/report.css">
    <script type="text/javascript" src="${base}/jmreport/desreport_/cdn/vue/vue.min.js"></script>
    <script type="text/javascript" src="${base}/jmreport/desreport_/cdn/iview/iview.min.js"></script>

    <!-- Import via CDN -->
    <link rel="stylesheet" href="${base}/jmreport/desreport_/corelib/xspreadsheet.css?${CACHE_VERSION}">
    <link rel="shortcut icon" href="${base}/jmreport/desreport_/corelib/logo.png?${CACHE_VERSION}" type="image/x-ico">
    <script src="${base}/jmreport/desreport_/corelib/xspreadsheet.js?${CACHE_VERSION}"></script>
    <script src="${base}/jmreport/desreport_/corelib/locale/zh-cn.js?${CACHE_VERSION}"></script>
    <script src="${base}/jmreport/desreport_/jquery/jquery-3.4.1.min.js"></script>
    <script src="${base}/jmreport/desreport_/jquery/jquery.excel.js?${CACHE_VERSION}"></script>
    <script src="${base}/jmreport/desreport_/js/domainUrl.js?${CACHE_VERSION}"></script>
    <script src="${base}/jmreport/desreport_/js/jQcheck_token.js?${CACHE_VERSION}"></script>
    <script src="${base}/jmreport/desreport_/cdn/html2canvas/html2canvas.min.js"></script>
    <script src="${base}/jmreport/desreport_/cdn/html2canvas/canvas2image.js"></script>
    <script src="${base}/jmreport/desreport_/js/chart_type_list.js?${CACHE_VERSION}"></script>
    <script>
        let base = "${base}";
        /**
         * 获取url参数
         */
        function getRequestUrl() {
            var url = location.search;
            var theRequest = new Object();
            if (url.indexOf("?") != -1) {
                var str = url.substr(1);
                strs = str.split("&");
                for(var i = 0; i < strs.length; i++) {
                    theRequest[strs[i].split("=")[0]]=decodeURI(strs[i].split("=")[1]);
                }
            }
            return theRequest;
        }

        let token = getRequestUrl().token;
        if (token == "" || token == null){
            token = window.localStorage.getItem('JmReport-Access-Token');
        }
        window.localStorage.setItem('JmReport-Access-Token',token);
    </script>
    <style>
        .ivu-form-item {
            margin-bottom: 10px;
            vertical-align: top;
            zoom: 1;
        }
        .ivu-menu-vertical.ivu-menu-light:after {
            content: '';
            display: block;
            width: 1px;
            height: 100%;
            background: #ffffff;
            position: absolute;
            top: 0;
            bottom: 0;
            right: 0;
            z-index: 1;
        }
        .vertical-center-modal{
            width: 60%;
            height: 60%;
            margin-left: 18%;
            margin-top: 5%;
        }
        .ivu-select-dropdown.ivu-transfer-no-max-height {
            max-height: none;
            max-width: 200px;
            margin-left: 142px;
        }
        .ivurow{
            position: relative;
            margin-left: 0;
            margin-right: 0;
            height: auto;
            zoom: 1;
            display: -webkit-inline-box;
        }
        .ivu-col > div.chart-active{
            border-color: blue;
            box-shadow: 0px 0px 8px blue;
        }
        .ivu-col > div.chart-selected{
            border-color: blue !important;
            box-shadow: 0px 0px 8px blue;
        }

        .chart-modal-content .ivu-tabs-tabpane{
            padding: 0 0 0 8px;
        }
        #dataTree{
            margin-left: 25px;
        }
        .no-allowed{
            cursor: not-allowed;
           /* pointer-events: none;*/
        }

        .no-allowed:after {
            position: absolute;
            width: 200px;
            height: 150px;
            top: 0;
            left: 0;
            content: "";
            background: #fff;
            opacity: 0.65;
            z-index: 5;
            filter: alpha(opacity=40);
        }
        .colorPicker{
            width: 200%;
        }
        .iSelect{
            width: 150%;
        }
        .datastyle{
            margin-bottom: 10px;
        }
        .blockDiv{
            margin-left: 25px;margin-top: -10px;font-size: 12px;color: #000;
        }

        .jm-rp-left-container{
            position: absolute;
            top: 0;
            left: 0;
        }
        .jm-rp-right-container{
            position: absolute;
            top: 0;
            right: 0;
        }
        .jm-rp-designer{
            position: absolute;
            left: 220px;
            width: calc(100% - 470px)
        }
        .jm-rp-designer.left{
            left: 20px;
            width: calc(100% - 260px)
        }
        .jm-rp-designer.right{
            left: 220px;
            width: calc(100% - 240px)
        }
        .jm-rp-designer.all{
            left: 20px;
            width: calc(100% - 40px)
        }
        [v-cloak] {
            display: none;
        }
        .ivu-poptip-popper {
            min-width: 100px;
        }
        .ivu-poptip-body-content-word-wrap {
            text-align: center;
        }

        /*加载效果*/
        .zindex-top{
            z-index: 999;
        }
        .zindex-top .ivu-icon-ios-loading{
            animation: cycle-spin 1s linear infinite;
        }
        @keyframes cycle-spin {
            from { transform: rotate(0deg);}
            50%  { transform: rotate(180deg);}
            to   { transform: rotate(360deg);}
        }
    </style>
<body onload="load()">
<div id="app" v-cloak>
    <Spin size="large" fix v-if="createLoading" class="zindex-top">
        <Icon type="ios-loading" size=24></Icon>
        <div>Loading</div>
    </Spin>
<#include "./modal.ftl">
    <div class="layout">
        <div class="jm-rp-left-container">
            <div id="treeDiv">
                <span slot="title" @click="toggleLeft">
                    <Icon type="ios-arrow-back" size="24"/>
                </span>
                <Card style="width: 290px" v-if="dataShow">
                    <template>
                        <div id="dataDiv">
                            <template>
                                <i-menu theme="light" width="75%" style="margin-left: -25px;" :class="menuitemClasses">
                                    <Card style="width:95%;height: 45px;border: none;margin-left: 10px; z-index:999">
                                        <div >
                                            数据集管理
                                            <Dropdown @on-click="onMenuSelect" placement="bottom-start">
                                                <a href="javascript:void(0)" style="margin-left: 45px">
                                                    <Icon type="md-add" />
                                                </a>
                                                <Dropdown-menu slot="list">
                                                    <Dropdown-item name="sqlInfo">SQL数据集</Dropdown-item>
                                                    <Dropdown-item name="apiInfo">API数据集</Dropdown-item>
                                                    <Dropdown-item name="3">JavaBean数据集</Dropdown-item>
                                                </Dropdown-menu>
                                            </Dropdown>
                                        </div>
                                    </Card>
                                    <div id="dataTree">
                                        <template v-for="(item,index) in treeData">
                                            <Tree :data="item" @on-select-change="changeTree"></Tree>
                                        </template>
                                    </div>
                                    <Submenu name="param">
                                        <template slot="title">
                                            参数管理
                                        </template>
                                        <Menu-Item>
                                            <span>参数管理</span>
                                        </Menu-Item>
                                    </Submenu>
                                    <Submenu name="system">
                                        <template slot="title">
                                            系统变量
                                        </template>
                                        <Menu-Item>
                                            <span>系统变量</span>
                                        </Menu-Item>
                                    </Submenu>
                                    <Submenu name="reportIfo">
                                        <template slot="title">
                                            报表信息
                                        </template>
                                        <Card style="width:95%;height: 160px;line-height: 8px;margin-left: 25px;">
                                            <div style="margin-left: -30%;">
                                                <i-form :model="designerObj" label-colon :label-width="90">
                                                    <form-item label="编码">
                                                        <i-input v-model="designerObj.code" disabled ></i-input>
                                                    </form-item>

                                                    <form-item label="名称">
                                                        <i-input v-model="designerObj.name" placeholder="请输入名称" @on-blur="excelQueryName" @on-change="changeName"></i-input>
                                                    </form-item>

                                                    <form-item label="类型">
                                                        <i-select :model.sync="designerObj.type" v-model="designerObj.type" style="width:100%" @on-change="selectmenuList">
                                                            <i-option v-for="item in menuList" :value="item.value">{{ item.label }}</i-option>
                                                        </i-select>
                                                    </form-item>
                                                </i-form>
                                            </div>
                                        </Card>
                                    </Submenu>
                                </i-menu>
                            </template>
                        </div>
                    </template>
                </Card>
            </div>
        </div>

        <div :class="centerDivClass">
            <div id="tableDiv">
                <Card>
                    <div class="layout-content">
                        <div id="x-spreadsheet-demo" style="overflow-x:auto"></div>
                    </div>
                </Card>
            </div>
        </div>
        <div class="jm-rp-right-container">
            <div id="propsDiv">
                <span slot="title" @click="toggleRight">
                    <Icon size="24" type="ios-arrow-forward"/>
                </span>
                <Card style="width: 235px;height: 977px" v-if="propsContentShow">
                    <Tabs size="small" v-model="rightTabName" >
                        <tab-pane label="基本" name="name1">
                            <div id="propsContentDiv" class="layout-content" style="height: 895px;">
                                <div>
                                    <p>坐标</p>
                                    <i-input disabled v-model="excel.coordinate"></i-input>
                                    <p>类型</p>
                                    <i-select v-model="excel.type">
                                        <i-option value="text" key="1">文本</i-option>
                                        <i-option value="pic" key="2">图片</i-option>
                                        <i-option value="barCode" key="3">条形码</i-option>
                                        <i-option value="chart" key="4">图表</i-option>
                                    </i-select>
                                    <p>值</p>
                                    <div>
                                        <i-input v-model="excel.excelValue" @keyup.enter.native="submitValue"></i-input>
                                    </div>
                                    <p>聚合方式</p>
                                    <i-select ref="excelPolyWay" :model.sync="excel.polyWay" v-model="excel.polyWay" @on-change="selectPolyList">
                                        <i-option v-for="item in polyWayList" :value="item.value">{{ item.label }}</i-option>
                                    </i-select>
                                    <p>扩展方向</p>
                                    <i-select :model.sync="excel.direction" v-model="excel.direction" @on-change="selectDirectionList">
                                        <i-option v-for="item in directionList" :value="item.value">{{ item.label }}</i-option>
                                    </i-select>
                                    <p>显示</p>
                                    <div>
                                        <i-input></i-input>
                                    </div>

                                    <p>行依赖</p>
                                    <i-select>
                                        <i-option value="default" key="1">默认</i-option>
                                        <i-option value="customer" key="2">自定义</i-option>
                                    </i-select>
                                    <p>列依赖</p>
                                    <i-select>
                                        <i-option value="default" key="1">默认</i-option>
                                        <i-option value="customer" key="2">自定义</i-option>
                                    </i-select>

                                    <p>超链接</p>
                                    <div>
                                        <i-input></i-input>
                                        <Icon type="md-create"/>
                                    </div>

                                    <p>弹出目标</p>
                                    <i-select>
                                        <i-option value="1" key="1">当前窗口</i-option>
                                        <i-option value="2" key="2">新窗口</i-option>
                                        <i-option value="3" key="3">父窗口</i-option>
                                        <i-option value="4" key="4">顶层窗口</i-option>
                                        <i-option value="5" key="5">自定义</i-option>
                                    </i-select>

                                    <p>自定义属性</p>
                                    <div>
                                        <i-input></i-input>
                                    </div>

                                    <p>是否是字典</p>
                                    <i-select @on-change="selectUseDict" v-model="excel.isDict">
                                        <i-option :value="0" key="1">否</i-option>
                                        <i-option :value="1" key="2">是</i-option>
                                    </i-select>

                                    <div v-if="excel.isDict=='1'">
                                        <p>字典编码</p>
                                        <div>
                                            <i-input @on-blur="changeDictCode" v-model="excel.dictCode" placeholder="请输入"></i-input>
                                        </div>
                                    </div>

                                    <p v-if="chartsflag">偏移量</p>
                                    <div v-if="chartsflag">
                                        <i-input v-model="offsetInfo" @on-blur="changeLayerOffset"></i-input>
                                    </div>

                                </div>
                            </div>
                        </tab-pane>
                        <tab-pane label="样式" name="name2" v-if="chartsflag">
                            <i-menu theme="light" width="auto" style="margin-left: -20px;height: 900px;" :class="menuitemClasses" accordion>
                                <Submenu name="1" style="border-bottom: inset 1px;">
                                    <template slot="title">
                                        标题设置
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>标题文字&nbsp;&nbsp;</p>
                                            <i-input size="small" v-model="echartInfo.titleText" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>字体颜色&nbsp;&nbsp;</p>
                                            <Col><color-picker class="colorPicker" v-model="echartInfo.titleColor" size="small" @on-change="styleChanges"/></Col>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>字体加粗&nbsp;&nbsp;</p>
                                            <i-select size="small" class="iSelect" :model.sync="echartInfo.titleFontWeight" v-model="echartInfo.titleFontWeight" @on-change="styleChanges">
                                                <i-option value="normal">normal</i-option>
                                                <i-option value="bold">bold</i-option>
                                                <i-option value="bolder">bolder</i-option>
                                                <i-option value="lighter">lighter</i-option>
                                            </i-select>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>字体大小&nbsp;&nbsp;</p>
                                            <i-input size="small" type="number" v-model="echartInfo.titleFontSize" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>
                                        <Row class="ivurow">
                                            <p  style="margin-bottom: 10px;">标题位置&nbsp;&nbsp;</p>
                                            <i-select size="small" class="iSelect" :model.sync="echartInfo.titleLocation" v-model="echartInfo.titleLocation" @on-change="styleChanges">
                                                <i-option value="left">left</i-option>
                                                <i-option value="center">center</i-option>
                                                <i-option value="right">right</i-option>
                                            </i-select>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="2" style="border-bottom: inset 1px;" v-if="chartsType =='bar' || chartsTypeArr.indexOf('bar')!=-1">
                                    <template slot="title">
                                        柱体设置
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>宽度&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo.barWidth" @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>圆角&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo.barRadius" @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>
                                        <Row class="ivurow">
                                            <p style="margin-bottom: 10px;">最小高度&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo.barMinHeight" @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="3" style="border-bottom: inset 1px;" v-if="chartsType =='line' || chartsTypeArr.indexOf('line')!=-1">
                                    <template slot="title">
                                        折线设置
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>平滑曲线&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 77px;" v-model="echartInfo.smooth" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>标记点&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 90px;" v-model="echartInfo.showSymbol" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>点大小&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo.symbolSize" @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>阶梯线图&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 77px;" v-model="echartInfo.step" @on-change="styleChanges"/>
                                        </Row>
                                        <#--<Row class="ivurow">
                                            <p>阶梯线图&nbsp;&nbsp;</p>
                                            <i-select size="small" :model.sync="echartInfo.steptwo" v-model="echartInfo.steptwo" @on-change="styleChanges">
                                                <i-option value="start">当前点</i-option>
                                                <i-option value="middle">中间点</i-option>
                                                <i-option value="end">下个拐点</i-option>
                                            </i-select>
                                        </Row>-->
                                        <#--<Row class="ivurow">
                                            <p>面积堆积&nbsp;&nbsp;</p>
                                            <i-switch size="small" v-model="echartInfo." @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>面积透明&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo." @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>-->
                                        <Row class="ivurow">
                                            <p style="margin-bottom: 10px;">线条宽度&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo.linewidth" @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="4" style="border-bottom: inset 1px;" v-if="chartsType =='pie'">
                                    <template slot="title">
                                        饼图设置
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>环形饼图&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 77px;" v-model="echartInfo.isRadius" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow" v-if="echartInfo.isRadius">
                                            <p>半径大小&nbsp;&nbsp;</p>
                                            <i-input size="small" v-model="echartInfo.pieRadius" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>南丁格尔玫瑰&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 50px;" v-model="echartInfo.roseType" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>自动排序&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 77px;" v-model="echartInfo.autoSort" @on-change="styleChanges"/>
                                        </Row>
                                        <#--  <Row class="ivurow">
                                              <p>不展示零&nbsp;&nbsp;</p>
                                              <i-switch size="small" v-model="echartInfo.notCount" @on-change="styleChanges"/>
                                          </Row>-->
                                        <Row class="ivurow">
                                            <p>最小角度&nbsp;&nbsp;</p>
                                            <i-input size="small" type="number" v-model="echartInfo.minAngle" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>

                                        <Row class="ivurow">
                                            <p style="margin-bottom: 10px;">标签位置&nbsp;&nbsp;</p>
                                            <i-select size="small" style="width: 180%;" :model.sync="echartInfo.pieLabelPosition" v-model="echartInfo.pieLabelPosition" @on-change="styleChanges">
                                                <i-option value="outside">外侧</i-option>
                                                <i-option value="inside">内部</i-option>
                                                <i-option value="center">中心</i-option>
                                            </i-select>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="5" style="border-bottom: inset 1px;" v-if="chartsType !=='pie'&&chartsType !=='map'">
                                    <template slot="title">
                                        X轴设置
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>显示&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 105px;" v-model="echartInfo.xaxisShow" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>X轴名称&nbsp;&nbsp;</p>
                                            <i-input size="small" v-model="echartInfo.xaxisText" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>分隔线&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 90px;" v-model="echartInfo.xaxisLine" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow" v-if="echartInfo.xaxisLine">
                                            <p>轴线颜色&nbsp;&nbsp;</p>
                                            <Col><color-picker class="colorPicker" v-model="echartInfo.xaxisLinecol" size="small" @on-change="styleChanges"/></Col>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>文字角度&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo.axisLabelRotate" @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>
                                        <Row class="ivurow">
                                            <p style="margin-bottom: 10px;">字体大小&nbsp;&nbsp;</p>
                                            <i-input size="small" type="number" v-model="echartInfo.xaxisTextsize" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="6" style="border-bottom: inset 1px;" v-if="chartsType !== 'pie'&&chartsType !=='map'">
                                    <template slot="title">
                                        Y轴设置
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>显示&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 105px;" v-model="echartInfo.yaxisShow" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>Y轴名称&nbsp;&nbsp;</p>
                                            <i-input size="small" v-model="echartInfo.yaxisText" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>分隔线&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 90px;" v-model="echartInfo.yaxisLine" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow" v-if="echartInfo.yaxisLine">
                                            <p>轴线颜色&nbsp;&nbsp;</p>
                                            <Col><color-picker class="colorPicker" v-model="echartInfo.yaxisLinecol" size="small" @on-change="styleChanges"/></Col>
                                        </Row>
                                        <Row class="ivurow">
                                            <p style="margin-bottom: 10px;">字体大小&nbsp;&nbsp;</p>
                                            <i-input size="small" type="number" v-model="echartInfo.yaxisTextsize" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="7" style="border-bottom: inset 1px;">
                                    <template slot="title">
                                        数值设置
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>显示&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 105px;" v-model="echartInfo.numerShow" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>字体大小&nbsp;&nbsp;</p>
                                            <i-input size="small" type="number" v-model="echartInfo.numerTextSize" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>字体颜色&nbsp;&nbsp;</p>
                                            <Col><color-picker class="colorPicker" size="small" v-model="echartInfo.numerTextcol" @on-change="styleChanges"/></Col>
                                        </Row>
                                        <Row class="ivurow">
                                            <p style="margin-bottom: 10px;">字体粗细&nbsp;&nbsp;</p>
                                            <i-select size="small" class="iSelect" :model.sync="echartInfo.numerTextweig" v-model="echartInfo.numerTextweig" @on-change="styleChanges">
                                                <i-option value="normal">normal</i-option>
                                                <i-option value="bold">bold</i-option>
                                                <i-option value="bolder">bolder</i-option>
                                                <i-option value="lighter">lighter</i-option>
                                            </i-select>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="8" style="border-bottom: inset 1px;">
                                    <template slot="title">
                                        提示语设置
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>显示&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 105px;" v-model="echartInfo.tooltipShow" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>字体大小&nbsp;&nbsp;</p>
                                            <i-input size="small" type="number" v-model="echartInfo.tooltipTextSize" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>
                                        <Row class="ivurow">
                                            <p style="margin-bottom: 10px;">字体颜色&nbsp;&nbsp;</p>
                                            <Col><color-picker class="colorPicker" size="small" v-model="echartInfo.tooltipTextcol" @on-change="styleChanges"/></Col>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="9" style="border-bottom: inset 1px;">
                                    <template slot="title">
                                        图例设置
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>显示&nbsp;&nbsp;</p>
                                            <i-switch size="small" style="margin-left: 105px;" v-model="echartInfo.legendShow" @on-change="styleChanges"/>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>字体大小&nbsp;&nbsp;</p>
                                            <i-input size="small" type="number" v-model="echartInfo.legendTextsize" @on-blur="styleChanges" style="width: 111px;"></i-input>
                                        </Row>
                                        <Row class="ivurow" v-if="echartInfo.legendTextcol">
                                            <p>字体颜色&nbsp;&nbsp;</p>
                                            <Col><color-picker class="colorPicker" size="small" v-model="echartInfo.legendTextcol" @on-change="styleChanges"/></Col>
                                        </Row>
                                        <#--<Row class="ivurow">
                                            <p>图例宽度&nbsp;&nbsp;</p>
                                            <i-input size="small" type="number" v-model="echartInfo.legendItemWidth" @on-blur="styleChanges" style="width: 111px;margin-bottom: 10px;"></i-input>
                                        </Row>-->
                                        <Row class="ivurow">
                                            <p>纵向位置&nbsp;&nbsp;</p>
                                            <i-select size="small" style="width: 180%;" :model.sync="echartInfo.legendTop" v-model="echartInfo.legendTop" @on-change="styleChanges">
                                                <i-option value="top">顶部</i-option>
                                                <i-option value="bottom">底部</i-option>
                                            </i-select>
                                        </Row>
                                        <Row class="ivurow">
                                            <p style="margin-bottom: 10px;">横向位置&nbsp;&nbsp;</p>
                                            <i-select size="small" class="iSelect" :model.sync="echartInfo.legendLeft" v-model="echartInfo.legendLeft" @on-change="styleChanges">
                                                <i-option value="left">左对齐</i-option>
                                                <i-option value="center">居中</i-option>
                                                <i-option value="right">右对齐</i-option>
                                            </i-select>
                                        </Row>
                                        <Row class="ivurow" v-if="chartsType !== 'bar'">
                                            <p style="margin-bottom: 10px;">布局朝向&nbsp;&nbsp;</p>
                                            <i-select size="small" style="width: 180%;" :model.sync="echartInfo.legendOrient" v-model="echartInfo.legendOrient" @on-change="styleChanges">
                                                <i-option value="horizontal">横排</i-option>
                                                <i-option value="vertical">竖排</i-option>
                                            </i-select>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="10" style="border-bottom: inset 1px;">
                                    <template slot="title" v-if="chartsType !== 'pie'">
                                        坐标轴边距
                                    </template>
                                    <template slot="title" v-if="chartsType == 'pie'">
                                        边距
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>左边距&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo.gridLeft" @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>顶边距&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo.gridTop" @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>右边距&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo.gridRight" @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>
                                        <Row class="ivurow">
                                            <p style="margin-bottom: 10px;">底边距&nbsp;&nbsp;</p>
                                            <slider v-model="echartInfo.gridBottom" @on-change="styleChanges" style="margin-top: -9px;width: 120px;margin-left: 5px;"></slider>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="11" style="border-bottom: inset 1px;" v-if="chartsType !== 'pie'">
                                    <template slot="title">
                                        自定义颜色
                                    </template>
                                    <div class="blockDiv">
                                        <Row class="ivurow">
                                            <p>字体颜色&nbsp;&nbsp;</p>
                                            <Col><color-picker class="colorPicker" size="small" v-model="echartInfo.axisLabelTextCol" @on-change="styleChanges"/></Col>
                                        </Row>
                                        <Row class="ivurow">
                                            <p>坐标轴颜色&nbsp;&nbsp;</p>
                                            <Col><color-picker class="colorPicker" size="small" v-model="echartInfo.axisLineLineCol" @on-change="styleChanges"/></Col>
                                        </Row>
                                        <Row class="ivurow" v-if="chartsType == 'bar' && echartInfo.seriesItemNorCol">
                                            <p>柱体颜色&nbsp;&nbsp;</p>
                                            <Col><color-picker class="colorPicker" size="small" v-model="echartInfo.seriesItemNorCol" @on-change="styleChanges"/></Col>
                                        </Row>
                                        <Row class="ivurow" v-if="chartsType == 'line' && echartInfo.seriesLinemNorCol">
                                            <p style="margin-bottom: 10px;">线条颜色&nbsp;&nbsp;</p>
                                            <Col><color-picker class="colorPicker" size="small" v-model="echartInfo.seriesLinemNorCol" @on-change="styleChanges"/></Col>
                                        </Row>
                                    </div>
                                </Submenu>
                                <Submenu name="12" style="border-bottom: inset 1px;" v-if="chartsType == 'pie'|| isMultiChart">
                                    <template slot="title">
                                        自定义配色
                                    </template>
                                    <div style="margin-left: 25px;margin-top: -15px;">
                                        <Row class="ivurow" style="margin-bottom: 5px;">
                                            <i-button type="primary" size="small" @click="colorMatchModal=true">新增</i-button>
                                        </Row>
                                        <i-table stripe :columns="columns2" :data="echartInfo.colorMatchData"></i-table>
                                    </div>
                                </Submenu>
                            </i-menu>
                        </tab-pane>
                        <tab-pane label="数据" name="name3" v-if="chartsflag">
                            <div class="datastyle">
                                <p>数据类型:</p>
                                <i-select :model.sync="dataAllocation.dataType" v-model="dataAllocation.dataType">
                                    <i-option value="sqlechData">SQL数据集</i-option>
                                    <i-option value="apiechData">Api数据集</i-option>
                                </i-select>
                            </div>
                            <div class="datastyle" v-if="dataAllocation.dataType == 'apiechData'">
                                <div class="datastyle">
                                    <p>Api类型:</p>
                                    <i-select :model.sync="dataAllocation.status" v-model="dataAllocation.status">
                                        <i-option value="staticData">静态数据</i-option>
                                        <i-option value="dynamicData">动态数据</i-option>
                                    </i-select>
                                </div>
                                <div class="datastyle" v-if="dataAllocation.status == 'staticData'">
                                    <p>数据值:</p>
                                    <i-button type="primary" @click="addEchartInfoData">编辑</i-button>
                                </div>
                                <div class="datastyle" v-else="dataAllocation.status == 'dynamicData'">
                                    <div>
                                        <p>绑定数据集:</p>
                                        <i-select :model.sync="dataAllocation.selectId" v-model="dataAllocation.selectId">
                                            <i-option v-for="item in dataAllocation.apiListOpt" :value="item.dbId">{{ item.title }}</i-option>
                                        </i-select>
                                    </div>
                                </div>
                            </div>
                            <div class="datastyle" v-if="dataAllocation.dataType == 'sqlechData'">
                                <div class="datastyle">
                                    <p>绑定数据集:</p>
                                    <i-select :model.sync="dataAllocation.selectId" v-model="dataAllocation.selectId" @on-change="selectSqlListOpt">
                                        <i-option v-for="item in dataAllocation.sqlListOpt" :value="item.dbId">{{ item.title }}</i-option>
                                    </i-select>
                                </div>
                                <div class="datastyle">
                                    <p>分类属性:</p>
                                    <i-select :model.sync="dataAllocation.sqlxAxis" v-model="dataAllocation.sqlxAxis">
                                        <i-option v-for="item in dataAllocation.sqlListField" :value="item.title">{{ item.title }}</i-option>
                                    </i-select>
                                </div>
                                <div class="datastyle">
                                    <p>值属性:</p>
                                    <i-select :model.sync="dataAllocation.sqlseries" v-model="dataAllocation.sqlseries">
                                        <i-option v-for="item in dataAllocation.sqlListField" :value="item.title">{{ item.title }}</i-option>
                                    </i-select>
                                </div>
                                <template v-if="isMultiChart">
                                    <div class="datastyle">
                                        <p>系列属性:</p>
                                        <i-select :model.sync="dataAllocation.sqlgroup" v-model="dataAllocation.sqlgroup">
                                            <i-option v-for="item in dataAllocation.sqlListField" :value="item.title">{{ item.title }}</i-option>
                                        </i-select>
                                    </div>
                                </template>
                            </div>
                            <div class="datastyle" v-if="dataAllocation.dataType == 'sqlechData' && specialChartType == 'linebar'">
                                <p>系列类型:</p>
                                <div style="margin-top: -15px;">
                                    <Row class="ivurow" style="margin-bottom: 5px;">
                                        <i-button type="primary" size="small" @click="seriesModal=true">新增</i-button>
                                    </Row>
                                    <i-table stripe :columns="seriesColumns" :data="dataAllocation.seriesTypeData"></i-table>
                                </div>
                            </div>
                            <i-button @click="echDataRun" type="primary" style="width: 100%;height: 5%;margin-top: 10%;">运行</i-button>
                        </tab-pane>
                    </Tabs>

                </Card>
            </div>
        </div>
    </div>
</div>

<script>

    var excel_config_id = "${config_id}";
    var xs = null;
    var vm = null;

    function load() {
        let token = window.localStorage.getItem('JmReport-Access-Token');
        if (token == "" || token == null){
            token = getRequestUrl().token;
        }
        console.log("index_load--------------",token);
        const options = {
            "viewLocalImage":"/design/report/img",//预览本地图片方法
            "uploadUrl":"/design/report/upload", //统一上传地址
            "uploadExcelUrl":"/design/report/importExcel?token="+token,//上传excel方法
            pageSize:[10,20,30], //分页条数
            domain:window.location.origin+base,
            showToolbar: true,     //头部操作按钮
            showGrid: true,        //excel表格
            showContextmenu: true, //右键操作按钮
            view: {
                height: () => document.documentElement.clientHeight,
                width: () => document.documentElement.clientWidth,
            },
            row: {
                len: 100,
                height: 25,
                minRowResizerHeight:1 //拖拽行最小高度
            },
            col: {
                len: 26,
                width: 100,
                minWidth: 60,
                height: 0,
                minColResizerHeight:1//拖拽列最小高度
            },
            style: {
                bgcolor: '#ffffff',
                align: 'left',
                valign: 'middle',
                textwrap: false,
                strike: false,
                underline: false,
                color: '#0a0a0a',
                font: {
                    name: 'Microsoft YaHei',
                    size: 10,
                    bold: false,
                    italic: false,
                },
            },
        };

        x.spreadsheet.locale('zh-cn');
        xs = x.spreadsheet('#x-spreadsheet-demo', options)
                .onSave(function (data) {
                    //设置报表打印宽度
                    const dataRect = xs.data.getDataRect();
                    let dataRectWidth = 0;
                    if(dataRect){
                        dataRectWidth = dataRect.w;
                    }
                    //直接读取文本框的值
                    const printElWidth = xs.sheet.toolbar.toolPrintInputEl.input.el.value
                    data['dataRectWidth'] = dataRectWidth;
                    data['excel_config_id'] = excel_config_id;
                    data['printElWidth'] = Number(printElWidth) || dataRectWidth;
                    data['printElHeight'] = Number(xs.sheet.toolbar.toolPrintHeightInputEl.input.el.value)
                    data['toolPrintSizeObj'] = xs.data.toolPrintSizeObj;

                    jQuery.excelSave(data, token,function () {
                        xs.tip("保存成功!");
                    });
                })
                .onAddChart(function(a){
                    vm.addChartModule();
                })
                .onSelectChart(function(data){
                    vm.chartsflag=true;
                    vm.selectChart(data);
                })
                .onChartDelete(function(){
                    vm.chartsflag=false;
                    vm.rightTabName='name1';
                })
                .onUploadExcel(function (res) {
                   if(!res.success) return;
                   const xsData ={...xs.getData()};
                   xsData.styles = res.result.style;
                   xsData.rows = res.result.rows;
                   xs.loadData(xsData);
               });

        jQuery.excelGet(excel_config_id, token,function (res) {
            //加入预览地址
            xs.data.settings.viewUrl = window.location.origin+base+'/design/report/view/'+excel_config_id;
            addDrag();
            if (res.success) {
                var str = res.result.jsonStr;
                if(!str) return;
                //页面加载时设置报表宽度
                const jsonStr = JSON.parse(str);
                xs.data.settings.printElWidth = jsonStr.printElWidth || 0;
                xs.data.printElHeight = jsonStr.printElHeight ||  1047; //默认a4纸大小
                xs.sheet.toolbar.toolPrintHeightInputEl.input.el.value =  xs.data.printElHeight;
                xs.loadData(jsonStr);
            } else {
                xs.tip(res.message);
            }
        });
        /*xs.sheet.toolbar.toolPrintInputEl.input.el.onchange=(e=>{
            var clientWidth = document.documentElement.clientWidth;
            var remainingWidth = clientWidth - e.target.value - 330;
            if (remainingWidth<300){
                xs.sheet.horizontalScrollbar.el.el.style.overflowX="scroll";
            }else {
                xs.sheet.horizontalScrollbar.el.el.style.overflowX="hidden";
            }
        })*/
    }



</script>
<script type="text/javascript" src="${base}/jmreport/desreport_/js/design.js?${CACHE_VERSION}"></script>
<script>
     window.onbeforeunload = function(event){
	   return '您可能有数据没有保存';
     };
</script>
</html>
