const view = {
    origin:window.location.origin
 }
// 预览页面 vue实例
 let rpViewInst = new Vue({
     el: "#app",
     data: function () {
         return {
             loading: false,
             visible: false,
             reportParamList:[],
             reportParamObj:{

             },
             callback:''
         }
     },
     methods:{
         show(reportParamList, callback){
             this.reportParamList = [...reportParamList];
             this.visible=true;
             let obj = {};
             for(let item of reportParamList){
                 if(!item.paramValue || item.paramValue.length==0){
                     obj[item.paramName] = '';
                 }else{
                     obj[item.paramName] = item.paramValue;
                 }
             }
             this.reportParamObj = obj;
             this.callback = callback;
             //console.log('show', reportParamList)
         },
         onSave() {
             //console.log('this.paramobj', this.reportParamObj);
             this.callback(this.reportParamObj);
             this.visible=false;
             Vue.prototype.$Spin.show();
         }
     }
 })
 //方便前端调试
 if(getRequestUrl().develop=='true'){
     view.origin=getRequestUrl().origin;
 }
 const reg = /{([a-zA-Z0-9_\u4e00-\u9fa5]+).(\S+)}/
 let xs = null;
 window.onresize=()=>{
     //窗口大小改变后，设置图片上边距
     setTimeout(() => {
         view.dealPicTop();
         changeScrollBottom();
     }, 1);

 }
 view.load = function(excelConfigId){
     Vue.prototype.$Spin.show();
     //拿到token
     let token = window.localStorage.getItem('JmReport-Access-Token');
     if (token == "" || token == null || "undefined"==token){
         token = getRequestUrl().token;
         window.localStorage.setItem('JmReport-Access-Token',token);
     }
     view.token = token;
     console.log("view_view--------------",view.token);
     view.excelConfigId = excelConfigId;
     const options = {
         "viewLocalImage":"/design/report/img",//预览本地图片方法
         domain:view.origin+base,
         rpBar: true,
         showToolbar:false ,     //头部操作按钮
         showGrid: false,        //excel表格
         showContextmenu: false, //右键操作按钮
         readOnly:true,
         view: {
             height: () => document.documentElement.clientHeight,
             width: () => document.documentElement.clientWidth,
         },
         row: {
             len: 100,
             height: 25,
         },
         col: {
             len: 26,
             width: 100,
             minWidth: 60,
             height: 0,
             indexWidth: 0,
         },
         style: {
             bgcolor: '#ffffff',
             align: 'left',
             valign: 'middle',
             textwrap: false,
             strike: false,
             underline: false,
             color: '#0a0a0a',
             font: {
                 name: 'Helvetica',
                 size: 10,
                 bold: false,
                 italic: false,
             },
         },
     };
     //x.spreadsheet.locale('zh-cn');
     const requestParam = getRequestUrl();
     let jmdata=requestParam.jmdata;
     // 下载oss图片到本地
     options.downLoadImage = (imageUrl)=>{
         return axios.get(`${options.domain}/design/report/download/image?imageUrl=${imageUrl}`)
     }
     if(jmdata){
         options.total = 1;
         xs = x.spreadsheet('#x-spreadsheet-demo', options)
         const excelData = JSON.parse(decodeURIComponent(jmdata));
        xs.data.rows._={}
        xs.data.cols._={};
        xs.data.styles=[];
        xs.loadData(excelData);
     }else{
         let page=1;
         let total = 1;
         options.pageInfo={
             url:`${view.origin}${base}/design/report/show`,
             data:{
                 "id":excelConfigId,
                 "params":requestParam
             }
         }
         var loadExcelView = function(inputparam){
             if(inputparam){
                 Object.keys(inputparam).map(key=>{
                     requestParam[key] = inputparam[key]
                     if(key=='pageNo'){
                         page = Number(inputparam[key])
                     }
                 })
             }
             view.dictInfo = []
             requestParam.pageNo = page;
             jQuery.excelView(excelConfigId,requestParam,function (res) {
                 if(res.success){
                     var str = res.result.jsonStr;
                     if(!str){
                         xs.loadData({});
                         return;
                     }
                     //预览运行图表数据
                     let jsonStr = JSON.parse(str);
                     if (jsonStr &&  jsonStr.chartList && jsonStr.chartList.length > 0){
                         jsonStr.chartList.forEach(item=>{
                             let echartJson = JSON.parse(item.config);
                             let sqlxAxis = '';
                             let sqlseries = '';
                             let sqlgroup = '';
                             let sqltype = '';
                             if (item.extData){
                                 sqlxAxis = item.extData.sqlxAxis;
                                 sqlseries = item.extData.sqlseries;
                                 sqlgroup = item.extData.sqlgroup;
                                 sqltype = item.extData.sqltype;
                             }
                             //替换SQL数据
                             if (item.extData.dataType === 'sqlechData' && item.extData.selectId != ''){
                                 jQuery.qurestSql(item.extData,token,function (res) {
                                     if(res.success){
                                         echartJson = querySqlData(echartJson,sqlxAxis,sqlseries,sqlgroup,sqltype,res.result);
                                         item.config = JSON.stringify(echartJson);
                                     }
                                 })
                             //替换api数据
                             }else if (item.extData.dataType === 'apiechData' && item.extData.selectId != ''){
                                 if (item.extData.status == 'dynamicData') {
                                     jQuery.qurestApi(item.extData,token,function (res) {
                                         if(res.success){
                                             echartJson = queryApiData(echartJson,res.result);
                                             item.config = JSON.stringify(echartJson);
                                         }
                                     })
                                 }
                             }else{
                                 item.config=JSON.stringify(echartJson);
                             }
                         })
                         str = JSON.stringify(jsonStr);
                     }
                     //获取分页参数
                     const dealDataList = view.dealDataList(res.result.dataList);
                     const dataList = dealDataList.dataList;
                     const count = dealDataList.count;
                     const pageObj = dealDataList.pageObj;
                     const excelDataList = view.getExcelData(dataList);
                     view.dictInfo = res.result.dictInfo
                     if(Object.keys(pageObj).length===1){
                         total = pageObj[Object.keys(pageObj)[0]];
                         options.getPageResult = getPageResult
                     }
                     options.count = count;
                     options.pdfName=res.result.name;
                     options.page =page;
                     options.total = total;

                     const printAllFlag=encodeURIComponent(JSON.stringify({'printAll':true}));
                     options.getAll=`${view.origin}${base}/design/report/show?id=${excelConfigId}&params=${printAllFlag}`;
                     //查找全部数据接口
                     options.getAllFn=function () {
                         return axios.get(options.getAll);
                     };

                     //多页打印回调函数
                     options.parseDataFn=view.parseData;
                     options.dealManySourceFn=dealManySource;
                     const requestParamObj = getRequestUrl();
                     let requestStr=``;
                     if(requestParamObj){
                         for(let key in requestParamObj){
                             requestStr+=(requestStr.includes("?")?`&`:`?`)+`${key}=${requestParamObj[key]}`
                         }
                         requestStr+=(requestStr.includes("?")?`&`:`?`)+`token=${token}`
                     }
                     var base64Arry = [];
                     //console.log('--options',JSON.stringify(options))
                     xs = x.spreadsheet('#x-spreadsheet-demo', options)
                         .onExportExcelPage(function(){
                             //导出当前页excel
                             /*const settings = xs.data.settings;
                             const pageSize = settings.pageSize | 10;*/
                             //window.open(base+`/design/report/exportExcel/${excelConfigId}/${settings.page}/${pageSize}/${requestStr}`);
                         })
                         .onExportExcelAll(function(){
                             //导出全部excel
                             //window.open(base+`/design/report/exportAllExcel/${excelConfigId}?token=${token}`);
                             xs.getLayerBase64().then(values=>{
                                 base64Arry = values;
                                 var dataStr = '';
                                 if (base64Arry != null && base64Arry.length > 0){
                                     dataStr = JSON.stringify({excelConfigId:excelConfigId,base64Arry:base64Arry});
                                 }else {
                                     dataStr = JSON.stringify({excelConfigId:excelConfigId});
                                 }
                                 let url = `${view.origin}${base}/design/report/exportAllExcel`;
                                 $.ajax({
                                     type : "POST",
                                     contentType: "application/json;charset=UTF-8",
                                     url : url,
                                     data : dataStr,
                                     success : function(data) {
                                         ajaxFileDownload(data.file, data.name);
                                     },
                                     error : function(e){
                                         xs.tip(e.error);
                                     }
                                 });
                             })
                         });
                     view.viewReport(str,excelDataList);
                     Vue.prototype.$Spin.hide();
                 }else{
                     Vue.prototype.$Spin.hide();
                     Vue.prototype.$Message.warning(res.message);
                 }
             })
         }

         //先校验 参数 再
         jQuery.checkParam(excelConfigId,(res)=>{
             if(res.success){
                 Vue.prototype.$Spin.hide();
                 let requestUrlParam = getRequestUrlParam();
                 if(reportMode=='dev'){
                     // 判断地址参数是否和数据库参数匹配
                     var match = dbParamMatchUrlParam(res.result, requestUrlParam)
                     if(match){
                         //如果匹配 则直接显示报表
                         loadExcelView(requestUrlParam)
                     }else{
                         //如果不匹配 则弹框 需要用户填写相关参数
                         // rpViewInst.show(res.result, loadExcelView);
                         loadExcelView()
                     }
                 }else{
                     let dbParam = {}
                     for(let item of res.result){
                         dbParam[item.paramName] = item.paramValue
                     }
                     let inputparam = Object.assign(dbParam, requestUrlParam)
                     loadExcelView(inputparam)
                 }
             }else{
                 //无参数
                 loadExcelView();
             }
         })
     }

     //增加访问次数
     jQuery.addViewCount(excelConfigId);

 }
 view.getExcelData=function(dataList){
     const excelDataList = {};
     for(let key in dataList){
         const dataObj = dataList[key];
         excelDataList[key] = JSON.parse(JSON.stringify(dataObj.list));
         excelDataList[`${key}_isPage`] =dataObj['isPage'];

     }
     return excelDataList;
 }
 /**
  * 获得分页信息
  * @param {} resultList
  */
 view.dealDataList=function(resultList){
     //处理之前老数据,只有一个数据源，
     if(Object.keys(resultList).length==1){
          let dataKey = Object.keys(resultList)[0];
          let dataObj = resultList[dataKey];
          if(
              !dataObj.isPage
               && dataObj.total>1
           ){
                dataObj['isPage']='1';
             }
     }
     const dataList = JSON.parse(JSON.stringify(resultList));
     let count = 1;
     const pageObj = {}
     Object.keys(dataList).forEach(key=>{
         const dataObj = dataList[key];
         Object.keys(dataObj).forEach(resultKey=>{
             if(resultKey.endsWith("total")){
                 //是否是分页数据集
                 if(dataObj[`isPage`]=='1' &&dataObj['list'].length>1){
                     count = dataObj[`count`];
                     pageObj[key] = dataObj['total'];
                 }
                 delete dataObj['total'];
                 delete dataObj['count'];
             }
         })
     });
     return {
         dataList,
         count,
         pageObj
     }
 }

 // 将表达式的json数据转化成真实数据
 view.parseData = function(str,dataList,isPrint=false){
     //console.log('----------------------------')
     //console.log(str)
     console.log('数据集',dataList)
     //console.log('----------------------------')
     if(isPrint){
         dataList = view.dealDataList(dataList);
         dataList = view.getExcelData(dataList.dataList);
     }
     Object.keys(dataList).forEach(key=>{
         delete dataList[`${key}_count`]
         if(key.endsWith("_total")){
             delete  dataList[key]
         }
     });
     //将数据里的key转成小写
     Object.values(dataList).forEach(item=>{
        item instanceof Array && item.forEach(row=>{
             Object.keys(row).forEach(key=>{
                 const lowerKey = key.toLowerCase();
                 if (lowerKey != key) {
                     row[lowerKey] = row[key];
                     delete row[key];
                 }
             })
         })
     });
     let strObj = JSON.parse(str);
     if(!dataList) return;
     const dataListLen = Object.keys(dataList)
          .filter(item=>!item.endsWith('_isPage'))
          .length
     if(dataListLen==1){
         // 有一个数据集，并且数据集中只有一条记录
         let resultArray = Object.values(dataList);
         if(!resultArray) return
         const dataArryLen = resultArray[0].length
         if(dataArryLen==1){
             strObj = dealOneData(strObj,dataList)
         }else if(dataArryLen>1){
             strObj =  dealManySource(strObj,dataList)
         }else {
             strObj = dealNoData(strObj)
         }
     }else if(dataListLen>1){
         strObj = dealManySource(strObj,dataList)
     }
     // 字典数据处理
     dictDataHandler(strObj);
     //console.log('----------------------------')
     console.log('最终的数据对象',strObj)
     //console.log('----------------------------')
     return strObj;
 }
 view.dealPicTop=function(){
     if(!xs) return;
     const imageData = xs.data.imgList;
     if(!imageData) return;
     //判断是否有套打图片,处理套打图片对不上问题
     const isBackend = imageData.some(item=>item.isBackend)
     if(isBackend){
         const $content = $(".x-spreadsheet-overlayer-content")[0];
         $content.style.top='0px';
     }
 }
 view.viewReport = function(str,dataList,type){
     const viewData = view.parseData(str,dataList);
     if(type==='rpchange'){
         viewData.imgList = []
         viewData.chartList = []
     }
     xs.loadData(viewData);
     view.dealPicTop();
 }


function ajaxFileDownload(data,filename) {
    var a = document.createElement('a');
    var bstr = atob(data), n = bstr.length, u8arr = new Uint8Array(n);
    while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
    }
    var blob =  new Blob([u8arr], { type: "application/octet-stream" });
    var url = window.URL.createObjectURL(blob);
    a.href = url;
    a.download = filename;
    a.click();
    window.URL.revokeObjectURL(url);
}

 //图表预览替换查询SQL数据
function querySqlData(echartJson,sqlxAxis,sqlseries,sqlgroup,sqltype,result){
    let charType = echartJson.series[0].type;
    let resultArr=JSON.parse(JSON.stringify(result));//记录结果集数据
    if (charType === 'bar' || charType === 'line'){
        let xAxisData = [];
        let seriesData = [];
        let legendData = [];//图例数据
        result.forEach(item=>{
            for(var d in item) {
                if (xAxisData.indexOf(item[d]) != -1){
                    let index = xAxisData.indexOf(item[d]);
                    seriesData[index] = seriesData[index] + item[sqlseries];
                    delete item[sqlseries];
                }else {
                    if (d === sqlxAxis){
                        xAxisData.push(item[d]);
                    }
                    if (d === sqlseries){
                        seriesData.push(item[d]);
                    }
                    if (d === sqlgroup && legendData.indexOf(item[d]) == -1){
                        legendData.push(item[d]);
                    }
                }
            }
        });
        echartJson.xAxis.data = xAxisData;
        //图例数据大于0，多组分类数据
        if(legendData.length>1){
            //处理分组数据
            let series=[];
            legendData.forEach((name,index)=>{
                //获取series公共样式
                let seriesStyle = echartJson.series.filter(item=>item.name==name);
                //let commonObj=Object.assign(echartJson.series[0],{name:name,data:[]});
                let commonObj=Object.assign(seriesStyle[0],{name:name,data:[]});
                let seriesObj=JSON.parse(JSON.stringify(commonObj));
                //获取series的data数据集
                for(let item of resultArr){
                    if(seriesObj.data.length==xAxisData.length){
                        break;
                    }
                    if(item[sqlgroup] == name){
                        seriesObj.data.push(item[sqlseries]);
                    }
                }
                series[index]=seriesObj;
            });
            console.log("series===>",series);
            echartJson.series=series;
        }else{
            echartJson.series[0].data = seriesData;
        }
        return echartJson;
    }else if (charType === 'pie'){
        let objpie = [];
        result.forEach(item=>{
            var objres = {};
            for(var d in item) {
                if (d === sqlxAxis){
                    objres['name'] = item[d];
                }
                if (d === sqlseries){
                    objres['value'] = item[d];
                }
            }
            objpie.push(objres);
        });
        let colorList=echartJson.series[0].data.map(item=>{return item.itemStyle;});
        echartJson.series[0].data = mergeObject(objpie);
        console.log('colorList',colorList);
        echartJson.series[0].data.forEach(item,index=>{
            item.itemStyle=colorList[index];
        });
        return echartJson;
    }else if(charType === 'scatter'){
        echartJson.series[0].data = result.map(item=>{
            return [item[sqlxAxis],item[sqlseries]]
        });
        return obj;
    }
}
//图表预览替换查询api数据
function queryApiData(echartJson,result){
    let charType = echartJson.series[0].type;
    if (charType === 'bar' || charType === 'line'){
        let xAxisData = [];
        let seriesData = [];
        result.data.forEach(item=>{
            for(var d in item) {
                if (d === 'name'){
                    xAxisData.push(item[d]);
                }
                if (d === 'value'){
                    seriesData.push(item[d]);
                }
            }
        });
        echartJson.xAxis.data = xAxisData;
        //包含分类多组数据处理
        if(result.category){
            let series=[];
            //设置图例数据
            result.category.forEach((item,index)=>{
                //获取series公共样式获取
                let commonObj=Object.assign(echartJson.series[0],{name:item,data:[]});
                //多种图表的series公共样式获取
                 if(result.type && result.type.length>0){
                     let filter = echartJson.series.filter(serie=>serie.type == result.type[index]);
                     if(filter&&filter.length>0){
                         commonObj=Object.assign(filter[0],{name:item,data:[]});
                     }
                 }
                let seriesObj=JSON.parse(JSON.stringify(commonObj));
                //获取series的data数据集
                seriesObj.data=seriesData.map(item=>{
                    return item[index]
                });
                series[index]=seriesObj;
            });
            echartJson.series=series;
        }else{
            echartJson.series[0].data = seriesData;
        }
        return echartJson;
    }else if (charType === 'pie'){
        //饼图数据替换、自定义颜色替换
        let colorList=echartJson.series[0].data.map(item=>{return item.itemStyle;});
        console.log('colorList',colorList);
        echartJson.series[0].data = result.data;
        echartJson.series[0].data.forEach(item,index=>{
            item.itemStyle=colorList[index];
        });
        return echartJson;
    }else if(charType === 'scatter'){
        echartJson.series[0].data = result.data.map(item=>{return [item.name,item.value]});
        return obj;
    }
}

//数组对象去重
function mergeObject(array) {
    var arrayFilted = [];
    array.forEach(value=>{
        if ( arrayFilted.length == 0 ) {
            arrayFilted.push(value);
        }else{
            let flag = true;
            arrayFilted.forEach(valueIndex=>{
                if (valueIndex.name && valueIndex.name === value.name) {
                    valueIndex.value = valueIndex.value + value.value;
                    flag = false;
                }
            });
            if (flag){
                arrayFilted.push(value);
            }
        }
    });
    return arrayFilted;
}

 /**
  * 单条数据
  * @param strObj
  * @param dataList
  * @returns {*}
  */
 function dealOneData(strObj,dataList) {
     // 有一个数据集，并且数据集中只有一条记录，详情表单
     let resultArray = Object.values(dataList);
     let dbsArray = Object.keys(dataList)
     let  resultList = resultArray[0][0];
     let excelRows = strObj.rows;
     for(let rowKey in excelRows){
         let cells = excelRows[rowKey].cells;
         if(!cells) continue;
         for(let cellKey in cells){
             let cell = cells[cellKey];
             let text  = cell.text;
             if(reg.test(text)){
                 let dbs = text.match(reg)[1]
                 if(dbsArray.indexOf(dbs)>=0){
                     const cellText = resultList[text.match(reg)[2]] || "";
                     cell.text = ''+cellText;
                 }
             }
         }
     }
     return strObj;
 }

 function getRowData(height,startRowNum,dataCells,resultDataList){
    if(!resultDataList) return {};
    let rowData = {};

    //判断有无分组
    let dataCellsFlag = 0;
    let dataRightFlag = 0;
    for (let cellIndex in dataCells){
        if (dataCells[cellIndex].aggregate === "group"){
            dataCellsFlag++;
        }
        if (dataCells[cellIndex].direction === "right"){
            dataRightFlag++;
        }
    }
    //处理数据
    let newresultList = [];
    const groupObj=[];
    const mergesArr=[];
    let maxRowNum = startRowNum;
    let groupStartNum = maxRowNum;
    if (dataCellsFlag === 0 && dataCellsFlag === 0 && dataRightFlag === 0){
        //列表数据
        rowData = backSelectData(resultDataList,dataCells,maxRowNum,rowData,height, mergesArr)
    }else if (dataCellsFlag > 0 && dataRightFlag == 0){
        //分组数据 maxRowNum 行数
        newresultList = backGroupData(dataCellsFlag,dataCells,resultDataList,newresultList,groupObj)
        backSelectData(newresultList,dataCells,maxRowNum,rowData,height)
        //设置合并单元格
        let maxendRowNum = startRowNum + newresultList.length;
        for(let key in groupObj){
            if (maxRowNum >= maxendRowNum){
                maxRowNum = groupStartNum;
            }
            let cellIndex = groupObj[key].cellIndex;
            const count = groupObj[key].count;
            const cell = rowData[maxRowNum].cells[cellIndex];
            if (count>1){
                cell.merge = [count-1,0];
            }
            maxRowNum =  maxRowNum+1;

            //将合并的单元格merge添加到数组里
            if (count>1){
                let letter = String.fromCharCode(64 + parseInt(cellIndex+1));
                let endsite = count+maxRowNum-1;
                let mergelocat = letter+maxRowNum+':'+letter+endsite;
                mergesArr.push(mergelocat);
            }
            //将分组后的多余数据删除
            for (let m = 1; m < count; m++) {
                rowData[maxRowNum] && delete  rowData[maxRowNum].cells[cellIndex];
                maxRowNum++;
            }
        }
    }else if (dataRightFlag > 0){
        //分组数据 maxRowNum 列数
        newresultList = backGroupData(dataRightFlag,dataCells,resultDataList,newresultList,groupObj)
        backSelectRightData(newresultList,dataCells,maxRowNum,rowData,height);
        //设置合并单元格
        let maxendRowNum = startRowNum + newresultList.length;
        for(let key in groupObj){
            if (maxRowNum >= maxendRowNum){
                maxRowNum = groupStartNum;
            }
            let cellIndex = groupObj[key].cellIndex;
            const count = groupObj[key].count;
            const cell = rowData[cellIndex].cells[maxRowNum];
            if (count>1){
                cell.merge = [0,count-1];
            }
            maxRowNum =  maxRowNum+1;
            for (let m = 1; m < count; m++) {
                rowData[cellIndex] && delete  rowData[cellIndex].cells[maxRowNum];
                maxRowNum++;
            }
        }
    }
    //将分组的数据和合并的数组返回
    let arrmap = [];
    if (mergesArr.length > 0){
        arrmap["mergesArr"] = mergesArr;
    }
     arrmap["rowData"] = rowData;
    return arrmap;
 }

 //处理分组数据
function backGroupData(dataCellsFlag,dataCells,resultDataList,newresultList,groupObj){
    var listgroup = [];
    let isProcessed = true;
    let listgroupSize = 0;
    for (let cellIndex in dataCells){
        if(!dataCells[cellIndex].text) continue;
        if (dataCells[cellIndex].text.indexOf("group(") != -1 || dataCells[cellIndex].text.indexOf("groupRight(") != -1 ) {
            let cellMe = subStringStr(dataCells[cellIndex].text, "#{", "}").split(".")[1];
            let field = "";
            if (dataCells[cellIndex].text.indexOf("group(") != -1 ){
                field = subStringStr(cellMe, "group(", ")");
            }else if(dataCells[cellIndex].text.indexOf("groupRight(") != -1 ){
                field = subStringStr(cellMe, "groupRight(", ")");
            }
            //一个字段分组
            if (dataCellsFlag === 1){
                listgroup = arrayGroupBy(resultDataList,field);
                listGroupFe(listgroup,groupObj,field,cellIndex);
                for (let i = 0; i < listgroup.length; i++) {
                    newresultList.push.apply(newresultList,listgroup[i]);
                }
            }else if (dataCellsFlag > 1){
                //多个字段分组
                if(isProcessed){
                    //第一次分组
                    listgroup = arrayGroupBy(resultDataList,field);
                    listGroupFe(listgroup,groupObj,field,cellIndex);
                    listgroupSize = listgroup.length;
                }else {
                    //其余字段分组
                    var listgroupThree = [];
                    newresultList = [];
                    for (let i = 0; i < listgroupSize; i++) {
                        var listgroupTwo = [];
                        listgroupTwo = arrayGroupBy(listgroup[i],field);
                        listGroupFe(listgroupTwo,groupObj,field,cellIndex);
                        for (let j = 0; j < listgroupTwo.length; j++) {
                            listgroupThree.push(listgroupTwo[j]);
                        }
                    }
                    //将分组数据合并为集合
                    listgroup = listgroupThree;
                    listgroupSize = listgroup.length;
                    for (let i = 0; i < listgroupThree.length; i++) {
                        newresultList.push.apply(newresultList,listgroupThree[i]);
                    }
                }
            }
            isProcessed = false;
        }
    }
    return newresultList;
}

//将需要合并的个数和列位置记录
function listGroupFe(listgroup,groupObj,field,cellIndex){
    listgroup.forEach(listItem=>{
        const groupFieldObj = {};
        groupFieldObj.count = listItem.length;
        groupFieldObj.cellIndex = Number(cellIndex);
        groupObj.push(groupFieldObj);
    })
    return groupObj;
}

//将数据提取为rows中的格式
function backSelectData(resultDataList,dataCells,maxRowNum,rowData,height, mergesArr){
    for (let i = 0; i < resultDataList.length; i++) {
        let resultObj = resultDataList[i];
        let newCellObj={};
        for (let cellIndex in dataCells){
            let tempCell = {...dataCells[cellIndex]}
            if(tempCell.virtual){
                if(i>0){
                    delete tempCell['virtual']
                }
            }
            let text = tempCell.text;
            newCellObj[cellIndex] = tempCell
            if(reg.test(text)){
                if (text.match(reg)[2].indexOf("group(") != -1){
                    let field2 = subStringStr(text.match(reg)[2],"group(",")");
                    text = resultObj[field2] || "";
                    newCellObj[cellIndex].text = text;
                }else {
                    text = resultObj[text.match(reg)[2]] || "";
                    newCellObj[cellIndex].text = text;
                }
            }

            if(mergesArr){
                if(dataCells[cellIndex].merge){
                    let arr = dataCells[cellIndex].merge
                    if(arr && arr.length>0){
                        let charCode = parseInt(cellIndex)+ 64 + 1
                        let letter = String.fromCharCode(charCode);
                        let letter2 = String.fromCharCode(charCode+parseInt(arr[1]));
                        let mergeCode = letter+(maxRowNum+1)+':'+letter2+(maxRowNum+1)
                        mergesArr.push(mergeCode)
                    }
                }
            }

        }
        rowData[maxRowNum] = {};
        rowData[maxRowNum].height = height;
        rowData[maxRowNum].cells=newCellObj;
        maxRowNum++;
    }
    return rowData;
}

function backSelectRightData(resultDataList,dataCells,maxRowNum,rowData,height){
    for (let cellIndex in dataCells){
        var dataRight = [];
        rowData[cellIndex] = {};
        rowData[cellIndex].height = height;
        let startMaxRowNum = maxRowNum;
        for (let i = 0; i < resultDataList.length; i++) {
            let newCellObj={};
            newCellObj[startMaxRowNum] = {...dataCells[cellIndex]};
            let text = newCellObj[startMaxRowNum].text;
            let resultObj = resultDataList[i];
            if(reg.test(text)){
                if (text.match(reg)[2].indexOf("groupRight(") != -1){
                    let field2 = subStringStr(text.match(reg)[2],"groupRight(",")");
                    let textfield = resultObj[field2] || "";
                    newCellObj[startMaxRowNum].text = textfield;
                }else {
                    let textfield = resultObj[text.match(reg)[2]] || "";
                    newCellObj[startMaxRowNum].text = textfield;
                }
            }
            rowData[cellIndex].cells =  newCellObj;
            dataRight.push(rowData[cellIndex].cells);
            startMaxRowNum++;
        }
        for (let dataRightindex in dataRight){
            rowData[cellIndex].cells = { ...rowData[cellIndex].cells,...dataRight[dataRightindex]};
        }
    }
    return rowData;
}

//分组方法
const arrayGroupBy = (list, field) => {
    let sorted = groupBy(list, function (item) {
        return [item[field]];
    });
    return sorted;
};
const groupBy = (array, f) => {
    let groups = {};
    array.forEach(function (o) {
        var group = JSON.stringify(f(o));
        groups[group] = groups[group] || [];
        groups[group].push(o);
    });
    return Object.keys(groups).map(function (group) {
        return groups[group];
    });
};

//截取字符串方法
function subStringStr(str,strStart,strEnd){
    let strStartIndex = str.indexOf(strStart);
    let strEndIndex = str.indexOf(strEnd);
    if (strStartIndex < 0) {
        return "";
    }
    if (strEndIndex < 0) {
        return "";
    }
    let result = str.substring(strStartIndex, strEndIndex).substring(strStart.length);
    return result;
}

 /**
  * 没有数据情况
  * @param strObj
  */
 function dealNoData(strObj={}) {
     const rows = strObj.rows
     for(const rowIndex in rows){
         const cells = rows[rowIndex].cells
         for(const cellIndex in cells){
            const cell = cells[cellIndex]
             if(reg.test(cell.text)){
                 cell.text = ''
             }
         }
     }
     return strObj;
 }

 function getMaxIndexInRows(strObj){
     if(!strObj) return 0;
     return  Math.max(...Object.keys(strObj)
               .filter(item=>item!='len')
               .map(item=>Number(item)))
   }

   function getRowObj(strObj={},dataList={}){
        //多个数据源遍历
     let rowObj = {};
     //保留数据集行
     let strRows = JSON.parse(JSON.stringify(strObj.rows));
     let strRowObj = {};
     for(let rowIndex in strRows){
         if(Number(rowIndex)<0) continue;
         strRowObj = strRows[rowIndex];
         let cellObj = strRowObj.cells;
         if(!cellObj){
             continue;
         }
         let dbName='';
         for(let cellIndex in cellObj ){
             let cellText = cellObj[cellIndex].text || "";
             if(reg.test(cellText)){
                 //匹配数据集数据
                 let cellTextArr = cellText.match(reg);
                  dbName = cellTextArr[1];
                 let field = cellTextArr[2];
                 if(!rowObj[dbName]){
                     rowObj[dbName] = {};
                     rowObj[dbName].rowNums = [];
                     rowObj[dbName].cellNums = [];
                     rowObj[dbName].tableFields = [];
                     rowObj[dbName].height = strRowObj.height;
                     //记录数据集样式
                     rowObj[dbName].dataCells = strRows[rowIndex].cells;
                     //数据集上一行记录
                     const total = (dataList[dbName] && dataList[dbName].length) || 0;
                     if(total>1){
                         rowObj[dbName].prevRow=strRows[(rowIndex-1<0)?0:(rowIndex-1)];
                     }else{
                         rowObj[dbName].prevRow =strRows[rowIndex];
                     }
                     rowObj[dbName].dataSetNumber=Number(rowIndex);
                     rowObj[dbName].isPage = dataList[`${dbName}_isPage`]
                 }
                 rowObj[dbName].rowNums.push(parseInt(rowIndex));
                 rowObj[dbName].cellNums.push(parseInt(cellIndex));
                 rowObj[dbName].tableFields.push(field);
             }else{
                 if(rowObj[dbName]){
                     rowObj[dbName].rowNums.push(parseInt(rowIndex));
                     rowObj[dbName].cellNums.push(parseInt(cellIndex));
                     rowObj[dbName].tableFields.push("");
                 }
             }

         }
     };
     //数据集高度
       if(strObj.dataSetNumber){
           strObj.dataSetHeight = strObj.rows[strObj.dataSetNumber].height;
       }
    return rowObj;
   }
 /**
  * 多条数据
  * @param strObj:表格配置
  * @param dataList:数据集合
  * @returns {*}
  */
 function dealManySource(strObj={},dataList={}){
    let rowObj = getRowObj(strObj,dataList);
    if(Object.values(rowObj) && Object.values(rowObj).length>0){
         const dataSetNumberArr = Object.values(rowObj)
         .filter(item=>item['isPage']=='1')
         .map(item=>item.dataSetNumber);
         if(dataSetNumberArr && dataSetNumberArr.length>0){
             //保留数据集位置，打印全部时，第二页到最后只打印列表数据
             strObj.dataSetNumber = Math.min(...dataSetNumberArr);
         }
    }
     const rowNumObj = {};
     const initRowLen = Object.keys(strObj.rows).length;
     for(let key in rowObj){
       //遍历数据
       let tempObj = rowObj[key];
       if(!tempObj) continue;
       const dataCells = tempObj.dataCells;
       const currentCell = {};
       for (let cellIndex in dataCells){
           let cellObj = dataCells[cellIndex];
           const cellText = String(cellObj.text);
           if(!cellText) continue;
           if(cellText.startsWith('#{')){
               if(cellText.includes(key)){
                currentCell[cellIndex] = dataCells[cellIndex];
               }
           }else{
            currentCell[cellIndex] = dataCells[cellIndex];
           }
       }
       const rowNumSize = new Set(tempObj.rowNums).size;
       const cellNumSize = new Set(tempObj.cellNums).size;
       if(rowNumSize>1 && cellNumSize != 1){
          strObj.rows = {...strObj.rows,...dealOneData(strObj,{[key]:dataList[key]}).rows};
       }else{
         let currentDataRow = {};
         if (rowNumSize>1){
             //横向分组处理数据
             const currentCellNum = Math.min(...tempObj.cellNums);
             let strRows = JSON.parse(JSON.stringify(strObj.rows));
             const currentRow = {};
             for(let rowIndex in strRows) {
                 if (Number(rowIndex) < 0) continue;
                 let strrCells = strRows[rowIndex].cells;
                 for(let cellsIndex in strrCells) {
                     if (Number(cellsIndex) === currentCellNum){
                         currentRow[rowIndex] = strrCells[cellsIndex];
                     }
                 }
             }
             //currentCellNum 列数
             let arrmap = getRowData(tempObj.height,currentCellNum,currentRow,dataList[key]);
             currentDataRow = arrmap["rowData"];
             //处理设置单元格宽度除了第一行不起作用
             let strCol = JSON.parse(JSON.stringify(strObj.cols));
             let colSty = strCol[currentCellNum];
             for (let i = 0; i < dataList[key].length; i++) {
                 strCol[currentCellNum+i] = colSty
             }
             strObj.cols = strCol;
         }else {
             //获得当前行位置 currentRowNum 行数
             const currentRowNum = Math.min(...tempObj.rowNums);
             let arrmap = getRowData(tempObj.height,currentRowNum,currentCell,dataList[key]);
             currentDataRow = arrmap["rowData"];
             let  huamergesArr = arrmap["mergesArr"];
             strObj.merges.push.apply(strObj.merges,huamergesArr);
         }
       const newDataLen = Object.keys({...strObj.rows,...currentDataRow}).length;
         if(!currentDataRow || JSON.stringify(currentDataRow) == "{}"){
             continue;
         }
           let tempRepeatRange = getRepeatRange(currentDataRow)
           if(!strObj.repeatRange){
               strObj.repeatRange = []
           }
           strObj.repeatRange.push(tempRepeatRange)

       if(newDataLen<=initRowLen && cellNumSize != 1){
           //没有新数据生成
           strObj.rows = {...strObj.rows,...currentDataRow};
           rowObj = getRowObj(strObj,dataList);
       }else{
           let rightFlag = false;
           tempObj.tableFields.forEach(item=>{
               if (item.indexOf("groupRight") != -1){
                   rightFlag = true;
               }
           })
           if (cellNumSize === 1 && rightFlag){
               //横向分组提取数据
               for(let rowIndex in currentDataRow) {
                   for(let cellIndex in currentDataRow[rowIndex].cells) {
                       strObj.rows[rowIndex].cells[cellIndex] = currentDataRow[rowIndex].cells[cellIndex];
                   }
               }
               rowObj = getRowObj(strObj,dataList);
           }else {
               //数据有新增
               maxRowNum =  (
                   Object.keys({...strObj.rows,...currentDataRow})
                       .filter(item=>item!='len')
               ).length;
               //取出新数据的位置
               const dataKeys = Object.keys(currentDataRow);
               const dataStartIndex = Math.min(...dataKeys);
               const dataEndIndex =  Math.max(...dataKeys);
               let rowsKeys = Object.keys( strObj.rows);
               let rowInterval=0;
               for (let i =0 ; i <rowsKeys.length;i++ ){
                   if(rowsKeys[i+1]-rowsKeys[i]>1){
                       rowInterval = rowsKeys[i+1]-rowsKeys[i]-1
                       break;
                   };
               };
               //取出数据剩余的部分
               const rowDataOthers  = {};
               for(let rowIndex in strObj.rows){
                   if(rowIndex=='len' || Number(rowIndex)<=dataStartIndex) continue;
                   const hasText = Object.values(strObj.rows[rowIndex].cells).some(item=>item.text);
                   if(hasText){
                       rowDataOthers[rowIndex] = {...strObj.rows[rowIndex]};
                   }
               }
               //update-begin-author:taoyan date:20201016 for:全体数据平移
               let rowCycleTrans = new RowCycleTrans(strObj, dataStartIndex, dataEndIndex, tempObj['cellNums'], currentDataRow);
               rowCycleTrans.getTransRows();
               //update-end-author:taoyan date:20201016 for:全体数据平移
               let maxRowIndex = getMaxIndexInRows(strObj.rows)+1;
               //if(rowInterval>0) maxRowIndex+=rowInterval;   //最大行值加间隔行数 key - dataStartIndex
               let newOthers = {};
               for(let key in rowDataOthers){
                   newOthers[maxRowIndex++] ={...rowDataOthers[key]};
               }
              // strObj.rows = {...strObj.rows,...newOthers}
               rowObj = getRowObj(strObj,dataList);
           }

       }
       }
     }
     const minRowNum = Math.min(...Object.values(rowNumObj));
     strObj.styles.push({"border":{"bottom":["thin","#000"],
             "top":["thin","#000"],"left":["thin","#000"],"right":["thin","#000"]}});
     const borderStyleLen = strObj.styles.length-1;
     for(let key in strObj.rows){
         if(key<minRowNum) continue;
         const cells = strObj.rows[key].cells;
         if(!cells) continue;
         Object.values(cells).forEach(cell=>{
             if(!cell.style){
                 cell.style=borderStyleLen
             }
         })
     }
     return strObj;
 }

 /**
  * 获取url参数
  */
 function getRequestUrl() {
     var url = location.search;
     var theRequest = new Object();
     if (url.indexOf("?") != -1) {
         var str = url.substr(1);
         strs = str.split("&");
         for(var i = 0; i < strs.length; i++) {
             theRequest[strs[i].split("=")[0]]=decodeURI(strs[i].split("=")[1]);
         }
     }
     return theRequest;
 }

 function getPageResult(pageNo,pageSize=10){
     const requestParam = getRequestUrl();
     requestParam.pageNo = pageNo;
     requestParam.pageSize = pageSize;
    // requestParam['onlyPageData'] = '1'
     jQuery.excelView(view.excelConfigId,requestParam,function (res) {
         if(res.success){
             var str = res.result.jsonStr;
             if(!str){
                return;
             }
             const dealDataList  = view.dealDataList(res.result.dataList);
             const dataList = dealDataList.dataList;
             //获取分页参数
             const pageObj = dealDataList.pageObj;
             if(Object.keys(pageObj).length===1){
                 xs.data.settings.page = pageNo;
                 xs.data.settings.total = pageObj[Object.keys(pageObj)[0]];
                 if(xs.data.settings.total==1){
                     //下一页和最后一页禁用
                     xs.sheet.rpbar.btn_next.btn.el.disabled=true;
                     xs.sheet.rpbar.btn_end.btn.el.disabled=true;
                 }
             }
             xs.sheet.rpbar.btn_input.countSpan.el.innerHTML=xs.data.settings.total;
             view.viewReport(str,view.getExcelData(dataList),'rpchange');
         }
     })
 }

/**
 * 改变滚动条位置
 */
function changeScrollBottom() {
   // console.log('changeScrollBottom')
    let overlayer = document.getElementsByClassName('x-spreadsheet-overlayer');
    if(overlayer){
        var height = overlayer[0].style.height;
        var heinum = Number(height.split('px')[0]) - 40;
        document.getElementsByClassName('x-spreadsheet-scrollbar vertical')[0].style.bottom = 'calc(100% - '+heinum+'px)';
    }
}

/**
 * 获取请求地址中的参数
 */
function getRequestUrlParam() {
    var url = window.location.href;
    var index = url.indexOf("?");
    var param = {};
    if(index>0){
        var strs = url.substring(index+1);
        var array = strs.split("&");
        for(let a of array){
            var temp = a.split('=');
            param[temp[0]] = decodeURIComponent(temp[1])
        }
    }
    return param;
}

/**
 * 判断数据库的报表参数是否匹配请求地址参数
 */
function dbParamMatchUrlParam(dbList, urlParam) {
    let res = false;
    let array = Object.keys(urlParam);
    if(!array){
        return res;
    }
    for(let item of dbList){
        if(array.indexOf(item.paramName)>=0){
            res = true;
        }
    }
    return res;
}

/**
 * 字典数据处理
 * @param json
 */
function dictDataHandler(json) {
    if(json){
        let rows = json.rows;
        let dictInfo = view.dictInfo
        if(rows){
            //遍历行
            Object.keys(rows).map(rowIndex=>{
                let row = rows[rowIndex].cells;
                if(row){
                    //遍历列
                    Object.keys(row).map(colIndex=>{
                        //获取单元格
                        let cell = row[colIndex]
                        if(cell.isDict===1){
                            let tempText = cell.text;
                            let tempDictList = dictInfo[cell.dictCode];
                            console.log('tempText',tempDictList)
                            cell.text = getDictTextByValue(tempDictList, tempText)
                        }
                    })
                }
            })
        }
    }
}

/**
 * 获取字典 文本
 * @param ls
 * @param Value
 * @returns {string|*}
 */
function getDictTextByValue(ls, value) {
    if(!ls||ls.length==0){
        return value;
    }
    let text = ''
    for(let item of ls){
        if(item.value == value){
            text = item.text;
            break;
        }
    }
    return text;
}

/**
 * 获取数据 所在范围
 * @param rows
 * @returns {{sci: string, eci: string, sri: string, eri: string}}
 */
function getRepeatRange(rows){
    //currentDataRow
    let sri,sci,eri,eci;
    let rowsIndex = Object.keys(rows)
    sri = rowsIndex[0]
    let beginCells = rows[sri].cells
    let beginColArr = Object.keys(beginCells)
    sci = beginColArr[0]

    eri = rowsIndex[rowsIndex.length-1]
    let endCells = rows[eri].cells
    let endColArr = Object.keys(endCells)
    eci = endColArr[endColArr.length-1]
    return {sri:Number(sri), sci:Number(sci), eri:Number(eri), eci:Number(eci)}
}