$.ajaxSetup({
    contentType:"application/x-www-form-urlencoded;charset=utf-8",
    complete:function(XMLHttpRequest,textStatus){
        //通过XMLHttpRequest取得响应结果
        var res = XMLHttpRequest.responseText;
        try{
            var jsonData = JSON.parse(res);
            if(jsonData.code===403 || jsonData.code===500) {
                const message = jsonData.message;
                if (message) {
                    let confirMessage = '';
                    if (message.includes('Token失效')
                        || message.includes('token不能为空')
                        || message.includes('token非法')
                    ) {
                        confirMessage = '操作失败，Token失效，请重新登录!';
                    }
                    if (confirMessage) {
                        Vue.prototype.$Modal.warning({
                            title: '登录已过期',
                            content: '很抱歉,登录已过期,请重新登录',
                            onOk: () => {
                                //window.open(window._CONFIG['domianURL'],'_self');
                                window.opener=null;
                                window.open('','_self');
                                window.close();
                            }
                        });
                    }
                }
            }
        }catch(e){
            window.open(LOGIN_URL);
        }
    }
});