const reg = /^[\u4e00-\u9fa5_a-zA-Z0-9]+$/;
const validateDbCode= (rule, value, callback) => {
    if (value === '') {
        callback(new Error('编码不能为空'));
    } else {
        if(!reg.test(value)){
        callback(new Error('编码只能包含中英文、数字和下划线'));
        }
        callback();
    }
};
vm = new Vue({
        el: "#app",
        created(){
           this.createLoading = true
            this.offsetInfo = '0,0'
        },
        mounted() {
            // this.tableHeight = window.innerHeight - this.$refs.dynamicTable.$el.offsetTop - 200;
            // this.paramTableHeight = window.innerHeight - this.$refs.paramTable.$el.offsetTop - 200;
          // this.$refs.dynamicTable.$el.style.cssText= "padding-bottom: 10%;";
            this.token = window.localStorage.getItem('JmReport-Access-Token');
            console.log("index_design--------------",this.token);
            this.initFieldTree();
            //多数据源
            this.initDataSource();
            //图表选择弹框样式添加
            addChartModalSelectedStyle();
        },
        data: function () {
            let _this = this;
            return {
                createLoading: false,
                treeObj:{},//数据集code和名称
                dataXs:"",
                menuitem : "printinfo",
                menuList:[{value: 'printinfo',label: '打印设计'},{value: 'datainfo',label: '数据报表'}, {value: 'chartinfo', label: '图形报表'},],
                polyWayList:[{value: 'select',label: '列表'},{value: 'group',label: '分组'}],
                directionList:[{value: 'down',label: '纵向'},{value: 'right',label: '横向'}],
                dataSourceTypeList:[{value: '1',label: 'MySQL'},{value: '2',label: 'Oracle'},{value: '3',label: 'SQLServer'}],
                designerObj:{
                    id:"",
                    name:"",
                    type:"printinfo"
                },
                visible: false,
                token:"",
                apiModal:false,
                deleteParamModel:false,
                deleteFieldModel:false,
                dataShow:true, //数据显示/隐藏
                propsContentShow:true, //属性显示/隐藏
                tabValue:"1", //
                treeSpanNum:3,
                tableSpanNum:21,
                propsSpanNum:3,
                excel:{
                    excelValue:"",
                    type:"text",
                    coordinate:"",  //坐标
                    ri:0,
                    ci:0,
                    polyWay:"",
                    direction:"",
                    isDict: 0,
                    dictCode:''
                },
                offsetInfo: '0,0',
                loading:true,
                tableHeight: 0,
                paramTableHeight: 0,
                moduleTitle: "",
                //addIsPage: false,
                tab1: {
                    selectParamTables:[],
                    data: [],
                    columns: [
                        {
                            type: 'selection',
                            width: 35,
                            align: 'center'
                        },
                        {
                            type: 'index',
                            width: 60,
                            align: 'center'
                        },
                        {
                            title: '字段名',
                            key: 'fieldName',
                            /*width: '220',*/
                            render: (h, params) => {
                                return this.renderInput(h, params, 'fieldName','tab1')
                            }
                        },
                        {
                            title: '排序',
                            key: 'orderNum',
                            /*width: '80',*/
                            render: (h, params) => {
                                return this.renderInput(h, params, 'orderNum','tab1')
                            }
                        },
                        {
                            title: '字段文本',
                            /*width: '220',*/
                            key: 'fieldText',
                            render: (h, params) => {
                                return this.renderInput(h, params, 'fieldText','tab1')
                            }
                        },
                        {
                            title: '类型',
                            /*width: '140',*/
                            key: 'widgetType',
                            render: (h, params) => {
                                let options = [ // 下拉选项
                                    {title: '数值类型', value: 'Integer'},
                                    {title: '字符类型', value: 'String'},
                                    {title: '日期类型', value: 'Date'},
                                    {title: '时间类型', value: 'Datetime'},
                                    {title: '长整型', value: 'Long'}
                                ];

                                return h('i-select', {
                                        props: {
                                            size:'small',
                                            value: this.tab1.data[params.index].widgetType,
                                        },
                                        on: {
                                            'on-change': (value) => {
                                                _this.tab1.data[params.index].widgetType = value;
                                            }
                                        },
                                    },
                                    options.map(item => {
                                        return h('i-option', {
                                            props: {
                                                value: item.value
                                            }
                                        }, item.title)
                                    })
                                );
                            }
                        },
                        /*{
                            title: '是否显示',
                            width: '100',
                            key: 'isShow',
                            render:(h, params)=> {
                                return h('Checkbox',{
                                    props: {
                                        size:'small',
                                        value: this.tab1.data[params.index].isShow,
                                    },
                                    on: {
                                        'on-change': (value) => {
                                            _this.tab1.data[params.index].isShow = value;
                                        }
                                    }
                                });
                            }
                        },
                        {
                            title: '字段href',
                            width: '220',
                            key: 'fieldHref',
                            render: (h, params) => {
                                return this.renderInput(h, params, 'fieldHref','tab1')
                            }
                        },
                        {
                            title: '查询模式',
                            width: '140',
                            key: 'searchMode',
                            render: (h, params) => {
                                let options = [ // 下拉选项
                                    {title: '单条件查询', value: 'single'},
                                    {title: '范围查询', value: 'group'}
                                ];

                                return h('i-select', {
                                        props: {
                                            size:'small',
                                            value: '',
                                        },
                                        on: {
                                            'on-change': (value) => {
                                                _this.tab1.data[params.index].fieldType = value;
                                            }
                                        },
                                    },
                                    options.map(item => {
                                        return h('i-option', {
                                            props: {
                                                value: item.value
                                            }
                                        }, item.title)
                                    })
                                );
                            }
                        },
                        {
                            title: '取值表达式',
                            width: '220',
                            key: 'replaceVal',
                            render: (h, params) => {
                                return this.renderInput(h, params, 'replaceVal','tab1')
                            }
                        },
                        {
                            title: '字典code',
                            width: '220',
                            key: 'dictCode',
                            render: (h, params) => {
                                return this.renderInput(h, params, 'dictCode','tab1')
                            }
                        },
                        {
                            title: '是否查询',
                            width: '100',
                            key: 'isSearch',
                            render:(h, params)=> {
                                return h('Checkbox',{
                                    props: {
                                        size:'small',
                                        value: this.tab1.data[params.index].isSearch,
                                    },
                                    on: {
                                        'on-change': (value) => {
                                            _this.tab1.data[params.index].isSearch = value;
                                        }
                                    }
                                });
                            }
                        },*/

                    ]
                },
                tab2:{
                    selectParamTables:[],
                    data: [],
                    columns: [
                        {
                            type: 'selection',
                            width: 35,
                            align: 'center'
                        },
                        {
                            type: 'index',
                            width: 60,
                            align: 'center'
                        },
                        {
                            title: '参数',
                            key: 'paramName',
                            width: '300',
                            render: (h, params) => {
                                return this.renderInput(h, params, 'paramName','tab2')
                            }
                        },
                        {
                            title: '参数文本',
                            key: 'paramTxt',
                            width: '300',
                            render: (h, params) => {
                                return this.renderInput(h, params, 'paramTxt','tab2')
                            }
                        },
                        {
                            title: '默认值',
                            key: 'paramValue',
                            width: '300',
                            render: (h, params) => {
                                return this.renderInput(h, params, 'paramValue','tab2')
                            }
                        },
                        {
                            title: '排序',
                            key: 'orderNum',
                            width: '300',
                            render: (h, params) => {
                                return this.renderInput(h, params, 'orderNum','tab2')
                            }
                        },
                    ]
                },
                sqlForm: {
                    dbCode: "",
                    dbChName: "",
                    dbDynSql: "",
                    dbType: "",
                    apiUrl: "",
                    apiMethod: "0",
                    isPage:false,
                    dbSource:""
                },
                sqlModal: false,
                treeData:null,
                sqlFormValidate:{
                    dbCode:[
                        { validator: validateDbCode, trigger: 'blur' }
                    ],
                    dbChName:[
                        { required: true, message: '名称不能为空', trigger: 'blur' }
                    ],
                    dbDynSql:[
                        { required: true, message: '报表SQL不能为空', trigger: 'blur' }
                    ],
                    apiUrl:[
                        { required: true, message: '请求地址不能为空', trigger: 'blur' }
                    ]
                },
                sourceModal: false,
                sourceTab:{
                    //selectParamTables:[],
                    data: [],
                    columns: [
                        {
                            type: 'index',
                            width: 60,
                            align: 'center'
                        },
                        {
                            title: '数据源名称',
                            key: 'name'
                        },
                        {
                            title: '数据库类型',
                            key: 'dbType',
                            render: (h, params) => {
                                switch (params.row.dbType) {
                                    case "1":
                                        return h('span', 'MySQL');
                                        break;
                                    case "2":
                                        return h('span', 'Oracle');
                                        break;
                                    case "3":
                                        return h('span', 'SQLServer');
                                        break;
                                }
                            }
                        },
                        {
                            title: '用户名',
                            key: 'dbUsername'
                        },
                        {
                            title: '操作',
                            key: 'action',
                            width: 150,
                            align: 'center',
                            render: (h, params) => {
                                return this.renderButton(h, params);
                            }
                        }
                    ]
                },
                visibleData: false,
                dataSource: {
                    id: "",
                    code: "",
                    reportId:"",
                    name: "",
                    dbType: "",
                    dbDriver: "",
                    dbUrl: "",
                    dbUsername:"",
                    dbPassword:""
                },
                dataFormValidate:{
                    name:[
                        { required: true, message: '数据源名称不能为空', trigger: 'blur' }
                    ],
                    dbType:[
                        { required: true, message: '数据源类型不能为空', trigger: 'blur' }
                    ],
                    dbDriver:[
                        { required: true, message: '驱动类不能为空', trigger: 'blur' }
                    ],
                    dbUrl:[
                        { required: true, message: '数据源地址不能为空', trigger: 'blur' }
                    ],
                    dbUsername:[
                        { required: true, message: '用户名不能为空', trigger: 'blur' }
                    ],
                    dbPassword:[
                        { required: true, message: '密码不能为空', trigger: 'blur' }
                    ],
                },
                echartInfo:{
                    id: '',
                    //标题
                    titleShow: true,
                    titleText: '',
                    titleFontSize: 20,
                    titleFontWeight: 'bolder',
                    titleColor: '#c43632',
                    titleLocation: 'left',
                    //柱体
                    barWidth: 0,
                    barRadius: 0,
                    barMinHeight: 0,
                    //折线
                    step: false, //阶梯线图
                    showSymbol: true,//标记点
                    smooth: false,//平滑曲线
                    symbolSize: 8,// 设置折线上圆点大小
                    linewidth: 5,// 设置线宽
                    //饼图
                    pieLabelPosition:'outside', //标签位置
                    minAngle:0,  //最小角度
                    notCount:false,  //不展示零
                    autoSort:false,  //自动排序
                    roseType:false,  //南丁格尔玫瑰
                    isRadius:false,  //是否环形
                    pieRadius:'40%,50%',//半径大小
                    //地图
                    scale :0,
                    numerTextHighCol:'',
                    borderWidth:0,
                    areaCol:'',
                    areaHighCol:'',
                    borderCol:'',
                    //X轴样式
                    xaxisShow: true,
                    xaxisText: "",
                    xaxisLine: true,
                    xaxisLinecol: '#c43632',
                    xaxisTextsize: 0,
                    axisLabelRotate:0,
                    //Y轴样式
                    yaxisShow: true,
                    yaxisText: "",
                    yaxisLine: true,
                    yaxisLinecol: '#c43632',
                    yaxisTextsize: 0,
                    //数值设置
                    numerShow: true,
                    numerTextSize: 0,
                    numerTextcol: '#c43632',
                    numerTextweig: "",
                    //提示框
                    tooltipShow: true,
                    tooltipTextSize: 0,
                    tooltipTextcol: '#c43632',
                    //图例
                    legendShow: true,
                    //legendItemWidth: 0,
                    legendTop: "top",
                    legendLeft: "left",
                    legendOrient: "horizontal",
                    legendTextcol: '#c43632',
                    legendTextsize: 0,
                    //图例数据
                    legendData:[],
                    //轴边距
                    gridLeft: 0,
                    gridTop: 0,
                    gridRight: 0,
                    gridBottom: 0,
                    //xy轴字体颜色/轴线颜色
                    axisLabelTextCol: '#c43632',
                    axisLineLineCol: '#c43632',
                    seriesItemNorCol: '#c43632',
                    seriesLinemNorCol: '#c43632',
                    //自定义颜色样式
                    colorMatchData:[]
                },
                dataAllocation:{
                    dataType: 'sqlechData',
                    status: 'staticData',
                    optionData:'{}',
                    selectOptionData: {},
                    apiListOpt:[],
                    sqlListOpt:[],
                    sqlListField:[],
                    sqlxAxis:'',
                    sqlseries:'',
                    sqlgroup:'',//系列属性
                    sqltype:'',//系列类型
                    selectId:'',
                    seriesTypeData:[]//系列类型数据
                },
                addEchart:false,
                chartModule:false,
                chartsType:'',
                selectedChartType :"",//图表选择类型
                colorMatchModal:false,
                colorMatch:{
                   color1:""
                },
                columns2: [
                {
                    title: '颜色',
                    key: 'color1',
                    align:'center',
                    width :80,
                    render: (h, params) => {
                        return this.renderColorButton(h, params,'color1',1);
                    }
                },
                {
                    title: '操作',
                    key: 'action',
                    align:'center',
                    width :110,
                    render: (h, params) => {
                       return this.renderColorButton(h, params,'action',1);
                    }
                }
                ],
                chartsflag:false,
                isMultiChart:false,//是否多组
                rightTabName:'name1',
                chartsTypeArr:[],
                specialChartType:"",
                seriesModal:false,
                seriesObj : {},
                seriesColumns: [
                    {
                        title: '系列',
                        key: 'name',
                        align:'center',
                        width :80
                    },
                    {
                        title: '类型',
                        key: 'type',
                        align:'center',
                        width :80
                    },
                    {
                        title: '操作',
                        key: 'action',
                        align:'center',
                        width :110,
                        render: (h, params) => {
                            return this.renderColorButton(h, params,'action',2);
                        }
                    }
                ],
            }
        },
        computed: {
            menuitemClasses: function () {
                return [
                    'menu-item',
                    this.isCollapsed ? 'collapsed-menu' : ''
                ]
            },
            centerDivClass: function () {
                let str = 'jm-rp-designer'
                if(!this.dataShow && !this.propsContentShow){
                    str+=' all'
                }else if(!this.dataShow){
                    str+=' left'
                }else if(!this.propsContentShow){
                    str+=' right'
                }
                return str;
            }
        },
        methods: {

            addColorMatch(){
                let obj={...this.colorMatch};
                if(obj.color1){
                    obj._index>=0?this.echartInfo.colorMatchData.splice(obj._index,1,obj):this.echartInfo.colorMatchData.push(obj);
                    //运行到图表
                    this.echDataRun();
                }
                this.colorMatchModal=false;
                this.colorMatch={color1:''};
            },
            addSeriesType(){
                let obj={...this.seriesObj};
                obj._index>=0?this.dataAllocation.seriesTypeData.splice(obj._index,1,obj):this.dataAllocation.seriesTypeData.push(obj);
                this.chartsTypeArr=this.uniqueArr(this.chartsTypeArr.concat(this.dataAllocation.seriesTypeData.map(item=>{return item.type})));
                this.seriesObj={name:'',type:''};
                this.seriesModal=false;
            },
            addSelectStyle(item){
                if(item.allowed){
                    this.selectedChartType=item.type;
                }
            },
            tabClick(name) {
                console.log(this.$refs.dynamicTable.$el.offsetHeight);
                console.log(this.$refs.paramTable.$el.offsetHeight);
                console.log("====tabClick",name);
            },
            selectParamAll(){
                this.tab2.selectParamTables = this.tab2.data.map(item=>
                    {
                       return {"tableIndex":item.tableIndex,"id":item.id}
                    });
            },
            cancelParamAll(){
               this.tab2.selectParamTables = [];
            },
            selectParam(selection,row){
                this.tab2.selectParamTables=[...this.tab2.selectParamTables,{"tableIndex":row.tableIndex,"id":row.id}];
            },
            cancelParam(selection,row){
                this.tab2.selectParamTables = this.tab2.selectParamTables.filter(item=>item.tableIndex!=row.tableIndex);
            },
            selectFieldAll(){
                this.tab1.selectParamTables = this.tab1.data.map(item=>
                {
                    return {"tableIndex":item.tableIndex,"id":item.id}
                });
            },
            cancelFieldAll(){
                this.tab1.selectParamTables = [];
            },
            selectField(selection,row){
                this.tab1.selectParamTables=[...this.tab1.selectParamTables,{"tableIndex":row.tableIndex,"id":row.id}];
            },
            cancelField(selection,row){
                this.tab1.selectParamTables = this.tab1.selectParamTables.filter(item=>item.tableIndex!=row.tableIndex);
            },
            dbDynSqlBlur(){
                //获得原数据Map
                let dataMap={}
                if(this.tab2.data && this.tab2.data.length>0){
                    this.tab2.data.forEach(item=>{
                        dataMap[item.paramName] = item;
                    })
                }

                let reg=/\${(\S+)\}/g;
                let dbDynSql = this.sqlForm.dbDynSql;
                if(!reg.test(dbDynSql)){
                    return;
                }

                let dbDynSqlArr = dbDynSql.match(reg);
                let paramsArr = [];
                if(dbDynSqlArr && dbDynSqlArr.length>0){
                    let maxOrderNum = 1;
                    dbDynSqlArr.forEach((item,index)=>{
                        item = item.replace("${","").replace("}","").trim();
                        let paramObj = {};
                        paramObj.paramName = item;
                        paramObj.paramTxt = item;
                        paramObj.orderNum = maxOrderNum++;
                        paramObj.tableIndex = paramObj.orderNum;
                        const oldItem =  dataMap[item];
                        paramObj.id = (oldItem && oldItem.id) || "";
                        paramObj.paramValue = (oldItem && oldItem.paramValue) || "";
                        paramsArr.push(paramObj);
                    })
                }
                this.tab2.data = [...paramsArr];
            },
            toggleLeft(){
                let $i = $($("#treeDiv").find("i")[0]);
                let l1=12.5,l2=12.5;
                let $dataDiv = $("#dataDiv");
                if($i.hasClass("ivu-icon-ios-arrow-back")){
                    //收缩
                    this.dataShow = false
                    //this.treeSpanNum = 1;
                    l1 = 1.5;//收缩后的百分比
                    $i.removeClass("ivu-icon-ios-arrow-back");
                    $i.addClass('ivu-icon-ios-arrow-forward');
                    $dataDiv.slideUp();
                }else{
                    this.dataShow = true
                    //this.treeSpanNum = 3;
                    l1 = 12.5;//展开后的百分比
                    $i.addClass("ivu-icon-ios-arrow-back");
                    $i.removeClass('ivu-icon-ios-arrow-forward');
                    $dataDiv.slideDown();
                }
                if (this.propsContentShow){//判断右边是否展开
                    l2 = 12.5
                } else {
                    l2= 1.5
                }
                let treeDiv = document.getElementById("treeDiv").parentNode;//获取父节点
                treeDiv.style.cssText= "display: block;width: "+ l1 +"%;";//给父节点设置属性
            },
            toggleRight(){
              //propsDivd
                let $i = $($("#propsDiv").find("i")[0]);
                let l1=12.5,l2=12.5;
                let $propsContentDiv = $("#propsContentDiv");
                if($i.hasClass("ivu-icon-ios-arrow-back")){
                    this.propsContentShow = true
                    //this.propsSpanNum = 3;
                    l2=12.5;
                    $i.removeClass("ivu-icon-ios-arrow-back");
                    $i.addClass('ivu-icon-ios-arrow-forward');
                    $propsContentDiv.slideDown();
                }else{
                    //收缩
                    this.propsContentShow = false
                    //this.propsSpanNum = 1;
                    l2 = 1.5;
                    $i.addClass("ivu-icon-ios-arrow-back");
                    $i.removeClass('ivu-icon-ios-arrow-forward');
                    $propsContentDiv.slideUp();
                }
                if (this.dataShow){
                    l1 = 12.5
                } else {
                    l1= 1.5
                }
                //let treeDiv = document.getElementById("propsDiv").parentNode;
                //treeDiv.style.cssText= "display: block;width: "+ l2 +"%;";

               // let l3 = 100 - (l1+ l2);//算出中间table的百分比
                //let treeDiv = document.getElementById("tableDiv").parentNode;
                //treeDiv.style.cssText= "display: block;width: "+ l3 +"%;";
            },
            addParamTable(){
                let indexArr = this.tab2.data.map(item=>item.tableIndex);
                let orderNumArr = this.tab2.data.map(item=>item.orderNum);
                if(indexArr.length==0){
                    indexArr=[0];
                }
                if(orderNumArr.length==0){
                    orderNumArr=[0];
                }
                this.tab2.selectParamTables = [];
                this.tab2.data=[...this.tab2.data,{
                    'paramName':"",
                    'paramTxt':"",
                    'paramValue':"",
                    'orderNum':Math.max(...orderNumArr)+1,
                    'tableIndex':Math.max(...indexArr)+1
                }];
            },
            removeParamTable(){
                this.deleteParamModel = true;
            },
            removeFieldTable(){
                this.deleteFieldModel = true;
            },
            deleteParamTable(){
                let tableIndexArr = this.tab2.selectParamTables.map(item=>item.tableIndex);
                this.tab2.data = this.tab2.data.filter(item=>!tableIndexArr.includes(item.tableIndex));
                let selectTableObj = this.tab2.selectParamTables.filter(item=>item.id);
                let selectIds = selectTableObj.map(item=>item.id);
                this.tab2.selectParamTables = [];
                let dbDynSql  = this.sqlForm.dbDynSql;
                dbDynSql = dbDynSql.substring(0,dbDynSql.indexOf("where"));
                let paramArr = []
                if(this.tab2.data.length>0){
                    dbDynSql = dbDynSql+" where ";
                    this.tab2.data.forEach(item=>{
                        const paramName = `${item.paramName}`;
                        paramArr.push(`${paramName}='`+"${"+paramName+"}'")
                    })
                }
                dbDynSql = dbDynSql+paramArr.join(" and ");
                this.sqlForm.dbDynSql=dbDynSql.trim();
                const deleParams={selectIds,id:this.sqlForm.id,dbDynSql}
                //后台删除,保存时删除
                if(selectIds.length>0){
                    $.ajax({
                        url:`${base}/design/report/deleteParamByIds`,
                        type:"delete",
                        contentType:"application/json",
                        headers:{"X-Access-Token":this.token},
                        data:JSON.stringify(deleParams),
                        success:(result)=>{
                        }
                    });
                }
            },
            deleteFieldTable(){
                let tableIndexArr = this.tab1.selectParamTables.map(item=>item.tableIndex);
                this.tab1.data = this.tab1.data.filter(item=>!tableIndexArr.includes(item.tableIndex));
                let selectTableObj = this.tab1.selectParamTables.filter(item=>item.id);
                let selectIds = selectTableObj.map(item=>item.id);
                this.tab1.selectParamTables = [];
                const deleParams={selectIds}
                if(selectIds.length>0){
                    $.ajax({
                        url:`${base}/design/report/deleteFieldByIds`,
                        type:"delete",
                        contentType:"application/json",
                        headers:{"X-Access-Token":this.token},
                        data:JSON.stringify(deleParams),
                        success:(result)=>{
                        }
                    });
                }
            },
            submitValue(e){
               let value = e.target.value;
               setExcelData({ri:this.excel.ri,ci:this.excel.ci},value);
            },
            initFieldTree(){
                console.log("index_initFieldTree--------------",token);
                if (excel_config_id != null && excel_config_id != ""){
                    var url = `${base}/design/report/field/tree/${excel_config_id}?token=${token}`;
                    $.get(url,(result)=>{
                        console.log("initTree======");
                        const treeObj = {};
                        let treeResult = result.result;
                        this.dataAllocation.apiListOpt = [];
                        this.dataAllocation.sqlListOpt = [];
                        result.result.forEach(item=>{
                            if (item[0].type === "0"){
                                this.dataAllocation.sqlListOpt.push(item[0]);
                            }else {
                                this.dataAllocation.apiListOpt.push(item[0]);
                            }
                        })
                        if(treeResult && treeResult.length>0){
                            treeResult.forEach(item=>{
                                treeObj[item[0].title] = item[0].code;
                                item[0].render=(h, { root, node, data })=>{
                                    console.log("render=====");
                                    return h('span', {
                                        style: {
                                            display: 'inline-block',
                                            width: '100%'
                                        }
                                    }, [
                                        h('span', [
                                            h('span',{style:{display: 'inline-block', width: '90px',overflow: 'hidden',textOverflow: 'ellipsis',whiteSpace: 'nowrap'}}, data.title)
                                        ]),
                                        h('span', {
                                            style: {
                                                display: 'inline-block',
                                                float: 'right',
                                                marginLeft: '10px'
                                            }
                                        }, [
                                            h('i-button', {
                                                props: Object.assign({}, {
                                                    type: 'default',
                                                    size: 'small',
                                                }, {
                                                    icon: 'ios-create-outline',
                                                }),
                                                on: {
                                                    "click": () => {
                                                        this.tabValue="1";
                                                        $.get(`${base}/design/report/loadDbData/${data.dbId}?token=${token}`, (result)=> {
                                                            console.log('result=====',result);
                                                            let reportResult = result.result;
                                                            if(!reportResult){
                                                                return;
                                                            }
                                                            //设置数据
                                                            this.sqlForm = reportResult.reportDb;
                                                            var bol = reportResult.reportDb.isPage;
                                                            this.tab1.data=reportResult.fieldList;
                                                            if(this.tab1.data){
                                                                this.tab1.data.forEach((item,index)=>{
                                                                    item.tableIndex = index+1;
                                                                })
                                                            }
                                                            this.tab2.data=reportResult.paramList;
                                                            if(this.tab2.data){
                                                                this.tab2.data.forEach((item,index)=>{
                                                                    item.tableIndex = index+1;
                                                                })
                                                            }
                                                            if (this.sqlForm.dbType === "0"){
                                                                this.moduleTitle = "SQL数据集";
                                                            } else {
                                                                this.moduleTitle = "Api数据集";
                                                            }
                                                            if (bol=='1'){
                                                                this.sqlForm.isPage = true;
                                                                //this.addIsPage = false;
                                                            }else {
                                                                this.sqlForm.isPage = false;
                                                            }
                                                            this.sqlModal = true;
                                                        });

                                                    }
                                                }
                                            }),
                                            h('i-button', {
                                                props: Object.assign({}, {
                                                    type: 'default',
                                                    size: 'small',
                                                }, {
                                                    icon: 'ios-close',
                                                }),
                                                on: {
                                                    "click": () => {
                                                        this.$Modal.confirm({
                                                            content: '<i class="ivu-icon ivu-icon-ios-alert" style="color: #f90;font-size: 20px;margin-right: 5px;"></i>是否确认删除?',
                                                            onOk: () => {
                                                                $.get(`${base}/design/report/delDbData/${data.dbId}?token=${token}`, (result)=> {
                                                                    console.log('result=====',result);
                                                                    if (result.success){
                                                                        this.$Notice.success({
                                                                            title: '删除成功'
                                                                        });
                                                                        this.initFieldTree();
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    }
                                                }
                                            })
                                        ])
                                    ]);
                                }
                                //渲染子数据
                                item[0].children.forEach(item=>{
                                    item.render=(h, { root, node, data })=>{
                                        return h('Tooltip', {props: {content: data.fieldText }},[ h('span', data.title)])
                                    }
                                });
                            })
                        }
                        this.treeData = treeResult;
                        this.treeObj = treeObj;
                    });
                    this.getReport();
                }
            },
            getReport(){
                $.get(`${base}/design/report/get/${excel_config_id}?token=${token}`,(result)=>{
                    if (result.result != "" && result.result != null){
                        this.designerObj = result.result;
                    }
                });
            },
            checkChange(ispage){
                if (ispage){
                    $.get(`${base}/design/report/queryIsPage/${excel_config_id}?token=${token}`,(result)=>{
                        if (result.result != "" && result.result != null){
                            if (result.result){
                                this.$Modal.confirm({
                                    content: '已有数据集分页,是否更改?',
                                    onOk: () => {
                                        this.sqlForm.isPage = true;
                                    },
                                    onCancel: ()=> {
                                        this.sqlForm.isPage = false;
                                    }
                                });
                            }
                        }
                    });
                }
            },
            getDbField(){
               let dbFields = [];
               this.tab1.data.forEach(item=>{
                  let dbField = {};
                   dbField.fieldName = item.fieldName;
                   dbField.fieldText = item.fieldTxt;
                  dbFields.push(dbField);
               });
               return dbFields;
            },
            clearDb(){
                this.getReport();
                for(let key in this.sqlForm){
                    this.sqlForm[key] = "";
                }
                this.sqlForm.isPage=true;
                this.sqlForm.apiMethod="0";
                this.tab1.data = [];
                this.tab2.data = [];
            },
            saveDb(){
                this.$refs.sqlForm.validate((valid)=>{
                    if(valid){
                        //保存表单
                        let reportDb = {};
                        reportDb.id = this.sqlForm.id;
                        reportDb.jimuReportId = excel_config_id;
                        reportDb.dbCode = this.sqlForm.dbCode;
                        reportDb.dbChName = this.sqlForm.dbChName;
                        reportDb.dbType = this.sqlForm.dbType;
                        reportDb.dbSource = this.sqlForm.dbSource;
                        if (this.sqlForm.isPage){
                            /*if (this.addIsPage){
                                reportDb.isPage = '0'
                            } else {
                                reportDb.isPage = '1'
                            }*/
                            reportDb.isPage = '1'
                        } else {
                            reportDb.isPage = '0'
                        }
                        if (this.sqlForm.dbType == "0"){
                            reportDb.dbDynSql = this.sqlForm.dbDynSql;
                        } else {
                            reportDb.apiUrl = this.sqlForm.apiUrl;
                            reportDb.apiMethod = this.sqlForm.apiMethod;
                        }
                        let url =  `${base}/design/report/saveDb`;
                        reportDb.fieldList = this.tab1.data; //解析出表字段
                        reportDb.paramList = this.tab2.data; //动态表单参数
                        $.ajax({
                            url: url,
                            type:"post",
                            contentType:"application/json",
                            headers:{"X-Access-Token":this.token},
                            data:JSON.stringify(reportDb),
                            success:(result)=>{
                                this.$Notice.success({
                                    title: '保存成功'
                                });
                                this.initFieldTree();
                                addDrag();
                                for(let key in this.sqlForm){
                                    this.sqlForm[key] = "";
                                }
                                this.sqlForm.isPage=false;
                                this.sqlForm.apiMethod="0";
                                this.tab1.data = [];
                                this.tab2.data = [];
                                this.sqlModal = false;
                            }
                        });
                        return;
                    }else{
                        setTimeout(() => {
                            this.loading = false
                            this.$nextTick(() => {
                                this.loading = true
                            })
                        }, 500)
                        return;
                    }
                });
            },
            handleSQLAnalyze() {
                let dbDynSql = this.sqlForm.dbDynSql;
                let dbSource = this.sqlForm.dbSource;
                if(!dbDynSql){
                    return;
                }
                if(dbDynSql.indexOf("where")!=-1){
                    dbDynSql = dbDynSql.substr(0,dbDynSql.indexOf("where"));
                }
                $.post(`${base}/design/report/executeSelectSql?token=${token}`,{
                      sql:dbDynSql,dbSource:dbSource
                },(result) => {
                    this.tab1.data = result.result;
                    this.tab1.data.forEach((item,index)=>{
                        item.tableIndex = index+1;
                    })
                })
            },
            selectdbSource(val){
                this.sqlForm.dbSource = val;
            },
            selectmenuList(val){
                this.designerObj.type = val;
            },
            handleApiAnalyze(){
                let dbDynApi = this.sqlForm.apiUrl;
                if(!dbDynApi){
                    return;
                }
                if(dbDynApi.indexOf("?")!=-1){
                    dbDynApi = dbDynApi.substr(0,dbDynApi.indexOf("?"));
                }
                let apiMethod = this.sqlForm.apiMethod;
                $.post(`${base}/design/report/executeSelectApi?token=${token}`,{
                    api:dbDynApi,method:apiMethod
                },(result) => {
                    this.tab1.data = result.result;
                    this.tab1.data.forEach((item,index)=>{
                        item.tableIndex = index+1;
                    })
                })
            },
            //渲染input
            renderInput(h, params, field,tabIndex) {
                return h('i-input', {
                    props: {
                        "size":"small",
                        type: 'text',
                        value: this[tabIndex].data[params.index][field]
                    },
                    on: {
                        'on-blur': (event) => {
                            if(tabIndex==="tab2"){
                                let tableIndexArr = vm.tab2.selectParamTables.map(item=>item.tableIndex);
                                vm.tab2.data.forEach(item=>{
                                    if(tableIndexArr.includes(item.tableIndex)){
                                        item._checked = true;
                                    }
                                });
                            }
                            this[tabIndex].data[params.index][field] = event.target.value;
                        }
                    },
                })
            },
            changeTree(value){
                console.log("changeTree",value);
            },
            initDataSource(){
                $.get(`${base}/design/report/initDataSource?token=${token}`, (result)=> {
                    //this.$Spin.hide();
                    this.createLoading = false
                    let reportResult = result.result;
                    if(!reportResult){
                        return;
                    }
                    this.sourceTab.data = reportResult;
                    this.sourceTab.data.forEach((item,index)=>{
                        item.tableIndex = index+1;
                    })
                });
            },
            savePopup(){
                var that = this;
                let creatFlag = that.excelQueryName();
                if (creatFlag){
                    $.excelSave(that.dataXs, token,function () {
                        xs.tip("保存成功!");
                        onbeforeunload="return true";
                        window.location.reload();
                    });
                    that.visible = false;
                }
            },
            handleCreate(cb,data){
                var that = this;
                var obj = that.designerObj;
                if (obj.name == "" || obj.name == null) {
                    that.visible = true;
                    that.dataXs = data;
                    //that.$Message.error("名称不能为空!");
                    return "";
                }
                //同步校验
                let creatFlag = that.excelQueryName();
                if (creatFlag){
                    obj.id = excel_config_id;
                    cb(obj);
                }
            },
            excelQueryName () {
                var creatFlag = true;
                var that = this;
                var obj = that.designerObj;
                if(obj.name != "" && obj.name != null){
                    var url = `${base}/design/report/excelQueryName`;
                    $.ajax({
                        url: url,
                        type:"post",
                        async: false,
                        contentType:"application/json",
                        headers:{"X-Access-Token":this.token},
                        data:JSON.stringify(obj),
                        success:(result)=>{
                            if(result.result){
                            }else{
                                that.$Message.error("您输入的报表名字已经存在，换一个吧！");
                                obj.name="";
                                creatFlag = false;
                            }
                        }
                    });
                }
                return creatFlag;
            },
            changeName : function () {
            },
            onMenuSelect:function(name){
                this.menuitem = name;
                let modalFlag = false;
                if (name === "sqlInfo") {
                    //sql
                    this.moduleTitle = "SQL数据集";
                    this.sqlForm.dbType = "0";
                    modalFlag = true;
                }else if(name==="apiInfo"){
                    //api
                    this.moduleTitle = "Api数据集";
                    this.sqlForm.dbType = "1";
                    modalFlag = true;
                }
                this.sqlForm.dbCode = "";
                this.sqlForm.dbChName = "";
                this.sqlForm.dbDynSql = "";
                this.sqlForm.apiUrl = "";
                this.sqlForm.dbSource = "";
                this.tab1.data = [];
                this.tab2.data = [];
                this.sqlModal = modalFlag;
            },
            selectPolyList(name){
                //下拉改变单元格值
                let data = xs.data.getSelectArea();
                if(data.sri<0 || data.sci<0) return;
                if(!xs.data.rows["_"][data.sri]) return;
                let textr = xs.data.rows["_"][data.sri].cells[data.sci].text;
                if (textr != "" && textr.indexOf("#{") != -1){
                    if (name === 'group'){
                        if (xs.data.rows["_"][data.sri].cells[data.sci].direction === 'right') return;
                        xs.data.rows["_"][data.sri].cells[data.sci].aggregate='group';
                        let text = xs.data.rows["_"][data.sri].cells[data.sci].text;
                        let newxsdata = text.replace(subStringStr(text,"#{","}").split(".")[1],"group("+subStringStr(text,"#{","}").split(".")[1]+")");
                        xsSetNewdata(data,newxsdata)
                    }else if(name === 'select'){
                        if (xs.data.rows["_"][data.sri].cells[data.sci].direction === 'right') return;
                        xs.data.rows["_"][data.sri].cells[data.sci].aggregate='select';
                        let text = xs.data.rows["_"][data.sri].cells[data.sci].text;
                        let subtext = subStringStr(text,"#{","}").split(".")[1];
                        let newxsdata = text.replace(subtext,subStringStr(subtext,"group(",")"));
                        xsSetNewdata(data,newxsdata)
                    }
                }
            },
            selectDirectionList(name){
                //下拉改变单元格值
                let data = xs.data.getSelectArea();
                if(data.sri<0 || data.sci<0) return;
                if(!xs.data.rows["_"][data.sri]) return;
                let textr = xs.data.rows["_"][data.sri].cells[data.sci].text;
                if (textr != "" && textr.indexOf("#{") != -1){
                    if (name === 'right'){
                        xs.data.rows["_"][data.sri].cells[data.sci].direction='right';
                        let text = xs.data.rows["_"][data.sri].cells[data.sci].text;
                        let text2 = subStringStr(text,"#{","}").split(".")[1];
                        let text4 = "";
                        if (text2.indexOf("group(") != -1) {
                            text4 = subStringStr(text2, "group(", ")");
                        }else {
                            text4 = text2;
                        }
                        let text3 = "groupRight("+text4+")"
                        let newxsdata = text.replace(text2,text3);
                        xsSetNewdata(data,newxsdata)
                        this.excel.polyWay = 'group';
                        this.$refs.excelPolyWay.disabled = true;
                    }else if(name === 'down'){
                        xs.data.rows["_"][data.sri].cells[data.sci].direction='down';
                        let text = xs.data.rows["_"][data.sri].cells[data.sci].text;
                        let subtext = subStringStr(text,"#{","}").split(".")[1];
                        let newxsdata = text.replace(subtext,subStringStr(subtext,"groupRight(",")"));
                        xsSetNewdata(data,newxsdata)
                        this.excel.polyWay = 'select';
                        this.$refs.excelPolyWay.disabled = false;
                    }
                }
            },
            // 是否使用字典下拉框改变事件
            selectUseDict(value){
                //下拉改变单元格值
                if(!value && value!=0){
                    return ;
                }
                let data = xs.data.getSelectArea();
                if(data.sri<0 || data.sci<0){
                    return;
                }
                if(value==0){
                    let code = vm.excel.dictCode
                    this.removeReportDictCode(code)
                    vm.excel.dictCode = ''
                    xs.data.rows["_"][data.sri].cells[data.sci]['dictCode']=''
                }
                xs.data.rows["_"][data.sri].cells[data.sci]['isDict']=value
                //xs.sheet.reload()
            },
            // 字典编码改变事件
            changeDictCode(){
                let value = this.excel.dictCode
                console.log('changeDictCode',value)
                let data = xs.data.getSelectArea();
                if(data.sri<0 || data.sci<0) return;
                console.log('changeDictCode', value)
                if(vm.excel.isDict==1){
                    xs.data.rows["_"][data.sri].cells[data.sci]['dictCode']=value
                    this.addReportDictCode(value)
                }
            },
            //新增字典编码到excel data dicts
            addReportDictCode(code){
                if(!xs.data.dicts){
                    xs.data.dicts = []
                }
                xs.data.dicts.push(code)
            },
            //移除字典编码
            removeReportDictCode(code){
                if(xs.data.dicts){
                    let index = xs.data.dicts.indexOf(code)
                    if(index>=0){
                        xs.data.dicts.splice(index,1);
                    }
                }
            },
            sourceManage(){
                this.sourceModal = true;
            },
            saveSourceDb(){
                this.sourceModal = false;
            },
            addDataSource(){
                this.visibleData = true;
            },
            selectdbType(name){
                if (name === "1"){
                    this.dataSource.dbDriver = "com.mysql.jdbc.Driver";
                    this.dataSource.dbUrl = "jdbc:mysql://127.0.0.1:3306/jeecg-boot?useUnicode=true&characterEncoding=UTF-8&serverTimezone=GMT%2B8";
                }else if (name === "2"){
                    this.dataSource.dbDriver = "oracle.jdbc.OracleDriver";
                    this.dataSource.dbUrl = "jdbc:oracle:thin:@127.0.0.1:1521:ORCL";
                }else if (name === "3"){
                    this.dataSource.dbDriver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                    this.dataSource.dbUrl = "jdbc:sqlserver://127.0.0.1:1433;SelectMethod=cursor;DatabaseName=jeecgboot";
                }
            },
            clearDbSou(){
                this.$refs.dataSource.resetFields();
                this.initDataSource();
            },
            saveDataSource(){
                this.$refs.dataSource.validate((valid)=>{
                    if(valid){
                        //保存表单
                        let dbSource = {};
                        dbSource.id = this.dataSource.id;
                        dbSource.reportId = excel_config_id;
                        dbSource.code = this.dataSource.code;
                        dbSource.name = this.dataSource.name;
                        dbSource.dbType = this.dataSource.dbType;
                        dbSource.dbDriver = this.dataSource.dbDriver;
                        dbSource.dbUrl = this.dataSource.dbUrl;
                        dbSource.dbUsername = this.dataSource.dbUsername;
                        dbSource.dbPassword = this.dataSource.dbPassword;
                        let url =  `${base}/design/report/addDataSource`;
                        $.ajax({
                            url: url,
                            type:"post",
                            contentType:"application/json",
                            headers:{"X-Access-Token":this.token},
                            data:JSON.stringify(dbSource),
                            success:(result)=>{
                                this.$Notice.success({
                                    title: '保存成功'
                                });
                                this.initDataSource();
                                this.dataSource = {};
                                this.visibleData = false;
                            }
                        });
                        return;
                    }else{
                        setTimeout(() => {
                            this.loading = false
                            this.$nextTick(() => {
                                this.loading = true
                            })
                        }, 500)
                        return;
                    }
                })
            },
            //渲染button
            renderButton(h, params) {
                return h('div',[
                    h('i-button', {
                        props: {
                            type: 'primary',
                            size: 'small'
                        },
                        style:{
                            'margin-right':'5px'
                        },
                        on: {
                            click: () => {
                                this.sourceTab.data.forEach((item)=>{
                                    if (item.id === params.row.id){
                                        this.dataSource = item;
                                    }
                                })
                                this.visibleData = true;
                            }
                        }
                    },'编辑'),
                    h('i-button', {
                        props: {
                            type: 'primary',
                            size: 'small'
                        },
                        on: {
                            click: () => {
                                this.$Modal.confirm({
                                    content: '是否确认删除?',
                                    onOk: () => {
                                        let dbSource = {};
                                        dbSource.id = params.row.id;
                                        let url =  `${base}/design/report/delDataSource`;
                                        $.ajax({
                                            url: url,
                                            type:"post",
                                            contentType:"application/json",
                                            headers:{"X-Access-Token":this.token},
                                            data:JSON.stringify(dbSource),
                                            success:(result)=>{
                                                this.$Notice.success({
                                                    title: '删除成功'
                                                });
                                                this.initDataSource();
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    },'删除')
                ])
            },
            //渲染button
            renderColorButton(h, params,key,type) {
                console.log('params',params)
                if(key=='action'){
                    return h('div',[
                        h('a', {
                            /*  props: {
                                  type: 'primary',
                                  size: 'small'
                              },*/
                            style:{
                                'margin-right':'15px',
                                'color':'#3399ff'
                            },
                            on: {
                                click: () => {
                                    if(type==1){
                                        this.colorMatch=params.row;
                                        this.colorMatchModal = true;
                                    }else{
                                        this.seriesObj=params.row;
                                        this.seriesModal = true;
                                    }
                                }
                            }
                        },'编辑'),
                        h('a', {
                            /*  props: {
                                  type: 'error',
                                  size: 'small'
                              },*/
                            style:{
                                'color':'#ff6600'
                            },
                            on: {
                                click: () => {
                                    this.$Modal.confirm({
                                        content: '<i class="ivu-icon ivu-icon-ios-alert" style="color: #f90;font-size: 20px;margin-right: 5px;"></i>是否确认删除?',
                                        onOk: () => {
                                            if(type==1){
                                              this.echartInfo.colorMatchData.splice(params.index, 1);
                                              this.echDataRun();
                                            }else{
                                              this.dataAllocation.seriesTypeData.splice(params.index, 1);
                                            }
                                        }
                                    });
                                }
                            }
                        },'删除')
                    ])
                }else{
                    return h('div',{
                        style:{
                            'background':params.row.color1,
                            'width':'18px',
                            'height':'18px',
                            'margin-left':'15px'
                        }
                    })
                }
            },
            dataSourceTest(){
                let dbSource = {};
                dbSource.dbType = this.dataSource.dbType;
                dbSource.dbDriver = this.dataSource.dbDriver;
                dbSource.dbUrl = this.dataSource.dbUrl;
                dbSource.dbName = this.dataSource.dbName;
                dbSource.dbUsername = this.dataSource.dbUsername;
                dbSource.dbPassword = this.dataSource.dbPassword;
                let url =  `${base}/design/report/testConnection`;
                $.ajax({
                    url: url,
                    type:"post",
                    contentType:"application/json",
                    headers:{"X-Access-Token":this.token},
                    data:JSON.stringify(dbSource),
                    success:(result)=>{
                        this.$Modal.info({
                            title: "测试提醒",
                            content: result.message
                        });
                    }
                });
            },
            //图表标题
            echTilChange(status){
                this.echartInfo.titleShow = status;
            },
            //图表静态数据编辑框
            addEchartInfoData(){
                this.addEchart = true;
            },
            addEchartData(){
                this.addEchart = false;
            },
            //选择图表sql
            selectSqlListOpt(name){
                this.dataAllocation.sqlxAxis = '';
                this.dataAllocation.sqlseries = '';
                this.dataAllocation.sqlgroup = '';
                this.dataAllocation.sqltype = '';
                this.dataAllocation.seriesTypeData =[];
                this.dataAllocation.sqlListOpt.forEach(item=>{
                    if (item.dbId === name){
                        this.dataAllocation.sqlListField = item.children;
                    }
                });
            },
            changeLayerOffset(){
                let value = this.offsetInfo
                if(!value){
                    xs.updateLayerOffset(this.echartInfo.id, [0,0]);
                    return;
                }
                if(value.indexOf(',')<0){
                    this.$Message.warning('偏移量格式不正确！');
                    return;
                }
                let arr = value.split(',')
                if(arr.length!=2){
                    this.$Message.warning('偏移量格式不正确！');
                    return;
                }
                xs.updateLayerOffset(this.echartInfo.id, arr);
            },
            //单击选中图表
            selectChart(data){
                let that = this;
                that.echartInfo.id = data.id;
                if(!data.offset){
                    that.offsetInfo = '0,0'
                }else{
                    that.offsetInfo = data.offset.join(',')
                }
                if(!data.options){
                    return;
                }
                if (data.extData != "" && typeof(data.extData) != "undefined"){
                    let extData = data.extData;
                    that.dataAllocation.dataType = extData.dataType;
                    that.dataAllocation.status = extData.status;
                    that.dataAllocation.selectId = extData.selectId;
                    that.selectSqlListOpt(that.dataAllocation.selectId)
                    that.dataAllocation.sqlxAxis = extData.sqlxAxis;
                    that.dataAllocation.sqlseries = extData.sqlseries;
                    that.dataAllocation.sqlgroup = extData.sqlgroup;
                    that.dataAllocation.seriesTypeData = extData.seriesTypeData;
                }else {
                    that.dataAllocation.dataType = 'apiechData';
                    that.dataAllocation.status = 'staticData';
                }
                that.dataAllocation.selectOptionData = data.options;
                that.specialChartType = data.options.chartType?data.options.chartType:null;
                that.chartsType = that.dataAllocation.selectOptionData.series[0].type;
                //获取图表类型集
                that.chartsTypeArr = that.uniqueArr(that.dataAllocation.selectOptionData.series.map(item=>{return item.type}));
                //选中判断是否多组图表数据
                that.isMultiChart = that.dataAllocation.selectOptionData.series.length>1?true:false;
                //选中图表绑定配置
                jsontoconfig(that.echartInfo,that.dataAllocation,data.options);
            },
            uniqueArr(arr){
                if (Array.hasOwnProperty('from')) {
                    return Array.from(new Set(arr));
                } else {
                    var n = {}, r = [];
                    for (var i = 0; i < arr.length; i++) {
                        if (!n[arr[i]]) {
                            n[arr[i]] = true;
                            r.push(arr[i]);
                        }
                    }
                    return r;
                }
            },
            styleChanges(){
                this.echDataRun();
            },
            //将配置运行为图表
            echDataRun() {
                let that = this;
                let id = that.echartInfo.id;
                if(!that.dataAllocation.selectOptionData.series) return;
                let charType = that.dataAllocation.selectOptionData.series[0].type;
                //动态api数据获取
                if (that.dataAllocation.dataType === 'sqlechData' && that.dataAllocation.selectId != '') {
                    let sqlxAxis = that.dataAllocation.sqlxAxis;
                    let sqlseries = that.dataAllocation.sqlseries;
                    let sqlgroup = that.dataAllocation.sqlgroup;
                    let sqltype = that.dataAllocation.sqltype;
                    let seriesTypeData = that.dataAllocation.seriesTypeData;
                    jQuery.qurestSql(that.dataAllocation,this.token,function (res) {
                        if(res.success){
                            let backObj = querySqlData(charType, res.result, sqlxAxis, sqlseries,sqlgroup,seriesTypeData,that.dataAllocation.optionData);
                            that.dataAllocation.optionData = JSON.stringify(backObj);
                        }
                    })
                } else if (that.dataAllocation.dataType === 'apiechData' && that.dataAllocation.selectId != '') {
                    if (that.dataAllocation.status == 'dynamicData') {
                        jQuery.qurestApi(that.dataAllocation,this.token,function (res) {
                            if(res.success){
                                let backObj = queryApiData(charType, res.result, that.dataAllocation.optionData);
                                that.dataAllocation.optionData = JSON.stringify(backObj);
                            }
                        })
                    }
                }
                //静态数据组装json
                let options = configtojson(that.echartInfo, that.dataAllocation.optionData, this.dataAllocation.selectOptionData);
                //通过id修改配置
                let chartExtData = {};
                chartExtData.dataType = that.dataAllocation.dataType;
                chartExtData.status = that.dataAllocation.status;
                chartExtData.selectId = that.dataAllocation.selectId;
                chartExtData.sqlxAxis = that.dataAllocation.sqlxAxis;
                chartExtData.sqlseries = that.dataAllocation.sqlseries;
                chartExtData.sqlgroup = that.dataAllocation.sqlgroup;
                chartExtData.sqltype = that.dataAllocation.sqltype;
                chartExtData.seriesTypeData = that.dataAllocation.seriesTypeData;
                xs.updateChart(id , options);
                xs.updateChartExtData(id,chartExtData);
                let data = {};
                data.id = id;
                data.options = options;
                data.extData = chartExtData;
                this.selectChart(data);
            },
            addChartModule(){
                this.chartModule = true;
            },
            okAddChart(){
                //sureAddchart
                if(!this.selectedChartType){
                    this.$Message.warning('未曾选中图表！');
                    this.chartModule = false;
                }else{
                    let url =  `${base}/design/report/addChart`;
                    $.ajax({
                        url: url,
                        type: "GET",
                        async: false,
                        headers:{"X-Access-Token":this.token},
                        data:{"chartType":this.selectedChartType},
                        success:(result)=>{
                            let option = {};
                            option = result.result;
                            xs.addChart(option);
                            this.chartModule = false;
                            this.selectedChartType="";
                            this.specialChartType="";
                            //判断图表类型
                            this.isMultiChart=option.series.length>1?true:false;
                            this.chartsflag = true;
                        }
                    });
                }
            },
            //页面有图表时显示样式和数据tab
            tabPaneShow(){
                this.chartsflag = true;
            },
            //进入设计页面或刷新时运行所有图表
            designTrigDia(xsChartList){
                let that = this;
                xsChartList.forEach(item=>{
                    let data = {};
                    data.id = item.layer_id;
                    data.extData = item.extData;
                    data.options = $.parseJSON(item.config);
                    that.selectChart(data)
                    that.echDataRun()
                })
            }
        }
    }
)

//选中绑定配置
function jsontoconfig(echartInfo,dataAllocation,option){
    //样式
    jsontoconfigStyle(echartInfo,option,option.series[0].type);
    //根据图表类型处理数据
    if (option.series[0].type === 'bar' || option.series[0].type === 'line'  || option.series[0].type === 'scatter'){
        let optdata = '{"categories":'+JSON.stringify(option.xAxis.data?option.xAxis.data:'',null, "\t") + "," + '"series":'+ JSON.stringify(option.series,null, "\t")+"}";
        dataAllocation.optionData = optdata;
    }else if (option.series[0].type === 'pie'){
        dataAllocation.optionData = JSON.stringify(option.series[0].data, null, "\t");

        if(option.series[0].data.length>0){
            //自定义颜色配置
            let data=option.series[0].data.map(item=>{
                let color={"color1":null};
                if(item.itemStyle){
                    color={"color1":item.itemStyle.color}
                }
                return color
            })
            echartInfo.colorMatchData=data.filter(item=>item.color1 && item.color1.length>0)
        }
    }
}

//配置刷新运行json
function configtojson(echartInfo,optionData,selectOptionData){

    //根据类型处理数据
    let obj = $.parseJSON( optionData );
    if (selectOptionData.series[0].type === 'bar'  || selectOptionData.series[0].type === 'line' || selectOptionData.series[0].type === 'scatter'){
        selectOptionData.xAxis.data = obj.categories;
        selectOptionData.series=obj.series;
    }else if (selectOptionData.series[0].type === 'pie'){
        var copyObj = JSON.parse(JSON.stringify(obj));
        //是否排序
        copyObj =echartInfo.autoSort?copyObj.sort(function (a, b) {return a.value - b.value;}):obj;
        copyObj.forEach(function(item, index){
            //设置颜色
            var color=getMatchColor(echartInfo,index);
            if(item.itemStyle){
                item.itemStyle.color = color;
            }else{
                item.itemStyle={'color':color}
                //Vue.set(item, 'itemStyle', {'color':color})
            }
        });
        selectOptionData.series[0].data = copyObj;
        // 图例数据设置
        selectOptionData.legend.data=selectOptionData.series[0].data.map(item=>{return item.name})
    }

    //样式
    configtojsonStyle(selectOptionData,echartInfo,selectOptionData.series[0].type);

    return selectOptionData;
}

//转换请求api数据
function queryApiData(charType,result,optionData) {
    let obj = $.parseJSON(optionData);
    if (charType === 'bar' || charType === 'line'){
        let xAxisData = [];
        let seriesData = [];
        result.data.forEach(item=>{
            for(var d in item) {
                if (d === 'name'){
                    xAxisData.push(item[d]);
                }
                if (d === 'value'){
                    seriesData.push(item[d]);
                }
            }
        });
        obj.categories = xAxisData;
        //包含分类多组数据处理
        if(result.category){
            let series=[];
            //设置图例数据
            vm.echartInfo.legendData=result.category;
            result.category.forEach((name,index)=>{
                //获取series默认样式
                let commonObj=Object.assign(obj.series[0],{name:name,data:[]});
                //判断原有样式是否存在
                let hasSeries = obj.series.filter(item=>item.name === name);
                if(hasSeries!=null && hasSeries.length>0) {
                    commonObj=Object.assign(hasSeries[0],{name:name,data:[]});
                }
                //多种图表的series公共样式获取
                if(result.type && result.type.length>0){
                    let filter = obj.series.filter(serie=>serie.type == result.type[index]);
                    if(filter&&filter.length>0){
                        commonObj=Object.assign(filter[0],{name:name,data:[]});
                    }
                }
                let seriesObj=JSON.parse(JSON.stringify(commonObj));
                //获取series的data数据集
                seriesObj.data=seriesData.map(item=>{
                    return item[index]
                });
                series[index]=seriesObj;
            });
            obj.series=series;
        }else{
            obj.series[0].data = seriesData;
        }
        return obj;
    }else if (charType === 'pie'){
        obj = result.data;
        return obj;
    }else if(charType === 'scatter'){
        obj.series[0].data = result.data.map(item=>{return [item.name,item.value]});
        return obj;
    }
}

//转换请求sql数据
function querySqlData(charType,result,sqlxAxis,sqlseries,sqlgroup,seriesTypeData,optionData) {
    let obj = $.parseJSON(optionData);
    let resultArr=JSON.parse(JSON.stringify(result));//记录结果集数据
    if (charType === 'bar' || charType === 'line'){
        let xAxisData = [];
        let seriesData = [];
        let legendData = [];//图例数据
        //饼图、柱形图特有样式
        let linestyle={"yAxisIndex": 1,"step": false,"showSymbol": true,"smooth": false,"symbolSize":5,"lineStyle":{"width":2}};
        let barstyle={"barWidth": 15,"barMinHeight": 2};
        result.forEach(item=>{
            for(var d in item) {
                if (xAxisData.indexOf(item[d]) != -1){
                    let index = xAxisData.indexOf(item[d]);
                    seriesData[index] = (parseFloat(seriesData[index])  +  parseFloat(item[sqlseries]));
                    delete item[sqlseries];
                }else {
                    if (d === sqlxAxis){
                        xAxisData.push(item[d]);
                    }
                    if (d === sqlseries){
                        seriesData.push(item[d]);
                    }
                    if (d === sqlgroup && legendData.indexOf(item[d]) == -1){
                        legendData.push(item[d]);
                    }
                }
            }
        });
        obj.categories = xAxisData;
        //图例数据大于0，多组分类数据
        if(legendData.length>1){
            //设置图例数据
            vm.echartInfo.legendData=legendData;
            //处理分组数据
            var series=[];
            legendData.forEach((name,index)=>{
                //获取series公共样式
                var commonObj=null;
                //多组单案例
               if(legendData.length === 1){
                    commonObj=Object.assign(obj.series[0],{ name:name,data:[]});
               }else{
                   //多组多案例

                   let hasSeries = obj.series.filter(item=>item.name === name);
                   if(hasSeries!=null && hasSeries.length>0){
                       //1.判断有没有存在好的样式
                       commonObj=Object.assign(hasSeries[0],{ name:name,data:[]});
                   }else{
                       //2.没有存在好的样式设置默认样式
                       commonObj=Object.assign(obj.series[0],{ name:name,data:[]});
                   }
                   //自定义的图表类型（折柱）
                   if(vm.specialChartType === 'linebar'){
                       //判断系列自定义样式
                       var filterArr = seriesTypeData.filter(seriesType=>seriesType.name === name);//获取到对应系列的类型
                       if(filterArr && filterArr.length>0){
                           //判断系列自定义样式
                           let type = filterArr[0].type;
                           if(type === 'line'){
                               commonObj=Object.assign({ name:name,data:[],type:type,itemStyle:obj.series[0].itemStyle },linestyle)
                           }else{
                               //柱子样式
                               let itemStyle =JSON.parse(JSON.stringify(obj.series[0].itemStyle));
                               if(Object.prototype.toString.call(itemStyle.normal.barBorderRadius).slice(8, -1) === 'Undefined'){
                                   itemStyle.normal.barBorderRadius=0;
                               }
                               commonObj=Object.assign({ name:name,data:[],type:type,itemStyle:itemStyle},barstyle)
                           }
                       }
                   }
               }

                let seriesObj=JSON.parse(JSON.stringify(commonObj));
                //获取series的data数据集
                for(let item of resultArr){
                    if(seriesObj.data.length==xAxisData.length){
                        break;
                    }
                    if(item[sqlgroup] === name){
                        seriesObj.data.push(item[sqlseries]);
                    }
                }
                series[index]=seriesObj;
            });
            console.log("series===>",series);
            obj.series=series;
        }else{
            obj.series[0].data = seriesData;
        }
        return obj;
    }else if (charType === 'pie'){
        let objpie = [];
        result.forEach(item=>{
            var objres = {};
            for(var d in item) {
                if (d === sqlxAxis){
                    objres['name'] = item[d];
                }
                if (d === sqlseries){
                    objres['value'] = item[d];
                }
            }
            objpie.push(objres);
        });
        obj = mergeObject(objpie);
        return obj;
    }else if(charType === 'scatter'){
        obj.series[0].data = result.map(item=>{
            return [item[sqlxAxis],item[sqlseries]]
        });
        return obj;
    }
}

//数组对象去重
function mergeObject(array) {
    var arrayFilted = [];
    array.forEach(value=>{
        if ( arrayFilted.length == 0 ) {
            arrayFilted.push(value);
        }else{
            let flag = true;
            arrayFilted.forEach(valueIndex=>{
                if (valueIndex.name && valueIndex.name === value.name) {
                    valueIndex.value = valueIndex.value + value.value;
                    flag = false;
                }
            });
            if (flag){
                arrayFilted.push(value);
            }
        }
    });
    return arrayFilted;
}

function xsSetNewdata(data,newxsdata){
    xs.data.rows["_"][data.sri].cells[data.sci].text=newxsdata;
    vm.excel.excelValue = newxsdata;
    xs.sheet.reload()
}

function setExcelData({ri=0,ci=0},text,isDrag=false,style,merge) {
    let cell = {[ci]:{"text":text}};
    //第一个单元格样式
    if(style || style==0){
        cell[ci]['style']=style;
    }
    if(merge){
        //加入合并单元格
        cell[ci]["merge"] = merge;
    }
    let tableData = {};
    let rowsData = xs.getData().rows;
    if(rowsData[ri]){
        //有数据
        let cells = {...rowsData[ri].cells,...cell};
        tableData = {"rows":{
                ...rowsData,[ri]:{cells,isDrag}
            }
        };
    }else{
        tableData={
            "rows":{
                ...rowsData,[ri]:{"cells":cell,isDrag}
            }
        }
    }

    //加入高度设置
    const row = xs.getData().rows[ri];
    const height = row && row.height;
    if(height){
        tableData.rows[ri].height = height;
    }

    xs.loadData(tableData);

}

function setExcelCoordinate(ev){
    let data = xs.data.getCellRectByXY(ev.offsetX, ev.offsetY);
    if(data.ri<0 || data.ci<0) return;
    vm.excel.coordinate = `${data.ri},${data.ci}`;
    vm.excel.ri = data.ri;
    vm.excel.ci = data.ci;
}

function getMatchColor(echartInfo,index){
    var matchColors = echartInfo.colorMatchData || [];
    if (matchColors && matchColors[index]) {
        var color1 = matchColors[index].color1;
        return color1;
    }else{
        return null;
    }
}

let sheetDiv = document.getElementById('x-spreadsheet-demo');

//单击事件
sheetDiv.onclick=function(ev){
    Object.keys(vm.excel).map(k=>{
        vm.excel[k]=''
    })
    setExcelCoordinate(ev);
    let row = xs.getData().rows[vm.excel.ri];
    let text="";
    if(row){
        text = row.cells[vm.excel.ci]?row.cells[vm.excel.ci].text:"";
    }
    vm.excel.excelValue = text;
    let cellMe = [];
    if (text != "" && text.indexOf("#{") != -1){
        cellMe = subStringStr(text,"#{","}").split(".");
        let field = cellMe[1];
        if (field.indexOf("group(") != -1){
            vm.excel.polyWay = "group"
        }else {
            vm.excel.polyWay = "select"
        }
        if (field.indexOf("groupRight(") != -1){
            vm.excel.direction = "right"
            vm.excel.polyWay = "group"
            vm.$refs.excelPolyWay.disabled = true;
        }else{
            vm.excel.direction = "down"
            vm.$refs.excelPolyWay.disabled = false;
        }
        vm.excel.isDict = row.cells[vm.excel.ci]?row.cells[vm.excel.ci].isDict:"";
        vm.excel.dictCode = row.cells[vm.excel.ci]?row.cells[vm.excel.ci].dictCode:"";
    }

}

function subStringStr(str,strStart,strEnd){
    /* 找出指定的2个字符在 该字符串里面的 位置 */
    let strStartIndex = str.indexOf(strStart);
    let strEndIndex = str.indexOf(strEnd);
    /* index 为负数 即表示该字符串中 没有该字符 */
    if (strStartIndex < 0) {
        return "";
    }
    if (strEndIndex < 0) {
        return "";
    }
    /* 开始截取 */
    let result = str.substring(strStartIndex, strEndIndex).substring(strStart.length);
    return result;
}

// 双击事件
sheetDiv.ondblclick=function(ev){
    console.log("双击=====");
}

// 拖拽开始
sheetDiv.ondragover = function (ev) {
    console.log("拖拽开始=====");
    ev.preventDefault(); //阻止向上冒泡
};

// 拖拽结束
sheetDiv.ondrop = function (ev) {
    console.log("拖拽结束=====");
    ev.preventDefault();

    let id = ev.dataTransfer.getData('id');
    let dbText = ev.dataTransfer.getData('dbText').trim();
    dbText = vm.treeObj[dbText];
    //设置pop后的text文本获取
    let text = $("#"+id).find("[class='ivu-tooltip-rel']").text().trim();
    let excelText = `#{${dbText}.${text}}`;
    excelText = excelText.replace(/\((.+?)\)/g,'');
    let data = xs.data.getCellRectByXY(ev.offsetX, ev.offsetY);
    const cell = xs.data.getCell(data.ri,data.ci);
    const style = cell && cell.style;
    const merge = cell && cell.merge;
    setExcelCoordinate(ev);
    setExcelData({ri:data.ri,ci:data.ci},excelText,true,style,merge);
    vm.excel.excelValue = excelText;
    //设置撤销操作
    xs.sheet.toolbar.undoEl.setState(false);
    //{"rows":{"3":{"cells":{"5":{"text":""}}},"len":100}}
    const rowData = JSON.parse(JSON.stringify(xs.data.rows["_"]));
    rowData[data.ri]["cells"][data.ci].text="";

    xs.data.history.undoItems.push(JSON.stringify({"rows":rowData}));

    vm.excel.polyWay = 'select';
    vm.excel.direction = 'down';

};

function addDrag(){
    setTimeout(function(){
        if(!xs) return;
        let {ri,ci} = xs.data.selector;
        vm.excel.ri = ri;
        vm.excel.ci  =ci;
        vm.excel.coordinate = `${ri},${ci}`;
        //绑定拖拽事件
        let index = 0;
        $("#dataTree ul .ivu-tree-children").each(function(){
            let $li = $(this).find("li");
            $li.attr("draggable","true");
            $li.attr("id","label"+(++index));

            let dbText = $($li.parent().siblings('span')[1]).text();

            $li[0].ondragstart = function (ev) {
                //dataTransfer.setData() 方法设置被拖数据的数据类型和值
                ev.dataTransfer.setData("id", this.id);
                ev.dataTransfer.setData("dbText", dbText);
            };
        });
        if (xs.data.chartList && xs.data.chartList.length > 0){
            vm.tabPaneShow();
            vm.designTrigDia(xs.data.chartList);
        }
    },300);
}

//图表选中样式绑定
function jsontoconfigStyle(echartInfo,option,charType){
    //标题
    echartInfo.titleText = option.title.text?option.title.text:'';
    echartInfo.titleFontSize = option.title.textStyle.fontSize?option.title.textStyle.fontSize: 20;
    echartInfo.titleFontWeight = option.title.textStyle.fontSize?option.title.textStyle.fontWeight:'bolder';
    echartInfo.titleColor =  option.title.textStyle.color?option.title.textStyle.color:'#c43632';
    echartInfo.titleLocation = option.title.left;
    //饼图
    if(charType === 'pie'){
        echartInfo.isRadius = option.series[0].isRadius;
        echartInfo.radius =  option.series[0].isRadius?option.series[0].pieRadius:'55%';
        if(option.series[0].isRadius){
            echartInfo.pieRadius = option.series[0].pieRadius?option.series[0].pieRadius:'45%,55%';
        }
        echartInfo.roseType = option.series[0].roseType=='radius'?true:false;
        echartInfo.minAngle = option.series[0].minAngle;
        echartInfo.pieLabelPosition = option.series[0].label.position;
        echartInfo.autoSort = option.series[0].autoSort;
        echartInfo.notCount = option.series[0].notCount;
        //数值显示
        echartInfo.numerShow = option.series[0].label.show;
        echartInfo.numerTextSize = option.series[0].label.textStyle.fontSize;
        echartInfo.numerTextcol = option.series[0].label.textStyle.color;
        echartInfo.numerTextweig = option.series[0].label.textStyle.fontWeight;
        //边距
        echartInfo.gridLeft = option.series[0].left;
        echartInfo.gridTop = option.series[0].top;
        echartInfo.gridRight = option.series[0].right;
        echartInfo.gridBottom = option.series[0].bottom;
    }
    if (charType === 'bar'|| charType === 'line' || charType === 'scatter'){
        //series为多数据多图表的处理
        let colorList=[];
        option.series.forEach(item=>{
            if (item.type === 'bar'){
                //柱体
                echartInfo.barWidth = item.barWidth;
                echartInfo.barRadius = item.itemStyle.normal.barBorderRadius;
                echartInfo.barMinHeight = item.barMinHeight;
                echartInfo.seriesItemNorCol = option.series.length==1?item.itemStyle.normal.color:'';
                if(vm.isMultiChart && item.itemStyle.normal.color)
                colorList.push({name:item.name,color1:item.itemStyle.normal.color})
            }
            if (item.type === 'line'){
                echartInfo.step = item.step; //阶梯线图
                echartInfo.showSymbol = item.showSymbol;//标记点
                echartInfo.smooth = item.smooth;//平滑曲线
                echartInfo.symbolSize =item.symbolSize;// 设置折线上圆点大小
                echartInfo.linewidth = item.lineStyle.width;// 设置线宽
                echartInfo.seriesLinemNorCol = option.series.length==1?item.lineStyle.color:null;//线条颜色
                if(vm.isMultiChart && item.lineStyle.color)
                colorList.push({name:item.name,color1:item.lineStyle.color})
            }
            if(item.type === 'scatter'){
                echartInfo.seriesItemNorCol =  item.itemStyle.normal.color?item.itemStyle.normal.color:'';
                echartInfo.symbolSize =item.symbolSize;// 设置折线上圆点大小
            }
        })
        if(vm.isMultiChart)
        echartInfo.colorMatchData=vm.uniqueArr(colorList).map(color=>{if(color.color1) return {color1:color.color1}})
        //X轴
        echartInfo.xaxisShow = option.xAxis.show;
        echartInfo.xaxisText = option.xAxis.name;
        echartInfo.xaxisLine = option.xAxis.splitLine.show;
        echartInfo.xaxisLinecol = option.xAxis.splitLine.lineStyle.color;
        echartInfo.xaxisTextsize = option.xAxis.axisLabel.textStyle.fontSize;
        echartInfo.axisLabelRotate = option.xAxis.axisLabel.rotate;
        //Y轴（多数据处理）
        let yAxis=typeJudge(option.yAxis,'Array')?option.yAxis[0]:option.yAxis;
        let yAxisName=typeJudge(option.yAxis,'Array')?option.yAxis.map(item=>{return item.name}).join(","):option.yAxis.name;
        echartInfo.yaxisShow = yAxis.show;
        echartInfo.yaxisText = yAxisName;
        echartInfo.yaxisLine = yAxis.splitLine.show;
        echartInfo.yaxisLinecol = yAxis.splitLine.lineStyle.color;
        echartInfo.yaxisTextsize = yAxis.axisLabel.textStyle.fontSize;
        //数值显示
        echartInfo.numerShow = option.series[0].itemStyle.normal.label.show;
        echartInfo.numerTextSize = option.series[0].itemStyle.normal.label.textStyle.fontSize;
        echartInfo.numerTextcol = option.series[0].itemStyle.normal.label.textStyle.color;
        echartInfo.numerTextweig = option.series[0].itemStyle.normal.label.textStyle.fontWeight;
        //轴边距
        echartInfo.gridLeft = option.grid.left;
        echartInfo.gridTop = option.grid.top;
        echartInfo.gridRight = option.grid.right;
        echartInfo.gridBottom = option.grid.bottom;
        //轴线和字体颜色
        echartInfo.axisLabelTextCol = option.xAxis.axisLabel.textStyle.color;
        echartInfo.axisLineLineCol = option.xAxis.axisLine.lineStyle.color;
    }
    if(charType === 'map'){
        //区域线的宽度、颜色、区域颜色
        echartInfo.scale=option.geo.zoom;
        echartInfo.xaxisTextsize=option.geo.label.fontSize;
        echartInfo.numerTextcol=option.geo.label.color;
        echartInfo.numerTextHighCol=option.geo.emphasis.label.color;
        echartInfo.borderWidth=option.geo.itemStyle.borderWidth;
        echartInfo.areaCol=option.geo.itemStyle.areaColor;
        echartInfo.areaHighCol=option.geo.emphasis.itemStyle.areaColor;
        echartInfo.borderCol=option.geo.itemStyle.borderColor;
        echartInfo.gridLeft = option.geo.left;
        echartInfo.gridTop = option.geo.top;
        echartInfo.gridRight = option.geo.right;
        echartInfo.gridBottom = option.geo.bottom;
    }else{
        //提示框
        echartInfo.tooltipShow = option.tooltip.show;
        echartInfo.tooltipTextSize = option.tooltip.textStyle.fontSize;
        echartInfo.tooltipTextcol = option.tooltip.textStyle.color;
        //图例
        echartInfo.legendShow = option.legend.show;
        echartInfo.legendData = option.legend.data;
        echartInfo.legendTop = option.legend.top;
        echartInfo.legendLeft = option.legend.left;
        echartInfo.legendOrient = option.legend.orient;
        echartInfo.legendTextcol = option.legend.textStyle.color?option.legend.textStyle.color:'';
        echartInfo.legendTextsize = option.legend.textStyle.fontSize;
    }
}

//图表运行json数据样式
function configtojsonStyle(selectOptionData,echartInfo,charType){
    //标题
    selectOptionData.title.text = echartInfo.titleText;
    selectOptionData.title.textStyle.fontSize = echartInfo.titleFontSize;
    selectOptionData.title.textStyle.fontWeight = echartInfo.titleFontWeight;
    selectOptionData.title.textStyle.color = echartInfo.titleColor;
    selectOptionData.title.left = echartInfo.titleLocation;

    if(charType === 'pie'){
        //饼图
        selectOptionData.series[0].isRadius = echartInfo.isRadius;
        selectOptionData.series[0].radius = echartInfo.isRadius? echartInfo.pieRadius.split(',') : '55%';
        selectOptionData.series[0].pieRadius = echartInfo.isRadius? echartInfo.pieRadius : '45%,55%';
        selectOptionData.series[0].roseType=echartInfo.roseType?'radius':"";
        selectOptionData.series[0].minAngle = echartInfo.minAngle;
        selectOptionData.series[0].label.position = echartInfo.pieLabelPosition;
        selectOptionData.series[0].notCount = echartInfo.notCount;
        selectOptionData.series[0].autoSort = echartInfo.autoSort;
        //数值显示
        selectOptionData.series[0].label.show = echartInfo.numerShow;
        selectOptionData.series[0].label.textStyle.fontSize = echartInfo.numerTextSize;
        selectOptionData.series[0].label.textStyle.color = echartInfo.numerTextcol;
        selectOptionData.series[0].label.textStyle.fontWeight = echartInfo.numerTextweig;
        //轴边距
        selectOptionData.series[0].left = echartInfo.gridLeft;
        selectOptionData.series[0].top = echartInfo.gridTop;
        selectOptionData.series[0].right = echartInfo.gridRight;
        selectOptionData.series[0].bottom = echartInfo.gridBottom;
    }
    if (charType === 'bar'|| charType === 'line' || charType === 'scatter'){
        //多数据多图表处理
        selectOptionData.series.forEach(item=>{
            //柱体样式
            if(item.type=='bar'){
                item.barWidth = echartInfo.barWidth;
                item.barMinHeight = echartInfo.barMinHeight;
                item.itemStyle.normal.barBorderRadius = echartInfo.barRadius;
                item.itemStyle.normal.color = echartInfo.seriesItemNorCol;
                if(vm.isMultiChart){
                    echartInfo.legendData.forEach((name,index)=>{
                        if(name === item.name){
                            if(echartInfo.colorMatchData[index])
                            item.itemStyle.normal.color = echartInfo.colorMatchData[index].color1;
                        }
                    })
                }
            }
            //折线样式
            if(item.type=='line') {
                item.step = echartInfo.step; //阶梯线图
                item.showSymbol = echartInfo.showSymbol;//标记点
                item.symbolSize = echartInfo.symbolSize;// 设置折线上圆点大小
                item.smooth = echartInfo.smooth;//平滑曲线
                item.lineStyle.width = echartInfo.linewidth;// 设置线宽
                item.lineStyle.color = echartInfo.seriesLinemNorCol;
                if(vm.isMultiChart){
                    echartInfo.legendData.forEach((name,index)=>{
                        if(name === item.name){
                            if(echartInfo.colorMatchData[index])
                            item.lineStyle.color = echartInfo.colorMatchData[index].color1;
                        }
                    })
                }
            }
            if(item.type === 'scatter'){
                item.itemStyle.normal.color = echartInfo.seriesItemNorCol;
                item.symbolSize = echartInfo.symbolSize;// 设置折线上圆点大小
            }
        })
        //X轴样式
        selectOptionData.xAxis.show = echartInfo.xaxisShow;
        selectOptionData.xAxis.name = echartInfo.xaxisText;
        selectOptionData.xAxis.splitLine.show = echartInfo.xaxisLine;
        selectOptionData.xAxis.splitLine.lineStyle.color = echartInfo.xaxisLinecol;
        selectOptionData.xAxis.axisLabel.textStyle.fontSize = echartInfo.xaxisTextsize;
        selectOptionData.xAxis.axisLabel.rotate = echartInfo.axisLabelRotate;
        //Y轴样式
        if(typeJudge(selectOptionData.yAxis,'Array')){
            selectOptionData.yAxis[0].splitLine.show = echartInfo.yaxisLine; //多y轴分割线显示设置
            selectOptionData.yAxis.forEach((item,index)=>{
                item.show = echartInfo.yaxisShow;
                item.name = echartInfo.yaxisText.indexOf(",")!=-1?echartInfo.yaxisText.split(",")[index]:echartInfo.yaxisText;
                item.splitLine.lineStyle.color = echartInfo.yaxisLinecol;
                item.axisLabel.textStyle.fontSize = echartInfo.yaxisTextsize;
                //y轴线和字体颜色
                item.axisLabel.textStyle.color = echartInfo.axisLabelTextCol;
                item.axisLine.lineStyle.color = echartInfo.axisLineLineCol;
            })
        }else{
            selectOptionData.yAxis.show = echartInfo.yaxisShow;
            selectOptionData.yAxis.name = echartInfo.yaxisText;
            selectOptionData.yAxis.splitLine.show = echartInfo.yaxisLine;
            selectOptionData.yAxis.splitLine.lineStyle.color = echartInfo.yaxisLinecol;
            selectOptionData.yAxis.axisLabel.textStyle.fontSize = echartInfo.yaxisTextsize;
            //y轴线和字体颜色
            selectOptionData.yAxis.axisLabel.textStyle.color = echartInfo.axisLabelTextCol;
            selectOptionData.yAxis.axisLine.lineStyle.color = echartInfo.axisLineLineCol;
        }
        //数值显示
        selectOptionData.series.forEach(item=>{
            item.itemStyle.normal.label.show = echartInfo.numerShow;
            item.itemStyle.normal.label.textStyle.fontSize = echartInfo.numerTextSize;
            item.itemStyle.normal.label.textStyle.color = echartInfo.numerTextcol;
            item.itemStyle.normal.label.textStyle.fontWeight = echartInfo.numerTextweig;
        });
        //图例文字
        if(selectOptionData.series.length==1){
            selectOptionData.legend.data[0] = echartInfo.yaxisText;
            selectOptionData.series[0].name = echartInfo.yaxisText;
        }else{
            if(echartInfo.legendData.length>0){
                selectOptionData.legend.data= echartInfo.legendData
            }
        }
        //轴边距
        selectOptionData.grid.left = echartInfo.gridLeft;
        selectOptionData.grid.top = echartInfo.gridTop;
        selectOptionData.grid.right = echartInfo.gridRight;
        selectOptionData.grid.bottom = echartInfo.gridBottom;
        //轴线和字体颜色
        selectOptionData.xAxis.axisLabel.textStyle.color = echartInfo.axisLabelTextCol;
        selectOptionData.xAxis.axisLine.lineStyle.color = echartInfo.axisLineLineCol;
    }
    if(charType === 'map'){
        //区域线的宽度、颜色、区域颜色
        selectOptionData.geo.zoom=echartInfo.scale;
        selectOptionData.geo.label.fontSize=echartInfo.xaxisTextsize;
        selectOptionData.geo.label.color=echartInfo.numerTextcol;
        selectOptionData.geo.emphasis.label.color=echartInfo.numerTextHighCol;
        selectOptionData.geo.itemStyle.borderWidth=echartInfo.borderWidth;
        selectOptionData.geo.itemStyle.areaColor=echartInfo.areaCol;
        selectOptionData.geo.emphasis.itemStyle.areaColor=echartInfo.areaHighCol;
        selectOptionData.geo.itemStyle.borderColor=echartInfo.borderCol;
        selectOptionData.geo.left = echartInfo.gridLeft;
        selectOptionData.geo.top = echartInfo.gridTop;
        selectOptionData.geo.right = echartInfo.gridRight;
        selectOptionData.geo.bottom = echartInfo.gridBottom;
        return false;
    }
    //提示框
    selectOptionData.tooltip.show = echartInfo.tooltipShow;
    selectOptionData.tooltip.textStyle.fontSize = echartInfo.tooltipTextSize;
    selectOptionData.tooltip.textStyle.color = echartInfo.tooltipTextcol;
    //图例
    selectOptionData.legend.show = echartInfo.legendShow;
    //selectOptionData.legend.itemWidth = echartInfo.legendItemWidth;
    selectOptionData.legend.top = echartInfo.legendTop;
    selectOptionData.legend.left = echartInfo.legendLeft;
    selectOptionData.legend.orient = echartInfo.legendOrient;
    if(echartInfo.legendTextcol)
    selectOptionData.legend.textStyle.color = echartInfo.legendTextcol;
    selectOptionData.legend.textStyle.fontSize = echartInfo.legendTextsize;
}

// addDrag();
//判断数据类型
function typeJudge(o,type){
    return Object.prototype.toString.call(o).slice(8, -1) === type
}

function addChartModalSelectedStyle() {
    let chartArray = document.querySelectorAll('.chart-modal-content .ivu-col');
    console.log('chartArray',chartArray)
    for(var a=0;a<chartArray.length;a++){
        var chart = chartArray[a];
        chart.onmouseover = function(e){
            var tar = e.target
            var activeDiv;
            if(tar.tagName === 'IMG'){
                activeDiv = tar.parentNode;
            }else{
                var col = tar.className
                if(col && col.indexOf('ivu-col')>=0) {
                    activeDiv = tar.querySelector('div')
                }
            }
            if(activeDiv&&activeDiv.parentNode.className.indexOf('no-allowed')>=0){
                return;
            }
            if(activeDiv){
                activeDiv.className = activeDiv.className+ ' chart-active'
            }
        }
        chart.onmouseout = function(e){
            var tar = e.target
            var activeDiv;
            if(tar.tagName === 'IMG'){
                activeDiv = tar.parentNode
            }else{
                var col = tar.className
                if(col && col.indexOf('ivu-col')>=0){
                    activeDiv = tar.querySelector('div')
                }
            }
            if(activeDiv&&activeDiv.parentNode.className.indexOf('no-allowed')>=0){
                return;
            }
            if(activeDiv){
                activeDiv.className=activeDiv.className.replace(' chart-active','')
            }
        }
    }
}