axios.interceptors.response.use(
    response => {
        const code = response.data.code;
        if(code===403 || code===500){
            const message = response.data.message;
            if(message){
                let confirMessage = '';
                if(message.includes('Token失效')
                    || message.includes('token不能为空')
                    || message.includes('token非法')
                ){
                    confirMessage = '操作失败，Token失效，请重新登录!';
                }
                if(confirMessage){
                    Vue.prototype.$Modal.warning({
                        title: '登录已过期',
                        content: '很抱歉,登录已过期,请重新登录',
                        onOk: () => {
                            //window.open(window._CONFIG['domianURL'],'_self');
                            window.opener=null;
                            window.open('','_self');
                            window.close();
                        }
                    });
                }
            }
        }

        return response
    },
    error => {
        return Promise.reject(error)
    }
)
