(function($){
    $.extend({
        excelSave:function(data,token,callback,url){
            if(!url){
                url=`${base}/design/report/save`;
            }
            const saveFn=(obj)=>{
                //判断报表是否有分组字段
                const rows = data.rows;
                let groupField="";
                for(let key in rows){
                    if(groupField) break;
                    const cells = rows[key].cells;
                    for(let cellKey in cells){
                        const text = cells[cellKey].text;
                        if(!text) continue;
                        if(text.includes(".group(")){
                            groupField = text.replace(".group","")
                                             .replace("(","")
                                             .replace(")}","").substring(text.indexOf(".group("));
                            break;

                        }
                    }
                }
                if(groupField){
                    data.isGroup=true;
                    data.groupField=groupField;
                }
                if (data.chartList && data.chartList.length > 0){
                    data.chartList.forEach(item=>{
                        if (item.width === 0 || item.height === 0){
                            item.width = "650";
                            item.height = "350";
                        }
                    })
                }
                var dataStr = JSON.stringify({designerObj:obj,...data});
                if ( obj.name != null && obj.name != "" ){
                    $.ajax({
                        type : "POST",
                        contentType: "application/json;charset=UTF-8",
                        url : url,
                        headers:{"X-Access-Token":token},
                        data : dataStr,
                        //请求成功
                        success : function(result) {
                            onbeforeunload="return true";
                            window.location.reload();
                            callback(result);
                        },
                        //请求失败，包含具体的错误信息
                        error : function(e){
                            console.log(e.status);
                            console.log(e.responseText);
                        }
                    });
                }
            }
            vm.handleCreate(saveFn,data);
        },
        excelGet:function(code,token,callback,url){
            if (code != null && code != ""){
                if(!url){
                    url=`${base}/design/report/get/${code}`;
                }
                $.ajax({
                    type : "GET",
                    url : url,
                    headers:{"X-Access-Token":token},
                    //请求成功
                    success : function(result) {
                        if (result.result != "" && result.result != null){
                            callback(result);
                        }
                    },
                    //请求失败，包含具体的错误信息
                    error : function(e){
                        console.log(e.status);
                        console.log(e.responseText);
                    }
                });
            }
        },
        excelView:function(id,requestParam, callback, api = '', url){
            if(!url){
                url=`${view.origin}${base}/design/report/show`;
            }
            $.ajax({
                type : "GET",
                url : url,
                header:"Content-Type: application/json",
                data:{"id":id,"apiUrl":api,"params":JSON.stringify(requestParam)},
                //请求成功
                success : function(result) {
                    callback(result);
                },
                //请求失败，包含具体的错误信息
                error : function(e){
                    console.log(e.status);
                    console.log(e.responseText);
                }
            });
        },
        addViewCount:function (id) {
            var url=`${view.origin}${base}/design/report/addViewCount/${id}`;
            $.ajax({
                type : "POST",
                url : url,
                header:"Content-Type: application/json",
                //请求成功
                success : function() {
                    console.log('浏览新增1');
                },
                //请求失败，包含具体的错误信息
                error : function(e){
                    console.log(e.status);
                    console.log(e.responseText);
                }
            });
        },
        checkParam: function (id, callback) {
            var url=`${view.origin}${base}/design/report/checkParam/${id}`;
            $.ajax({
                type : "GET",
                url : url,
                header:"Content-Type: application/json",
                //请求成功
                success : function(result) {
                    callback(result);
                },
                //请求失败，包含具体的错误信息
                error : function(e){
                    console.log(e.status);
                    console.log(e.responseText);
                }
            });
        },
        qurestSql:function (dataAllocation,token,callback) {
            let url = `${base}/design/report/qurestSql`;
            let apiSelectId = dataAllocation.selectId;
            $.ajax({
                url: url,
                type: "GET",
                async: false,
                headers: {"X-Access-Token": token},
                data: {"apiSelectId": apiSelectId},
                success: (result) => {
                    callback(result);
                }
            });
        },
        qurestApi:function(dataAllocation,token,callback){
            let url = `${base}/design/report/qurestApi`;
            let apiSelectId = dataAllocation.selectId;
            $.ajax({
                url: url,
                type: "GET",
                async: false,
                headers: {"X-Access-Token": token},
                data: {"apiSelectId": apiSelectId},
                success: (result) => {
                    callback(result);
                }
            });
        }


    });
})(jQuery);

function dataURLtoFile (dataurl, filename) {
    var arr = dataurl.split(','),
        mime = arr[0].match(/:(.*?);/)[1],
        bstr = atob(arr[1]),
        n = bstr.length,
        u8arr = new Uint8Array(n);
    while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
    }
    return new File([u8arr], filename, { type: mime });
}
