/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.ai.prop;

import dev.langchain4j.model.openai.OpenAiChatModelName;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="jeecg.ai-chat")
public class AiChatProperties {
    public static final String PREFIX = "jeecg.ai-chat";
    private boolean enabled = false;
    private String provider = "OPENAI";
    private Credential credential = new Credential();
    private String apiKey = "";
    private String model = OpenAiChatModelName.GPT_3_5_TURBO.toString();
    private String apiHost = "https://api.openai.com/v1/";
    private Metadata metadata = new Metadata();
    private int timeout = this.metadata.getTimeout();
    private Proxy proxy;

    public String getApiKey() {
        return this.credential.getApiKey();
    }

    public void setApiKey(String apiKey) {
        this.credential.setApiKey(apiKey);
    }

    public int getTimeout() {
        return this.metadata.getTimeout();
    }

    public void setTimeout(int timeout) {
        this.metadata.setTimeout(timeout);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getProvider() {
        return this.provider;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public String getModel() {
        return this.model;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiChatProperties)) {
            return false;
        }
        AiChatProperties other = (AiChatProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        Credential this$credential = this.getCredential();
        Credential other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$apiHost = this.getApiHost();
        String other$apiHost = other.getApiHost();
        if (this$apiHost == null ? other$apiHost != null : !this$apiHost.equals(other$apiHost)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Proxy this$proxy = this.getProxy();
        Proxy other$proxy = other.getProxy();
        return !(this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AiChatProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getTimeout();
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        Credential $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $apiHost = this.getApiHost();
        result = result * 59 + ($apiHost == null ? 43 : $apiHost.hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Proxy $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        return result;
    }

    public String toString() {
        return "AiChatProperties(enabled=" + this.isEnabled() + ", provider=" + this.getProvider() + ", credential=" + this.getCredential() + ", apiKey=" + this.getApiKey() + ", model=" + this.getModel() + ", apiHost=" + this.getApiHost() + ", metadata=" + this.getMetadata() + ", timeout=" + this.getTimeout() + ", proxy=" + this.getProxy() + ")";
    }

    public static class Metadata {
        private int timeout = 60;

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getTimeout() == other.getTimeout();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Metadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTimeout();
            return result;
        }

        public String toString() {
            return "AiChatProperties.Metadata(timeout=" + this.getTimeout() + ")";
        }
    }

    public static class Credential {
        private String apiKey = "";
        private String secretKey;

        public String getApiKey() {
            return this.apiKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credential)) {
                return false;
            }
            Credential other = (Credential)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$apiKey = this.getApiKey();
            String other$apiKey = other.getApiKey();
            if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            return !(this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Credential;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $apiKey = this.getApiKey();
            result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            return result;
        }

        public String toString() {
            return "AiChatProperties.Credential(apiKey=" + this.getApiKey() + ", secretKey=" + this.getSecretKey() + ")";
        }
    }

    public static class Proxy {
        String host;
        Integer port;

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Proxy)) {
                return false;
            }
            Proxy other = (Proxy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Proxy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "AiChatProperties.Proxy(host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }
    }
}

