/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.firewall.interceptor;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.jmreport.common.annotation.JimuNoLoginRequired;
import org.jeecg.modules.jmreport.common.annotation.RequiresPermissions;
import org.jeecg.modules.jmreport.common.annotation.RequiresRoles;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.e;
import org.jeecg.modules.jmreport.common.util.m;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.config.firewall.interceptor.handlers.JmIPermissionsVerifyHandler;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportShareService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class JimuReportTokenInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JimuReportTokenInterceptor.class);
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    @Autowired
    private JmReportBaseConfig jmBaseConfig;
    @Autowired
    private IJimuReportShareService jimuReportShareService;
    @Autowired
    private JmIPermissionsVerifyHandler permissionsVerifyHandler;
    private static String NO_PERMISSION_PROMPT_MSG = "\u6743\u9650\u4e0d\u8db3\uff0c\u8bf7\u5347\u7ea7\u4f1a\u5458\uff01";
    private static final Integer GEN_TEST_DATA_CODE = 402;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        String string = e.j(request.getRequestURI().substring(request.getContextPath().length()));
        log.info("==========\u63a5\u6536\u5230\u8bf7\u6c42:[{}],ip:[{}]==========", (Object)string, (Object)JimuReportTokenInterceptor.getIpAddr(request));
        log.debug("JimuReportInterceptor check requestPath = " + string);
        int n2 = 500;
        if (m.a(string)) {
            log.error("\u8bf7\u6ce8\u610f\uff0c\u8bf7\u6c42\u5730\u5740\u6709xss\u653b\u51fb\u98ce\u9669\uff01" + string);
            this.backError(response, "\u8bf7\u6c42\u5730\u5740\u6709xss\u653b\u51fb\u98ce\u9669!", n2);
            return false;
        }
        String string2 = this.jmBaseConfig.getCustomPrePath();
        log.debug("customPrePath: {}", (Object)string2);
        if (OkConvertUtils.isNotEmpty(string2) && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        request.setAttribute("customPrePath", (Object)string2);
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        if (string.contains("/jmreport/shareView/")) {
            return true;
        }
        JimuNoLoginRequired jimuNoLoginRequired = method.getAnnotation(JimuNoLoginRequired.class);
        if (OkConvertUtils.isNotEmpty(jimuNoLoginRequired)) {
            return true;
        }
        boolean bl = false;
        try {
            bl = this.verifyToken(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            if (this.jimuReportShareService.isSharingEffective(string, request)) {
                return true;
            }
            String string3 = request.getParameter("previousPage");
            if (OkConvertUtils.isNotEmpty(string3)) {
                if (!string.startsWith("/jmreport/view")) {
                    log.error("\u4e0d\u88ab\u5141\u8bb8\u7684\u94bb\u53d6\u8bf7\u6c42\u5730\u5740(" + request.getMethod() + ")\uff1a" + string);
                    this.backError(response, "Token\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6743\u9650\u8bbf\u95ee\uff01", n2);
                    return false;
                }
                if (this.jimuReportShareService.isShareingToken(string, request)) {
                    return true;
                }
                log.error("\u5206\u4eab\u94fe\u63a5\u5931\u6548\u6216\u5206\u4eabtoken\u4e0d\u5339\u914d(" + request.getMethod() + ")\uff1a" + string);
                this.backError(response, "\u5206\u4eab\u94fe\u63a5\u5931\u6548\u6216\u5206\u4eabtoken\u4e0d\u5339\u914d\uff0c\u7981\u6b62\u94bb\u53d6!", n2);
                return false;
            }
            log.error("Token\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + string);
            this.backError(response, "Token\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6743\u9650\u8bbf\u95ee\uff01", n2);
            return false;
        }
        RequiresRoles requiresRoles = method.getAnnotation(RequiresRoles.class);
        Result<?> result = this.permissionsVerifyHandler.verifyRoles(request, requiresRoles, string);
        if (OkConvertUtils.isNotEmpty(result) && !result.isSuccess()) {
            this.backError(response, OkConvertUtils.getString(result.getMessage(), "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650\uff01"), OkConvertUtils.getInt(result.getCode(), n2));
            return false;
        }
        RequiresPermissions requiresPermissions = method.getAnnotation(RequiresPermissions.class);
        Result<?> result2 = this.permissionsVerifyHandler.verifyPermissions(request, requiresPermissions);
        if (OkConvertUtils.isNotEmpty(result2) && !result2.isSuccess()) {
            this.backError(response, OkConvertUtils.getString(result2.getMessage(), "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650\uff01"), OkConvertUtils.getInt(result2.getCode(), n2));
            return false;
        }
        return true;
    }

    private boolean verifyToken(HttpServletRequest request) {
        return this.jimuTokenClient.verifyToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backError(HttpServletResponse response, String msg, Integer msgCode) {
        PrintWriter printWriter = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setHeader("auth", "fail");
        try {
            printWriter = response.getWriter();
            Result<Object> result = Result.error(msgCode, msg);
            printWriter.print(JSON.toJSON(result));
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage());
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static String getIpAddr(HttpServletRequest request) {
        String string = null;
        try {
            string = request.getHeader("x-forwarded-for");
            if (StringUtils.isEmpty((CharSequence)string) || "unknown".equalsIgnoreCase(string)) {
                string = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)string) || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
                string = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)string) || "unknown".equalsIgnoreCase(string)) {
                string = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StringUtils.isEmpty((CharSequence)string) || "unknown".equalsIgnoreCase(string)) {
                string = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (StringUtils.isEmpty((CharSequence)string) || "unknown".equalsIgnoreCase(string)) {
                string = request.getRemoteAddr();
            }
        }
        catch (Exception exception) {
            log.error("IPUtils ERROR ", (Throwable)exception);
        }
        return string;
    }
}

