/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import lombok.Generated;
import org.jeecg.modules.jmreport.common.constant.a;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean success = true;
    private String message = "";
    private Integer code = 0;
    private T result;
    private long timestamp = System.currentTimeMillis();
    @JsonIgnore
    private String onlTable;

    public Result<T> success(String message) {
        this.message = message;
        this.code = a.f;
        this.success = true;
        return this;
    }

    public static <T> Result<T> OK() {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(a.f);
        return result;
    }

    public static <T> Result<T> OK(T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(a.f);
        result.setResult(data);
        return result;
    }

    public static <T> Result<T> OK(String msg, T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(a.f);
        result.setMessage(msg);
        result.setResult(data);
        return result;
    }

    public static <T> Result<T> FAIL(String msg, T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(false);
        result.setCode(a.f);
        result.setMessage(msg);
        result.setResult(data);
        return result;
    }

    public static Result<Object> error(String msg) {
        return Result.error(a.e, msg);
    }

    public static Result<Object> error(int code, String msg) {
        Result<Object> result = new Result<Object>();
        result.setCode(code);
        result.setMessage(msg);
        result.setSuccess(false);
        return result;
    }

    public Result<T> error500(String message) {
        this.message = message;
        this.code = a.e;
        this.success = false;
        return this;
    }

    public static Result<Object> noauth(String msg) {
        return Result.error(a.g, msg);
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Integer getCode() {
        return this.code;
    }

    @Generated
    public T getResult() {
        return this.result;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getOnlTable() {
        return this.onlTable;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setCode(Integer code) {
        this.code = code;
    }

    @Generated
    public void setResult(T result) {
        this.result = result;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonIgnore
    @Generated
    public void setOnlTable(String onlTable) {
        this.onlTable = onlTable;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Result)) {
            return false;
        }
        Result result = (Result)o2;
        if (!result.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != result.isSuccess()) {
            return false;
        }
        if (this.getTimestamp() != result.getTimestamp()) {
            return false;
        }
        Integer n2 = this.getCode();
        Integer n3 = result.getCode();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        String string = this.getMessage();
        String string2 = result.getMessage();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        T t = this.getResult();
        T t2 = result.getResult();
        if (t == null ? t2 != null : !t.equals(t2)) {
            return false;
        }
        String string3 = this.getOnlTable();
        String string4 = result.getOnlTable();
        return !(string3 == null ? string4 != null : !string3.equals(string4));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    @Generated
    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        n3 = n3 * 59 + (this.isSuccess() ? 79 : 97);
        long l2 = this.getTimestamp();
        n3 = n3 * 59 + (int)(l2 >>> 32 ^ l2);
        Integer n4 = this.getCode();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        String string = this.getMessage();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        T t = this.getResult();
        n3 = n3 * 59 + (t == null ? 43 : t.hashCode());
        String string2 = this.getOnlTable();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        return n3;
    }

    @Generated
    public String toString() {
        return "Result(success=" + this.isSuccess() + ", message=" + this.getMessage() + ", code=" + this.getCode() + ", result=" + this.getResult() + ", timestamp=" + this.getTimestamp() + ", onlTable=" + this.getOnlTable() + ")";
    }
}

