/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.NoContentException;

public class NoContentInputStreamDelegate
extends InputStream {
    protected InputStream delegate;
    protected boolean hasRead;

    public NoContentInputStreamDelegate(InputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read() throws IOException {
        int amount = this.delegate.read();
        return this.check(amount);
    }

    private int check(int amount) throws NoContentException {
        if (amount > -1) {
            this.hasRead = true;
        } else if (!this.hasRead) {
            throw new NoContentException("No content");
        }
        return amount;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int amount = this.delegate.read(b);
        return this.check(amount);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int amount = this.delegate.read(b, off, len);
        return this.check(amount);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

