/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.node;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.ScriptTask;
import org.flowable.bpmn.model.ServiceTask;
import org.jeecg.modules.extbpm.process.adapter.BpmnCreator;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildNode;
import org.jeecg.modules.extbpm.process.adapter.model.ListenerModel;
import org.jeecg.modules.extbpm.process.adapter.node.UserTaskNodeCreator;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNode;

public class TaskNodeCreator {
    public static List<ServiceTask> createServiceTask(List<ChildNode> serviceNodes, List<ExtActProcessNode> extActProcessNodes) {
        ArrayList<ServiceTask> tasks = new ArrayList<ServiceTask>();
        for (ChildNode node : serviceNodes) {
            ExtActProcessNode extActProcessNode = new ExtActProcessNode();
            ChildAttr childAttr = node.getAttr();
            String id = node.getId();
            String name = node.getName();
            ServiceTask serviceTask = new ServiceTask();
            serviceTask.setId(id);
            serviceTask.setName(name);
            extActProcessNode.setProcessNodeCode(id);
            extActProcessNode.setProcessNodeName(name);
            if (ObjectUtils.isNotEmpty((Object)childAttr)) {
                serviceTask.setResultVariableName(childAttr.getResultVariable());
                serviceTask.setImplementationType(childAttr.getExpressionType());
                serviceTask.setImplementation(childAttr.getExpressionValue());
                serviceTask.setDocumentation(childAttr.getDescription());
                extActProcessNode.setNodeConfigJson(JSON.toJSONString((Object)childAttr));
            }
            tasks.add(serviceTask);
            extActProcessNodes.add(extActProcessNode);
        }
        return tasks;
    }

    public static List<ScriptTask> createScripTask(List<ChildNode> serviceNodes, List<ExtActProcessNode> extActProcessNodes) {
        ArrayList<ScriptTask> tasks = new ArrayList<ScriptTask>();
        for (ChildNode node : serviceNodes) {
            ExtActProcessNode extActProcessNode = new ExtActProcessNode();
            String id = node.getId();
            String name = node.getName();
            ChildAttr childAttr = node.getAttr();
            ScriptTask scriptTask = new ScriptTask();
            scriptTask.setId(id);
            scriptTask.setName(name);
            extActProcessNode.setProcessNodeCode(id);
            extActProcessNode.setProcessNodeName(name);
            if (ObjectUtils.isNotEmpty((Object)childAttr)) {
                scriptTask.setScript(childAttr.getScriptContent());
                scriptTask.setScriptFormat(childAttr.getScriptFormat());
                scriptTask.setDocumentation(childAttr.getDescription());
                extActProcessNode.setNodeConfigJson(JSON.toJSONString((Object)childAttr));
            }
            tasks.add(scriptTask);
            extActProcessNodes.add(extActProcessNode);
        }
        return tasks;
    }

    public static List<ServiceTask> createMessageTask(List<ChildNode> messageNodes, List<ExtActProcessNode> extActProcessNodes) {
        ArrayList<ServiceTask> tasks = new ArrayList<ServiceTask>();
        for (ChildNode node : messageNodes) {
            ServiceTask serviceTask = new ServiceTask();
            ExtActProcessNode extActProcessNode = new ExtActProcessNode();
            String id = node.getId();
            String name = node.getName();
            ChildAttr childAttr = node.getAttr();
            serviceTask.setId(id);
            serviceTask.setName(name);
            extActProcessNode.setProcessNodeCode(id);
            extActProcessNode.setProcessNodeName(name);
            if (ObjectUtils.isNotEmpty((Object)childAttr)) {
                serviceTask.setResultVariableName(childAttr.getResultVariable());
                serviceTask.setImplementationType(childAttr.getExpressionType());
                serviceTask.setImplementation(childAttr.getExpressionValue());
                serviceTask.setDocumentation(childAttr.getDescription());
                extActProcessNode.setNodeConfigJson(JSON.toJSONString((Object)childAttr));
            }
            tasks.add(serviceTask);
            extActProcessNodes.add(extActProcessNode);
        }
        return tasks;
    }

    public static List<CallActivity> createCallActivity(List<ChildNode> serviceNodes) {
        ArrayList<CallActivity> callActivities = new ArrayList<CallActivity>();
        for (ChildNode node : serviceNodes) {
            ChildAttr childAttr = node.getAttr();
            Integer approvalMode = node.getApprovalMode();
            Boolean isMuti = childAttr.getIsMulti();
            List<IOParameter> inVariableModels = node.getInVariableModels();
            List<IOParameter> outVariableModels = node.getOutVariableModels();
            CallActivity callActivity = new CallActivity();
            callActivity.setId(node.getId());
            callActivity.setName(node.getName());
            if (ObjectUtils.isNotEmpty((Object)childAttr)) {
                MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics;
                callActivity.setCalledElement(childAttr.getCalledElement());
                if (!UserTaskNodeCreator.COUNTER_SIGN.equals(approvalMode)) {
                    multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
                    multiInstanceLoopCharacteristics.setLoopCardinality(childAttr.getLoopCardinality());
                    multiInstanceLoopCharacteristics.setElementVariable(childAttr.getElementVariable());
                    multiInstanceLoopCharacteristics.setCompletionCondition(childAttr.getCompletionCondition());
                    multiInstanceLoopCharacteristics.setSequential(childAttr.getIsSequential().booleanValue());
                    multiInstanceLoopCharacteristics.setInputDataItem(childAttr.getCollection());
                    callActivity.setLoopCharacteristics(multiInstanceLoopCharacteristics);
                }
                if (ObjectUtils.isNotEmpty((Object)isMuti) && isMuti.booleanValue()) {
                    multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
                    multiInstanceLoopCharacteristics.setInputDataItem("${flowUtil.stringToList(assigneeDataIdList)}");
                    multiInstanceLoopCharacteristics.setElementVariable("handleDataId");
                    callActivity.setLoopCharacteristics(multiInstanceLoopCharacteristics);
                }
            }
            if (ObjectUtils.isNotEmpty(inVariableModels)) {
                callActivity.setInParameters(inVariableModels);
            }
            if (ObjectUtils.isNotEmpty(outVariableModels)) {
                callActivity.setOutParameters(outVariableModels);
            }
            callActivities.add(callActivity);
            TaskNodeCreator.setListener(callActivity, node);
        }
        return callActivities;
    }

    private static void setListener(CallActivity callActivity, ChildNode node) {
        List<ListenerModel> listenerModel = node.getListenerData();
        if (ObjectUtils.isNotEmpty(listenerModel)) {
            ArrayList<FlowableListener> executionListeners = new ArrayList<FlowableListener>();
            for (ListenerModel listener : listenerModel) {
                FlowableListener activitiListener = BpmnCreator.createActivitiListener(listener);
                executionListeners.add(activitiListener);
            }
            callActivity.setExecutionListeners(executionListeners);
        }
    }
}

