/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.mq.utils;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.bson.Document;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.ProcessInstance;
import org.jeecg.common.desform.vo.DesignFormDataVo;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.bpm.cmd.CustomTimeStartJobCmd;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.entity.ConditionGroup;
import org.jeecg.modules.extbpm.process.adapter.entity.Conditions;
import org.jeecg.modules.extbpm.process.adapter.enums.SystemVariableEnums;
import org.jeecg.modules.extbpm.process.adapter.mapper.FlowTimerJobMapper;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component(value="minFlowUtils")
public class MinFlowUtils {
    private static final Logger log = LoggerFactory.getLogger(MinFlowUtils.class);
    @Autowired
    public MongoTemplate mongoTemplate;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ManagementService managementService;
    @Autowired
    private FlowTimerJobMapper flowTimerJobMapper;

    public DesformSuperQuery getDesformSuperQuery(String queryCondition) {
        JSONArray jsonArray;
        DesformSuperQuery desformSuperQuery = new DesformSuperQuery();
        if (ObjectUtils.isNotEmpty((Object)queryCondition) && ObjectUtils.isNotEmpty((Object)(jsonArray = JSONArray.parseArray((String)queryCondition)))) {
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            String matchType = StringUtil.isEmpty((String)jsonObject.getString("matchType")) ? MatchTypeEnum.AND.name() : jsonObject.getString("matchType");
            String queryItems = jsonObject.getString("queryItems");
            List superQueryItems = JSONArray.parseArray((String)queryItems, SuperQueryItem.class);
            if (ObjectUtils.isNotEmpty((Object)superQueryItems) && ObjectUtils.isNotEmpty(superQueryItems.get(0))) {
                desformSuperQuery.setMatchType(MatchTypeEnum.getByValue((String)matchType));
                desformSuperQuery.setQueryItems(superQueryItems);
            }
            return desformSuperQuery;
        }
        return desformSuperQuery;
    }

    public void replaceStartCondition(String formKey, String dataId, DesformSuperQuery desformSuperQuery) {
        List queryItems;
        if (ObjectUtils.isNotEmpty((Object)desformSuperQuery) && ObjectUtils.isNotEmpty((Object)(queryItems = desformSuperQuery.getQueryItems()))) {
            for (SuperQueryItem queryItem : queryItems) {
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)queryItem.getVal());
                    if (!ObjectUtils.isNotEmpty((Object)jsonObject)) continue;
                    String formNodeType = jsonObject.getString("formNodeType");
                    if (formNodeType.equals("system")) {
                        String variableValue = jsonObject.getString("variableValue");
                        if (variableValue.equals(SystemVariableEnums.nowDate.name())) {
                            queryItem.setVal(DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd"));
                        }
                        if (variableValue.equals(SystemVariableEnums.second.name())) {
                            queryItem.setVal(DateUtils.getDate().getTime() + "");
                        }
                        if (variableValue.equals(SystemVariableEnums.millisecond.name())) {
                            long time = System.currentTimeMillis();
                            queryItem.setVal(time + "");
                        }
                        if (!variableValue.equals(SystemVariableEnums.dataSourceId.name())) continue;
                        queryItem.setVal(dataId);
                        continue;
                    }
                    DesignFormData designFormData = this.getDesignFormData(formKey, dataId);
                    if (!ObjectUtils.isNotEmpty((Object)designFormData)) continue;
                    String variableValue = jsonObject.getString("variableValue");
                    JSONObject sourceJsonObject = designFormData.getDesformData();
                    Object value = sourceJsonObject.get((Object)variableValue);
                    if (ObjectUtils.isNotEmpty((Object)value)) {
                        queryItem.setVal(value.toString());
                        continue;
                    }
                    queryItem.setVal("");
                }
                catch (Exception e) {
                    log.info("\u503c\u7c7b\u578b\u4e3aString");
                }
            }
        }
    }

    public void addTimerJob(DesignFormData designFormData, ChildAttr childAttr, String processKey) {
        boolean isAfter;
        String formTableCode = childAttr.getFormTableCode();
        String triggerField = childAttr.getTriggerField();
        Integer executeType = childAttr.getExecuteType();
        Integer plusDate = childAttr.getPlusDate();
        Integer plusDateUnit = childAttr.getPlusDateUnit();
        Integer cycleType = childAttr.getCycleType();
        JSONObject jsonObject = designFormData.getDesformData();
        Date triggerFieldValue = jsonObject.getDate(triggerField);
        String dataId = designFormData.getId();
        Date targetTime = null;
        String repeat = "";
        if (executeType.equals(2)) {
            plusDate = -plusDate.intValue();
        }
        if (executeType.equals(1)) {
            targetTime = triggerFieldValue;
        } else if (ObjectUtils.isNotEmpty((Object)triggerFieldValue)) {
            if (plusDateUnit.equals(1)) {
                targetTime = org.apache.commons.lang3.time.DateUtils.addMinutes((Date)triggerFieldValue, (int)plusDate);
            }
            if (plusDateUnit.equals(2)) {
                targetTime = org.apache.commons.lang3.time.DateUtils.addHours((Date)triggerFieldValue, (int)plusDate);
            }
            if (plusDateUnit.equals(3)) {
                targetTime = org.apache.commons.lang3.time.DateUtils.addDays((Date)triggerFieldValue, (int)plusDate);
            }
        }
        Map timerJob = this.getTimerJob(processKey, dataId);
        if (targetTime != null && ObjectUtils.isEmpty((Object)timerJob) && (isAfter = targetTime.after(DateUtils.getDate()))) {
            if (cycleType.equals(4)) {
                String week = MinFlowUtils.getWeek(targetTime);
                repeat = MessageFormat.format("0 0 1 ? * {0}", week);
            }
            if (cycleType.equals(3)) {
                int day = targetTime.getDate();
                repeat = MessageFormat.format("0 0 1 {0} * ?", day);
            }
            if (cycleType.equals(2)) {
                int month = targetTime.getMonth() + 1;
                int day = targetTime.getDate();
                repeat = MessageFormat.format("0 0 1 {0} {1} ?", day, month);
            }
            this.managementService.executeCommand((Command)new CustomTimeStartJobCmd(processKey, formTableCode, dataId, targetTime, "admin", repeat));
        }
    }

    public Map getTimerJob(String processKey, String dataId) {
        log.info("\u68c0\u6d4b\u5b9a\u65f6\u4efb\u52a1\u662f\u5426\u5b58\u5728getTimerJob,dataId:{} ,processKey:{}", (Object)dataId, (Object)processKey);
        List<Map> mapList = this.flowTimerJobMapper.selectTimerJob(dataId, processKey);
        if (ObjectUtils.isNotEmpty(mapList)) {
            for (Map map : mapList) {
                String data_id;
                String handlerCfg = MapUtil.getStr((Map)map, (Object)"HANDLER_CFG_");
                JSONObject jsonObject = JSONObject.parseObject((String)handlerCfg);
                if (!ObjectUtils.isNotEmpty((Object)jsonObject) || !dataId.equals(data_id = jsonObject.getString("BPM_DATA_ID"))) continue;
                return map;
            }
        }
        return null;
    }

    public static String getWeek(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("E", Locale.ENGLISH);
        String week = sdf.format(date);
        return week.toUpperCase();
    }

    public static String getCondition(List<ConditionGroup> groups) {
        StringBuilder sb = new StringBuilder();
        String content = "";
        sb.append("${");
        int i = 1;
        if (ObjectUtils.isNotEmpty(groups)) {
            for (ConditionGroup group : groups) {
                List<Conditions> conditions;
                int groupSize = groups.size();
                if (groupSize > 1) {
                    sb.append("(");
                }
                if (ObjectUtils.isNotEmpty(conditions = group.getQueryItems())) {
                    int j = 1;
                    for (Conditions c : conditions) {
                        if (!StringUtil.isNotEmpty((String)c.getField())) continue;
                        boolean valIsObj = false;
                        String conditionValue = c.getVal();
                        try {
                            JSONObject.parseObject((String)conditionValue);
                            valIsObj = true;
                        }
                        catch (Exception e) {
                            valIsObj = false;
                        }
                        QueryRuleEnum optType = c.getRule();
                        if (ObjectUtils.isNotEmpty((Object)optType)) {
                            if (optType.equals((Object)"empty")) {
                                sb.append("(" + c.getField());
                                sb.append("==null");
                                sb.append(" || ");
                                sb.append(c.getField());
                                sb.append("==''");
                                sb.append(")");
                            } else if (optType.equals((Object)"not_empty")) {
                                sb.append("(" + c.getField());
                                sb.append("!=null");
                                sb.append(" && ");
                                sb.append(c.getField());
                                sb.append("!=''");
                                sb.append(")");
                            } else {
                                sb.append(c.getField());
                                if (QueryRuleEnum.EQ.equals((Object)optType)) {
                                    sb.append("==");
                                } else {
                                    sb.append(optType.getValue());
                                }
                                if (valIsObj) {
                                    sb.append("@@@" + conditionValue + "###");
                                } else {
                                    String type = c.getType();
                                    if (MinFlowUtils.isNumber(type) || StringUtil.isNumeric((String)conditionValue)) {
                                        sb.append(conditionValue);
                                    } else {
                                        sb.append("'" + conditionValue + "'");
                                    }
                                }
                            }
                        }
                        if (j < conditions.size()) {
                            sb.append(" && ");
                        }
                        ++j;
                    }
                }
                if (groupSize > 1) {
                    sb.append(")");
                }
                if (i < groupSize) {
                    sb.append(" || ");
                }
                ++i;
            }
            sb.append("}");
            content = sb.toString();
            if (content.equals("${}")) {
                content = "";
            }
        }
        return content;
    }

    public static String replaceCondition(String conditionValue, Map<String, Object> params) {
        String text = conditionValue;
        if (conditionValue.contains("@@@")) {
            String conditionText = text.substring(text.indexOf("@@@"), text.indexOf("###") + 3);
            String objText = conditionText.replace("@@@", "").replace("###", "");
            JSONObject jsonObject = JSONObject.parseObject((String)objText);
            if (ObjectUtils.isNotEmpty((Object)jsonObject)) {
                Object value = null;
                String variableValue = jsonObject.getString("variableValue");
                if (StringUtil.isNotEmpty((String)variableValue) && ObjectUtils.isNotEmpty(params)) {
                    value = params.get(variableValue);
                }
                text = ObjectUtils.isNotEmpty(value) ? text.replace(conditionText, "'" + value.toString() + "'") : text.replace(conditionText, "''");
            }
            if (text.contains("@@@")) {
                MinFlowUtils.replaceCondition(text, params);
            }
        }
        return text.replace("${", "").replace("}", "");
    }

    public static boolean isNumber(String type) {
        Object[] numberTypes = new String[]{"number", "money", "switch", "rate", "slider", "date"};
        return ArrayUtil.contains((Object[])numberTypes, (Object)type);
    }

    public DesignFormData getDesignFormData(String formKey, String dataId) {
        DesignFormData designFormData = null;
        Document var3 = (Document)this.mongoTemplate.findById((Object)dataId, Document.class, formKey);
        if (ObjectUtils.isNotEmpty((Object)var3)) {
            designFormData = new DesignFormData(formKey, var3);
        }
        return designFormData;
    }

    public DesignFormDataVo getDesignFormDataVo(DesignFormData designFormData) {
        DesignFormDataVo designFormDataVo = new DesignFormDataVo();
        BeanUtils.copyProperties((Object)designFormData, (Object)designFormDataVo);
        return designFormDataVo;
    }

    public Object getAssigneeUser(Boolean multiple, String executionId, String processInstanceId, String variableContent) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (StringUtil.isNotEmpty((String)variableContent)) {
            JSONObject desformData;
            String dataValue;
            String dataId;
            String formDataSourceKey;
            JSONObject jsonObject = JSONObject.parseObject((String)variableContent);
            String formTableCode = jsonObject.getString("formTableCode");
            String fieldName = jsonObject.getString("fieldName");
            String nodeType = jsonObject.getString("nodeType");
            String nodeId = jsonObject.getString("nodeId");
            DesignFormData designFormData = null;
            if (FormTableTypeEnums.table.name().equals(nodeType)) {
                designFormData = this.getStartDesFormData(executionId, formTableCode);
            }
            if (FormTableTypeEnums.search.name().equals(nodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, nodeId);
                dataId = (String)this.runtimeService.getVariable(executionId, formDataSourceKey, String.class);
                designFormData = this.getDesignFormData(formTableCode, dataId);
            }
            if (FormTableTypeEnums.plus.name().equals(nodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", processInstanceId, nodeId);
                dataId = (String)this.runtimeService.getVariable(executionId, formDataSourceKey, String.class);
                designFormData = this.getDesignFormData(formTableCode, dataId);
            }
            if (ObjectUtils.isNotEmpty((Object)designFormData) && ObjectUtils.isNotEmpty((Object)(dataValue = (desformData = designFormData.getDesformData()).getString(fieldName)))) {
                if (dataValue.contains("[")) {
                    JSONArray jsonArray = JSONArray.parseArray((String)dataValue);
                    if (!multiple.booleanValue()) {
                        return jsonArray.get(0);
                    }
                    return JSONArray.parseArray((String)dataValue);
                }
                return dataValue;
            }
        }
        return "";
    }

    public DesignFormData getStartDesFormData(String executionId, String formTableCode) {
        DesignFormData designFormData = null;
        JSONObject data = (JSONObject)this.runtimeService.getVariable(executionId, "BPM_DELETE_DATA", JSONObject.class);
        if (data != null) {
            DesignFormDataVo designFormDataVo = (DesignFormDataVo)JSONObject.toJavaObject((JSON)data, DesignFormDataVo.class);
            designFormData = new DesignFormData();
            BeanUtils.copyProperties((Object)designFormDataVo, (Object)designFormData);
        } else {
            String dataId = (String)this.runtimeService.getVariable(executionId, WorkFlowGlobals.BPM_DATA_ID, String.class);
            designFormData = this.getDesignFormData(formTableCode, dataId);
        }
        return designFormData;
    }

    public static String getCustomCron(ChildAttr childAttr) {
        Integer monthType;
        String value;
        Integer hourValueMax;
        Integer hourValueMin;
        String cron = "0 0 {0} {1} {2} {3}";
        String param0 = "*";
        String param1 = "*";
        String param2 = "*";
        String param3 = "?";
        Integer hourType = oConvertUtils.getInt((Object)childAttr.getHourType(), (int)1);
        if (hourType.equals(2)) {
            hourValueMin = childAttr.getHourValueMin();
            hourValueMax = childAttr.getHourValueMax();
            param0 = hourValueMin + "-" + hourValueMax;
        }
        if (hourType.equals(3)) {
            String value2;
            Object[] hourValues = childAttr.getHourValues();
            param0 = value2 = ArrayUtil.join((Object[])hourValues, (CharSequence)",");
        }
        if (hourType.equals(4)) {
            hourValueMin = childAttr.getHourValueMin();
            hourValueMax = childAttr.getHourValueMax();
            param0 = hourValueMin + "/" + hourValueMax;
        }
        Integer dayValue = oConvertUtils.getInt((Object)childAttr.getDayValue(), (int)1);
        Integer dayOrWeekType = oConvertUtils.getInt((Object)childAttr.getDayOrWeekType(), (int)1);
        if (dayOrWeekType.equals(1)) {
            Integer dayValueMax;
            Integer dayValueMin;
            if (dayValue.equals(2)) {
                dayValueMin = childAttr.getDayValueMin();
                dayValueMax = childAttr.getDayValueMax();
                param1 = dayValueMin + "-" + dayValueMax;
            }
            if (dayValue.equals(3)) {
                Object[] dayValues = childAttr.getDayValues();
                param1 = value = ArrayUtil.join((Object[])dayValues, (CharSequence)",");
            }
            if (dayValue.equals(4)) {
                dayValueMin = childAttr.getDayValueMin();
                dayValueMax = childAttr.getDayValueMax();
                param1 = dayValueMin + "/" + dayValueMax;
            }
            if (dayValue.equals(5)) {
                Integer days = MinFlowUtils.getDaysOfMonth();
                param1 = days + "";
            }
        }
        if (dayOrWeekType.equals(2)) {
            Object[] weekValue = childAttr.getWeekValue();
            value = ArrayUtil.join((Object[])weekValue, (CharSequence)",");
            param1 = "?";
            param3 = value;
        }
        if ((monthType = Integer.valueOf(oConvertUtils.getInt((Object)childAttr.getMonthType(), (int)1))).equals(2)) {
            String value3;
            Object[] monthValues = childAttr.getMonthValues();
            param2 = value3 = ArrayUtil.join((Object[])monthValues, (CharSequence)",");
        }
        return MessageFormat.format(cron, param0, param1, param2, param3);
    }

    private static int getDaysOfMonth() {
        Date date = DateUtils.getDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static void main(String[] args) throws ParseException, InterruptedException {
        CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
        cronTriggerImpl.setCronExpression("0 0 1 ? * MON-FRI");
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.add(1, 2);
        List dates = TriggerUtils.computeFireTimesBetween((OperableTrigger)cronTriggerImpl, null, (Date)now, (Date)calendar.getTime());
        System.out.println(dates.size());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < 7 && i <= 19; ++i) {
            System.out.println("#################" + dateFormat.format((Date)dates.get(i)));
        }
        Date year = DateUtils.parseDate((String)"2023", (String)"yyyy");
        System.out.println(year.getTime());
        Date month = DateUtils.parseDate((String)"2023-01-20 10:23:31", (String)"yyyy-MM-dd HH:mm:ss");
        System.out.println(month.getTime());
    }

    public MinFlowUtils(MongoTemplate mongoTemplate, RuntimeService runtimeService, ManagementService managementService, FlowTimerJobMapper flowTimerJobMapper) {
        this.mongoTemplate = mongoTemplate;
        this.runtimeService = runtimeService;
        this.managementService = managementService;
        this.flowTimerJobMapper = flowTimerJobMapper;
    }
}

