/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.mq.utils;

import com.alibaba.fastjson.JSONObject;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.ProcessInstance;
import org.jeecg.common.util.DateUtils;
import org.jeecg.modules.extbpm.process.adapter.enums.SystemVariableEnums;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="branchUtils")
public class BranchUtils {
    private static final Logger log = LoggerFactory.getLogger(BranchUtils.class);
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IDesignFormDataService designFormDataService;
    private String processInstanceId;
    private String executionId;
    private ProcessInstance processInstance;

    public Boolean getConditionValue(String executionId, String processInstanceId, String conditionValue) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (StringUtil.isNotEmpty((String)conditionValue)) {
            this.processInstance = processInstance;
            this.executionId = executionId;
            this.processInstanceId = processInstanceId;
            String expression = this.replaceCondition(conditionValue);
            if (StringUtil.isNotEmpty((String)expression)) {
                Map variables = this.runtimeService.getVariables(executionId);
                Expression compile = AviatorEvaluator.compile((String)expression);
                Boolean execute = (Boolean)compile.execute(variables);
                return execute;
            }
        }
        return false;
    }

    private String replaceCondition(String conditionValue) {
        String text = conditionValue;
        if (conditionValue.contains("@@@")) {
            String conditionText = text.substring(text.indexOf("@@@"), text.indexOf("###") + 3);
            String objText = conditionText.replace("@@@", "").replace("###", "");
            JSONObject jsonObject = JSONObject.parseObject((String)objText);
            if (ObjectUtils.isNotEmpty((Object)jsonObject)) {
                Object value = this.getValue(jsonObject);
                text = ObjectUtils.isNotEmpty((Object)value) ? text.replace(conditionText, value.toString()) : text.replace(conditionText, "null");
            }
            if (text.contains("@@@")) {
                text = this.replaceCondition(text);
            }
        }
        return text.replace("${", "").replace("}", "");
    }

    public Object getValue(JSONObject jsonObject) {
        String formNodeId = jsonObject.getString("formNodeId");
        String formNodeType = jsonObject.getString("formNodeType");
        String formTableCode = jsonObject.getString("formTableCode");
        String variableValue = jsonObject.getString("variableValue");
        if (formNodeType.equals("system")) {
            Object val = this.getVariableValue(jsonObject);
            return val;
        }
        if (StringUtil.isNotEmpty((String)formNodeType)) {
            String dataId;
            String formDataSourceKey;
            DesignFormData designFormData = null;
            if (FormTableTypeEnums.table.name().equals(formNodeType)) {
                String dataId2 = (String)this.runtimeService.getVariable(this.executionId, WorkFlowGlobals.BPM_DATA_ID, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId2);
            }
            if (FormTableTypeEnums.search.name().equals(formNodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formNodeId);
                dataId = (String)this.runtimeService.getVariable(this.executionId, formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId);
            }
            if (FormTableTypeEnums.plus.name().equals(formNodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, formNodeId);
                dataId = (String)this.runtimeService.getVariable(this.executionId, formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId);
            }
            if (ObjectUtils.isNotEmpty(designFormData)) {
                JSONObject sourceJsonObject = designFormData.getDesformData();
                return sourceJsonObject.get((Object)variableValue);
            }
        }
        return null;
    }

    private Object getVariableValue(JSONObject jsonObject) {
        Object result = "";
        String variableValue = jsonObject.getString("variableValue");
        if (variableValue.equals(SystemVariableEnums.nowDate.name())) {
            result = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd");
        }
        if (variableValue.equals(SystemVariableEnums.second.name())) {
            result = DateUtils.getDate().getTime();
        }
        if (variableValue.equals(SystemVariableEnums.millisecond.name())) {
            result = System.currentTimeMillis();
        }
        if (variableValue.equals(SystemVariableEnums.executeId.name())) {
            result = this.executionId;
        }
        return result;
    }
}

