/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.job;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.engine.RuntimeService;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.DateUtils;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.enums.StartTypeEnums;
import org.jeecg.modules.extbpm.process.adapter.mapper.FlowTimerJobMapper;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.MinFlowUtils;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNode;
import org.jeecg.modules.joa.util.ProcessUtils;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DateFieldTriggerProcessJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(DateFieldTriggerProcessJob.class);
    @Autowired
    private ProcessUtils processUtils;
    @Autowired
    private MinFlowUtils minFlowUtils;
    @Autowired
    public IDesignFormDataService designFormDataService;
    @Autowired
    public RuntimeService runtimeService;
    @Autowired
    private FlowTimerJobMapper flowTimerJobMapper;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info(String.format(" \u8fdb\u5165\u3010\u6309\u65e5\u671f\u5b57\u6bb5\u89e6\u53d1\u6d41\u7a0b\u3011\u68c0\u67e5\u5b9a\u65f6\u4efb\u52a1 DateFieldTriggerProcessJob\uff0c\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp(), new Object[0]));
        List processList = this.processUtils.getExtActProcessByStartType(StartTypeEnums.dateFieldEvent.name());
        if (ObjectUtils.isNotEmpty((Object)processList)) {
            for (ExtActProcess extActProcess : processList) {
                try {
                    ExtActProcessNode extActProcessNode = this.processUtils.getExtActProcessNode(extActProcess.getId(), "start");
                    String nodeConfig = extActProcessNode.getNodeConfigJson();
                    ChildAttr childAttr = (ChildAttr)JSON.parseObject((String)nodeConfig, ChildAttr.class);
                    String formTableCode = childAttr.getFormTableCode();
                    String processKey = extActProcess.getProcessKey();
                    DesformSuperQuery desformSuperQuery = this.getDesformSuperQuery(childAttr);
                    List list = this.designFormDataService.list(formTableCode, desformSuperQuery);
                    if (!ObjectUtils.isNotEmpty((Object)list)) continue;
                    log.info(">>>\u68c0\u67e5\u6309\u65e5\u671f\u5b57\u6bb5\u89e6\u53d1\u6d41\u7a0b\uff1a\u3010" + extActProcess.getProcessName() + "\u3011\uff0c\u7b26\u5408\u6761\u6570\uff1a" + list.size());
                    log.info(">>>\u68c0\u67e5\u6309\u65e5\u671f\u5b57\u6bb5\u89e6\u53d1\u6d41\u7a0b\uff1a\u3010" + extActProcess.getProcessName() + "\u3011\uff0c\u7b26\u5408\u6570\u636e\uff1a" + list.toString());
                    for (DesignFormData designFormData : list) {
                        this.minFlowUtils.addTimerJob(designFormData, childAttr, processKey);
                    }
                }
                catch (Exception e) {
                    log.error(">>>\u68c0\u67e5\u6309\u65e5\u671f\u5b57\u6bb5\u89e6\u53d1\u6d41\u7a0b\uff1a\u3010" + extActProcess.getProcessName() + "\u3011 \u6d41\u7a0bKEY\uff1a" + extActProcess.getProcessKey() + "\uff0c\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
    }

    private DesformSuperQuery getDesformSuperQuery(ChildAttr childAttr) {
        String triggerField = childAttr.getTriggerField();
        Integer executeType = childAttr.getExecuteType();
        Integer plusDate = childAttr.getPlusDate();
        Integer plusDateUnit = childAttr.getPlusDateUnit();
        DesformSuperQuery desformSuperQuery = this.minFlowUtils.getDesformSuperQuery(childAttr.getStartCondition());
        try {
            Date beginDate = DateUtils.parseDate((String)DateUtils.getDate((String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            Date endDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)beginDate, (int)1);
            if (executeType.equals(2) && plusDateUnit.equals(3)) {
                beginDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)beginDate, (int)plusDate);
                endDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)beginDate, (int)(plusDate + 1));
            }
            SuperQueryItem superQueryItemGe = new SuperQueryItem(WidgetTypes.DATE.getType(), triggerField, beginDate.getTime() + "", QueryRuleEnum.GE);
            SuperQueryItem superQueryItemLt = new SuperQueryItem(WidgetTypes.DATE.getType(), triggerField, endDate.getTime() + "", QueryRuleEnum.LT);
            desformSuperQuery.getQueryItems().add(superQueryItemGe);
            desformSuperQuery.getQueryItems().add(superQueryItemLt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return desformSuperQuery;
    }

    public static void main(String[] args) {
        try {
            Date data1 = DateUtils.parseDate((String)"2022-12-24", (String)"yyyy-MM-dd");
            Date data2 = org.apache.commons.lang3.time.DateUtils.addDays((Date)data1, (int)1);
            System.out.println(data1.getTime());
            System.out.println(data2.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

