/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.base;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.desform.vo.DesignFormDataVo;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.enums.SystemVariableEnums;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.MinFlowUtils;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNodeDeployment;
import org.jeecg.modules.joa.util.ProcessUtils;
import org.jeecg.modules.minides.constant.MiniDesConstant;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDataDelegate {
    private static final Logger log = LoggerFactory.getLogger(BaseDataDelegate.class);
    @Autowired
    public IDesignFormDataService designFormDataService;
    @Autowired
    public RedisUtil redisUtil;
    public String processInstanceId;
    public String processKey;
    public ExtActProcess extActProcess;
    public String processId;
    public String activityId;
    public String executeId;
    public String deploymentId;
    public ProcessUtils processUtils;
    public MinFlowUtils minFlowUtils;
    public ExtActProcessNodeDeployment extActProcessNode;
    public ChildAttr childAttr;
    public DelegateExecution delegateExecution;

    public Boolean init(DelegateExecution delegateExecution) {
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        this.delegateExecution = delegateExecution;
        this.processInstanceId = delegateExecution.getProcessInstanceId();
        this.processUtils = (ProcessUtils)SpringContextUtils.getBean((String)"processUtils");
        this.minFlowUtils = (MinFlowUtils)SpringContextUtils.getBean((String)"minFlowUtils");
        this.processKey = executionEntity.getProcessDefinitionKey();
        this.executeId = delegateExecution.getId();
        this.extActProcess = this.processUtils.getExtActProcessByProcessKey(this.processKey);
        this.deploymentId = executionEntity.getDeploymentId();
        if (ObjectUtils.isNotEmpty((Object)this.extActProcess)) {
            this.processId = this.extActProcess.getId();
            this.activityId = executionEntity.getActivityId();
            if (ObjectUtils.isNotEmpty((Object)this.extActProcess)) {
                String nodeConfig;
                this.extActProcessNode = this.processUtils.getExtActProcessNodeDeployment(this.processId, this.deploymentId, this.activityId);
                if (ObjectUtils.isNotEmpty((Object)this.extActProcessNode) && StringUtil.isNotEmpty((String)(nodeConfig = this.extActProcessNode.getNodeConfigJson()))) {
                    this.childAttr = (ChildAttr)JSON.parseObject((String)nodeConfig, ChildAttr.class);
                    return true;
                }
            }
        }
        return false;
    }

    public void executeAdd() {
        if (ObjectUtils.isNotEmpty((Object)this.childAttr)) {
            String formModel = this.childAttr.getFormModel();
            String formTableCode = this.childAttr.getFormTableCode();
            if (StringUtil.isNotEmpty((String)formTableCode)) {
                DesignFormData designFormData = new DesignFormData();
                designFormData.setDesformCode(formTableCode);
                JSONObject formData = JSON.parseObject((String)formModel);
                this.replaceVariable(formData, null);
                designFormData.setDesformData(formData);
                designFormData.setTriggerProcess(false);
                Result result = this.designFormDataService.addOne(designFormData);
                if (result.isSuccess()) {
                    JSONObject object = (JSONObject)result.getResult();
                    String formDataKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, this.activityId);
                    String dataId = object.getString("dataId");
                    log.debug("------------\u6dfb\u52a0\u6570\u636e\u8282\u70b9: {}--------------", (Object)dataId);
                    this.delegateExecution.setVariable(formDataKey, (Object)dataId);
                }
            }
        }
    }

    public DesformSuperQuery initSuperQuery() {
        List queryItems;
        DesformSuperQuery desformSuperQuery = this.minFlowUtils.getDesformSuperQuery(this.childAttr.getSearchFieldGroup());
        if (ObjectUtils.isNotEmpty((Object)desformSuperQuery) && ObjectUtils.isNotEmpty((Object)(queryItems = desformSuperQuery.getQueryItems()))) {
            for (SuperQueryItem queryItem : queryItems) {
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)queryItem.getVal());
                    if (!ObjectUtils.isNotEmpty((Object)jsonObject)) continue;
                    String formNodeType = jsonObject.getString("formNodeType");
                    if (formNodeType.equals("system")) {
                        Object val = this.getVariableValue(jsonObject);
                        if (!ObjectUtils.isNotEmpty((Object)val)) continue;
                        queryItem.setVal(val.toString());
                        continue;
                    }
                    if (formNodeType.equals("variable")) {
                        String variableValue = jsonObject.getString("variableValue");
                        Object val = this.delegateExecution.getVariable(variableValue);
                        if (ObjectUtils.isNotEmpty((Object)val)) {
                            queryItem.setVal(val.toString());
                            continue;
                        }
                        queryItem.setVal("");
                        continue;
                    }
                    Object value = this.getValue(jsonObject, null);
                    if (ObjectUtils.isNotEmpty((Object)value)) {
                        queryItem.setVal(value.toString());
                        continue;
                    }
                    queryItem.setVal("");
                }
                catch (Exception e) {
                    log.info("\u503c\u7c7b\u578b\u4e3aString");
                }
            }
        }
        return desformSuperQuery;
    }

    public List<DesignFormData> executeQuery() {
        String formTableCode;
        if (ObjectUtils.isNotEmpty((Object)this.childAttr) && StringUtil.isNotEmpty((String)(formTableCode = this.childAttr.getFormTableCode()))) {
            List<OrderItem> orderItems;
            DesformSuperQuery desformSuperQuery = this.initSuperQuery();
            Page page = new Page();
            String sortField = this.childAttr.getSortField();
            String sortType = this.childAttr.getSortType();
            Boolean ignoreSortRule = this.childAttr.getIgnoreSortRule();
            if (StringUtil.isNotEmpty((String)sortField) && !ignoreSortRule.booleanValue()) {
                orderItems = BaseDataDelegate.getQueryConditionOrders(sortField, sortType);
                page.setOrders(orderItems);
            } else {
                orderItems = BaseDataDelegate.getQueryOrderByUpdateTime();
                page.setOrders(orderItems);
            }
            Long limitNum = ObjectUtils.isEmpty((Object)this.childAttr.getLimitNum()) ? 100L : this.childAttr.getLimitNum();
            if (ObjectUtils.isNotEmpty((Object)limitNum)) {
                page.setSize(limitNum.longValue());
            }
            Result pageList = this.designFormDataService.pageList(formTableCode, page, desformSuperQuery);
            IPage result = (IPage)pageList.getResult();
            return result.getRecords();
        }
        return null;
    }

    public static List<OrderItem> getQueryConditionOrders(String sortField, String sortType) {
        ArrayList<OrderItem> list = new ArrayList<OrderItem>();
        if ("desc".equals(sortType)) {
            list.add(OrderItem.desc((String)sortField));
        } else {
            list.add(OrderItem.asc((String)sortField));
        }
        return list;
    }

    public static List<OrderItem> getQueryOrderByUpdateTime() {
        ArrayList<OrderItem> list = new ArrayList<OrderItem>();
        list.add(OrderItem.desc((String)"update_time"));
        return list;
    }

    public static List<OrderItem> getQueryConditionOrders(ChildAttr childAttr) {
        String sortField = childAttr.getSortField();
        String sortType = childAttr.getSortType();
        Boolean ignoreSortRule = childAttr.getIgnoreSortRule();
        if (StringUtil.isNotEmpty((String)sortField) && !ignoreSortRule.booleanValue()) {
            return BaseDataDelegate.getQueryConditionOrders(sortField, sortType);
        }
        return BaseDataDelegate.getQueryOrderByUpdateTime();
    }

    public List<DesignFormData> queryRedisData(String formDataSourceKey) {
        List<DesignFormData> records;
        String dataIdKey = (String)this.delegateExecution.getVariable(formDataSourceKey, String.class);
        if (StringUtil.isNotEmpty((String)dataIdKey) && ObjectUtils.isNotEmpty((Object)(records = (List)this.redisUtil.get(dataIdKey)))) {
            Long limitNum = ObjectUtils.isEmpty((Object)this.childAttr.getLimitNum()) ? 100L : this.childAttr.getLimitNum();
            if (records.size() > limitNum.intValue()) {
                records = records.subList(0, limitNum.intValue());
            }
            String sortField = this.childAttr.getSortField();
            String sortType = this.childAttr.getSortType();
            if (StringUtil.isNotEmpty((String)sortField)) {
                records.sort((o1, o2) -> {
                    String object2 = o2.getDesformData().getString(sortField);
                    String object1 = o1.getDesformData().getString(sortField);
                    if (StringUtil.isNotEmpty((String)object2) && StringUtil.isNotEmpty((String)object1)) {
                        if ("desc".equals(sortType)) {
                            return object2.compareTo(object1);
                        }
                        return object1.compareTo(object2);
                    }
                    return -1;
                });
            }
            DesformSuperQuery superQuery = this.initSuperQuery();
            MatchTypeEnum match = superQuery.getMatchType();
            List superQueryItems = superQuery.getQueryItems();
            records = records.stream().filter(item -> {
                JSONObject jsonObject = item.getDesformData();
                int trueCount = 0;
                if (ObjectUtils.isNotEmpty((Object)superQueryItems)) {
                    for (SuperQueryItem superQueryItem : superQueryItems) {
                        String field = superQueryItem.getField();
                        String conditionValue = superQueryItem.getVal();
                        String type = superQueryItem.getType();
                        QueryRuleEnum rule = superQueryItem.getRule();
                        Object fieldValue = jsonObject.get((Object)field);
                        boolean tag = this.ruleValue(conditionValue, fieldValue, type, rule);
                        if (!tag) continue;
                        ++trueCount;
                    }
                }
                if (MatchTypeEnum.AND.equals((Object)match)) {
                    return trueCount == superQueryItems.size();
                }
                return trueCount > 0;
            }).collect(Collectors.toList());
            return records;
        }
        return null;
    }

    public void replaceVariable(JSONObject formData, DesignFormData record) {
        if (ObjectUtils.isNotEmpty((Object)formData)) {
            for (Map.Entry entry : formData.entrySet()) {
                JSONObject jsonObject;
                Object fieldObj = entry.getValue();
                String fieldKey = (String)entry.getKey();
                if (!(fieldObj instanceof JSONObject) || !ObjectUtils.isNotEmpty((Object)(jsonObject = (JSONObject)fieldObj))) continue;
                String formNodeType = jsonObject.getString("formNodeType");
                if (formNodeType.equals("system")) {
                    Object val = this.getVariableValue(jsonObject);
                    formData.put(fieldKey, val);
                    continue;
                }
                if (formNodeType.equals("variable")) {
                    String variableValue = jsonObject.getString("variableValue");
                    Object val = this.delegateExecution.getVariable(variableValue);
                    formData.put(fieldKey, val);
                    continue;
                }
                Object value = this.getValue(jsonObject, record);
                formData.put(fieldKey, value);
            }
        }
    }

    public Object getValue(JSONObject jsonObject, DesignFormData record) {
        String formNodeId = jsonObject.getString("formNodeId");
        String formNodeType = jsonObject.getString("formNodeType");
        String formTableCode = jsonObject.getString("formTableCode");
        String variableValue = jsonObject.getString("variableValue");
        if (StringUtil.isNotEmpty((String)formNodeType)) {
            String dataId;
            String formDataSourceKey;
            String code;
            DesignFormData designFormData = null;
            if (ObjectUtils.isNotEmpty((Object)record) && formTableCode.equals(code = record.getDesformCode())) {
                designFormData = record;
            }
            if (FormTableTypeEnums.table.name().equals(formNodeType) && ObjectUtils.isEmpty(designFormData)) {
                designFormData = this.getStartDesFormData(formTableCode);
            }
            if (FormTableTypeEnums.search.name().equals(formNodeType) && ObjectUtils.isEmpty((Object)designFormData)) {
                formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formNodeId);
                dataId = (String)this.delegateExecution.getVariable(formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId);
            }
            if (FormTableTypeEnums.plus.name().equals(formNodeType) && ObjectUtils.isEmpty((Object)designFormData)) {
                formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, formNodeId);
                dataId = (String)this.delegateExecution.getVariable(formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId);
            }
            if (ObjectUtils.isNotEmpty((Object)designFormData)) {
                JSONObject sourceJsonObject = designFormData.getDesformData();
                return sourceJsonObject.get((Object)variableValue);
            }
        }
        return null;
    }

    private boolean ruleValue(Object conditionValue, Object fieldValue, String type, QueryRuleEnum rule) {
        if (ObjectUtils.isNotEmpty((Object)fieldValue)) {
            if (QueryRuleEnum.EQ.equals((Object)rule) && fieldValue.equals(conditionValue)) {
                return true;
            }
            if (QueryRuleEnum.NE.equals((Object)rule) && !fieldValue.equals(conditionValue)) {
                return true;
            }
            if (QueryRuleEnum.LIKE.equals((Object)rule) && ObjectUtils.isNotEmpty((Object)conditionValue) && fieldValue.toString().indexOf(conditionValue.toString()) != -1) {
                return true;
            }
            if (QueryRuleEnum.LEFT_LIKE.equals((Object)rule) && ObjectUtils.isNotEmpty((Object)conditionValue) && fieldValue.toString().endsWith(conditionValue.toString())) {
                return true;
            }
            if (QueryRuleEnum.RIGHT_LIKE.equals((Object)rule) && ObjectUtils.isNotEmpty((Object)conditionValue) && fieldValue.toString().startsWith(conditionValue.toString())) {
                return true;
            }
            if (QueryRuleEnum.IN.equals((Object)rule) && ObjectUtils.isNotEmpty((Object)conditionValue) && fieldValue.toString().contains(conditionValue.toString())) {
                return true;
            }
            if (QueryRuleEnum.NOT_EMPTY.equals((Object)rule)) {
                return true;
            }
            if (ArrayUtil.contains((Object[])MiniDesConstant.NUMBER_TYPE, (Object)type) && ObjectUtils.isNotEmpty((Object)conditionValue)) {
                Number val2;
                Number val1;
                if ("number".equals(type) || "integer".equals(type)) {
                    val1 = Integer.parseInt(conditionValue.toString());
                    val2 = Integer.parseInt(fieldValue.toString());
                    if (QueryRuleEnum.GT.equals((Object)rule)) {
                        return (Integer)val2 > (Integer)val1;
                    }
                    if (QueryRuleEnum.GE.equals((Object)rule)) {
                        return (Integer)val2 >= (Integer)val1;
                    }
                    if (QueryRuleEnum.LT.equals((Object)rule)) {
                        return (Integer)val2 < (Integer)val1;
                    }
                    if (QueryRuleEnum.LE.equals((Object)rule)) {
                        return (Integer)val2 <= (Integer)val1;
                    }
                }
                if ("money".equals(type)) {
                    val1 = new BigDecimal(conditionValue.toString());
                    val2 = new BigDecimal(fieldValue.toString());
                    if (QueryRuleEnum.GT.equals((Object)rule)) {
                        return ((BigDecimal)val1).compareTo((BigDecimal)val2) == 1;
                    }
                    if (QueryRuleEnum.GE.equals((Object)rule)) {
                        return ((BigDecimal)val1).compareTo((BigDecimal)val2) >= 0;
                    }
                    if (QueryRuleEnum.LT.equals((Object)rule)) {
                        return ((BigDecimal)val1).compareTo((BigDecimal)val2) == -1;
                    }
                    if (QueryRuleEnum.LE.equals((Object)rule)) {
                        return ((BigDecimal)val1).compareTo((BigDecimal)val2) <= 0;
                    }
                }
            }
        } else if (QueryRuleEnum.EMPTY.equals((Object)rule)) {
            return true;
        }
        return false;
    }

    public DesignFormData getStartDesFormData(String formTableCode) {
        DesignFormData designFormData = null;
        JSONObject data = (JSONObject)this.delegateExecution.getVariable("BPM_DELETE_DATA", JSONObject.class);
        if (data != null) {
            DesignFormDataVo designFormDataVo = (DesignFormDataVo)JSONObject.toJavaObject((JSON)data, DesignFormDataVo.class);
            designFormData = new DesignFormData();
            BeanUtils.copyProperties((Object)designFormDataVo, (Object)designFormData);
        } else {
            String dataId = (String)this.delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
            designFormData = this.designFormDataService.getById(formTableCode, dataId);
        }
        return designFormData;
    }

    private Object getVariableValue(JSONObject jsonObject) {
        Object result = "";
        String variableValue = jsonObject.getString("variableValue");
        if (variableValue.equals(SystemVariableEnums.nowDate.name())) {
            result = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd");
        }
        if (variableValue.equals(SystemVariableEnums.second.name())) {
            result = DateUtils.getDate().getTime();
        }
        if (variableValue.equals(SystemVariableEnums.millisecond.name())) {
            result = System.currentTimeMillis();
        }
        if (variableValue.equals(SystemVariableEnums.dataSourceId.name())) {
            result = this.delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
        }
        if (variableValue.equals(SystemVariableEnums.executeId.name())) {
            result = this.executeId;
        }
        return result;
    }
}

