/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.base.BaseDataDelegate;
import org.jeecg.modules.extbpm.process.adapter.enums.SystemVariableEnums;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.minides.enums.GetDataTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="updateRecordDelegate")
public class UpdateRecordDelegate
extends BaseDataDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(UpdateRecordDelegate.class);

    public void execute(DelegateExecution delegateExecution) {
        log.info("---------\u8fdb\u5165\u66f4\u65b0\u8bb0\u5f55-\u670d\u52a1\u8282\u70b9 UpdateRecordDelegate-----------");
        boolean init = this.init(delegateExecution);
        if (init) {
            String dataId3;
            String formDataSourceKey;
            String dataId2;
            String formTableCode = this.childAttr.getFormTableCode();
            String formTableSourceTaskId = this.childAttr.getFormTableSourceTaskId();
            String formTableSourceNodeType = this.childAttr.getFormTableSourceNodeType();
            List<String> dataIds = new ArrayList<String>();
            if (FormTableTypeEnums.table.name().equals(formTableSourceNodeType)) {
                dataId2 = (String)delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
                if (StringUtil.isNotEmpty((String)dataId2)) {
                    dataIds.add(dataId2);
                }
            } else if (FormTableTypeEnums.plus.name().equals(formTableSourceNodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                dataId3 = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                if (StringUtil.isNotEmpty((String)dataId3)) {
                    dataIds.add(dataId3);
                }
            } else if (FormTableTypeEnums.search.name().equals(formTableSourceNodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                dataId3 = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                if (StringUtil.isNotEmpty((String)dataId3)) {
                    dataIds.add(dataId3);
                }
            } else if (FormTableTypeEnums.getMore.name().equals(formTableSourceNodeType)) {
                List records;
                String dataKey;
                Integer getDataType = this.childAttr.getFormTableSourceGetDataType();
                String formDataSourceKey2 = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                if (GetDataTypeEnums.from_redis.getType().equals(getDataType) && StringUtil.isNotEmpty((String)(dataKey = (String)delegateExecution.getVariable(formDataSourceKey2, String.class))) && ObjectUtils.isNotEmpty((Object)(records = (List)this.redisUtil.get(dataKey)))) {
                    dataIds = records.stream().map(DesignFormData::getId).collect(Collectors.toList());
                }
                if (GetDataTypeEnums.from_db.getType().equals(getDataType)) {
                    dataIds = (List)delegateExecution.getVariable(formDataSourceKey2, List.class);
                }
            } else if (FormTableTypeEnums.subEvent.name().equals(formTableSourceNodeType) && StringUtil.isNotEmpty((String)(dataId2 = (String)delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class)))) {
                dataIds.add(dataId2);
            }
            if (ObjectUtils.isNotEmpty(dataIds)) {
                for (String dataId3 : dataIds) {
                    DesignFormData designFormData = this.designFormDataService.getById(formTableCode, dataId3);
                    this.updateData(designFormData, dataId3, formTableCode);
                }
            }
        }
    }

    private void updateData(DesignFormData designFormData, String dataId, String formTableCode) {
        if (ObjectUtils.isNotEmpty((Object)designFormData)) {
            JSONArray jsonArray;
            JSONObject desFormData = designFormData.getDesformData();
            String updateFields = this.childAttr.getUpdateFields();
            if (ObjectUtils.isNotEmpty((Object)desFormData) && ObjectUtils.isNotEmpty((Object)(jsonArray = JSONArray.parseArray((String)updateFields)))) {
                for (Object obj : jsonArray) {
                    JSONObject valueObject;
                    String formNodeType;
                    DesignFormData updateObj = new DesignFormData();
                    JSONObject jsonObject = (JSONObject)obj;
                    String fieldName = jsonObject.getString("field");
                    String type = jsonObject.getString("fieldType");
                    Object fieldValue = jsonObject.get((Object)"val");
                    if (fieldValue instanceof JSONObject && StringUtil.isNotEmpty((String)(formNodeType = (valueObject = (JSONObject)fieldValue).getString("formNodeType")))) {
                        String variableValue;
                        if (formNodeType.equals("system")) {
                            variableValue = valueObject.getString("variableValue");
                            if (variableValue.equals(SystemVariableEnums.nowDate.name())) {
                                fieldValue = DateUtils.formatDate((Date)DateUtils.getDate(), (String)"yyyy-MM-dd");
                            }
                            if (variableValue.equals(SystemVariableEnums.second.name())) {
                                fieldValue = DateUtils.getDate().getTime();
                            }
                            if (variableValue.equals(SystemVariableEnums.millisecond.name())) {
                                fieldValue = System.currentTimeMillis();
                            }
                            if (variableValue.equals(SystemVariableEnums.dataSourceId.name())) {
                                fieldValue = this.delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
                            }
                            if (variableValue.equals(SystemVariableEnums.executeId.name())) {
                                fieldValue = this.executeId;
                            }
                        } else if (formNodeType.equals("variable")) {
                            variableValue = valueObject.getString("variableValue");
                            fieldValue = this.delegateExecution.getVariable(variableValue);
                        } else {
                            fieldValue = this.getValue(valueObject, null);
                        }
                    }
                    String optType = jsonObject.getString("optType");
                    JSONObject dataJson = new JSONObject();
                    if (optType.equals("1")) {
                        dataJson.put(fieldName, fieldValue);
                    } else {
                        String oldValue = desFormData.getString(fieldName);
                        Object updateVal = this.getUpdateValue(optType, type, fieldValue, oldValue);
                        dataJson.put(fieldName, updateVal);
                    }
                    updateObj.setId(dataId);
                    updateObj.setDesformCode(formTableCode);
                    updateObj.setDesformDataJson(JSONObject.toJSONString((Object)dataJson));
                    updateObj.setTriggerProcess(false);
                    this.designFormDataService.updateById(updateObj);
                    log.info("------------\u66f4\u65b0\u6570\u636e\u8282\u70b9: {}--------------", (Object)dataId);
                }
            }
        }
    }

    private Object getUpdateValue(String optType, String type, Object fieldValue, String oldValue) {
        if (ObjectUtils.isEmpty((Object)fieldValue)) {
            fieldValue = "0";
        }
        if (StringUtil.isEmpty((String)oldValue)) {
            oldValue = "0";
        }
        if (StringUtil.isNotEmpty((String)type)) {
            Number old;
            Number value;
            if (type.equals("money")) {
                value = new BigDecimal(fieldValue.toString());
                old = new BigDecimal(oldValue);
                if (optType.equals("2")) {
                    return ((BigDecimal)value).add((BigDecimal)old);
                }
                if (optType.equals("3")) {
                    return ((BigDecimal)old).subtract((BigDecimal)value);
                }
            }
            if (type.equals("integer") || type.equals("number")) {
                value = oConvertUtils.getInt((Object)fieldValue, (int)0);
                old = oConvertUtils.getInt((String)oldValue, (int)0);
                if (optType.equals("2")) {
                    return (Integer)old + (Integer)value;
                }
                if (optType.equals("3")) {
                    return (Integer)old - (Integer)value;
                }
            }
        }
        return null;
    }
}

