/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.vo.DomainUrl;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNodeDeployment;
import org.jeecg.modules.joa.util.ProcessUtils;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="messageDelegate")
public class MessageDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(MessageDelegate.class);
    public static final String PC_TOKEN_LOGIN_PAGE = "/tokenLogin";
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IDesignFormDataService designFormDataService;
    @Autowired
    private ISysBaseAPI baseApi;
    @Autowired
    private JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private ProcessUtils processUtils;
    public static ExecutorService cachedThreadPool = new ThreadPoolExecutor(0, 1024, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public void execute(DelegateExecution delegateExecution) {
        if (this.baseApi == null) {
            this.baseApi = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
        }
        if (this.jeecgBaseConfig == null) {
            this.jeecgBaseConfig = (JeecgBaseConfig)SpringContextUtils.getBean(JeecgBaseConfig.class);
        }
        if (this.processUtils == null) {
            this.processUtils = (ProcessUtils)SpringContextUtils.getBean((String)"processUtils");
        }
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        String processDefinitionKey = executionEntity.getProcessDefinitionKey();
        String executionId = executionEntity.getId();
        String processInstanceId = executionEntity.getProcessInstanceId();
        ExtActProcess extActProcess = this.processUtils.getExtActProcessByProcessKey(processDefinitionKey);
        if (ObjectUtils.isNotEmpty((Object)extActProcess)) {
            String processId = extActProcess.getId();
            String activityId = executionEntity.getActivityId();
            ExtActProcessNodeDeployment extActProcessNode = this.processUtils.getExtActProcessNodeDeployment(processId, activityId);
            log.info("-------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011-----\u63a8\u9001\u6d88\u606f\u5f00\u59cb--------------");
            log.info("\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011taskid= {}\uff0ctaskName= {} ,processInstanceId= {}", new Object[]{activityId, extActProcessNode.getProcessNodeName(), processId});
            this.sendMessage(delegateExecution, extActProcessNode, processInstanceId, executionId, extActProcess.getTenantId());
        }
    }

    private void sendMessage(DelegateExecution delegateExecution, ExtActProcessNodeDeployment extActProcessNode, String processInstanceId, String executionId, Integer tenantId) {
        String nodeConfig;
        if (ObjectUtils.isNotEmpty((Object)extActProcessNode) && StringUtil.isNotEmpty((String)(nodeConfig = extActProcessNode.getNodeConfigJson()))) {
            log.info("-----\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011--------\u6d88\u606f\u53d1\u9001\u914d\u7f6enodeConfig:{}--------------", (Object)nodeConfig);
            ChildAttr childAttr = (ChildAttr)JSON.parseObject((String)nodeConfig, ChildAttr.class);
            String type = childAttr.getType();
            String templateContext = childAttr.getTemplateContext();
            String jsonContext = childAttr.getJsonContext();
            Map<String, Object> data = this.getData(delegateExecution, type);
            templateContext = this.parseContent(templateContext, jsonContext, data, processInstanceId, executionId);
            String title = childAttr.getTitle();
            CharSequence[] toUserId = childAttr.getToUserIds();
            String toUserExpression = childAttr.getToUserExpression();
            if (StringUtils.isNotEmpty((CharSequence)toUserExpression)) {
                toUserId = this.getUserIds(toUserExpression, executionId, processInstanceId);
            }
            CharSequence[] copyToUserId = childAttr.getCopyToUserIds();
            MessageDTO messageDTO = new MessageDTO();
            if (ObjectUtils.isEmpty((Object)toUserId)) {
                messageDTO.setToAll(Boolean.valueOf(true));
            } else {
                messageDTO.setToAll(Boolean.valueOf(false));
                messageDTO.setToUser(String.join((CharSequence)",", toUserId));
            }
            if (ObjectUtils.isNotEmpty((Object)copyToUserId)) {
                messageDTO.setCopyToUser(String.join((CharSequence)",", copyToUserId));
            }
            messageDTO.setTitle(title);
            messageDTO.setType(type);
            messageDTO.setIsMarkdown(true);
            messageDTO.setFromUser("system");
            messageDTO.setContent(templateContext);
            messageDTO.setData(data);
            cachedThreadPool.execute(() -> {
                log.info("-------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011-----\u8fdb\u5165\u5f02\u6b65\u63a8\u9001-----------Begin---");
                log.info("------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011------\u5f02\u6b65\u6d88\u606f\u53d1\u9001\u5bf9\u8c61 : {} ", (Object)JSON.toJSONString((Object)messageDTO));
                TenantContext.setTenant((String)oConvertUtils.getString((Object)tenantId));
                this.baseApi.sendTemplateMessage(messageDTO);
                log.info("-------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011-----\u5f02\u6b65\u63a8\u9001\u7ed3\u675f-----------End---");
            });
        }
    }

    private String parseContent(String templateContext, String jsonContext, Map<String, Object> dataMap, String processInstanceId, String executionId) {
        if (ObjectUtils.isNotEmpty(dataMap)) {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonContext);
            return this.replaceCondition(templateContext, jsonObject, dataMap, processInstanceId, executionId);
        }
        return "";
    }

    private Map<String, Object> getData(DelegateExecution delegateExecution, String type) {
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        Map variableInstanceMaps = delegateExecution.getVariableInstances();
        if (ObjectUtils.isNotEmpty((Object)variableInstanceMaps)) {
            for (Map.Entry entry : variableInstanceMaps.entrySet()) {
                String value;
                String name = (String)entry.getKey();
                VariableInstance variableInstance = (VariableInstance)entry.getValue();
                if (!ObjectUtils.isNotEmpty((Object)variableInstance) || !StringUtil.isNotEmpty((String)(value = variableInstance.getTextValue()))) continue;
                data.put(name, value);
            }
        }
        String processName = executionEntity.getProcessDefinitionName();
        String nodeName = executionEntity.getCurrentFlowElement().getName();
        data.put("_fw_node_name", nodeName);
        data.put("_fw_name", processName);
        data.put("_fw_title", executionEntity.getVariable("bpm_biz_title"));
        data.put("NOTICE_MSG_SUMMARY", this.getRouteInfo(executionEntity));
        if (!MessageTypeEnum.XT.getType().equals(type)) {
            data.put("NOTICE_MSG_BUS_ID", executionEntity.getId());
        }
        String url = this.getEmailHrefUrl(data);
        data.put("_fw_url", url);
        return data;
    }

    private String getEmailHrefUrl(Map<String, Object> data) {
        String domain = this.getPcDomainUrl();
        String url = domain + PC_TOKEN_LOGIN_PAGE;
        try {
            url = url + "?loginToken={LOGIN_TOKEN}";
            Object msgAbstract = data.get("NOTICE_MSG_SUMMARY");
            if (msgAbstract != null) {
                url = url + "&info=" + URLEncoder.encode(msgAbstract.toString(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }

    private String getPcDomainUrl() {
        DomainUrl domain = this.jeecgBaseConfig.getDomainUrl();
        if (domain == null || oConvertUtils.isEmpty((Object)domain.getPc())) {
            log.error("\u7f3a\u5c11\u914d\u7f6e\uff1ajeecg.domainUrl.pc\uff01");
            return "";
        }
        return domain.getPc();
    }

    private String getRouteInfo(ExecutionEntity executionEntity) {
        JSONObject msgAbstract = new JSONObject();
        msgAbstract.put("taskId", (Object)executionEntity.getActivityId());
        msgAbstract.put("procInsId", (Object)executionEntity.getProcessInstanceId());
        msgAbstract.put("taskDetail", (Object)true);
        return msgAbstract.toJSONString();
    }

    private String replaceCondition(String conditionValue, JSONObject jsonObject, Map<String, Object> dataMap, String processInstanceId, String executionId) {
        String text = conditionValue;
        if (text.contains("{{")) {
            String conditionText = text.substring(text.indexOf("{{"), text.indexOf("}}") + 2);
            String objText = conditionText.replace("{{", "").replace("}}", "");
            if (ObjectUtils.isNotEmpty((Object)objText)) {
                Object value = this.getValue(objText, jsonObject, dataMap, processInstanceId, executionId);
                text = ObjectUtils.isNotEmpty((Object)value) ? text.replace(conditionText, value.toString()) : text.replace(conditionText, "");
            }
            text = this.replaceCondition(text, jsonObject, dataMap, processInstanceId, executionId);
        }
        return text;
    }

    public Object getValue(String objText, JSONObject jsonContext, Map<String, Object> dataMap, String processInstanceId, String executionId) {
        String[] obj = objText.split("\\.");
        if (ObjectUtils.isNotEmpty((Object)obj)) {
            String key = obj[0];
            if (key.contains("_FW_")) {
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    String name = entry.getKey();
                    if (!name.equals(key)) continue;
                    return entry.getValue();
                }
            } else {
                try {
                    String jsonParams = jsonContext.getString(key);
                    String context = new String(Base64.getDecoder().decode(jsonParams), "utf-8");
                    JSONObject valueObj = JSONObject.parseObject((String)context);
                    return this.getValueByJsonObject(valueObj, executionId, processInstanceId);
                }
                catch (Exception e) {
                    log.info("\u6d88\u606f\u6a21\u677f\u89e3\u6790\u5f02\u5e38{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    public Object getValueByJsonObject(JSONObject valueObj, String executionId, String processInstanceId) {
        String formTableCode = valueObj.getString("formTableCode");
        String formNodeId = valueObj.getString("nodeId");
        String variableValue = valueObj.getString("field");
        String formNodeType = valueObj.getString("nodeType");
        if (StringUtils.isNotEmpty((CharSequence)formNodeType)) {
            String dataId;
            String formDataSourceKey;
            DesignFormData designFormData = null;
            if (FormTableTypeEnums.table.name().equals(formNodeType)) {
                String dataId2 = (String)this.runtimeService.getVariable(executionId, WorkFlowGlobals.BPM_DATA_ID, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId2);
            }
            if (FormTableTypeEnums.search.name().equals(formNodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, formNodeId);
                dataId = (String)this.runtimeService.getVariable(executionId, formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId);
            }
            if (FormTableTypeEnums.plus.name().equals(formNodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", processInstanceId, formNodeId);
                dataId = (String)this.runtimeService.getVariable(executionId, formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getById(formTableCode, dataId);
            }
            if (ObjectUtils.isNotEmpty(designFormData)) {
                JSONObject sourceJsonObject = designFormData.getDesformData();
                return sourceJsonObject.get((Object)variableValue);
            }
        }
        return null;
    }

    public String[] getUserIds(String toUserExpression, String executionId, String processInstanceId) {
        JSONObject jsonObject;
        Object value;
        if (StringUtils.isNotEmpty((CharSequence)toUserExpression) && (value = this.getValueByJsonObject(jsonObject = JSONObject.parseObject((String)toUserExpression), executionId, processInstanceId)) instanceof JSONArray && ObjectUtils.isNotEmpty((Object)value)) {
            JSONArray jsonArray = (JSONArray)value;
            List list = jsonArray.toJavaList(String.class);
            return (String[])ArrayUtil.toArray((Collection)list, String.class);
        }
        return null;
    }
}

