/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.bpmn.BpmnAutoLayout;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.CustomProperty;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventListener;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.InclusiveGateway;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.Message;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.ScriptTask;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.UserTask;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.adapter.entity.MyExtActProcess;
import org.jeecg.modules.extbpm.process.adapter.entity.ProcessData;
import org.jeecg.modules.extbpm.process.adapter.enums.StartTypeEnums;
import org.jeecg.modules.extbpm.process.adapter.enums.TimeTypeEnums;
import org.jeecg.modules.extbpm.process.adapter.model.ListenerModel;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.MinFlowUtils;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessForm;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNode;

public class BpmnCreator {
    public static UserTask createUserTask(String id, String name, String assignee) {
        UserTask userTask = new UserTask();
        userTask.setName(name);
        userTask.setId(id);
        userTask.setAssignee(assignee);
        return userTask;
    }

    public static UserTask createCounterSign(String id, String name, String assigneeList, String assignName) {
        UserTask userTask = new UserTask();
        userTask.setId(id);
        userTask.setName(name);
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
        multiInstanceLoopCharacteristics.setInputDataItem(assigneeList);
        multiInstanceLoopCharacteristics.setElementVariable(assignName);
        multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfActiveInstances == nrOfInstances}");
        multiInstanceLoopCharacteristics.setSequential(false);
        userTask.setAssignee("${" + assignName + "}");
        userTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        return userTask;
    }

    public static SequenceFlow createSequenceFlow(String from, String to) {
        SequenceFlow flow = new SequenceFlow();
        flow.setSourceRef(from);
        flow.setTargetRef(to);
        return flow;
    }

    public static SequenceFlow createSequenceFlow(String from, String to, String name, String conditionExpression) {
        SequenceFlow flow = new SequenceFlow();
        flow.setSourceRef(from);
        flow.setTargetRef(to);
        flow.setName(name);
        if (StringUtil.isNotEmpty((String)conditionExpression)) {
            flow.setConditionExpression(conditionExpression);
        }
        return flow;
    }

    public static StartEvent createStartEvent(String id) {
        StartEvent startEvent = new StartEvent();
        startEvent.setId(id);
        return startEvent;
    }

    public static ExclusiveGateway createExclusiveGateway(String id, String name) {
        ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
        exclusiveGateway.setId(id);
        exclusiveGateway.setName(name);
        return exclusiveGateway;
    }

    public static ParallelGateway createParallelGateway(String id, String name) {
        ParallelGateway gateway = new ParallelGateway();
        gateway.setId(id);
        gateway.setName(name);
        return gateway;
    }

    public static ServiceTask createServiceTask(String id, String name, List<CustomProperty> properties) {
        ServiceTask service = new ServiceTask();
        service.setId(id);
        service.setName(name);
        service.setCustomProperties(properties);
        return service;
    }

    public static EndEvent createEndEvent() {
        EndEvent endEvent = new EndEvent();
        endEvent.setId("end");
        return endEvent;
    }

    public static FlowableListener createActivitiListener(ListenerModel listenerModel) {
        FlowableListener activitiListener = new FlowableListener();
        activitiListener.setEvent(listenerModel.getEventType());
        String listenerType = listenerModel.getListenerType();
        if (listenerType.equals("javaClass")) {
            listenerType = "class";
        }
        activitiListener.setImplementationType(listenerType);
        activitiListener.setImplementation(listenerModel.getValue());
        activitiListener.setId(listenerModel.getId());
        return activitiListener;
    }

    /*
     * WARNING - void declaration
     */
    public static String createXML(List<ExtActProcessNode> extActProcessNodes, MyExtActProcess myExtActProcess, ExtActProcessForm extActProcessForm, ProcessData processData, List<UserTask> userTasks, List<ServiceTask> serviceTasks, List<ExclusiveGateway> gateways, List<ParallelGateway> polymerizeGateWays, List<InclusiveGateway> inclusiveGateways, List<ScriptTask> scriptTasks, List<CallActivity> callActivities, List<SequenceFlow> taskFlows, List<IntermediateCatchEvent> intermediateCatchEvents, List<ServiceTask> messageTask, String tenantId) {
        ChildAttr childAttr = processData.getAttr();
        BpmnModel bpmn = new BpmnModel();
        bpmn.setTargetNamespace("http://www.jeecg.com");
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.setName("designerJSON");
        extensionAttribute.setValue("http://www.jeecg.com");
        Process process = new Process();
        process.setId(myExtActProcess.getProcessKey());
        String startType = myExtActProcess.getStartType();
        if (StartTypeEnums.subEvent.name().equals(startType)) {
            process.setId("process" + myExtActProcess.getCustomProcessId());
        }
        process.setName(myExtActProcess.getProcessName());
        List<FlowableListener> listeners = BpmnCreator.getExecutionListener(processData.getExecuteListeners());
        StartEvent start = BpmnCreator.createStartEvent(processData.getId());
        start.setName(processData.getName());
        ExtActProcessNode extActProcessNode = new ExtActProcessNode();
        extActProcessNode.setProcessNodeCode(start.getId());
        extActProcessNode.setProcessNodeName(processData.getName());
        if (ObjectUtils.isNotEmpty((Object)childAttr)) {
            extActProcessNode.setNodeConfigJson(JSON.toJSONString((Object)childAttr));
        }
        extActProcessNodes.add(extActProcessNode);
        List<FlowableListener> startListeners = BpmnCreator.getExecutionListener(processData.getListenerData());
        if (ObjectUtils.isNotEmpty(startListeners)) {
            start.setExecutionListeners(startListeners);
        }
        if (StringUtil.isNotEmpty((String)processData.getInitiator())) {
            start.setInitiator(processData.getInitiator());
        }
        FlowableListener signalProcessStartListener = BpmnCreator.getSignalProcessStartListener();
        if (StartTypeEnums.manual.name().equals(startType)) {
            String oldStartType = processData.getStartType();
            if (StartTypeEnums.timerEvent.name().equals(oldStartType)) {
                String timeCycle = processData.getTimeCycle();
                String timeType = processData.getTimeType();
                String string = processData.getTimeDate();
                if (StringUtil.isNotEmpty((String)string)) {
                    String string2 = string.substring(0, string.lastIndexOf(":"));
                }
                TimerEventDefinition timerEventDefinition = new TimerEventDefinition();
                timerEventDefinition.setId("TimerEventDefinition_" + IdUtil.simpleUUID().substring(0, 7));
                if (ObjectUtils.isNotEmpty((Object)timeType)) {
                    void var28_30;
                    if (TimeTypeEnums.timeDate.name().equals(timeType)) {
                        if (!timeCycle.equals("custom")) {
                            timerEventDefinition.setTimeCycle(timeCycle);
                        } else {
                            timerEventDefinition.setTimeCycle((String)var28_30);
                        }
                    }
                    if (TimeTypeEnums.timeDuration.name().equals(timeType)) {
                        if (!timeCycle.equals("custom")) {
                            timerEventDefinition.setTimeDuration(timeCycle);
                        } else {
                            timerEventDefinition.setTimeDuration((String)var28_30);
                        }
                    }
                    if (TimeTypeEnums.timeDate.name().equals(timeType)) {
                        timerEventDefinition.setTimeDate((String)var28_30);
                    }
                }
                start.addEventDefinition((EventDefinition)timerEventDefinition);
            }
            if (StartTypeEnums.signal.name().equals(oldStartType)) {
                String signalEventName = processData.getAttr().getSignalEventName();
                BpmnCreator.addSignal(signalEventName, start, bpmn);
            }
            if (StartTypeEnums.message.name().equals(oldStartType)) {
                String messageEventName = processData.getMessageEventName();
                BpmnCreator.addMessageEvent(messageEventName, start, bpmn);
            }
        } else {
            String formTableCode;
            String beginDate = childAttr.getBeginDateStr();
            if (StartTypeEnums.timerEvent.name().equals(startType) && StringUtil.isNotEmpty((String)beginDate)) {
                TimerEventDefinition timerEventDefinition = new TimerEventDefinition();
                String timeCycle = childAttr.getTimeCycle();
                String string = childAttr.getEndDateStr();
                if (StringUtil.isNotEmpty((String)string)) {
                    String string3 = string.replace(" ", "T");
                    timerEventDefinition.setEndDate(string3);
                }
                if (StringUtil.isNotEmpty((String)timeCycle)) {
                    beginDate = beginDate.replace(" ", "T");
                    if (timeCycle.equals("1")) {
                        timerEventDefinition.setTimeCycle("R/" + beginDate + "/PT1M");
                    }
                    if (timeCycle.equals("2")) {
                        timerEventDefinition.setTimeCycle("R/" + beginDate + "/PT1H");
                    }
                    if (timeCycle.equals("3")) {
                        timerEventDefinition.setTimeCycle("R/" + beginDate + "/P1D");
                    }
                    if (timeCycle.equals("4")) {
                        timerEventDefinition.setTimeCycle("0 0 1 1 * ?");
                    }
                    if (timeCycle.equals("5")) {
                        timerEventDefinition.setTimeCycle("0 0 1 ? * WED");
                    }
                    if (timeCycle.equals("6")) {
                        timerEventDefinition.setTimeCycle("0 0 1 ? * MON-FRI");
                    }
                    if (timeCycle.equals("7")) {
                        timerEventDefinition.setTimeCycle("0 0 1 31 12 ?");
                    }
                    if (timeCycle.equals("custom")) {
                        String cron = MinFlowUtils.getCustomCron(childAttr);
                        timerEventDefinition.setTimeCycle(cron);
                    }
                }
                timerEventDefinition.setId("TimerEventDefinition_" + IdUtil.simpleUUID().substring(0, 7));
                start.addEventDefinition((EventDefinition)timerEventDefinition);
            }
            if (StartTypeEnums.tableEvent.name().equals(startType)) {
                formTableCode = childAttr.getFormTableCode();
                String startEventType = childAttr.getStartEventType();
                String string = childAttr.getStartCondition();
                String signalEventName = MessageFormat.format("{0}:{1}:{2}", childAttr.getFormTableCode(), extActProcessForm.getId(), startEventType);
                BpmnCreator.addSignal(signalEventName, start, bpmn);
                extActProcessForm.setStartSignalName(signalEventName);
                listeners.add(signalProcessStartListener);
            }
            if (StartTypeEnums.buttonEvent.name().equals(startType)) {
                formTableCode = childAttr.getFormTableCode();
                String signalEventName = "button_signal:" + myExtActProcess.getId();
                BpmnCreator.addSignal(signalEventName, start, bpmn);
                if (StringUtil.isNotEmpty((String)formTableCode)) {
                    listeners.add(signalProcessStartListener);
                }
            }
            if (StartTypeEnums.subEvent.name().equals(startType)) {
                FlowableListener subEventStartListener = BpmnCreator.getSubEventStartListener();
                listeners.add(subEventStartListener);
            }
            extActProcessForm.setTriggerAction(childAttr.getStartEventType());
            extActProcessForm.setFormTableName(childAttr.getFormTableCode());
            String titleField = childAttr.getTitleField();
            if (StringUtil.isNotEmpty((String)titleField)) {
                extActProcessForm.setTitleExp(childAttr.getFormTableName() + "\u3010${" + titleField + "}\u3011");
            }
            extActProcessForm.setFormType(childAttr.getFormType());
            extActProcessForm.setFormDealStyle("default");
            if (StartTypeEnums.userEvent.name().equals(startType)) {
                Iterator<ExclusiveGateway> selectType = childAttr.getSelectType();
                String string = MessageFormat.format("{0}:{1}", ((Integer)((Object)selectType)).equals(1) ? "user_signal:add" : "user_signal:leave", myExtActProcess.getProcessKey());
                BpmnCreator.addSignal(string, start, bpmn);
                listeners.add(signalProcessStartListener);
                extActProcessForm.setFormTableName("sys_user");
                String titleExp = ((Integer)((Object)selectType)).equals(1) ? "\u4eba\u5458\u5165\u804c\u3010${realname}\u3011" : "\u4eba\u5458\u79bb\u804c\u3010${realname}\u3011";
                extActProcessForm.setTitleExp(titleExp);
                extActProcessForm.setFlowStatusCol("bpm_status");
                extActProcessForm.setFormType("3");
            }
        }
        EndEvent end = BpmnCreator.createEndEvent();
        process.addFlowElement((FlowElement)start);
        process.addFlowElement((FlowElement)end);
        StringBuilder nodes = new StringBuilder();
        for (UserTask userTask : userTasks) {
            process.addFlowElement((FlowElement)userTask);
            List boundaryEvents = userTask.getBoundaryEvents();
            if (!ObjectUtils.isNotEmpty((Object)boundaryEvents)) continue;
            for (BoundaryEvent boundaryEvent : boundaryEvents) {
                process.addFlowElement((FlowElement)boundaryEvent);
            }
        }
        for (ServiceTask serviceTask : serviceTasks) {
            process.addFlowElement((FlowElement)serviceTask);
        }
        for (ServiceTask serviceTask : messageTask) {
            process.addFlowElement((FlowElement)serviceTask);
        }
        for (ScriptTask scriptTask : scriptTasks) {
            process.addFlowElement((FlowElement)scriptTask);
        }
        for (ExclusiveGateway exclusiveGateway : gateways) {
            process.addFlowElement((FlowElement)exclusiveGateway);
        }
        for (ParallelGateway parallelGateway : polymerizeGateWays) {
            process.addFlowElement((FlowElement)parallelGateway);
        }
        for (CallActivity callActivity : callActivities) {
            process.addFlowElement((FlowElement)callActivity);
        }
        for (InclusiveGateway inclusiveGateway : inclusiveGateways) {
            process.addFlowElement((FlowElement)inclusiveGateway);
        }
        for (SequenceFlow sequenceFlow : taskFlows) {
            process.addFlowElement((FlowElement)sequenceFlow);
        }
        for (IntermediateCatchEvent intermediateCatchEvent : intermediateCatchEvents) {
            process.addFlowElement((FlowElement)intermediateCatchEvent);
        }
        if (ObjectUtils.isNotEmpty(listeners)) {
            process.setExecutionListeners(listeners);
        }
        bpmn.addProcess(process);
        BpmnCreator.setEventListener(processData, process);
        new BpmnAutoLayout(bpmn).execute();
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        byte[] byArray = bpmnXMLConverter.convertToXML(bpmn);
        String bytes = new String(byArray);
        myExtActProcess.setNote(nodes.toString());
        return bytes;
    }

    private static List<FlowableListener> getExecutionListener(List<ListenerModel> listenerData) {
        ArrayList<FlowableListener> executionListeners = new ArrayList<FlowableListener>();
        if (ObjectUtils.isNotEmpty(listenerData)) {
            for (ListenerModel listenerModel : listenerData) {
                FlowableListener executionListener = new FlowableListener();
                executionListener.setId(listenerModel.getId());
                executionListener.setImplementation(listenerModel.getValue());
                String listenerType = listenerModel.getListenerType();
                if (listenerType.equals("javaClass")) {
                    executionListener.setImplementationType("class");
                } else {
                    executionListener.setImplementationType(listenerType);
                }
                executionListener.setEvent(listenerModel.getEventType());
                executionListeners.add(executionListener);
            }
        }
        return executionListeners;
    }

    private static void setEventListener(ProcessData processData, Process process) {
        List<ListenerModel> eventListeners = processData.getEventListeners();
        if (ObjectUtils.isNotEmpty(eventListeners)) {
            ArrayList<EventListener> executionListeners = new ArrayList<EventListener>();
            for (ListenerModel listenerModel : eventListeners) {
                EventListener eventListener = new EventListener();
                eventListener.setId(listenerModel.getId());
                eventListener.setImplementation(listenerModel.getValue());
                String listenerType = listenerModel.getListenerType();
                if (listenerType.equals("javaClass")) {
                    eventListener.setImplementationType("class");
                } else {
                    eventListener.setImplementationType(listenerType);
                }
                String eventType = listenerModel.getEventType();
                if (StringUtil.isNotEmpty((String)eventType)) {
                    eventListener.setEvents(eventType);
                }
                executionListeners.add(eventListener);
            }
            process.setEventListeners(executionListeners);
        }
    }

    private static void addSignal(String signalName, StartEvent start, BpmnModel bpmn) {
        String signalId = "Signal_" + IdUtil.simpleUUID().substring(0, 6);
        Signal signal = new Signal();
        signal.setName(signalName);
        signal.setId(signalId);
        bpmn.addSignal(signal);
        SignalEventDefinition signalEventDefinition = new SignalEventDefinition();
        signalEventDefinition.setId("SignalEventDefinition_" + IdUtil.simpleUUID().substring(0, 7));
        signalEventDefinition.setSignalRef(signalId);
        start.addEventDefinition((EventDefinition)signalEventDefinition);
    }

    private static void addMessageEvent(String messageEventName, StartEvent start, BpmnModel bpmn) {
        String messageId = "Message_" + IdUtil.simpleUUID().substring(0, 6);
        Message message = new Message();
        message.setName(messageEventName);
        message.setId(messageId);
        bpmn.addMessage(message);
        MessageEventDefinition messageEventDefinition = new MessageEventDefinition();
        messageEventDefinition.setId("MessageEventDefinition_" + IdUtil.simpleUUID().substring(0, 7));
        messageEventDefinition.setMessageRef(messageId);
        start.addEventDefinition((EventDefinition)messageEventDefinition);
    }

    private static FlowableListener getSignalProcessStartListener() {
        FlowableListener executionListener = new FlowableListener();
        executionListener.setImplementation("org.jeecg.modules.extbpm.listener.execution.SignalProcessStartListener");
        executionListener.setImplementationType("class");
        executionListener.setEvent("start");
        return executionListener;
    }

    private static FlowableListener getSubEventStartListener() {
        FlowableListener executionListener = new FlowableListener();
        executionListener.setImplementation("org.jeecg.modules.minides.listener.MiniSubProcessStartListener");
        executionListener.setImplementationType("class");
        executionListener.setEvent("start");
        return executionListener;
    }
}

