/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.vo.excel;

import java.util.List;
import lombok.Generated;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.vo.widget.DesformCheckRule;
import org.jeecg.modules.online.desform.vo.widget.DesformWidget;

public class ValidateRule {
    public static final String NOT_NULL = "_NOT_NULL";
    public static final String NUM = "_NUM";
    private String pattern;
    private String msg;

    public static ValidateRule notNull(DesformWidget widget) {
        ValidateRule rule = new ValidateRule();
        rule.setPattern(NOT_NULL);
        rule.setMsg(ValidateRule.getWidgetName(widget) + "\u5fc5\u987b\u586b\u5199");
        return rule;
    }

    public static ValidateRule getRuleByPattern(String pattern, DesformWidget widget) {
        ValidateRule rule = new ValidateRule();
        rule.setPattern(pattern);
        List<DesformCheckRule> rules = widget.getRules();
        for (DesformCheckRule temp : rules) {
            if (!pattern.equals(temp.getPattern())) continue;
            rule.setMsg(ValidateRule.getErrorTip(widget, temp.getMessage()));
            break;
        }
        return rule;
    }

    public static ValidateRule getNumberRule(DesformWidget widget) {
        ValidateRule rule = new ValidateRule();
        rule.setPattern(NUM);
        rule.setMsg(ValidateRule.getWidgetName(widget) + "\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b");
        return rule;
    }

    private static String getWidgetName(DesformWidget widget) {
        return "[" + widget.getName() + "]";
    }

    private static String getErrorTip(DesformWidget widget, String message) {
        String nameStr = ValidateRule.getWidgetName(widget);
        if (oConvertUtils.isEmpty((Object)message)) {
            return nameStr + "\u683c\u5f0f\u4e0d\u5339\u914d";
        }
        if (message.indexOf("${title}") >= 0) {
            return message.replace("${title}", nameStr);
        }
        return nameStr + message;
    }

    public boolean isNotNull() {
        return NOT_NULL.equals(this.pattern);
    }

    public boolean isNum() {
        return NUM.equals(this.pattern);
    }

    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Generated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ValidateRule)) {
            return false;
        }
        ValidateRule other = (ValidateRule)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValidateRule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ValidateRule(pattern=" + this.getPattern() + ", msg=" + this.getMsg() + ")";
    }
}

