/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.mongo.service.a;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shiro.SecurityUtils;
import org.bson.types.ObjectId;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.lowapp.api.ILowAppBaseApi;
import org.jeecg.common.lowapp.model.LowAppFormAuthRecordModel;
import org.jeecg.common.lowapp.utils.LowAppCopyUtil;
import org.jeecg.common.online.api.IOnlineBaseExtApi;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.SqlInjectionUtil;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.constant.b;
import org.jeecg.modules.online.desform.datafactory.inter.dao.IDesformViewDao;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.mapper.DesignFormMapper;
import org.jeecg.modules.online.desform.mongo.dao.DesignFormListButtonDao;
import org.jeecg.modules.online.desform.mongo.dao.DesignFormListChartConfigDao;
import org.jeecg.modules.online.desform.mongo.dao.DesignFormListSuperQueryDao;
import org.jeecg.modules.online.desform.mongo.model.BaseColumn;
import org.jeecg.modules.online.desform.mongo.model.ButtonInfo;
import org.jeecg.modules.online.desform.mongo.model.CalendarColumn;
import org.jeecg.modules.online.desform.mongo.model.CardColumn;
import org.jeecg.modules.online.desform.mongo.model.DesformSetting;
import org.jeecg.modules.online.desform.mongo.model.DesignFormListChartConfig;
import org.jeecg.modules.online.desform.mongo.model.DictCount;
import org.jeecg.modules.online.desform.mongo.model.FieldOption;
import org.jeecg.modules.online.desform.mongo.model.GanttFields;
import org.jeecg.modules.online.desform.mongo.model.ListViewModel;
import org.jeecg.modules.online.desform.mongo.model.SummaryModel;
import org.jeecg.modules.online.desform.mongo.model.SuperQuery;
import org.jeecg.modules.online.desform.mongo.model.TreeModel;
import org.jeecg.modules.online.desform.mongo.model.ViewBasicModel;
import org.jeecg.modules.online.desform.mongo.model.custom.rule.CustomRules;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListViewService;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormSettingService;
import org.jeecg.modules.online.desform.service.IDesignFormAuthService;
import org.jeecg.modules.online.desform.service.IDesignFormService;
import org.jeecg.modules.online.desform.util.DesformQueryUtils;
import org.jeecg.modules.online.desform.vo.DesignFormViewVo;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQueryGroup;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.jeecg.modules.online.desform.vo.query.params.DesformExtentdParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="designFormListViewService")
public class g
implements IDesignFormListViewService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(g.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DesignFormMapper designFormMapper;
    @Lazy
    @Autowired
    IDesignFormService designFormService;
    @Autowired
    private IDesignFormAuthService designFormAuthService;
    @Autowired
    @Lazy
    IOnlineBaseExtApi onlineBaseExtApi;
    @Autowired
    @Lazy
    ILowAppBaseApi lowAppBaseApi;
    @Autowired
    private DesignFormListSuperQueryDao designFormListSuperQueryDao;
    @Autowired
    private DesignFormListChartConfigDao designFormListChartConfigDao;
    @Autowired
    private DesignFormListButtonDao designFormListButtonDao;
    @Autowired
    private IDesignFormSettingService designFormSettingService;
    @Autowired
    private ISysBaseAPI sysBaseApi;
    @Autowired
    public RedisTemplate redisTemplate;
    @Autowired
    IDesformViewDao viewDao;

    @Override
    public void createBaseView(String code) {
        JSONObject jsonData = new JSONObject();
        jsonData.put("desform_code", (Object)code);
        jsonData.put("name", (Object)"\u5168\u90e8");
        jsonData.put("type", (Object)"base");
        jsonData.put("seq", (Object)1);
        jsonData.put("hasSummary", (Object)true);
        this.viewDao.save(jsonData);
    }

    @Override
    public String addView(ViewBasicModel viewBasicModel) {
        GanttFields ganttFields;
        List<CalendarColumn> list;
        JSONObject jsonData = new JSONObject();
        jsonData.put("desform_code", (Object)viewBasicModel.getCode());
        jsonData.put("type", (Object)viewBasicModel.getType());
        Integer seq = this.a(viewBasicModel.getCode());
        jsonData.put("seq", (Object)seq);
        jsonData.put("name", (Object)("\u89c6\u56fe" + seq));
        if (oConvertUtils.isNotEmpty((Object)viewBasicModel.getGroupField())) {
            jsonData.put("groupField", (Object)viewBasicModel.getGroupField());
        }
        if (oConvertUtils.isNotEmpty((Object)viewBasicModel.getTitleField())) {
            jsonData.put("titleField", (Object)viewBasicModel.getTitleField());
        }
        if ((list = viewBasicModel.getCalendarColumnList()) != null && list.size() > 0) {
            jsonData.put("calendarColumnList", list);
        }
        if ("base".equals(viewBasicModel.getType())) {
            jsonData.put("hasSummary", (Object)true);
        }
        if ((ganttFields = viewBasicModel.getGanttFields()) == null) {
            ganttFields = new GanttFields();
        }
        jsonData.put("ganttFields", (Object)ganttFields);
        jsonData.put("createTime", (Object)System.currentTimeMillis());
        String id = this.viewDao.save(jsonData);
        return id;
    }

    @Override
    public String copyView(String listViewId) {
        JSONObject json = (JSONObject)this.viewDao.findById(listViewId);
        json.remove((Object)"_id");
        String code = json.getString("desform_code");
        Integer seq = this.a(code);
        json.put("name", (Object)("\u89c6\u56fe" + seq));
        json.put("seq", (Object)seq);
        json.put("createTime", (Object)System.currentTimeMillis());
        String id = this.viewDao.save(json);
        return id;
    }

    @Override
    public void removeView(String listViewId) {
        this.viewDao.removeById(listViewId);
    }

    private Integer a(String code) {
        return this.viewDao.getNextSeq(code);
    }

    @Override
    public long countView(String code) {
        return this.viewDao.countView(code);
    }

    @Override
    public List<JSONObject> getAllView(String code) {
        List<JSONObject> list = this.viewDao.selectList(code);
        if (CollectionUtils.isEmpty(list)) {
            this.createBaseView(code);
            list = this.viewDao.selectList(code);
        }
        for (JSONObject json : list) {
            Object objId = json.get((Object)"_id");
            if (objId instanceof String) {
                json.put("id", (Object)objId.toString());
                continue;
            }
            ObjectId id = (ObjectId)json.get((Object)"_id");
            json.put("id", (Object)id.toString());
        }
        return list;
    }

    @Override
    public void updateOneProp(JSONObject json) {
        String id = json.getString("id");
        this.viewDao.updateIncremental(id, json);
    }

    @Override
    public ListViewModel queryListViewInfo(DesignForm designForm, String listViewId, String username) {
        return this.queryListViewInfo(designForm, listViewId, null, username);
    }

    @Override
    public ListViewModel queryListViewInfo(DesignForm designForm, String listViewId, DesformSuperQuery superQuery, String username) {
        GanttFields ganttFields;
        CustomRules customRules;
        Object summaryInfo;
        Boolean hasSummary;
        JSONArray array;
        FieldOption fieldOption;
        Object waitQuery;
        Object queryButton;
        Object queryList;
        Object orders;
        Object buttons;
        List list;
        Object object;
        JSONArray systemColumnList;
        String showColumn;
        JSONObject json;
        a.info("\u3010DesignForm DB\u3011\u901a\u8fc7\u6570\u636e\u5e93\uff0c\u67e5\u8be2\u5217\u8868\u89c6\u56fe\u7684\u914d\u7f6e\uff0clistViewId={}", (Object)listViewId);
        ListViewModel model = new ListViewModel();
        if (oConvertUtils.isEmpty((Object)listViewId)) {
            return model;
        }
        if (superQuery == null) {
            superQuery = new DesformSuperQuery();
        }
        if ((json = (JSONObject)this.viewDao.findById(listViewId)) == null) {
            return model;
        }
        model.setTitleField(json.getString("titleField"));
        JSONArray columnList = json.getJSONArray("columnList");
        if (!CollectionUtils.isEmpty((Collection)columnList)) {
            model.setColumnList(columnList.toJavaList(BaseColumn.class));
        }
        if (oConvertUtils.isEmpty((Object)(showColumn = json.getString("showColumn")))) {
            showColumn = "default";
        }
        model.setShowColumn(showColumn);
        model.setShowColumnIsDiy("diy".equals(showColumn));
        JSONArray showColumnList = json.getJSONArray("showColumnList");
        if (!CollectionUtils.isEmpty((Collection)showColumnList)) {
            model.setShowColumnList(showColumnList.toJavaList(BaseColumn.class));
        }
        if (!CollectionUtils.isEmpty((Collection)(systemColumnList = json.getJSONArray("systemColumnList")))) {
            model.setSystemColumnList(systemColumnList.toJavaList(BaseColumn.class));
        }
        if ((object = json.get((Object)"conditions")) != null) {
            DesformSuperQueryGroup superQueryGroup = new DesformSuperQueryGroup();
            String matchTypeString = json.getString("matchType");
            superQueryGroup.setMatchType(MatchTypeEnum.getByValue((String)matchTypeString));
            String conditionType = json.getString("conditionType");
            superQuery.setMatchType(MatchTypeEnum.getByValue((String)conditionType));
            list = (List)object;
            ArrayList itemList = new ArrayList();
            for (Map temp : list) {
                if (temp.get("queryItems") != null) {
                    try {
                        DesformSuperQuery tempSuperQuery = (DesformSuperQuery)JSON.parseObject((String)JSON.toJSONString((Object)temp), DesformSuperQuery.class);
                        superQueryGroup.addSuperQuery(tempSuperQuery);
                        continue;
                    }
                    catch (Exception e2) {
                        throw new JeecgBootBizTipException((Throwable)e2);
                    }
                }
                SuperQueryItem item = new SuperQueryItem(new JSONObject(temp));
                itemList.add(item);
            }
            superQuery.setQueryItems(itemList);
            model.setSuperQuery(superQuery);
            model.setSuperQueryGroup(superQueryGroup);
        }
        if ((buttons = json.get((Object)"buttonList")) != null) {
            List buttonList = (List)buttons;
            model.setButtonList(buttonList);
        }
        if ((orders = json.get((Object)"orders")) != null) {
            List list2 = (List)orders;
            ArrayList<OrderItem> orderList = new ArrayList<OrderItem>();
            for (Map temp : list2) {
                OrderItem item;
                Object orderField = temp.get("field");
                if (null == orderField || "".equals(orderField.toString())) continue;
                boolean isAsc = "asc".equalsIgnoreCase(temp.get("type").toString());
                if (isAsc) {
                    item = OrderItem.asc((String)orderField.toString());
                    orderList.add(item);
                    continue;
                }
                item = OrderItem.desc((String)orderField.toString());
                orderList.add(item);
            }
            model.setOrderList(orderList);
        }
        if ((queryList = json.get((Object)"queryList")) != null) {
            list = (List)queryList;
            model.setQueryList(list);
        }
        if ((queryButton = json.get((Object)"queryButton")) != null) {
            model.setQueryButton((Boolean)queryButton);
        }
        if ((waitQuery = json.get((Object)"waitQuery")) != null) {
            model.setWaitQuery((Boolean)waitQuery);
        }
        String cardGroupField = json.getString("groupField");
        model.setCardGroupField(cardGroupField);
        JSONArray cardColumnList = json.getJSONArray("cardColumnList");
        if (oConvertUtils.isNotEmpty((Object)cardColumnList)) {
            model.setCardColumnList(cardColumnList.toJavaList(CardColumn.class));
        }
        if ((fieldOption = this.a(json, designForm, "leftFilterField")) != null) {
            model.setLeftFilterField(fieldOption.getField());
            List<DictCount> groupDataList = this.a(designForm, fieldOption.getField(), username, model, superQuery);
            long total = 0L;
            for (DictCount dc : groupDataList) {
                total += dc.getCount();
            }
            model.setTotal(total);
            String type = fieldOption.getType();
            if (WidgetTypes.SELECT_TREE.getType().equals(type)) {
                List<String> idList;
                TreeModel tm = fieldOption.getTreeModel();
                if ("code".equals(tm.getConditionField()) && (idList = this.designFormMapper.getSysCategoryIdByCode(tm.getPidValue())) != null && idList.size() > 0) {
                    tm.setConditionField("id");
                    tm.setPidValue(idList.get(0));
                }
                model.setTreeModel(tm);
                model.setDictCountList(groupDataList);
            } else {
                fieldOption.setGroupModeKey("leftFilterData");
                fieldOption.setGroupOrderKey("leftFilterOrder");
                fieldOption.setGroupDataConditionKey("leftFilterCondition");
                List<DictCount> dictCountList = this.a(fieldOption, json, groupDataList);
                if (dictCountList != null) {
                    model.setDictCountList(dictCountList);
                }
            }
        }
        String type = json.getString("type");
        model.setType(type);
        if ("card".equals(type)) {
            List<DictCount> dictCountList;
            if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                String tenantStr = TenantContext.getTenant();
                HttpServletRequest req = SpringContextUtils.getHttpServletRequest();
                Integer tenantId = oConvertUtils.getInteger((Object)tenantStr, (Integer)oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)req), (int)-1));
                json.put("X-Tenant-Id", (Object)tenantId);
            }
            if ((dictCountList = this.a(json, designForm, username, model)) != null) {
                model.setDictCountList(dictCountList);
            }
        }
        if ((array = json.getJSONArray("calendarColumnList")) != null && array.size() > 0) {
            List calendarColumnList = JSON.parseArray((String)array.toJSONString(), CalendarColumn.class);
            if ("calendar".equals(type)) {
                model.setCalendarColumnList(calendarColumnList);
            }
        }
        if ("base".equals(type) && (hasSummary = json.getBoolean("hasSummary")) != null && hasSummary.booleanValue() && (summaryInfo = json.get((Object)"summaryList")) != null) {
            List list3 = (List)summaryInfo;
            ArrayList<SummaryModel> summaryList = new ArrayList<SummaryModel>();
            for (Map temp : list3) {
                String summaryField = (String)temp.get("field");
                if (null == summaryField || "".equals(summaryField)) continue;
                String summaryType = (String)temp.get("type");
                SummaryModel summaryModel = new SummaryModel(summaryField, summaryType);
                summaryList.add(summaryModel);
            }
            model.setSummaryList(summaryList);
        }
        if ((customRules = (CustomRules)json.getObject("customRules", CustomRules.class)) != null) {
            model.setCustomRules(customRules);
        }
        if ((ganttFields = (GanttFields)json.getObject("ganttFields", GanttFields.class)) != null) {
            JSONObject jsonObject = JSON.parseObject((String)designForm.getDesformDesignJson());
            String titleField = jsonObject.getJSONObject("config").getString("titleField");
            model.setTitleField(titleField);
            model.setGanttFields(ganttFields);
        }
        return model;
    }

    private List<DictCount> a(JSONObject json, DesignForm designForm, String username, ListViewModel model) {
        FieldOption fieldOption = this.a(json, designForm, "groupField");
        if (fieldOption != null) {
            List<DictCount> groupDataList = this.a(designForm, fieldOption.getField(), username, model);
            fieldOption.setGroupModeKey("filterGroupType");
            fieldOption.setGroupDataConditionKey("filterGroupCondition");
            List<DictCount> dictCountList = this.a(fieldOption, json, groupDataList);
            return dictCountList;
        }
        return null;
    }

    private FieldOption a(JSONObject json, DesignForm designForm, String key) {
        Object leftFilterField = json.get((Object)key);
        if (leftFilterField != null && !"".equals(leftFilterField)) {
            String fieldStr = leftFilterField.toString();
            if ("create_by".equalsIgnoreCase(fieldStr) || "update_by".equalsIgnoreCase(fieldStr)) {
                return FieldOption.getSystemPersonField(fieldStr);
            }
            String jsonStr = designForm.getDesformDesignJson();
            if (oConvertUtils.isNotEmpty((Object)jsonStr)) {
                JSONObject col = JSON.parseObject((String)jsonStr);
                FieldOption fieldOption = org.jeecg.modules.online.desform.util.g.a(leftFilterField.toString(), col);
                return fieldOption;
            }
        }
        return null;
    }

    private List<DictCount> a(FieldOption fieldOption, JSONObject json, List<DictCount> groupDataList) {
        String type = fieldOption.getType();
        if (WidgetTypes.TABLE_DICT.getType().equals(type) || WidgetTypes.LINK_RECORD.getType().equals(type)) {
            List<DictCount> list = this.b(fieldOption, json, groupDataList);
            return list;
        }
        if (WidgetTypes.SELECT.getType().equals(type) || WidgetTypes.RADIO.getType().equals(type)) {
            List<DictCount> list = this.a(fieldOption, json, groupDataList, false);
            if (list != null && !list.isEmpty()) {
                String orderType = fieldOption.getOrderType(json);
                boolean isDesc = "desc".equalsIgnoreCase(orderType);
                list.sort((o1, o2) -> {
                    if (o1.getText() == null) {
                        return isDesc ? 1 : -1;
                    }
                    if (o2.getText() == null) {
                        return isDesc ? -1 : 1;
                    }
                    if (isDesc) {
                        return o2.getText().compareTo(o1.getText());
                    }
                    return o1.getText().compareTo(o2.getText());
                });
            }
            return list;
        }
        if (WidgetTypes.SELECT_USER.getType().equals(type)) {
            List<DictCount> list = this.a(fieldOption, json, groupDataList, true);
            return list;
        }
        return null;
    }

    private List<DictCount> b(FieldOption fieldOption, JSONObject json, List<DictCount> groupDataList) {
        Object leftFilterData = json.get((Object)fieldOption.getGroupModeKey());
        if (leftFilterData != null) {
            String filterStr = leftFilterData.toString();
            String orderType = fieldOption.getOrderType(json);
            if ("part".equalsIgnoreCase(filterStr)) {
                Object leftFilterCondition = json.get((Object)fieldOption.getGroupDataConditionKey());
                if (leftFilterCondition == null) {
                    return null;
                }
                String[] arr = leftFilterCondition.toString().split(",");
                List<String> codeList = Arrays.asList(arr);
                List<DictModel> dictList = this.queryTableAsDict(fieldOption, orderType, codeList);
                List<DictCount> dictCountList = this.a(groupDataList, dictList);
                return dictCountList;
            }
            if ("exist".equalsIgnoreCase(filterStr)) {
                List<DictModel> dictList = this.queryTableAsDict(fieldOption, orderType, null);
                this.b(groupDataList, dictList);
                return groupDataList;
            }
            if ("all".equalsIgnoreCase(filterStr)) {
                List<DictModel> dictList = this.queryTableAsDict(fieldOption, orderType, null);
                List<DictCount> dictCountList = this.a(groupDataList, dictList);
                return dictCountList;
            }
        }
        return null;
    }

    private List<DictCount> a(FieldOption fieldOption, JSONObject json, List<DictCount> groupDataList, boolean isTable) {
        String filterStr;
        String dictCode = fieldOption.getDictCode();
        ArrayList<DictModel> dictList = null;
        if (isTable) {
            String orderType = fieldOption.getOrderType(json);
            String dictTable = fieldOption.getDictTable();
            String dictText = fieldOption.getDictText();
            if ("sys_user".equals(dictTable)) {
                Integer tenantId = json.getInteger("X-Tenant-Id");
                dictList = this.designFormMapper.querySysUserDictDataByTenantId(tenantId);
            } else {
                dictList = this.queryTableDictDataBySqlInjection(dictTable, dictText, dictCode, null, dictCode, orderType);
            }
        } else if (oConvertUtils.isEmpty((Object)dictCode)) {
            String staticOptions = fieldOption.getStaticOptions();
            if (oConvertUtils.isEmpty((Object)staticOptions)) {
                return null;
            }
            JSONArray array = JSONArray.parseArray((String)staticOptions);
            dictList = new ArrayList();
            boolean showLabel = fieldOption.isStaticShowLabel();
            for (Object obj : array) {
                JSONObject temp = (JSONObject)obj;
                String value = temp.getString("value");
                String label = showLabel ? temp.getString("label") : value;
                dictList.add(new DictModel(value, label));
            }
        } else {
            dictList = this.sysBaseApi.getDictItems(dictCode);
        }
        Object leftFilterData = json.get((Object)fieldOption.getGroupModeKey());
        if (leftFilterData == null) {
            leftFilterData = "all";
        }
        if ("part".equalsIgnoreCase(filterStr = leftFilterData.toString())) {
            Object leftFilterCondition = json.get((Object)fieldOption.getGroupDataConditionKey());
            if (leftFilterCondition == null) {
                return null;
            }
            ArrayList<DictCount> list = new ArrayList<DictCount>();
            String[] arr = leftFilterCondition.toString().split(",");
            for (DictModel d2 : dictList) {
                boolean flag = false;
                for (String key : arr) {
                    if (!d2.getValue().equals(key)) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                DictCount temp = new DictCount(d2);
                for (DictCount dc : groupDataList) {
                    if (!d2.getValue().equals(dc.getValue())) continue;
                    temp.setCount(dc.getCount());
                    break;
                }
                list.add(temp);
            }
            return list;
        }
        if ("exist".equalsIgnoreCase(filterStr)) {
            this.b(groupDataList, dictList);
            return groupDataList;
        }
        List<DictCount> dictCountList = this.a(groupDataList, dictList);
        return dictCountList;
    }

    private List<DictCount> a(List<DictCount> groupDataList, List<DictModel> dictList) {
        ArrayList<DictCount> list = new ArrayList<DictCount>();
        for (DictModel d2 : dictList) {
            DictCount temp = new DictCount(d2);
            for (DictCount dictCount : groupDataList) {
                String dbData = dictCount.getValue();
                String value = d2.getValue();
                if (dbData == null || value == null || dbData.indexOf(value) < 0) continue;
                long cnt = dictCount.getCount();
                temp.setCount(cnt += temp.getCount());
            }
            list.add(temp);
        }
        return list;
    }

    private List<DictCount> b(List<DictCount> groupDataList, List<DictModel> dictList) {
        block0: for (DictCount d2 : groupDataList) {
            for (DictModel dictModel : dictList) {
                if (!dictModel.getValue().equals(d2.getValue())) continue;
                d2.setText(dictModel.getText());
                continue block0;
            }
        }
        return groupDataList;
    }

    private List<DictCount> a(DesignForm designForm, String leftFilterField, String username, ListViewModel listViewModel) {
        return this.a(designForm, leftFilterField, username, listViewModel, null, null);
    }

    private List<DictCount> a(DesignForm designForm, String leftFilterField, String username, ListViewModel listViewModel, DesformSuperQuery superQuery) {
        return this.a(designForm, leftFilterField, username, listViewModel, superQuery, null);
    }

    private List<DictCount> a(DesignForm designForm, String leftFilterField, String username, ListViewModel listViewModel, DesformSuperQuery superQuery, List<String> groupTypes) {
        return this.viewDao.getGroupData(designForm, leftFilterField, username, listViewModel, superQuery, groupTypes);
    }

    @Override
    public List<Map<String, Object>> loadQueryList(String listViewId) {
        JSONObject json;
        Object object;
        if (oConvertUtils.isNotEmpty((Object)listViewId) && (object = (json = (JSONObject)this.viewDao.findById(listViewId)).get((Object)"queryList")) != null) {
            return (List)object;
        }
        return null;
    }

    @Override
    public List<DictModel> queryTableAsDict(FieldOption fieldOption, String orderType, List<String> codeList) {
        return this.viewDao.queryTableAsDict(fieldOption, orderType, codeList);
    }

    @Override
    public String getFieldSummaryVal(DesignForm designForm, String field, String sType, DesformSuperQueryGroup superQueryGroup, DesformExtentdParam extendParams) {
        ListViewModel listViewModel = this.queryListViewInfo(designForm, extendParams.getListViewId(), extendParams.getUsername());
        return this.viewDao.getFieldSummaryVal(designForm, field, sType, superQueryGroup, listViewModel, extendParams);
    }

    @Override
    public void resetOrder(JSONObject jsonObject) {
        this.viewDao.resetOrder(jsonObject);
    }

    @Override
    public Query getQuery(String username, DesignForm designForm, DesformSuperQuery superQuery, ListViewModel listViewModel) {
        List<Criteria> criteriaList = this.getQueryCriterias(username, designForm, superQuery, listViewModel);
        if (criteriaList.size() > 0) {
            Criteria criteria = new Criteria();
            criteria.andOperator(criteriaList);
            Query query = new Query((CriteriaDefinition)criteria);
            CommonUtils.logInfo((String)"MongoDB \u67e5\u8be2\u6761\u4ef6: {}", (Object[])new Object[]{query});
            return query;
        }
        return null;
    }

    @Override
    public List<Criteria> getQueryCriterias(String username, DesignForm designForm, DesformSuperQuery superQuery, ListViewModel listViewModel) {
        Criteria treeTableCriteria;
        String code = designForm.getDesformCode();
        List<Criteria> criteriaList = this.geSystemtInjectionQueryCriterias(username, designForm, superQuery.getParameterMap(), listViewModel);
        Criteria superQueryCriteria = DesformQueryUtils.b(superQuery);
        if (superQueryCriteria != null) {
            criteriaList.add(superQueryCriteria);
        }
        if ((treeTableCriteria = this.a(superQuery.getParentField(), superQuery.getParentId())) != null) {
            criteriaList.add(treeTableCriteria);
        }
        return criteriaList;
    }

    private Criteria a(String parentField, String parentId) {
        DesformSuperQuery treeTableSuperQuery = DesformQueryUtils.a(parentField, parentId);
        if (treeTableSuperQuery == null || !treeTableSuperQuery.hasQuery()) {
            return null;
        }
        return DesformQueryUtils.b(treeTableSuperQuery);
    }

    @Override
    public List<Criteria> geSystemtInjectionQueryCriterias(String username, DesignForm designForm, Map<String, String[]> parameterMap, ListViewModel listViewModel) {
        List<Map<String, Object>> list;
        DesformSuperQuery baseQuery;
        Criteria baseQueryCriteria;
        Criteria filterCriteria;
        Criteria authCriteria;
        DesformSuperQuery authQuery;
        Criteria calendarCriteria;
        List<CalendarColumn> calendarColumnList;
        Criteria groupCriteria;
        DesformSuperQuery groupQuery;
        List<FieldOption> top5List;
        Criteria keywordCriteria;
        LowAppFormAuthRecordModel readAuth;
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        String code = designForm.getDesformCode();
        String delFlagValue = DesformQueryUtils.b("del_flag", parameterMap);
        if (oConvertUtils.isEmpty((Object)delFlagValue)) {
            delFlagCriteria = new Criteria("del_flag").is((Object)b.ai);
            criteriaList.add(delFlagCriteria);
        } else {
            delFlagCriteria = new Criteria("del_flag").is((Object)Integer.parseInt(delFlagValue));
            criteriaList.add(delFlagCriteria);
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String appId = DesformQueryUtils.b("appId", parameterMap);
        if (oConvertUtils.isNotEmpty((Object)appId) && (readAuth = this.lowAppBaseApi.getLowAppReadAuth(sysUser.getId(), appId, code, "read")) != null && !readAuth.isReadAll()) {
            List roleCodeList = this.sysBaseApi.getRolesByUsername(username);
            List departIdList = this.sysBaseApi.getDepartIdsByUsername(username);
            Criteria ownerCriteria = DesformQueryUtils.a(designForm, username, roleCodeList, departIdList);
            criteriaList.add(ownerCriteria);
        }
        if ((keywordCriteria = DesformQueryUtils.b(top5List = listViewModel.getFieldList(), parameterMap)) != null) {
            criteriaList.add(keywordCriteria);
        }
        if ("card".equals(listViewModel.getType()) && (groupQuery = listViewModel.getGroupQuery()) != null && groupQuery.getQueryItems().size() > 0 && (groupCriteria = DesformQueryUtils.b(groupQuery)) != null) {
            criteriaList.add(groupCriteria);
        }
        if ("calendar".equals(listViewModel.getType()) && (calendarColumnList = listViewModel.getCalendarColumnList()) != null && calendarColumnList.size() > 0 && (calendarCriteria = DesformQueryUtils.a(calendarColumnList, parameterMap)) != null) {
            criteriaList.add(calendarCriteria);
        }
        if ((authQuery = this.designFormAuthService.queryAuthData(code, username)).getQueryItems().size() > 0 && (authCriteria = DesformQueryUtils.b(authQuery)) != null) {
            criteriaList.add(authCriteria);
        }
        if (listViewModel.getSuperQuery() != null && (filterCriteria = DesformQueryUtils.a(listViewModel.getSuperQuery(), true)) != null) {
            criteriaList.add(filterCriteria);
        }
        if (listViewModel.getSuperQueryGroup() != null && (filterCriteria = DesformQueryUtils.a(listViewModel.getSuperQueryGroup(), true)) != null) {
            criteriaList.add(filterCriteria);
        }
        if ((baseQueryCriteria = DesformQueryUtils.a(baseQuery = DesformQueryUtils.d(list = listViewModel.getQueryList(), parameterMap), true)) != null) {
            criteriaList.add(baseQueryCriteria);
        }
        if (oConvertUtils.isNotEmpty((Object)listViewModel.getLeftFilterField())) {
            String field = listViewModel.getLeftFilterField();
            if (parameterMap != null) {
                ArrayList<SuperQueryItem> leftFilterItems = new ArrayList<SuperQueryItem>();
                for (String key : parameterMap.keySet()) {
                    CharSequence[] values;
                    if (!key.equals(field) || (values = parameterMap.get(field)) == null || values.length <= 0) continue;
                    String value = String.join((CharSequence)",", values);
                    if (value.trim().length() <= 0) break;
                    leftFilterItems.add(new SuperQueryItem(WidgetTypes.INPUT.getType(), field, value, QueryRuleEnum.EQ));
                    break;
                }
                if (leftFilterItems.size() > 0) {
                    DesformSuperQuery leftFilter = new DesformSuperQuery();
                    leftFilter.setMatchType(MatchTypeEnum.AND);
                    leftFilter.setQueryItems(leftFilterItems);
                    Criteria leftFilterCriteria = DesformQueryUtils.b(leftFilter);
                    if (leftFilterCriteria != null) {
                        criteriaList.add(leftFilterCriteria);
                    }
                }
            }
        }
        return criteriaList;
    }

    @Override
    public List<Criteria> addExpandParametersQueryCriterias(List<Criteria> criteriaList, DesformExtentdParam desformExtentdParam) {
        Map<String, String[]> parameterMap;
        List<String> excludeIdsList;
        if (oConvertUtils.isNotEmpty((Object)desformExtentdParam.getExcludeIds()) && !CollectionUtils.isEmpty(excludeIdsList = Arrays.asList(desformExtentdParam.getExcludeIds().split(",")))) {
            Criteria excludeIdsCriteria = new Criteria("_id").nin(excludeIdsList);
            criteriaList.add(excludeIdsCriteria);
        }
        if ((parameterMap = desformExtentdParam.getParameterMap()) != null && !parameterMap.isEmpty()) {
            for (String field : parameterMap.keySet()) {
                if (!"id".equals(field)) continue;
                CharSequence[] values = parameterMap.get(field);
                if (values == null || values.length <= 0) break;
                String valuesJoinStr = String.join((CharSequence)",", values);
                Criteria idsCriteria = new Criteria("_id").in((Object[])valuesJoinStr.split(","));
                criteriaList.add(idsCriteria);
                break;
            }
        }
        return criteriaList;
    }

    @Override
    public Criteria getQueryCriteriasGroup(String username, DesignForm designForm, DesformSuperQueryGroup desformSuperQueryGroup, ListViewModel listViewModel, DesformExtentdParam desformExtentdParam) {
        Criteria treeTableCriteria;
        List<DesformSuperQuery> superQueryGroupList = desformSuperQueryGroup.getSuperQueryGroup();
        Criteria criteriaGroup = new Criteria();
        ArrayList<Criteria> criteriaGroupList = new ArrayList<Criteria>();
        for (DesformSuperQuery superQuery : superQueryGroupList) {
            List<Criteria> criteriaList = DesformQueryUtils.b(superQuery, false);
            if (CollectionUtils.isEmpty(criteriaList)) continue;
            if (MatchTypeEnum.AND.equals((Object)superQuery.getMatchType())) {
                criteriaGroupList.add(new Criteria().andOperator(criteriaList));
                continue;
            }
            criteriaGroupList.add(new Criteria().orOperator(criteriaList));
        }
        if (!CollectionUtils.isEmpty(criteriaGroupList)) {
            if (MatchTypeEnum.AND.equals((Object)desformSuperQueryGroup.getMatchType())) {
                criteriaGroup.andOperator(criteriaGroupList);
            } else {
                criteriaGroup.orOperator(criteriaGroupList);
            }
        }
        Criteria criteriaAll = new Criteria();
        ArrayList<Criteria> criteriaAllList = new ArrayList<Criteria>();
        List<Criteria> systemInjectionCriteriaList = this.geSystemtInjectionQueryCriterias(username, designForm, desformExtentdParam.getParameterMap(), listViewModel);
        List<Criteria> finalCriteriaList = this.addExpandParametersQueryCriterias(systemInjectionCriteriaList, desformExtentdParam);
        if (!CollectionUtils.isEmpty(finalCriteriaList)) {
            criteriaAllList.add(criteriaGroup);
            criteriaAllList.add(new Criteria().andOperator(finalCriteriaList));
        }
        if ((treeTableCriteria = this.a(desformExtentdParam.getParentField(), desformExtentdParam.getParentId())) != null) {
            criteriaAllList.add(treeTableCriteria);
        }
        if (!CollectionUtils.isEmpty(criteriaAllList)) {
            criteriaAll.andOperator(criteriaAllList);
        }
        return criteriaAll;
    }

    @Override
    public void deleteFormViewData(String designFormCode) {
        this.viewDao.deleteViewConfigByCode(designFormCode);
    }

    @Override
    public List<DesignFormViewVo> queryListViewByCode(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        List<JSONObject> list = this.viewDao.getAllViewByCodeList(codeList);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<DesignFormViewVo> result = new ArrayList<DesignFormViewVo>();
        for (JSONObject json : list) {
            String name = json.getString("name");
            String type = json.getString("type");
            String id = json.getString("_id");
            String designFormCode = json.getString("desform_code");
            DesignFormViewVo vo = new DesignFormViewVo(id, type, name);
            vo.setDesignFormCode(designFormCode);
            result.add(vo);
        }
        return result;
    }

    @Override
    public void completeDataForDelFlag() {
        List formList = this.designFormMapper.selectList((Wrapper)new QueryWrapper());
        List tableNameList = formList.stream().map(i2 -> i2.getDesformCode()).collect(Collectors.toList());
        Set collectionNames = this.mongoTemplate.getCollectionNames();
        Query query = new Query();
        Update update = new Update().set("del_flag", (Object)0);
        for (String table : collectionNames) {
            if (tableNameList.indexOf(table) < 0) continue;
            this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, table);
        }
    }

    @Override
    public Map<String, String> copyDesignFormMongo(String originCode, String copyCode) {
        List<DesformSetting> settingList;
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser == null) {
            a.error("\u8868\u5355\u8bbe\u8ba1\u5668\u64cd\u4f5c\u9ad8\u7ea7\u67e5\u8be2\u6570\u636e\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a!");
        }
        String username = sysUser.getUsername();
        ButtonInfo button = new ButtonInfo(originCode);
        Example buttonExample = Example.of((Object)button);
        List buttonList = this.designFormListButtonDao.findAll(buttonExample);
        HashMap<String, String> buttonIdMapping = new HashMap<String, String>();
        if (buttonList != null && buttonList.size() > 0) {
            for (ButtonInfo json : buttonList) {
                String originId = json.getId();
                String copyId = IdWorker.getIdStr();
                buttonIdMapping.put(originId, copyId);
                json.setId(copyId);
                json.setCreateBy(username);
                json.setCreateTime(new Date());
                json.setDesignFormCode(copyCode);
            }
        }
        this.designFormListButtonDao.saveAll(buttonList);
        Query viewQuery = new Query((CriteriaDefinition)Criteria.where((String)"desform_code").is((Object)originCode));
        List viewList = this.mongoTemplate.find(viewQuery, JSONObject.class, "design_form_list_view");
        HashMap<String, String> viewIdMapping = new HashMap<String, String>();
        if (viewList != null && viewList.size() > 0) {
            for (Object json : viewList) {
                String originId = json.getString("_id");
                json.remove((Object)"_id");
                json.put("desform_code", (Object)copyCode);
                Object buttons = json.get((Object)"buttonList");
                if (buttons != null) {
                    ArrayList buttonIdList = (ArrayList)buttons;
                    List<String> copyButtonIdList = this.a(buttonIdList, buttonIdMapping);
                    json.put("buttonList", copyButtonIdList);
                }
                JSONObject temp = (JSONObject)this.mongoTemplate.insert(json, "design_form_list_view");
                ObjectId copyViewId = (ObjectId)temp.get((Object)"_id");
                viewIdMapping.put(originId, copyViewId.toString());
            }
        }
        if ((settingList = this.designFormSettingService.listByDesformCode(originCode)) != null && settingList.size() > 0) {
            for (DesformSetting json : settingList) {
                json.set_id(null);
                json.setDesformCode(copyCode);
                List<String> viewIds = json.getViewIds();
                List<String> copyViewIds = this.a(viewIds, viewIdMapping);
                json.setViewIds(copyViewIds);
            }
        }
        this.designFormSettingService.saveBatch(settingList);
        ExampleMatcher matcher = ExampleMatcher.matching().withIgnorePaths(new String[]{"selected", "myself"});
        Example example = Example.of((Object)new SuperQuery(originCode), (ExampleMatcher)matcher);
        List queryList = this.designFormListSuperQueryDao.findAll(example);
        if (queryList != null && queryList.size() > 0) {
            for (SuperQuery json : queryList) {
                json.setCreateBy(username);
                json.setId(IdWorker.getIdStr());
                json.setCode(copyCode);
            }
        }
        this.designFormListSuperQueryDao.saveAll(queryList);
        return viewIdMapping;
    }

    @Override
    public Map<String, String> backupDesignFormMongo(String formCode, String backupKey, String type) {
        Query query;
        List chartList;
        ExampleMatcher matcher;
        Example example;
        List queryList;
        List<DesformSetting> settingList;
        String newId;
        Query viewQuery;
        List viewList;
        ButtonInfo button;
        Example buttonExample;
        List buttonList;
        String newCode = LowAppCopyUtil.getBackupValue((String)formCode, (String)backupKey, (String)type);
        if ("cover".equals(type)) {
            Query buttonDeleteQuery = new Query((CriteriaDefinition)Criteria.where((String)"designFormCode").is((Object)newCode));
            this.mongoTemplate.remove(buttonDeleteQuery, "design_form_list_view_button");
        }
        if ((buttonList = this.designFormListButtonDao.findAll(buttonExample = Example.of((Object)(button = new ButtonInfo(formCode))))) != null && buttonList.size() > 0) {
            for (ButtonInfo json : buttonList) {
                String newId2 = LowAppCopyUtil.getBackupValue((String)json.getId(), (String)backupKey, (String)type);
                json.setId(newId2);
                json.setDesignFormCode(newCode);
                String processId = json.getProcessId();
                if (!oConvertUtils.isNotEmpty((Object)processId)) continue;
                String newProcessId = LowAppCopyUtil.getBackupValue((String)processId, (String)backupKey, (String)type);
                json.setProcessId(newProcessId);
            }
        }
        this.designFormListButtonDao.saveAll(buttonList);
        if ("cover".equals(type)) {
            Query viewDeleteQuery = new Query((CriteriaDefinition)Criteria.where((String)"desform_code").is((Object)newCode));
            this.mongoTemplate.remove(viewDeleteQuery, "design_form_list_view");
        }
        if ((viewList = this.mongoTemplate.find(viewQuery = new Query((CriteriaDefinition)Criteria.where((String)"desform_code").is((Object)formCode)), JSONObject.class, "design_form_list_view")) != null && viewList.size() > 0) {
            for (Object json : viewList) {
                String originId = json.getString("_id");
                newId = LowAppCopyUtil.getBackupValue((String)originId, (String)backupKey, (String)type);
                if (type.equals("cover")) {
                    json.put("_id", (Object)new ObjectId(newId));
                } else {
                    json.put("_id", (Object)newId);
                }
                json.put("desform_code", (Object)newCode);
                this.mongoTemplate.insert(json, "design_form_list_view");
            }
        }
        if ("cover".equals(type)) {
            Query settingDeleteQuery = new Query((CriteriaDefinition)Criteria.where((String)"desformCode").is((Object)newCode));
            this.mongoTemplate.remove(settingDeleteQuery, "design_form_setting");
        }
        if ((settingList = this.designFormSettingService.listByDesformCode(formCode)) != null && settingList.size() > 0) {
            for (DesformSetting json : settingList) {
                newId = LowAppCopyUtil.getBackupValue((String)json.get_id(), (String)backupKey, (String)type);
                json.set_id(newId);
                json.setDesformCode(newCode);
            }
        }
        this.designFormSettingService.saveBatch(settingList);
        if ("cover".equals(type)) {
            Query superQueryDeleteQuery = new Query((CriteriaDefinition)Criteria.where((String)"code").is((Object)newCode));
            this.mongoTemplate.remove(superQueryDeleteQuery, "design_form_list_super_query");
        }
        if ((queryList = this.designFormListSuperQueryDao.findAll(example = Example.of((Object)new SuperQuery(formCode), (ExampleMatcher)(matcher = ExampleMatcher.matching().withIgnorePaths(new String[]{"selected", "myself"}))))) != null && queryList.size() > 0) {
            for (SuperQuery json : queryList) {
                String newId3 = LowAppCopyUtil.getBackupValue((String)json.getId(), (String)backupKey, (String)type);
                json.setId(newId3);
                json.setCode(newCode);
            }
        }
        this.designFormListSuperQueryDao.saveAll(queryList);
        if ("cover".equals(type)) {
            Query chartDeleteQuery = new Query((CriteriaDefinition)Criteria.where((String)"designFormCode").is((Object)newCode));
            this.mongoTemplate.remove(chartDeleteQuery, "design_form_list_chart_config");
        }
        if ((chartList = this.mongoTemplate.find(query = new Query((CriteriaDefinition)Criteria.where((String)"designFormCode").is((Object)formCode)), DesignFormListChartConfig.class, "design_form_list_chart_config")) != null && chartList.size() > 0) {
            for (DesignFormListChartConfig json : chartList) {
                String newId4 = LowAppCopyUtil.getBackupValue((String)json.getId(), (String)backupKey, (String)type);
                json.setId(newId4);
                json.setDesignFormCode(newCode);
            }
        }
        this.designFormListChartConfigDao.saveAll(chartList);
        return null;
    }

    @Override
    public void deleteDesignFormMongoConfig(String designFormCode) {
        Query buttonDeleteQuery = new Query((CriteriaDefinition)Criteria.where((String)"designFormCode").is((Object)designFormCode));
        this.mongoTemplate.remove(buttonDeleteQuery, "design_form_list_view_button");
        Query viewDeleteQuery = new Query((CriteriaDefinition)Criteria.where((String)"desform_code").is((Object)designFormCode));
        this.mongoTemplate.remove(viewDeleteQuery, "design_form_list_view");
        Query settingDeleteQuery = new Query((CriteriaDefinition)Criteria.where((String)"desformCode").is((Object)designFormCode));
        this.mongoTemplate.remove(settingDeleteQuery, "design_form_setting");
        Query superQueryDeleteQuery = new Query((CriteriaDefinition)Criteria.where((String)"code").is((Object)designFormCode));
        this.mongoTemplate.remove(superQueryDeleteQuery, "design_form_list_super_query");
        Query chartDeleteQuery = new Query((CriteriaDefinition)Criteria.where((String)"designFormCode").is((Object)designFormCode));
        this.mongoTemplate.remove(chartDeleteQuery, "design_form_list_chart_config");
    }

    private List<String> a(List<String> buttonIdList, Map<String, String> buttonIdMapping) {
        ArrayList<String> copyList = new ArrayList<String>();
        for (String key : buttonIdList) {
            String mappingId = buttonIdMapping.get(key);
            if (mappingId == null) continue;
            copyList.add(mappingId);
        }
        return copyList;
    }

    @Override
    public List<DictModel> queryTableDictDataBySqlInjection(String table, String text, String code, List<String> codeList, String orderField, String orderType) {
        SqlInjectionUtil.filterContentMulti((String[])new String[]{table, text, code, orderField, orderType});
        table = SqlInjectionUtil.getSqlInjectTableName((String)table);
        text = SqlInjectionUtil.getSqlInjectField((String)text);
        code = SqlInjectionUtil.getSqlInjectField((String)code);
        orderField = SqlInjectionUtil.getSqlInjectField((String)orderField);
        orderType = SqlInjectionUtil.getSqlInjectField((String)orderType);
        return this.designFormMapper.queryTableDictData(table, text, code, codeList, orderField, orderType);
    }
}

