/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import org.bson.Document;
import org.jeecg.common.aspect.annotation.Dict;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.mongo.a.b;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.format.annotation.DateTimeFormat;

@TableName(value="design_form_data")
public class DesignFormData
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(DesignFormData.class);
    private static final long serialVersionUID = 1L;
    @TableId(type=IdType.ASSIGN_ID)
    private String id;
    private String desformId;
    @Excel(name="\u8868\u5355\u8bbe\u8ba1\u7f16\u7801", width=15.0)
    private String desformCode;
    @Excel(name="\u8868\u5355\u8bbe\u8ba1\u540d\u79f0", width=15.0)
    private String desformName;
    @Excel(name="\u8868\u5355\u8bbe\u8ba1\u7248\u672c", width=15.0)
    private Integer desformVersion;
    @Excel(name="\u8868\u5355\u6570\u636eJSON", width=15.0)
    private String desformDataJson;
    @TableField(exist=false)
    private JSONObject desformData;
    @Excel(name="Online\u8868\u5355\u7684Code", width=15.0)
    private String onlineFormCode;
    @Excel(name="Online\u6570\u636e\u8868\u4e2d\u7684id\uff0c\u7528\u4e8e\u4fee\u6539", width=15.0)
    private String onlineFormDataId;
    @Dict(dicCode="bpm_status")
    @Excel(name="\u6d41\u7a0b\u72b6\u6001", width=15.0, dicCode="bpm_status")
    private String bpmStatus;
    @Excel(name="OA\u8d85\u65f6\u65e5\u671f", width=15.0)
    private Date xOaTimeoutDate;
    @Excel(name="OA\u5f52\u6863\u72b6\u6001", width=15.0)
    private Integer xOaArchiveStatus;
    @Excel(name="\u521b\u5efa\u4eba", width=15.0)
    private String createBy;
    @Excel(name="\u521b\u5efa\u65f6\u95f4", width=20.0, format="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @Excel(name="\u4fee\u6539\u4eba", width=15.0)
    private String updateBy;
    @Excel(name="\u4fee\u6539\u65f6\u95f4", width=20.0, format="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    @Excel(name="\u5e94\u7528\u5220\u9664\u72b6\u6001 1\u662f 0\u5426", width=15.0)
    private Integer delFlag;
    @Excel(name="\u5220\u9664\u4eba", width=15.0)
    private String deleteBy;
    @Excel(name="\u5220\u9664\u65f6\u95f4", width=20.0, format="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date deleteTime;
    private String sysOrgCode;
    @Transient
    @TableField(exist=false)
    private boolean isTriggerProcess = true;
    @Transient
    @TableField(exist=false)
    private String importDataId;

    public DesignFormData() {
    }

    public DesignFormData(String desformCode, Document document) {
        JSONObject jSONObject = b.a(document);
        this.parseDataByJson(desformCode, jSONObject);
    }

    public DesignFormData(String desformCode, JSONObject jsonData) {
        this.parseDataByJson(desformCode, jsonData);
    }

    public String getDesformDataJson() {
        if (this.desformData == null) {
            return this.desformDataJson;
        }
        return JSON.toJSONString((Object)this.getDesformData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public JSONObject getDesformData() {
        if (this.desformData == null && oConvertUtils.isNotEmpty((Object)this.desformDataJson)) {
            this.setDesformData(JSON.parseObject((String)this.desformDataJson));
        }
        return this.desformData;
    }

    public void setDesformDataJson(String desformDataJson) {
        this.desformDataJson = desformDataJson;
        if (oConvertUtils.isNotEmpty((Object)desformDataJson)) {
            this.setDesformData(JSON.parseObject((String)desformDataJson));
        }
    }

    public void setDesformData(JSONObject desformData) {
        this.desformData = desformData;
        if (this.desformData == null) {
            return;
        }
        if (oConvertUtils.isEmpty((Object)this.desformData.getString("_id"))) {
            this.desformData.put("_id", (Object)this.getId());
        }
    }

    private void parseDataByJson(String desformCode, JSONObject jsonData) {
        this.desformCode = desformCode;
        this.id = jsonData.getString("_id");
        this.desformId = jsonData.getString("desform_id");
        this.desformName = jsonData.getString("desform_name");
        this.desformVersion = jsonData.getInteger("desform_version");
        this.onlineFormCode = jsonData.getString("online_form_code");
        this.onlineFormDataId = jsonData.getString("online_form_id");
        this.bpmStatus = jsonData.getString("bpm_status");
        this.xOaTimeoutDate = jsonData.getDate("x_oa_timeout_date");
        this.xOaArchiveStatus = jsonData.getInteger("x_oa_archive_status");
        this.createBy = jsonData.getString("create_by");
        this.updateBy = jsonData.getString("update_by");
        this.sysOrgCode = jsonData.getString("sys_org_code");
        try {
            this.createTime = jsonData.getDate("create_time");
        }
        catch (Exception exception) {
            log.warn(exception.getMessage());
        }
        try {
            this.updateTime = jsonData.getDate("update_time");
        }
        catch (Exception exception) {
            log.warn(exception.getMessage());
        }
        this.setDesformData(jsonData);
    }

    public void setxOaArchiveStatus(Integer xOaArchiveStatus) {
        this.xOaArchiveStatus = xOaArchiveStatus;
    }

    public Integer getxOaArchiveStatus() {
        return this.xOaArchiveStatus;
    }

    public void setxOaTimeoutDate(Date xOaTimeoutDate) {
        this.xOaTimeoutDate = xOaTimeoutDate;
    }

    public Date getxOaTimeoutDate() {
        return this.xOaTimeoutDate;
    }

    public String getId() {
        return this.id;
    }

    public String getDesformId() {
        return this.desformId;
    }

    public String getDesformCode() {
        return this.desformCode;
    }

    public String getDesformName() {
        return this.desformName;
    }

    public Integer getDesformVersion() {
        return this.desformVersion;
    }

    public String getOnlineFormCode() {
        return this.onlineFormCode;
    }

    public String getOnlineFormDataId() {
        return this.onlineFormDataId;
    }

    public String getBpmStatus() {
        return this.bpmStatus;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getUpdateBy() {
        return this.updateBy;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Integer getDelFlag() {
        return this.delFlag;
    }

    public String getDeleteBy() {
        return this.deleteBy;
    }

    public Date getDeleteTime() {
        return this.deleteTime;
    }

    public String getSysOrgCode() {
        return this.sysOrgCode;
    }

    public boolean isTriggerProcess() {
        return this.isTriggerProcess;
    }

    public String getImportDataId() {
        return this.importDataId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDesformId(String desformId) {
        this.desformId = desformId;
    }

    public void setDesformCode(String desformCode) {
        this.desformCode = desformCode;
    }

    public void setDesformName(String desformName) {
        this.desformName = desformName;
    }

    public void setDesformVersion(Integer desformVersion) {
        this.desformVersion = desformVersion;
    }

    public void setOnlineFormCode(String onlineFormCode) {
        this.onlineFormCode = onlineFormCode;
    }

    public void setOnlineFormDataId(String onlineFormDataId) {
        this.onlineFormDataId = onlineFormDataId;
    }

    public void setBpmStatus(String bpmStatus) {
        this.bpmStatus = bpmStatus;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    public void setDeleteBy(String deleteBy) {
        this.deleteBy = deleteBy;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }

    public void setSysOrgCode(String sysOrgCode) {
        this.sysOrgCode = sysOrgCode;
    }

    public void setTriggerProcess(boolean isTriggerProcess) {
        this.isTriggerProcess = isTriggerProcess;
    }

    public void setImportDataId(String importDataId) {
        this.importDataId = importDataId;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof DesignFormData)) {
            return false;
        }
        DesignFormData designFormData = (DesignFormData)o2;
        if (!designFormData.canEqual(this)) {
            return false;
        }
        if (this.isTriggerProcess() != designFormData.isTriggerProcess()) {
            return false;
        }
        Integer n2 = this.getDesformVersion();
        Integer n3 = designFormData.getDesformVersion();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        Integer n4 = this.getxOaArchiveStatus();
        Integer n5 = designFormData.getxOaArchiveStatus();
        if (n4 == null ? n5 != null : !((Object)n4).equals(n5)) {
            return false;
        }
        Integer n6 = this.getDelFlag();
        Integer n7 = designFormData.getDelFlag();
        if (n6 == null ? n7 != null : !((Object)n6).equals(n7)) {
            return false;
        }
        String string = this.getId();
        String string2 = designFormData.getId();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getDesformId();
        String string4 = designFormData.getDesformId();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getDesformCode();
        String string6 = designFormData.getDesformCode();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getDesformName();
        String string8 = designFormData.getDesformName();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getDesformDataJson();
        String string10 = designFormData.getDesformDataJson();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        JSONObject jSONObject = this.getDesformData();
        JSONObject jSONObject2 = designFormData.getDesformData();
        if (jSONObject == null ? jSONObject2 != null : !jSONObject.equals(jSONObject2)) {
            return false;
        }
        String string11 = this.getOnlineFormCode();
        String string12 = designFormData.getOnlineFormCode();
        if (string11 == null ? string12 != null : !string11.equals(string12)) {
            return false;
        }
        String string13 = this.getOnlineFormDataId();
        String string14 = designFormData.getOnlineFormDataId();
        if (string13 == null ? string14 != null : !string13.equals(string14)) {
            return false;
        }
        String string15 = this.getBpmStatus();
        String string16 = designFormData.getBpmStatus();
        if (string15 == null ? string16 != null : !string15.equals(string16)) {
            return false;
        }
        Date date = this.getxOaTimeoutDate();
        Date date2 = designFormData.getxOaTimeoutDate();
        if (date == null ? date2 != null : !((Object)date).equals(date2)) {
            return false;
        }
        String string17 = this.getCreateBy();
        String string18 = designFormData.getCreateBy();
        if (string17 == null ? string18 != null : !string17.equals(string18)) {
            return false;
        }
        Date date3 = this.getCreateTime();
        Date date4 = designFormData.getCreateTime();
        if (date3 == null ? date4 != null : !((Object)date3).equals(date4)) {
            return false;
        }
        String string19 = this.getUpdateBy();
        String string20 = designFormData.getUpdateBy();
        if (string19 == null ? string20 != null : !string19.equals(string20)) {
            return false;
        }
        Date date5 = this.getUpdateTime();
        Date date6 = designFormData.getUpdateTime();
        if (date5 == null ? date6 != null : !((Object)date5).equals(date6)) {
            return false;
        }
        String string21 = this.getDeleteBy();
        String string22 = designFormData.getDeleteBy();
        if (string21 == null ? string22 != null : !string21.equals(string22)) {
            return false;
        }
        Date date7 = this.getDeleteTime();
        Date date8 = designFormData.getDeleteTime();
        if (date7 == null ? date8 != null : !((Object)date7).equals(date8)) {
            return false;
        }
        String string23 = this.getSysOrgCode();
        String string24 = designFormData.getSysOrgCode();
        if (string23 == null ? string24 != null : !string23.equals(string24)) {
            return false;
        }
        String string25 = this.getImportDataId();
        String string26 = designFormData.getImportDataId();
        return !(string25 == null ? string26 != null : !string25.equals(string26));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DesignFormData;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        n3 = n3 * 59 + (this.isTriggerProcess() ? 79 : 97);
        Integer n4 = this.getDesformVersion();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Integer n5 = this.getxOaArchiveStatus();
        n3 = n3 * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        Integer n6 = this.getDelFlag();
        n3 = n3 * 59 + (n6 == null ? 43 : ((Object)n6).hashCode());
        String string = this.getId();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getDesformId();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getDesformCode();
        n3 = n3 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getDesformName();
        n3 = n3 * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getDesformDataJson();
        n3 = n3 * 59 + (string5 == null ? 43 : string5.hashCode());
        JSONObject jSONObject = this.getDesformData();
        n3 = n3 * 59 + (jSONObject == null ? 43 : jSONObject.hashCode());
        String string6 = this.getOnlineFormCode();
        n3 = n3 * 59 + (string6 == null ? 43 : string6.hashCode());
        String string7 = this.getOnlineFormDataId();
        n3 = n3 * 59 + (string7 == null ? 43 : string7.hashCode());
        String string8 = this.getBpmStatus();
        n3 = n3 * 59 + (string8 == null ? 43 : string8.hashCode());
        Date date = this.getxOaTimeoutDate();
        n3 = n3 * 59 + (date == null ? 43 : ((Object)date).hashCode());
        String string9 = this.getCreateBy();
        n3 = n3 * 59 + (string9 == null ? 43 : string9.hashCode());
        Date date2 = this.getCreateTime();
        n3 = n3 * 59 + (date2 == null ? 43 : ((Object)date2).hashCode());
        String string10 = this.getUpdateBy();
        n3 = n3 * 59 + (string10 == null ? 43 : string10.hashCode());
        Date date3 = this.getUpdateTime();
        n3 = n3 * 59 + (date3 == null ? 43 : ((Object)date3).hashCode());
        String string11 = this.getDeleteBy();
        n3 = n3 * 59 + (string11 == null ? 43 : string11.hashCode());
        Date date4 = this.getDeleteTime();
        n3 = n3 * 59 + (date4 == null ? 43 : ((Object)date4).hashCode());
        String string12 = this.getSysOrgCode();
        n3 = n3 * 59 + (string12 == null ? 43 : string12.hashCode());
        String string13 = this.getImportDataId();
        n3 = n3 * 59 + (string13 == null ? 43 : string13.hashCode());
        return n3;
    }

    public String toString() {
        return "DesignFormData(id=" + this.getId() + ", desformId=" + this.getDesformId() + ", desformCode=" + this.getDesformCode() + ", desformName=" + this.getDesformName() + ", desformVersion=" + this.getDesformVersion() + ", desformDataJson=" + this.getDesformDataJson() + ", desformData=" + this.getDesformData() + ", onlineFormCode=" + this.getOnlineFormCode() + ", onlineFormDataId=" + this.getOnlineFormDataId() + ", bpmStatus=" + this.getBpmStatus() + ", xOaTimeoutDate=" + this.getxOaTimeoutDate() + ", xOaArchiveStatus=" + this.getxOaArchiveStatus() + ", createBy=" + this.getCreateBy() + ", createTime=" + this.getCreateTime() + ", updateBy=" + this.getUpdateBy() + ", updateTime=" + this.getUpdateTime() + ", delFlag=" + this.getDelFlag() + ", deleteBy=" + this.getDeleteBy() + ", deleteTime=" + this.getDeleteTime() + ", sysOrgCode=" + this.getSysOrgCode() + ", isTriggerProcess=" + this.isTriggerProcess() + ", importDataId=" + this.getImportDataId() + ")";
    }
}

