<#assign CACHE_VERSION = "v=1703852121.10">
<#assign base = springMacroRequestContext.getContextUrl("")>

<#--noinspection HtmlUnknownTarget,FtlReferencesInspection-->
<#assign baseLib="${base}/desform/lib">
<#assign baseJmForm="${baseLib}/jm-form">
<#assign baseElementUI="${baseLib}/element-ui">
<!DOCTYPE html>
<html lang="zh-Hans">

<head>
	<title></title>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=Edge，chrome=1">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
	<#-- 加载样式 -->
	<link rel="stylesheet" href="${baseElementUI}/elementUI.css?${CACHE_VERSION}">
	<link rel="stylesheet" href="${baseJmForm}/JmForm.css?${CACHE_VERSION}">
	<link rel="stylesheet" href="${base}/desform/lib/toastui/ToastUI.css?cv=1">
	<link rel="stylesheet" href="${base}/desform/lib/tinymce/Tinymce.css?cv=1">
	<link rel="stylesheet" href="${base}/desform/lib/codemirror/Codemirror.css?cv=1">

	<style>
		html,
		body,
		#app {
			height: 100%;
		}
	</style>
</head>

<body>
	<div id="app">
		<!-- 需要设置编辑区域高度 -->
		<!-- preview upload generate-code generate-json -->
		<!-- :base-url="baseURL" :access-token="token" -->
		<jm-design-form
			v-show="currentPage == 'design'"
			ref="jmform"
			:debug="debug"
			quick-layout
			:is-low-app="isLowApp"
			style="height: 100%"
			@save="handleSaveForm"
			@emit-parent="handlerEmitParent"
		>
			<template slot="action">
				<el-button type="text" size="medium" icon="el-icon-view" @click="handlePreview">预览</el-button>
				<el-button type="text" size="medium" icon="el-icon-document-checked" @click="()=>handleSaveForm()">保存</el-button>
				<el-button type="text" size="medium" icon="el-icon-close" style="color:red" @click="handleClose">关闭</el-button>
			</template>
		</jm-design-form>
		<keep-alive>
			<form-setting-box
				v-if="currentPage == 'setting'"
				ref="settingBox"
				:design-json="designJson"
				:desform-code="desformCode"
				:is-low-app="isLowApp"
				@save="handleSaveForm"
				@close="handleClose"
				@emit-parent="handlerEmitParent"
			/>
		</keep-alive>

	</div>
</body>

<script src="${base}/desform/lib/unpkg/polyfill/7.2.5/polyfill.js"></script>

<#if (baiduMapAK!"")?trim?length gt 0>
<script src="https://api.map.baidu.com/api?v=3.0&ak=${baiduMapAK}"></script>
</#if>

<script src="${base}/desform/lib/unpkg/vue@2.7.13/vue.js?${CACHE_VERSION}"></script>
<script src="${base}/desform/lib/unpkg/jquery@3.4.1/jquery.js?${CACHE_VERSION}"></script>
<#--<script src="${base}/desform/lib/mathjs/MathJs.umd.js"></script>-->
<script src="${base}/desform/lib/unpkg/moment/moment@2.29.4.js"></script>
<script src="${base}/desform/lib/unpkg/moment/zh-cn@2.29.4.js"></script>

<script src="${base}/desform/lib/toastui/ToastUI.umd.js?cv=1"></script>
<script src="${base}/desform/lib/tinymce/Tinymce.umd.js?cv=1"></script>
<script src="${base}/desform/lib/codemirror/Codemirror.umd.js?cv=1"></script>

<script src="${baseElementUI}/ElementUI.umd.js?${CACHE_VERSION}"></script>
<script src="${base}/desform/lib/unpkg/vue-ls@3.2.1/vue-ls.min.js?${CACHE_VERSION}"></script>
<!-- 引入组件库 -->
<script src="${baseJmForm}/JmForm.umd.js?${CACHE_VERSION}"></script>
<!-- 需要在设计器中预览代码需要引入ace.js库 -->
<script src="${base}/desform/lib/unpkg/jm-form@1.1.23/ace.js?${CACHE_VERSION}"></script>
<script src="${base}/desform/utils.js?${CACHE_VERSION}"></script>

<#-- 二维码 -->
<script src="${baseLib}/qrcode.min.js?${CACHE_VERSION}"></script>
<#-- 条形码 -->
<script src="${baseLib}/JsBarcode.code128.min.js?${CACHE_VERSION}"></script>

<script>

	var store = JmForm.default.store
	var DeviceMixins = JmForm.default.mixins.DeviceMixins
	var constant = JmForm.default.constant

	// 从配置里读取主题颜色
	window['THEME_COLOR'] = '${themeColor}'
	// 从配置里读取上传方式
	window['UPLOAD_TYPE'] = '${uploadType}'
	// 从配置里读取签名秘钥 e3e3NcxzbUiGa53YYVXxWc8ADo5ISgQGx/gaZwERF91oAryDlivjqBv3wqRArgChupi+Y/Gg/swwGEyL0PuVFg==
	window['SIGNATURE_SECRET']= '${signatureSecret}'
	var debug = getQueryParams("debug")
  debug = !(debug === 'false')

  // 暂时关闭 debug 模式
  debug = true

	var isLowApp = getQueryParams("isLowApp")
	isLowApp = !(isLowApp === 'false')

	var token = getQueryParams("token")
	var messageId = getQueryParams("messageId")
	var tenantId = getQueryParams("tenantId")
	var lowAppId = getQueryParams("lowAppId")

	Vue.ls.set(constant.BASE_URL, '${baseURL}')
	Vue.ls.set(constant.ACCESS_TOKEN, token)
	Vue.ls.set(constant.TENANT_ID, tenantId)
	Vue.ls.set(constant.LOW_APP_ID, lowAppId)

	<#if desform ? exists>
	window.desformId = '${desform.id}'
	window.desformCode = '${desform.desformCode}'
	window.desformName = '${desform.desformName}'
	</#if>

	<#if qiniuConfig ? exists>
	console.log('qiniuConfig: ', ${qiniuConfig})
	window.qiniuConfig = ${qiniuConfig}
	window.qiniuPriSecretKey = 'e3e3NcxzbUiGa53YYVXxWc8ADo5ISgQGx/gaZwERF91oAryDlivjqBv3wqRArgChupi+Y/Gg/swwGEyL0PuVFg=='
	</#if>


	var originUrl = getQueryParams('originUrl')
	if (!originUrl) {
		originUrl = '${pcURL}'
	} else {
		originUrl = decodeURIComponent(originUrl)
	}
	window['_CONFIG'] = {
		originUrl: originUrl,
	}
	

	new Vue({
		el: '#app',
		store: store,
		mixins: [DeviceMixins],
		data: {

			<#if onlineCgformOptions ? exists>
			onlineFormOptions: ${onlineCgformOptions},
			</#if>
			<#if sysDictOptions ? exists>
			sysDictOptions: ${sysDictOptions},
			</#if>

			debug: debug,
			isLowApp: isLowApp,
			token: token,
			baseURL: '${baseURL}',
			designJson: {},
			desformCode: '${desform.desformCode}',
			// 当前页面
			currentPage: 'design',
		},
		created: function () {
			var _this = this
			window.addEventListener('message', function (event) {
				let { type, data } = event.data
				if (messageId !== event.data.messageId) {
					return;
				}
				switch (type) {
					case 'change-page':
						_this.handleChangePage(data.type)
						break;
					// 尝试关闭页面，如果更改了数据则提示
					case 'try-close':
						_this.handleClose()
						break;
					// 自定义动作指令
					case 'custom-button:command':
						_this.$refs.settingBox.doSuperEvent(data.type, data.data);
						break;
				}
			}, false)
			postEvent('created', null, messageId)
		},
		mounted: function () {
			//-- <#if designJson ? exists>
			this.setJSON(${designJson})
			//-- <#else>
			this.$refs.jmform.initJSON()
			//-- </#if>



		},
		methods: {

			/** 点击保存按钮事件 */
			handleSaveForm: function (settings) {
				var _this = this
				var source = _this.getJson()
				if (source.list.length === 0) {
					_this.postModal('alert-warning', '无法保存空表单', "提示")
					return
				}
				postEvent('request-save', {
					designJson: JSON.stringify(source),
					// 将refTable默认值配置统一提交到后台
					refTableDefaultValDbSync: _this.$refs.jmform.defaultValDbSync,
					settings,
				}, messageId);
			},

			/** 点击关闭按钮事件 */
			handleClose: function () {
				postEvent('closing', this.getJson(), messageId)
			},

			/** 点击浏览按钮 */
			handlePreview: function () {
				this.$refs.jmform.handlePreview()
			},

			/** 向父级触发事件 */
			handlerEmitParent({ type, data }) {
				postEvent(type, data, messageId);
			},

			handleChangePage: function (type) {
				let _this = this;
				if (this.currentPage === 'design') {
					// 静默获取设计器json数据（不对JSON数据做更改）
					this.designJson = this.$refs.jmform.widgetForm;
				}
				this.currentPage = type;
				if (type === 'design') {
					_this.$nextTick(function () {
						// 静默更改设计器JSON
						_this.$refs.jmform.widgetForm = _this.designJson
					});
				}
				if (type === 'setting') {
					_this.$nextTick(function () {
						// 重新构造widgets
						_this.$refs.settingBox.generateWidgets()
					});
				}
			},

			/** 获取设计器json数据 **/
			getJson: function () {
				if (this.currentPage === 'design') {
					return this.$refs.jmform.getJSON()
				} else {
					return this.$refs.settingBox.getJSON()
				}
			},
			/** 设置设计器json数据 **/
			setJSON: function (json) {
				this.designJson = json;
				this.$refs.jmform.setJSON(json);
			},

			/** 向父级提出弹窗申请 */
			postModal: function (type, content, title, options) {
				postEvent('modal', {
					type: type,
					title: title,
					content: content,
					options: options
				}, messageId)
			},

		}
	})
</script>

</html>