/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.mongo.service.a;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.List;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.lowapp.model.LowAppFormAuthRecordModel;
import org.jeecg.common.online.api.IOnlineBaseExtApi;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.mongo.constant.DesformSettingCode;
import org.jeecg.modules.online.desform.mongo.constant.a;
import org.jeecg.modules.online.desform.mongo.dao.DesignFormSettingDao;
import org.jeecg.modules.online.desform.mongo.model.DesformSetting;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormSettingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.stereotype.Service;

@Service(value="designFormSettingServiceImpl")
public class h
implements IDesignFormSettingService {
    private static final Logger a = LoggerFactory.getLogger(h.class);
    @Autowired
    private DesignFormSettingDao settingDao;
    @Autowired
    IOnlineBaseExtApi onlineBaseExtApi;

    @Override
    public List<DesformSetting> listByDesformCode(String desformCode) {
        DesformSetting desformSetting = new DesformSetting();
        desformSetting.setDesformCode(desformCode);
        ExampleMatcher exampleMatcher = ExampleMatcher.matching();
        Example example = Example.of((Object)desformSetting, (ExampleMatcher)exampleMatcher);
        return this.settingDao.findAll(example);
    }

    @Override
    public List<DesformSetting> listWithDefault(String desformCode) {
        List<DesformSetting> list = this.listByDesformCode(desformCode);
        for (DesformSettingCode desformSettingCode : DesformSettingCode.values()) {
            boolean bl = list.stream().anyMatch(desformSetting -> desformSettingCode.equals((Object)desformSetting.getCode()));
            if (bl) continue;
            list.add(this.a(desformSettingCode, desformCode));
        }
        return list;
    }

    private DesformSetting a(DesformSettingCode desformSettingCode, String string) {
        DesformSetting desformSetting = new DesformSetting();
        desformSetting.setCode(desformSettingCode);
        desformSetting.setDesformCode(string);
        desformSetting.setEnabled(true);
        desformSetting.setUserAuth(org.jeecg.modules.online.desform.mongo.constant.a.a);
        desformSetting.setViewAuth(org.jeecg.modules.online.desform.mongo.constant.a.c);
        desformSetting.setViewIds(new ArrayList<String>());
        return desformSetting;
    }

    private DesformSetting a(DesformSetting desformSetting) {
        if (oConvertUtils.isEmpty((Object)desformSetting.get_id())) {
            desformSetting.set_id(IdWorker.getIdStr());
        }
        DesformSetting desformSetting2 = this.a(desformSetting.getCode(), desformSetting.getDesformCode());
        if (desformSetting.getEnabled() == null) {
            desformSetting.setEnabled(desformSetting2.getEnabled());
        }
        if (desformSetting.getUserAuth() == null) {
            desformSetting.setUserAuth(desformSetting2.getUserAuth());
        }
        if (desformSetting.getViewAuth() == null) {
            desformSetting.setViewAuth(desformSetting2.getViewAuth());
        }
        if (desformSetting.getViewIds() == null) {
            desformSetting.setViewIds(desformSetting2.getViewIds());
        }
        return desformSetting;
    }

    @Override
    public DesformSetting saveOrUpdate(DesformSetting settingData) {
        if (settingData.getCode() == null) {
            throw new JeecgBootException("code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (oConvertUtils.isEmpty((Object)settingData.getDesformCode())) {
            throw new JeecgBootException("desformCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return (DesformSetting)this.settingDao.save(this.a(settingData));
    }

    @Override
    public List<DesformSetting> saveBatch(List<DesformSetting> settingList) {
        ArrayList<DesformSetting> arrayList = new ArrayList<DesformSetting>(settingList.size());
        for (DesformSetting desformSetting : settingList) {
            if (desformSetting.getCode() == null) {
                throw new JeecgBootException("code\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (oConvertUtils.isEmpty((Object)desformSetting.getDesformCode())) {
                throw new JeecgBootException("desformCode\u4e0d\u80fd\u4e3a\u7a7a");
            }
            arrayList.add(this.a(desformSetting));
        }
        return this.settingDao.saveAll(arrayList);
    }

    @Override
    public boolean removeByDesformCode(String desformCode) {
        List<DesformSetting> list = this.listByDesformCode(desformCode);
        this.settingDao.deleteAll(list);
        return true;
    }

    @Override
    public List<String> queryAllowFuncByCode(String desformCode, String viewId, String userId, String appId) {
        List<DesformSetting> list = this.listWithDefault(desformCode);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DesformSetting desformSetting : list) {
            if (!desformSetting.getEnabled().booleanValue()) continue;
            if (org.jeecg.modules.online.desform.mongo.constant.a.b.equals(desformSetting.getUserAuth())) {
                boolean bl = false;
                LowAppFormAuthRecordModel lowAppFormAuthRecordModel = this.onlineBaseExtApi.getLowAppReadAuth(userId, appId, desformCode, null);
                if (lowAppFormAuthRecordModel != null) {
                    bl = lowAppFormAuthRecordModel.isHasAdmin();
                }
                if (!bl) continue;
            }
            if (org.jeecg.modules.online.desform.mongo.constant.a.d.equals(desformSetting.getViewAuth()) && !desformSetting.getViewIds().contains(viewId)) continue;
            arrayList.add(desformSetting.getCode().name());
        }
        return arrayList;
    }
}

