/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.graphreport.service.a;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportItem;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportHead;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportItem;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportParams;
import org.jeecg.modules.online.graphreport.mapper.OnlGraphreportHeadMapper;
import org.jeecg.modules.online.graphreport.mapper.OnlGraphreportItemMapper;
import org.jeecg.modules.online.graphreport.mapper.OnlGraphreportParamsMapper;
import org.jeecg.modules.online.graphreport.service.IOnlGraphreportHeadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="onlGraphreportHeadServiceImpl")
public class c
extends ServiceImpl<OnlGraphreportHeadMapper, OnlGraphreportHead>
implements IOnlGraphreportHeadService {
    @Autowired
    private OnlGraphreportHeadMapper onlGraphreportHeadMapper;
    @Autowired
    private OnlGraphreportItemMapper onlGraphreportItemMapper;
    @Autowired
    private OnlGraphreportParamsMapper onlGraphreportParamsMapper;
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    @Override
    public List<Map<String, Object>> executeSelect(String sql, Map<String, Object> param) {
        return this.onlGraphreportHeadMapper.executeSelect(sql, param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMain(OnlGraphreportHead onlGraphreportHead, List<OnlGraphreportItem> onlGraphreportItemList, List<OnlGraphreportParams> paramsList) {
        if (onlGraphreportHead.getYaxisText() == null) {
            onlGraphreportHead.setYaxisText("yaxis_text");
        }
        this.onlGraphreportHeadMapper.insert(onlGraphreportHead);
        for (OnlGraphreportItem onlGraphreportItem : onlGraphreportItemList) {
            onlGraphreportItem.setGraphreportHeadId(onlGraphreportHead.getId());
            this.onlGraphreportItemMapper.insert(onlGraphreportItem);
        }
        for (OnlGraphreportParams onlGraphreportParams : paramsList) {
            onlGraphreportParams.setHeadId(onlGraphreportHead.getId());
            this.onlGraphreportParamsMapper.insert(onlGraphreportParams);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMain(OnlGraphreportHead onlGraphreportHead, List<OnlGraphreportItem> onlGraphreportItemList, List<OnlGraphreportParams> paramsList) {
        this.onlGraphreportHeadMapper.updateById(onlGraphreportHead);
        this.onlGraphreportItemMapper.deleteByMainId(onlGraphreportHead.getId());
        this.onlGraphreportParamsMapper.deleteByMainId(onlGraphreportHead.getId());
        for (OnlGraphreportItem onlGraphreportItem : onlGraphreportItemList) {
            onlGraphreportItem.setGraphreportHeadId(onlGraphreportHead.getId());
            this.onlGraphreportItemMapper.insert(onlGraphreportItem);
        }
        for (OnlGraphreportParams onlGraphreportParams : paramsList) {
            onlGraphreportParams.setHeadId(onlGraphreportHead.getId());
            this.onlGraphreportParamsMapper.insert(onlGraphreportParams);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        this.onlGraphreportHeadMapper.deleteById((Serializable)((Object)id));
        this.onlGraphreportItemMapper.deleteByMainId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delBatchMain(Collection<? extends Serializable> idList) {
        for (Serializable serializable : idList) {
            this.onlGraphreportHeadMapper.deleteById(serializable);
            this.onlGraphreportItemMapper.deleteByMainId(serializable.toString());
        }
    }

    @Override
    public OnlGraphreportHead queryByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        return (OnlGraphreportHead)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"sys:cache:online:graph"}, key="#head.id")
    public Map<String, Object> queryChartConfig(OnlGraphreportHead head) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        resultMap.put("head", head);
        if (head.getYaxisField() != null) {
            head.setYaxisField(head.getYaxisField().toLowerCase());
        }
        if (head.getXaxisField() != null) {
            head.setXaxisField(head.getXaxisField().toLowerCase());
        }
        List<OnlGraphreportItem> items = this.onlGraphreportItemMapper.selectByMainId(head.getId());
        for (OnlGraphreportItem i2 : items) {
            if (i2.getFieldName() == null) continue;
            i2.setFieldName(i2.getFieldName().toLowerCase());
        }
        HashMap<String, List> dictOptions = new HashMap<String, List>(5);
        for (OnlGraphreportItem item : items) {
            String dictCode = item.getDictCode();
            if (StringUtils.isEmpty((String)dictCode)) continue;
            List dictList = null;
            if (dictCode.toLowerCase().trim().indexOf("select ") == 0) {
                this.sysBaseAPI.dictTableWhiteListCheckByDict(dictCode, new String[0]);
                List<Map<String, Object>> queryDictList = this.onlGraphreportHeadMapper.executeSqlDict(dictCode);
                if (queryDictList != null && queryDictList.size() != 0) {
                    String queryDictJson = JSON.toJSONString(queryDictList);
                    dictList = JSON.parseArray((String)queryDictJson, DictModel.class);
                }
            } else {
                dictList = this.sysBaseAPI.queryDictItemsByCode(dictCode);
            }
            dictOptions.put(item.getFieldName(), dictList);
        }
        resultMap.put("items", items);
        resultMap.put("dictOptions", dictOptions);
        return resultMap;
    }

    @Override
    public List<OnlCgreportItem> parseJsonField(String json) {
        JSONArray jsonArray = JSON.parseArray((String)json);
        return this.parseJsonField(jsonArray);
    }

    @Override
    public List<OnlCgreportItem> parseJsonField(JSONArray array) {
        if (array == null || array.size() == 0) {
            return new ArrayList<OnlCgreportItem>();
        }
        HashMap<String, OnlCgreportItem> fieldMap = new HashMap<String, OnlCgreportItem>(5);
        for (int i2 = 0; i2 < array.size(); ++i2) {
            JSONObject obj = array.getJSONObject(i2);
            for (String key : obj.keySet()) {
                if (fieldMap.containsKey(key)) continue;
                OnlCgreportItem item = new OnlCgreportItem();
                item.setFieldName(key.toLowerCase());
                item.setFieldTxt(key);
                item.setIsShow(1);
                item.setOrderNum(i2);
                item.setId(org.jeecg.modules.online.cgform.d.c.a());
                item.setFieldType("String");
                fieldMap.put(key, item);
            }
        }
        return new ArrayList<OnlCgreportItem>(fieldMap.values());
    }
}

