/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.Process;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessForm;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNode;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNodeDeployment;
import org.jeecg.modules.extbpm.process.mapper.ExtActProcessFormMapper;
import org.jeecg.modules.extbpm.process.mapper.ExtActProcessMapper;
import org.jeecg.modules.extbpm.process.service.IExtActProcessNodeDeploymentService;
import org.jeecg.modules.extbpm.process.service.IExtActProcessNodeService;
import org.springframework.stereotype.Component;

@Component(value="processUtils")
public class ProcessUtils {
    private final ExtActProcessMapper extActProcessMapper;
    private final IExtActProcessNodeService extActProcessNodeService;
    private final IExtActProcessNodeDeploymentService extActProcessNodeDeploymentService;
    private final ExtActProcessFormMapper extActProcessFormMapper;
    private final RepositoryService repositoryService;
    private final RuntimeService runtimeService;

    public ExtActProcess getExtActProcessByProcessKey(String processKey) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(true, ExtActProcess::getProcessKey, (Object)processKey);
        return (ExtActProcess)this.extActProcessMapper.selectOne((Wrapper)queryWrapper);
    }

    public List<ExtActProcess> getExtActProcessByStartType(String startType, Integer tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(true, ExtActProcess::getStartType, (Object)startType);
        queryWrapper.lambda().eq(true, ExtActProcess::getTenantId, (Object)tenantId);
        return this.extActProcessMapper.selectList((Wrapper)queryWrapper);
    }

    public ExtActProcessNode getExtActProcessNode(String processId, String processNodeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(true, ExtActProcessNode::getProcessId, (Object)processId)).eq(true, ExtActProcessNode::getProcessNodeCode, (Object)processNodeCode);
        return (ExtActProcessNode)this.extActProcessNodeService.getOne((Wrapper)queryWrapper, false);
    }

    public ExtActProcessNodeDeployment getExtActProcessNodeDeployment(String processId, String deploymentId, String processNodeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(true, ExtActProcessNodeDeployment::getProcessId, (Object)processId)).eq(true, ExtActProcessNodeDeployment::getProcessNodeCode, (Object)processNodeCode)).eq(true, ExtActProcessNodeDeployment::getDeploymentId, (Object)deploymentId);
        return (ExtActProcessNodeDeployment)this.extActProcessNodeDeploymentService.getOne((Wrapper)queryWrapper, false);
    }

    public ExtActProcessNodeDeployment getExtActProcessNodeDeployment(String processId, String processNodeCode) {
        ProcessDefinition processDefinition;
        Integer n2;
        ExtActProcess extActProcess = (ExtActProcess)this.extActProcessMapper.selectById((Serializable)((Object)processId));
        if (ObjectUtils.isNotEmpty((Object)extActProcess) && (n2 = extActProcess.getOpenStatus()).equals(1) && ObjectUtils.isNotEmpty((Object)(processDefinition = this.getLastProcessDefinition(extActProcess.getProcessKey())))) {
            return this.getExtActProcessNodeDeployment(processId, processDefinition.getDeploymentId(), processNodeCode);
        }
        return null;
    }

    public ExtActProcessNodeDeployment getExtActProcessNodeDeployment(ExtActProcess extActProcess, String processNodeCode) {
        ProcessDefinition processDefinition;
        Integer n2;
        if (ObjectUtils.isNotEmpty((Object)extActProcess) && (n2 = extActProcess.getOpenStatus()).equals(1) && ObjectUtils.isNotEmpty((Object)(processDefinition = this.getLastProcessDefinition(extActProcess.getProcessKey())))) {
            return this.getExtActProcessNodeDeployment(extActProcess.getId(), processDefinition.getDeploymentId(), processNodeCode);
        }
        return null;
    }

    public ExtActProcessForm selectProcessFormByProcessIdAndFormCode(String processId, String formCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(true, ExtActProcessForm::getProcessId, (Object)processId)).eq(true, ExtActProcessForm::getFormTableName, (Object)formCode);
        return (ExtActProcessForm)this.extActProcessFormMapper.selectOne((Wrapper)queryWrapper);
    }

    public ExtActProcessForm selectProcessFormByProcessId(String processId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(true, ExtActProcessForm::getProcessId, (Object)processId);
        return (ExtActProcessForm)this.extActProcessFormMapper.selectOne((Wrapper)queryWrapper);
    }

    public List<ExtActProcessForm> selectProcessFormByActionAndFormCode(String action, String formCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().like(true, ExtActProcessForm::getTriggerAction, (Object)action)).eq(true, ExtActProcessForm::getFormTableName, (Object)formCode);
        return this.extActProcessFormMapper.selectList((Wrapper)queryWrapper);
    }

    public List<String> selectProcessNodeIds(String processId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"id"});
        queryWrapper.lambda().eq(true, ExtActProcessNode::getProcessId, (Object)processId);
        List list = this.extActProcessNodeService.listObjs((Wrapper)queryWrapper, e2 -> e2.toString());
        return list;
    }

    public ProcessDefinition getLastProcessDefinition(String processKey) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
    }

    public BpmnModel getBpmnModelByProcessDefId(String processDefId) {
        return this.repositoryService.getBpmnModel(processDefId);
    }

    protected void moveExecutionsToSingleActivityId(List<String> executionIds, String activityId) {
        this.runtimeService.createChangeActivityStateBuilder().moveExecutionsToSingleActivityId(executionIds, activityId).changeState();
    }

    public List<EndEvent> findEndFlowElement(String processDefId) {
        BpmnModel bpmnModel = this.getBpmnModelByProcessDefId(processDefId);
        if (bpmnModel != null) {
            Process process = bpmnModel.getMainProcess();
            return process.findFlowElementsOfType(EndEvent.class);
        }
        return null;
    }

    public boolean stopProcessInstanceById(String processInstanceId, String executionId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (ObjectUtils.isNotEmpty((Object)processInstance)) {
            List<EndEvent> list = this.findEndFlowElement(processInstance.getProcessDefinitionId());
            String string = list.get(0).getId();
            List list2 = this.runtimeService.createExecutionQuery().parentId(processInstanceId).list();
            ArrayList<String> arrayList = new ArrayList<String>();
            list2.forEach(execution -> arrayList.add(execution.getId()));
            arrayList.add(executionId);
            this.moveExecutionsToSingleActivityId(arrayList, string);
            return true;
        }
        return false;
    }

    public ProcessUtils(ExtActProcessMapper extActProcessMapper, IExtActProcessNodeService extActProcessNodeService, IExtActProcessNodeDeploymentService extActProcessNodeDeploymentService, ExtActProcessFormMapper extActProcessFormMapper, RepositoryService repositoryService, RuntimeService runtimeService) {
        this.extActProcessMapper = extActProcessMapper;
        this.extActProcessNodeService = extActProcessNodeService;
        this.extActProcessNodeDeploymentService = extActProcessNodeDeploymentService;
        this.extActProcessFormMapper = extActProcessFormMapper;
        this.repositoryService = repositoryService;
        this.runtimeService = runtimeService;
    }
}

